/*
 * Decompiled with CFR 0.152.
 */
package highlands.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import highlands.Highlands;
import highlands.block.BlockHighlandsSapling;
import highlands.worldgen.WorldGenJapaneseMapleTree;
import highlands.worldgen.WorldGenShrubbery;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHighlandsSapling2
extends BlockHighlandsSapling
implements IPlantable {
    private int treeType;
    private String[] treeNames = new String[]{"Hedge", "JapaneseMaple"};
    private int[] growTimes = new int[]{0, 5};

    public BlockHighlandsSapling2(int type) {
        super(type);
        float var3 = 0.4f;
        this.func_149676_a(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var3 * 2.0f, 0.5f + var3);
        this.func_149647_a(Highlands.tabHighlands);
        this.treeType = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("Highlands:sapling" + this.treeNames[this.treeType]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    @Override
    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(block, 1, this.treeType));
    }

    @Override
    public boolean func_149718_j(World par1World, int par2, int par3, int par4) {
        Block soil = par1World.func_147439_a(par2, par3 - 1, par4);
        return (par1World.func_72883_k(par2, par3, par4) >= 8 || par1World.func_72937_j(par2, par3, par4)) && soil != null && this.isSoilGoodForSaplingType(soil, par1World, par2, par3, par4);
    }

    private boolean isSoilGoodForSaplingType(Block soil, World par1World, int par2, int par3, int par4) {
        if (soil.canSustainPlant((IBlockAccess)par1World, par2, par3 - 1, par4, ForgeDirection.UP, (IPlantable)this)) {
            return true;
        }
        if (this.treeType == 0 && soil == Blocks.field_150433_aE) {
            return true;
        }
        if (this.treeType == 10 && soil == Blocks.field_150354_m) {
            return true;
        }
        return this.treeType == 12 && soil == Blocks.field_150355_j;
    }

    @Override
    public void func_149674_a(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (!par1World.field_72995_K) {
            super.func_149674_a(par1World, par2, par3, par4, par5Random);
            if (par1World.func_72957_l(par2, par3 + 1, par4) >= 9 && par5Random.nextInt(7) == 0) {
                if (par1World.func_72805_g(par2, par3, par4) > this.growTimes[this.treeType]) {
                    this.growTree(par1World, par2, par3, par4, par5Random);
                } else if (par1World.func_72805_g(par2, par3, par4) < 15) {
                    par1World.func_147465_d(par2, par3, par4, (Block)this, par1World.func_72805_g(par2, par3, par4) + 1, 2);
                }
            }
        }
    }

    @Override
    public boolean growTree(World par1World, int i, int j, int k, Random r) {
        boolean replaceSapling;
        int meta = par1World.func_72805_g(i, j, k);
        boolean isTreeGrowSuccess = true;
        int[] treeWideSaplings = new int[4];
        boolean growWideTree = false;
        int[] xysw = this.growTreeWide(par1World, i, j, k);
        if (xysw != null) {
            growWideTree = true;
            treeWideSaplings[0] = par1World.func_72805_g(xysw[0], j, xysw[1]);
            treeWideSaplings[1] = par1World.func_72805_g(xysw[0] + 1, j, xysw[1]);
            treeWideSaplings[2] = par1World.func_72805_g(xysw[0], j, xysw[1] + 1);
            treeWideSaplings[3] = par1World.func_72805_g(xysw[0] + 1, j, xysw[1] + 1);
            par1World.func_147465_d(xysw[0], j, xysw[1], Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0] + 1, j, xysw[1], Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0], j, xysw[1] + 1, Blocks.field_150350_a, 0, 2);
            par1World.func_147465_d(xysw[0] + 1, j, xysw[1] + 1, Blocks.field_150350_a, 0, 2);
        }
        if (replaceSapling = true) {
            par1World.func_147465_d(i, j, k, Blocks.field_150350_a, 0, 2);
        }
        if (this.treeType == 0) {
            isTreeGrowSuccess = new WorldGenShrubbery(true).func_76484_a(par1World, r, i, j, k);
        }
        if (this.treeType == 1) {
            isTreeGrowSuccess = new WorldGenJapaneseMapleTree(8, 4, true).func_76484_a(par1World, r, i, j, k);
        } else if (!isTreeGrowSuccess && replaceSapling && par1World.func_147437_c(i, j, k)) {
            par1World.func_147465_d(i, j, k, (Block)this, meta, 2);
        }
        return isTreeGrowSuccess;
    }

    @Override
    public int[] growTreeWide(World world, int i, int j, int k) {
        if (world.func_147439_a(i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(--i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(i + 1, j, --k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        if (world.func_147439_a(++i + 1, j, k) == this && world.func_147439_a(i, j, k + 1) == this && world.func_147439_a(i + 1, j, k + 1) == this) {
            return new int[]{i, k};
        }
        return null;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public EnumPlantType getPlantType(World world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    @Override
    public int getPlantMetadata(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public int func_149692_a(int metadata) {
        return metadata;
    }

    @Override
    public boolean isValidPosition(World world, int x, int y, int z, int meta) {
        if (world.func_147437_c(x, y, z)) {
            Block currentBlock = world.func_147439_a(x, y - 1, z);
            if (this.treeType == 0 && currentBlock == Blocks.field_150433_aE) {
                return true;
            }
            if (this.treeType == 10 && currentBlock == Blocks.field_150354_m) {
                return true;
            }
            if (this.treeType == 12 && currentBlock == Blocks.field_150355_j) {
                return true;
            }
            if (currentBlock == Blocks.field_150349_c || currentBlock == Blocks.field_150346_d) {
                return true;
            }
        }
        return false;
    }
}

