/*
 * Decompiled with CFR 0.152.
 */
package highlands.integration;

import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.apiculture.FlowerManager;
import forestry.api.recipes.RecipeManagers;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import highlands.biome.BiomeGenBaseHighlands;
import highlands.block.BlockHighlandsLeaves;
import highlands.block.BlockHighlandsLog;
import highlands.block.BlockHighlandsSapling;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class HighlandsCompatibilityManager {
    public static final BiomeGenBaseHighlands[] forestb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.autumnForest, (BiomeGenBaseHighlands)HighlandsBiomes.woodlands, (BiomeGenBaseHighlands)HighlandsBiomes.woodsMountains, (BiomeGenBaseHighlands)HighlandsBiomes.birchHills, (BiomeGenBaseHighlands)HighlandsBiomes.lowlands, (BiomeGenBaseHighlands)HighlandsBiomes.forestIsland, (BiomeGenBaseHighlands)HighlandsBiomes.redwoodForest};
    public static final BiomeGenBaseHighlands[] taigab = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.tallPineForest};
    public static final BiomeGenBaseHighlands[] snowb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.alps, (BiomeGenBaseHighlands)HighlandsBiomes.tundra, (BiomeGenBaseHighlands)HighlandsBiomes.snowMountains};
    public static final BiomeGenBaseHighlands[] jungleb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.tropics, (BiomeGenBaseHighlands)HighlandsBiomes.flyingMountains, (BiomeGenBaseHighlands)HighlandsBiomes.tropicalIslands, (BiomeGenBaseHighlands)HighlandsBiomes.rainforest};
    public static final BiomeGenBaseHighlands[] hillb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.highlandsb, (BiomeGenBaseHighlands)HighlandsBiomes.pinelands, (BiomeGenBaseHighlands)HighlandsBiomes.cliffs, (BiomeGenBaseHighlands)HighlandsBiomes.rockMountains, (BiomeGenBaseHighlands)HighlandsBiomes.mesa, (BiomeGenBaseHighlands)HighlandsBiomes.baldHill, (BiomeGenBaseHighlands)HighlandsBiomes.badlands, (BiomeGenBaseHighlands)HighlandsBiomes.desertMountains};
    public static final BiomeGenBaseHighlands[] plainsb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.meadow, (BiomeGenBaseHighlands)HighlandsBiomes.savannah};
    public static final BiomeGenBaseHighlands[] desertb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.dunes, (BiomeGenBaseHighlands)HighlandsBiomes.outback, (BiomeGenBaseHighlands)HighlandsBiomes.sahel};
    public static final BiomeGenBaseHighlands[] oceanb = new BiomeGenBaseHighlands[]{(BiomeGenBaseHighlands)HighlandsBiomes.lake, (BiomeGenBaseHighlands)HighlandsBiomes.ocean2, (BiomeGenBaseHighlands)HighlandsBiomes.volcanoIsland, (BiomeGenBaseHighlands)HighlandsBiomes.desertIsland, (BiomeGenBaseHighlands)HighlandsBiomes.estuary, (BiomeGenBaseHighlands)HighlandsBiomes.flyingMountains};

    public static void mobload_biomes() {
        for (BiomeGenBaseHighlands a : forestb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76767_f.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76767_f.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : taigab) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76768_g.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76768_g.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : snowb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76774_n.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76774_n.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : jungleb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76782_w.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76782_w.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : hillb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76770_e.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76770_e.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : plainsb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76772_c.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76772_c.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : desertb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76769_d.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76769_d.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
        for (BiomeGenBaseHighlands a : oceanb) {
            if (a == null) continue;
            a.setSpawnLists(BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.monster), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.creature), BiomeGenBase.field_76771_b.func_76747_a(EnumCreatureType.waterCreature));
        }
    }

    public static void registerBlocksThaumcraft() {
        for (Block b : HighlandsBlocks.logs) {
            if (b == HighlandsBlocks.ironWood) {
                ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.TREE, 4).add(Aspect.METAL, 2));
                continue;
            }
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.TREE, 4));
        }
        for (Block b : HighlandsBlocks.leaves) {
            if (b == HighlandsBlocks.ironWood) {
                ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.METAL, 1));
                continue;
            }
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.PLANT, 1));
        }
        for (Block b : HighlandsBlocks.saplings) {
            if (b == HighlandsBlocks.ironWood) {
                ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.TREE, 1).add(Aspect.PLANT, 1).add(Aspect.PLANT, 1).add(Aspect.METAL, 1));
                continue;
            }
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(b), (AspectList)new AspectList().add(Aspect.TREE, 1).add(Aspect.PLANT, 1).add(Aspect.PLANT, 1));
        }
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplanks), (int[])new int[]{0, 1, 2, 3}, (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplankhalf), (int[])new int[]{0, 1, 2, 3}, (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs0), (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs1), (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs2), (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs3), (AspectList)new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.berries), (AspectList)new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.cocoa2), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.SENSES, 1).add(Aspect.CROP, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.blueFlower), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIGHT, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.lavender), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIGHT, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.cattail), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.whiteFlower), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.LIGHT, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.raspberryBush), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.CROP, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.blueberryBush), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.CROP, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.cattail), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(HighlandsBlocks.thornbush), (AspectList)new AspectList().add(Aspect.PLANT, 2).add(Aspect.DEATH, 1));
    }

    public static void registerBiomesForgeBiomeDict() {
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.woodsMountains, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.highlandsb, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.tundra, BiomeDictionary.Type.FROZEN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.cliffs, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.pinelands, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.autumnForest, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.alps, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.tallPineForest, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.meadow, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.savannah, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.tropics, BiomeDictionary.Type.JUNGLE);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.outback, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.woodlands, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.bog, BiomeDictionary.Type.SWAMP);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.redwoodForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.dunes, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.lowlands, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.sahel, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.birchHills, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.tropicalIslands, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WATER);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.estuary, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SWAMP);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.badlands, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.flyingMountains, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WATER);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.snowMountains, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FROZEN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.rockMountains, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.desertMountains, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.DESERT);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.steppe, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.glacier, BiomeDictionary.Type.FROZEN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.ocean2, BiomeDictionary.Type.WATER);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.forestIsland, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.jungleIsland, BiomeDictionary.Type.JUNGLE);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.desertIsland, BiomeDictionary.Type.BEACH);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.volcanoIsland, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.snowIsland, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.FROZEN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.windyIsland, BiomeDictionary.Type.PLAINS);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.rockIsland, BiomeDictionary.Type.WASTELAND);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.valley, BiomeDictionary.Type.FOREST);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.lake, BiomeDictionary.Type.WATER);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.mesa, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.baldHill, BiomeDictionary.Type.MOUNTAIN);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.oasis, BiomeDictionary.Type.JUNGLE);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.canyon, BiomeDictionary.Type.DESERT);
        HighlandsCompatibilityManager.registerBiomeType(HighlandsBiomes.shrubland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.HILLS);
    }

    private static void registerBiomeType(BiomeGenBase biome, BiomeDictionary.Type ... types) {
        if (biome != null) {
            BiomeDictionary.registerBiomeType((BiomeGenBase)biome, (BiomeDictionary.Type[])types);
        }
    }

    public static void registerBlocksForestry() {
        StringBuilder sb = new StringBuilder();
        for (Block b : HighlandsBlocks.saplings) {
            if (b == null) continue;
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)("farmArboreal@" + b + ".0"));
            sb.append(b).append(".0;");
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("forester@" + sb.toString()));
        sb = new StringBuilder();
        for (Block b : HighlandsBlocks.logs) {
            if (b == null) continue;
            sb.append(b).append(".0;");
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)("forester@" + sb.toString()));
        FlowerManager.plainFlowers.add(new ItemStack(HighlandsBlocks.blueFlower));
        FlowerManager.plainFlowers.add(new ItemStack(HighlandsBlocks.lavender));
        FlowerManager.plainFlowers.add(new ItemStack(HighlandsBlocks.whiteFlower));
    }

    public static void registerRecipesForestry() {
        FluidStack juice = FluidRegistry.getFluidStack((String)"juice", (int)1);
        if (HighlandsBlocks.berries != null && juice != null) {
            FluidStack myjuice = juice.copy();
            myjuice.amount = 20;
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(HighlandsBlocks.berries)}, myjuice);
        }
        for (Block b : HighlandsBlocks.saplings) {
            if (b == null) continue;
            ItemStack sapling = new ItemStack(b);
            FluidStack biomass = FluidRegistry.getFluidStack((String)"biomass", (int)1);
            FluidStack water = FluidRegistry.getFluidStack((String)"water", (int)1);
            FluidStack honey = FluidRegistry.getFluidStack((String)"honey", (int)1);
            int scalar = b == HighlandsBlocks.ironwoodSapling ? 2 : 1;
            RecipeManagers.fermenterManager.addRecipe(sapling, 250 * scalar, 1.0f, biomass, water);
            if (juice != null) {
                RecipeManagers.fermenterManager.addRecipe(sapling, 250 * scalar, 1.5f, biomass, juice);
            }
            if (honey == null) continue;
            RecipeManagers.fermenterManager.addRecipe(sapling, 250 * scalar, 1.5f, biomass, honey);
        }
    }

    public static void registerBlocksMFR() {
        for (Block b : HighlandsBlocks.saplings) {
            if (!(b instanceof BlockHighlandsSapling)) continue;
            FactoryRegistry.sendMessage("registerPlantable", (BlockHighlandsSapling)b);
            FactoryRegistry.sendMessage("registerFertilizable", (BlockHighlandsSapling)b);
        }
        for (Block b : HighlandsBlocks.logs) {
            if (!(b instanceof BlockHighlandsLog)) continue;
            FactoryRegistry.sendMessage("registerHarvestable", (BlockHighlandsLog)b);
        }
        for (Block b : HighlandsBlocks.leaves) {
            if (!(b instanceof BlockHighlandsLeaves)) continue;
            FactoryRegistry.sendMessage("registerHarvestable", (BlockHighlandsLeaves)b);
        }
    }
}

