/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeCanopy
extends WorldGenHighlandsTreeBase {
    private boolean trunk2;

    public WorldGenTreeCanopy(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify, boolean thickTrunk) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
        this.trunk2 = thickTrunk;
    }

    public WorldGenTreeCanopy(int minH, int maxH, boolean notify, boolean thickTrunk) {
        this(0, 0, HighlandsBlocks.canopyWood, HighlandsBlocks.canopyLeaves, minH, maxH, notify, thickTrunk);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.woodMeta = 3;
            this.leaves = Blocks.field_150362_t;
            this.leavesMeta = 3;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        this.worldObj = world;
        this.random = random;
        boolean isWide = random.nextInt(3) == 0;
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 2, 15)) {
            return false;
        }
        this.genTree(world, random, locX, locY, locZ, treeHeight, isWide);
        if (this.trunk2) {
            this.genTree(world, random, locX + 1, locY, locZ, treeHeight += 3, isWide);
            this.genTree(world, random, locX, locY, locZ + 1, treeHeight += 3, isWide);
            this.genTree(world, random, locX + 1, locY, locZ + 1, treeHeight += 3, isWide);
        }
        this.worldObj = null;
        return true;
    }

    private boolean genTree(World world, Random random, int locX, int locY, int locZ, int treeHeight, boolean isWide) {
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
        }
        int h = locY + treeHeight - 1;
        this.generateLeafLayerCircle(world, random, 5.5, locX, locZ, h);
        this.generateLeafLayerCircle(world, random, 4.5, locX, locZ, ++h);
        h = locY + treeHeight - 6;
        int[] xyz = this.generateStraightBranch(world, random, 4, locX, h, locZ, random.nextInt(4));
        this.generateLeafLayerCircle(world, random, 4.5, xyz[0], xyz[2], xyz[1]);
        this.generateLeafLayerCircle(world, random, 3.5, xyz[0], xyz[2], xyz[1] + 1);
        return true;
    }
}

