/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeFir
extends WorldGenHighlandsTreeBase {
    private boolean trunk2;

    public WorldGenTreeFir(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify, boolean thickTrunk) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
        this.trunk2 = thickTrunk;
    }

    public WorldGenTreeFir(int minH, int maxH, boolean notify, boolean thickTrunk) {
        this(0, 0, HighlandsBlocks.firWood, HighlandsBlocks.firLeaves, minH, maxH, notify, thickTrunk);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.woodMeta = 1;
            this.leaves = Blocks.field_150362_t;
            this.leavesMeta = 1;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        this.worldObj = world;
        this.random = random;
        boolean isWide = random.nextInt(3) == 0;
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        if (!this.isLegalTreePosition(world, locX, locY, locZ) && world.func_147439_a(locX, locY - 1, locZ) != Blocks.field_150433_aE) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 2, 10)) {
            return false;
        }
        this.genTree(world, random, locX, locY, locZ, treeHeight, isWide);
        if (this.trunk2) {
            this.genTree(world, random, locX + 1, locY, locZ, treeHeight, isWide);
            this.genTree(world, random, locX, locY, locZ + 1, treeHeight, isWide);
            this.genTree(world, random, locX + 1, locY, locZ + 1, treeHeight, isWide);
        }
        this.worldObj = null;
        return true;
    }

    private boolean genTree(World world, Random random, int locX, int locY, int locZ, int treeHeight, boolean isWide) {
        int h;
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
        }
        double leafRadius = 4.5;
        double finalRadius = 2.5;
        int h0 = 6;
        if (treeHeight < 16) {
            h0 = 3;
        }
        for (h = locY + h0; h < treeHeight + locY; ++h) {
            if (isWide) {
                this.generateLeafLayerCircleNoise(world, random, leafRadius + 1.0, locX, locZ, h);
                ++h;
            }
            this.generateLeafLayerCircleNoise(world, random, leafRadius, locX, locZ, h);
            this.generateLeafLayerCircleNoise(world, random, leafRadius - 1.0, locX, locZ, ++h);
            if (!isWide) {
                this.generateLeafLayerCircleNoise(world, random, leafRadius - 1.5, locX, locZ, ++h);
            }
            leafRadius -= (leafRadius - finalRadius) / 3.0;
        }
        if (isWide) {
            this.generateLeafLayerCircleNoise(world, random, 2.0, locX, locZ, h);
            ++h;
        }
        this.generateLeafLayerCircleNoise(world, random, 1.5, locX, locZ, h);
        this.generateLeafLayerCircleNoise(world, random, 1.0, locX, locZ, ++h);
        this.setBlockInWorld(locX, ++h, locZ, this.leaves, this.leavesMeta);
        this.setBlockInWorld(locX, ++h, locZ, this.leaves, this.leavesMeta);
        return true;
    }
}

