/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.network;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import org.millenaire.common.Building;
import org.millenaire.common.Culture;
import org.millenaire.common.GuiActions;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.network.StreamReadWrite;

public class ClientSender {
    public static void activateMillChest(EntityPlayer player, Point pos) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(81);
            StreamReadWrite.writeNullablePoint(pos, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in activateMillChest", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void controlledBuildingsForgetBuilding(EntityPlayer player, Building townHall, BuildingProject project) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(71);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), (DataOutput)data);
            data.writeUTF(project.key);
            StreamReadWrite.writeNullablePoint(project.location.pos, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in controlledBuildingsToggleUpgrades", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.controlledBuildingsForgetBuilding(player, townHall, project);
    }

    public static void controlledBuildingsToggleUpgrades(EntityPlayer player, Building townHall, BuildingProject project, boolean allow) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(70);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), (DataOutput)data);
            data.writeUTF(project.key);
            StreamReadWrite.writeNullablePoint(project.location.pos, (DataOutput)data);
            data.writeBoolean(allow);
        }
        catch (IOException e) {
            MLN.printException("Error in controlledBuildingsToggleUpgrades", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.controlledBuildingsToggleUpgrades(player, townHall, project, allow);
    }

    public static void devCommand(int devcommand) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(206);
            data.write(devcommand);
        }
        catch (IOException e) {
            MLN.printException("Error in devCommand", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void displayVillageList(boolean loneBuildings) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(201);
            data.writeBoolean(loneBuildings);
        }
        catch (IOException e) {
            MLN.printException("Error in displayVillageList", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void hireExtend(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(31);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in hireExtend", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.hireExtend(player, villager);
    }

    public static void hireHire(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(30);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in hireHire", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.hireHire(player, villager);
    }

    public static void hireRelease(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(32);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in hireRelease", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.hireRelease(player, villager);
    }

    public static void importBuilding(EntityPlayer player, Point pos) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(82);
            StreamReadWrite.writeNullablePoint(pos, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in importBuilding", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void negationWand(EntityPlayer player, Building townHall) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(40);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in negationWand", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void newBuilding(EntityPlayer player, Building townHall, Point pos, String planKey) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(50);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), (DataOutput)data);
            StreamReadWrite.writeNullablePoint(pos, (DataOutput)data);
            data.writeUTF(planKey);
        }
        catch (IOException e) {
            MLN.printException("Error in newBuilding", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void newVillageCreation(EntityPlayer player, Point pos, String cultureKey, String villageTypeKey) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(20);
            data.writeUTF(cultureKey);
            data.writeUTF(villageTypeKey);
            StreamReadWrite.writeNullablePoint(pos, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in newVillageCreation", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void pujasChangeEnchantment(EntityPlayer player, Building temple, int enchantmentId) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(60);
            StreamReadWrite.writeNullablePoint(temple.getPos(), (DataOutput)data);
            data.writeShort(enchantmentId);
        }
        catch (IOException e) {
            MLN.printException("Error in pujasChangeEnchantment", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void questCompleteStep(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(10);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in questCompleteStep", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void questRefuse(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(11);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in questRefuse", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void requestMapInfo(Building townHall) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(203);
            StreamReadWrite.writeNullablePoint(townHall.getPos(), (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException(townHall + ": Error in sendUpdatePacket", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void sendAvailableContent() {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(205);
            data.writeUTF(MLN.effective_language);
            data.writeUTF(MLN.fallback_language);
            data.writeShort(Culture.vectorCultures.size());
            for (Culture culture : Culture.vectorCultures) {
                culture.writeCultureAvailableContentPacket(data);
            }
        }
        catch (IOException e) {
            MLN.printException("Error in displayVillageList", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void sendVersionInfo() {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(202);
            data.writeUTF("5.2.0");
        }
        catch (IOException e) {
            MLN.printException("Error in sendVersionInfo", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void summoningWandUse(EntityPlayer player, Point pos) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(80);
            StreamReadWrite.writeNullablePoint(pos, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in summoningWandUse", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void villageChiefPerformBuilding(EntityPlayer player, MillVillager chief, String planKey) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(1);
            data.writeLong(chief.villager_id);
            data.writeUTF(planKey);
        }
        catch (IOException e) {
            MLN.printException("Error in villageChiefPerformBuilding", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void villageChiefPerformCrop(EntityPlayer player, MillVillager chief, String value) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(2);
            data.writeLong(chief.villager_id);
            data.writeUTF(value);
        }
        catch (IOException e) {
            MLN.printException("Error in villageChiefPerformCrop", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void villageChiefPerformCultureControl(EntityPlayer player, MillVillager chief) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(3);
            data.writeLong(chief.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in villageChiefPerformCultureControl", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void villageChiefPerformDiplomacy(EntityPlayer player, MillVillager chief, Point village, boolean praise) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(4);
            data.writeLong(chief.villager_id);
            StreamReadWrite.writeNullablePoint(village, (DataOutput)data);
            data.writeBoolean(praise);
        }
        catch (IOException e) {
            MLN.printException("Error in villageChiefPerformDiplomacy", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.villageChiefPerformDiplomacy(player, chief, village, praise);
    }

    public static void villageChiefPerformVillageScroll(EntityPlayer player, MillVillager chief) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(5);
            data.writeLong(chief.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in villageChiefPerformVillageScroll", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static void controlledMilitaryDiplomacy(EntityPlayer player, Building th, Point target, int amount) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(90);
            StreamReadWrite.writeNullablePoint(th.getPos(), (DataOutput)data);
            StreamReadWrite.writeNullablePoint(target, (DataOutput)data);
            data.writeInt(amount);
        }
        catch (IOException e) {
            MLN.printException("Error in controlledMilitaryDiplomacy", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.controlledMilitaryDiplomacy(player, th, target, amount);
    }

    public static void controlledMilitaryPlanRaid(EntityPlayer player, Building th, Point target) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(91);
            StreamReadWrite.writeNullablePoint(th.getPos(), (DataOutput)data);
            StreamReadWrite.writeNullablePoint(target, (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in controlledMilitaryStartRaid", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.controlledMilitaryPlanRaid(player, th, th.mw.getBuilding(target));
    }

    public static void controlledMilitaryCancelRaid(EntityPlayer player, Building th) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(200);
            data.write(92);
            StreamReadWrite.writeNullablePoint(th.getPos(), (DataOutput)data);
        }
        catch (IOException e) {
            MLN.printException("Error in controlledMilitaryCancelRaid", e);
        }
        ClientSender.createAndSendServerPacket(data);
        GuiActions.controlledMilitaryCancelRaid(player, th);
    }

    public static void villagerInteractSpecial(EntityPlayer player, MillVillager villager) {
        ByteBufOutputStream data = ClientSender.getNewByteBufOutputStream();
        try {
            data.write(204);
            data.writeLong(villager.villager_id);
        }
        catch (IOException e) {
            MLN.printException("Error in villagerInteractSpecial", e);
        }
        ClientSender.createAndSendServerPacket(data);
    }

    public static ByteBufOutputStream getNewByteBufOutputStream() {
        return new ByteBufOutputStream(Unpooled.buffer());
    }

    public static C17PacketCustomPayload createServerPacket(ByteBufOutputStream data) {
        return new C17PacketCustomPayload("millenaire", data.buffer());
    }

    public static void sendPacketToServer(Packet packet) {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    private static void createAndSendServerPacket(ByteBufOutputStream bytes) {
        ClientSender.sendPacketToServer((Packet)ClientSender.createServerPacket(bytes));
    }
}

