/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.VillageType;
import org.millenaire.common.VillagerRecord;
import org.millenaire.common.VillagerType;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingPlanSet;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;
import org.millenaire.common.network.StreamReadWrite;

public class Culture {
    private static final int LANGUAGE_FLUENT = 500;
    private static final int LANGUAGE_MODERATE = 200;
    private static final int LANGUAGE_BEGINNER = 100;
    public static Vector<Culture> vectorCultures = new Vector();
    private static HashMap<String, Culture> cultures = new HashMap();
    private static HashMap<String, Culture> serverCultures = new HashMap();
    public static HashMap<String, String> oldShopConversion = new HashMap();
    private CultureLanguage mainLanguage;
    private CultureLanguage fallbackLanguage;
    private CultureLanguage mainLanguageServer;
    private CultureLanguage fallbackLanguageServer;
    private final HashMap<String, CultureLanguage> loadedLanguages = new HashMap();
    public String key;
    public String qualifierSeparator = " ";
    private HashMap<String, BuildingPlanSet> planSet = new HashMap();
    private final HashMap<String, BuildingPlanSet> serverPlanSet = new HashMap();
    public Vector<BuildingPlanSet> vectorPlanSets = new Vector();
    private final HashMap<String, VillageType> villageTypes = new HashMap();
    private final HashMap<String, VillageType> serverVillageTypes = new HashMap();
    public Vector<VillageType> vectorVillageTypes = new Vector();
    private final HashMap<String, VillageType> loneBuildingTypes = new HashMap();
    private final HashMap<String, VillageType> serverLoneBuildingTypes = new HashMap();
    public Vector<VillageType> vectorLoneBuildingTypes = new Vector();
    public final HashMap<String, VillagerType> villagerTypes = new HashMap();
    private final HashMap<String, VillagerType> serverVillagerTypes = new HashMap();
    public Vector<VillagerType> vectorVillagerTypes = new Vector();
    private final HashMap<String, Vector<String>> nameLists = new HashMap();
    public HashMap<String, Vector<Goods>> shopSells = new HashMap();
    public HashMap<String, Vector<Goods>> shopBuys = new HashMap();
    public HashMap<String, Vector<Goods>> shopBuysOptional = new HashMap();
    public HashMap<String, Vector<MillVillager.InvItem>> shopNeeds = new HashMap();
    public Vector<Goods> goodsVector = new Vector();
    public HashMap<String, Goods> goods = new HashMap();
    public HashMap<MillVillager.InvItem, Goods> goodsByItem = new HashMap();
    public Vector<String> knownCrops = new Vector();

    public static Culture getCultureByName(String name) {
        if (cultures.containsKey(name)) {
            return cultures.get(name);
        }
        if (serverCultures.containsKey(name)) {
            return serverCultures.get(name);
        }
        if (Mill.isDistantClient()) {
            Culture culture = new Culture(name);
            serverCultures.put(name, culture);
            return culture;
        }
        return null;
    }

    public static Culture getRandomCulture() {
        return (Culture)((Object)MillCommonUtilities.getWeightedChoice(vectorCultures, null));
    }

    public static boolean loadCultures() {
        Vector<File> culturesDirs = new Vector<File>();
        for (File dir : Mill.loadingDirs) {
            File cultureDir = new File(dir, "cultures");
            if (!cultureDir.exists()) continue;
            culturesDirs.add(cultureDir);
        }
        File customcultureDir = new File(Mill.proxy.getCustomDir(), "custom cultures");
        if (customcultureDir.exists()) {
            culturesDirs.add(customcultureDir);
        }
        Vector culturesDirsBis = (Vector)culturesDirs.clone();
        for (File culturesDir : culturesDirsBis) {
            for (File cultureDir : culturesDir.listFiles()) {
                if (!cultureDir.exists() || !cultureDir.isDirectory() || cultureDir.getName().startsWith(".") || cultures.containsKey(cultureDir.getName())) continue;
                if (MLN.LogCulture >= 1) {
                    MLN.major(cultureDir, "Loading culture: " + cultureDir.getName());
                }
                Culture culture = new Culture(cultureDir.getName());
                culture.initialise(culturesDirs);
                cultures.put(culture.key, culture);
                vectorCultures.add(culture);
            }
        }
        if (MLN.LogCulture >= 1) {
            MLN.major(null, "Finished loading cultures.");
        }
        return false;
    }

    public static void readCultureMissingContentPacket(ByteBufInputStream data) {
        try {
            int i;
            CultureLanguage[] langs;
            String key = data.readUTF();
            Culture culture = Culture.getCultureByName(key);
            CultureLanguage main = new CultureLanguage(culture, MLN.effective_language, true);
            CultureLanguage fallback = new CultureLanguage(culture, MLN.fallback_language, true);
            culture.mainLanguageServer = main;
            culture.fallbackLanguageServer = fallback;
            String playerName = Mill.proxy.getTheSinglePlayer().getDisplayName();
            for (CultureLanguage lang : langs = new CultureLanguage[]{main, fallback}) {
                HashMap<String, String> strings = StreamReadWrite.readStringStringMap((DataInput)data);
                for (String k : strings.keySet()) {
                    if (lang.strings.containsKey(k)) continue;
                    lang.strings.put(k, strings.get(k).replaceAll("\\$name", playerName));
                }
                strings = StreamReadWrite.readStringStringMap((DataInput)data);
                for (String k : strings.keySet()) {
                    if (lang.buildingNames.containsKey(k)) continue;
                    lang.buildingNames.put(k, strings.get(k).replaceAll("\\$name", playerName));
                }
                HashMap<String, Vector<String>> sentences = StreamReadWrite.readStringStringVectorMap((DataInput)data);
                for (String k : sentences.keySet()) {
                    if (lang.sentences.containsKey(k)) continue;
                    Vector<String> v = new Vector<String>();
                    for (String s : sentences.get(k)) {
                        v.add(s.replaceAll("\\$name", playerName));
                    }
                    lang.sentences.put(k, v);
                }
            }
            int nb = data.readShort();
            for (i = 0; i < nb; ++i) {
                key = data.readUTF();
                BuildingPlanSet set = culture.getBuildingPlanSet(key);
                set.readBuildingPlanSetInfoPacket(data);
            }
            nb = data.readShort();
            for (i = 0; i < nb; ++i) {
                key = data.readUTF();
                VillagerType vtype = culture.getVillagerType(key);
                vtype.readVillagerTypeInfoPacket(data);
            }
            nb = data.readShort();
            for (i = 0; i < nb; ++i) {
                key = data.readUTF();
                VillageType vtype = culture.getVillageType(key);
                vtype.readVillageTypeInfoPacket(data);
            }
            nb = data.readShort();
            for (i = 0; i < nb; ++i) {
                key = data.readUTF();
                VillageType vtype = culture.getLoneBuildingType(key);
                vtype.readVillageTypeInfoPacket(data);
            }
        }
        catch (IOException e) {
            MLN.printException("Error in readCultureInfoPacket: ", e);
        }
    }

    public static void refreshVectors() {
        Culture c;
        vectorCultures.clear();
        for (String k : cultures.keySet()) {
            c = cultures.get(k);
            vectorCultures.add(c);
        }
        for (String k : serverCultures.keySet()) {
            c = serverCultures.get(k);
            vectorCultures.add(c);
        }
        for (Culture c2 : vectorCultures) {
            c2.vectorPlanSets.clear();
            for (String key : c2.planSet.keySet()) {
                c2.vectorPlanSets.add(c2.planSet.get(key));
            }
            for (String key : c2.serverPlanSet.keySet()) {
                c2.vectorPlanSets.add(c2.serverPlanSet.get(key));
            }
            c2.vectorVillagerTypes.clear();
            for (String key : c2.villagerTypes.keySet()) {
                c2.vectorVillagerTypes.add(c2.villagerTypes.get(key));
            }
            for (String key : c2.serverVillagerTypes.keySet()) {
                c2.vectorVillagerTypes.add(c2.serverVillagerTypes.get(key));
            }
            c2.vectorVillageTypes.clear();
            for (String key : c2.villageTypes.keySet()) {
                c2.vectorVillageTypes.add(c2.villageTypes.get(key));
            }
            for (String key : c2.serverVillageTypes.keySet()) {
                c2.vectorVillageTypes.add(c2.serverVillageTypes.get(key));
            }
            c2.vectorLoneBuildingTypes.clear();
            for (String key : c2.loneBuildingTypes.keySet()) {
                c2.vectorLoneBuildingTypes.add(c2.loneBuildingTypes.get(key));
            }
            for (String key : c2.serverLoneBuildingTypes.keySet()) {
                c2.vectorLoneBuildingTypes.add(c2.serverLoneBuildingTypes.get(key));
            }
        }
    }

    public static void removeServerContent() {
        serverCultures.clear();
        for (String k : cultures.keySet()) {
            Culture c = cultures.get(k);
            c.serverPlanSet.clear();
            c.serverVillageTypes.clear();
            c.serverVillagerTypes.clear();
            c.serverLoneBuildingTypes.clear();
            c.mainLanguageServer = null;
            c.fallbackLanguageServer = null;
        }
        Culture.refreshVectors();
    }

    public Culture(String s) {
        this.key = s;
    }

    public boolean canReadBuildingNames() {
        if (Mill.proxy.getClientProfile() == null) {
            return true;
        }
        return !MLN.languageLearning || Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 100;
    }

    public boolean canReadDialogues(String username) {
        if (Mill.proxy.getClientProfile() == null) {
            return true;
        }
        return !MLN.languageLearning || Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 500;
    }

    public boolean canReadVillagerNames(String username) {
        if (Mill.proxy.getClientProfile() == null) {
            return true;
        }
        return !MLN.languageLearning || Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 200;
    }

    public int[] compareCultureLanguages(String main, String ref, BufferedWriter writer) throws Exception {
        CultureLanguage maincl = null;
        CultureLanguage refcl = null;
        if (this.loadedLanguages.containsKey(main)) {
            maincl = this.loadedLanguages.get(main);
        }
        if (this.loadedLanguages.containsKey(ref)) {
            refcl = this.loadedLanguages.get(ref);
        }
        if (refcl == null) {
            return new int[]{0, 0};
        }
        if (maincl == null) {
            writer.write("Data for culture " + this.key + " is missing." + MLN.EOL + MLN.EOL);
            return new int[]{0, refcl.buildingNames.size() + refcl.reputationLevels.size() + refcl.sentences.size() + refcl.strings.size()};
        }
        return maincl.compareWithLanguage(refcl, writer);
    }

    public String getBuildingGameName(BuildingPlan plan) {
        String planNameLC = plan.planName.toLowerCase();
        if (this.mainLanguage != null && this.mainLanguage.buildingNames.containsKey(planNameLC)) {
            return this.mainLanguage.buildingNames.get(planNameLC);
        }
        if (this.mainLanguageServer != null && this.mainLanguageServer.buildingNames.containsKey(planNameLC)) {
            return this.mainLanguageServer.buildingNames.get(planNameLC);
        }
        if (this.fallbackLanguage != null && this.fallbackLanguage.buildingNames.containsKey(planNameLC)) {
            return this.fallbackLanguage.buildingNames.get(planNameLC);
        }
        if (this.fallbackLanguageServer != null && this.fallbackLanguageServer.buildingNames.containsKey(planNameLC)) {
            return this.fallbackLanguageServer.buildingNames.get(planNameLC);
        }
        if (plan.parent != null) {
            return this.getBuildingGameName(plan.parent);
        }
        if (MLN.LogTranslation >= 1 || MLN.generateTranslationGap) {
            MLN.major(this, "Could not find the building name for :" + plan.planName);
        }
        return null;
    }

    public BuildingPlanSet getBuildingPlanSet(String key) {
        if (this.planSet.containsKey(key)) {
            return this.planSet.get(key);
        }
        if (this.serverPlanSet.containsKey(key)) {
            return this.serverPlanSet.get(key);
        }
        if (Mill.isDistantClient()) {
            BuildingPlanSet set = new BuildingPlanSet(this, key, null);
            this.serverPlanSet.put(key, set);
            return set;
        }
        return null;
    }

    public int getChoiceWeight() {
        return 10;
    }

    public String getCultureGameName() {
        return this.getCultureString("culture." + this.key);
    }

    public String getCultureString(String key) {
        key = key.toLowerCase();
        if (this.mainLanguage != null && this.mainLanguage.strings.containsKey(key)) {
            return this.mainLanguage.strings.get(key);
        }
        if (MLN.getRawStringMainOnly(key, false) != null) {
            return MLN.getRawStringMainOnly(key, false);
        }
        if (this.mainLanguageServer != null && this.mainLanguageServer.strings.containsKey(key)) {
            return this.mainLanguageServer.strings.get(key);
        }
        if (this.fallbackLanguage != null && this.fallbackLanguage.strings.containsKey(key)) {
            return this.fallbackLanguage.strings.get(key);
        }
        if (MLN.getRawStringFallbackOnly(key, false) != null) {
            return MLN.getRawStringFallbackOnly(key, false);
        }
        if (this.fallbackLanguageServer != null && this.fallbackLanguageServer.strings.containsKey(key)) {
            return this.fallbackLanguageServer.strings.get(key);
        }
        return key;
    }

    public String getLanguageLevelString() {
        if (Mill.proxy.getClientProfile() == null) {
            return MLN.string("culturelanguage.minimal");
        }
        if (Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 500) {
            return MLN.string("culturelanguage.fluent");
        }
        if (Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 200) {
            return MLN.string("culturelanguage.moderate");
        }
        if (Mill.proxy.getClientProfile().getCultureLanguageKnowledge(this.key) >= 100) {
            return MLN.string("culturelanguage.beginner");
        }
        return MLN.string("culturelanguage.minimal");
    }

    public VillageType getLoneBuildingType(String key) {
        if (this.loneBuildingTypes.containsKey(key)) {
            return this.loneBuildingTypes.get(key);
        }
        if (this.serverLoneBuildingTypes.containsKey(key)) {
            return this.serverLoneBuildingTypes.get(key);
        }
        if (Mill.isDistantClient()) {
            VillageType vtype = new VillageType(this, key, false);
            this.serverLoneBuildingTypes.put(key, vtype);
            return vtype;
        }
        return null;
    }

    public Vector<BuildingPlanSet> getPlanSetsWithTag(String tag) {
        Vector<BuildingPlanSet> sets = new Vector<BuildingPlanSet>();
        for (BuildingPlanSet set : this.vectorPlanSets) {
            if (!set.plans.firstElement()[0].tags.contains(tag)) continue;
            sets.add(set);
        }
        return sets;
    }

    public VillagerType getRandomForeignMerchant() {
        Vector<VillagerType> foreignMerchants = new Vector<VillagerType>();
        for (VillagerType v : this.vectorVillagerTypes) {
            if (!v.isForeignMerchant) continue;
            foreignMerchants.add(v);
        }
        if (foreignMerchants.size() == 0) {
            return null;
        }
        return (VillagerType)MillCommonUtilities.getWeightedChoice(foreignMerchants, null);
    }

    public String getRandomNameFromList(String listName) {
        Vector<String> list = this.nameLists.get(listName);
        if (list == null) {
            MLN.error(this, "Could not find name list: " + listName);
            return null;
        }
        return list.get(MillCommonUtilities.randomInt(list.size()));
    }

    public VillageType getRandomVillage() {
        return (VillageType)MillCommonUtilities.getWeightedChoice(this.vectorVillageTypes, null);
    }

    public String getReputationLevelLabel(int reputation) {
        CultureLanguage.ReputationLevel rlevel = this.getReputationLevel(reputation);
        if (rlevel != null) {
            return rlevel.label;
        }
        return "";
    }

    public String getReputationLevelDesc(int reputation) {
        CultureLanguage.ReputationLevel rlevel = this.getReputationLevel(reputation);
        if (rlevel != null) {
            return rlevel.desc;
        }
        return "";
    }

    public CultureLanguage.ReputationLevel getReputationLevel(int reputation) {
        CultureLanguage.ReputationLevel rlevel = null;
        if (this.mainLanguage != null) {
            rlevel = this.mainLanguage.getReputationLevel(reputation);
        }
        if (rlevel != null) {
            return rlevel;
        }
        if (this.fallbackLanguage != null) {
            return this.fallbackLanguage.getReputationLevel(reputation);
        }
        return null;
    }

    public String getReputationString() {
        if (Mill.proxy.getClientProfile() == null) {
            return MLN.string("culturereputation.neutral");
        }
        int reputation = Mill.proxy.getClientProfile().getCultureReputation(this.key);
        if (reputation < 0) {
            if (reputation <= -640) {
                return MLN.string("culturereputation.scourgeofgod");
            }
            if (reputation < -128) {
                return MLN.string("culturereputation.dreadful");
            }
            return MLN.string("culturereputation.bad");
        }
        if (reputation > 2048) {
            return MLN.string("culturereputation.stellar");
        }
        if (reputation > 1024) {
            return MLN.string("culturereputation.excellent");
        }
        if (reputation > 512) {
            return MLN.string("culturereputation.good");
        }
        if (reputation > 256) {
            return MLN.string("culturereputation.decent");
        }
        return MLN.string("culturereputation.neutral");
    }

    public CultureLanguage.Dialogue getDialog(MillVillager v1, MillVillager v2) {
        CultureLanguage.Dialogue d = this.mainLanguage.getDialogue(v1, v2);
        if (d != null) {
            return d;
        }
        if (this.mainLanguageServer != null) {
            d = this.mainLanguageServer.getDialogue(v1, v2);
        }
        if (d != null) {
            return d;
        }
        if (this.fallbackLanguage != null) {
            d = this.fallbackLanguage.getDialogue(v1, v2);
        }
        if (d != null) {
            return d;
        }
        if (this.fallbackLanguageServer != null) {
            d = this.fallbackLanguageServer.getDialogue(v1, v2);
        }
        if (d != null) {
            return d;
        }
        return null;
    }

    public CultureLanguage.Dialogue getDialogue(String key) {
        if (this.mainLanguage.dialogues.containsKey(key)) {
            return this.mainLanguage.dialogues.get(key);
        }
        if (this.mainLanguageServer != null && this.mainLanguageServer.dialogues.containsKey(key)) {
            return this.mainLanguageServer.dialogues.get(key);
        }
        if (this.fallbackLanguage != null && this.fallbackLanguage.dialogues.containsKey(key)) {
            return this.fallbackLanguage.dialogues.get(key);
        }
        if (this.fallbackLanguageServer != null && this.fallbackLanguageServer.dialogues.containsKey(key)) {
            return this.fallbackLanguageServer.dialogues.get(key);
        }
        return null;
    }

    public Vector<String> getSentences(String key) {
        if (this.mainLanguage != null && this.mainLanguage.sentences.containsKey(key)) {
            return this.mainLanguage.sentences.get(key);
        }
        if (this.mainLanguageServer != null && this.mainLanguageServer.sentences.containsKey(key)) {
            return this.mainLanguageServer.sentences.get(key);
        }
        if (this.fallbackLanguage != null && this.fallbackLanguage.sentences.containsKey(key)) {
            return this.fallbackLanguage.sentences.get(key);
        }
        if (this.fallbackLanguageServer != null && this.fallbackLanguageServer.sentences.containsKey(key)) {
            return this.fallbackLanguageServer.sentences.get(key);
        }
        return null;
    }

    public VillagerType getVillagerType(String key) {
        if (this.villagerTypes.containsKey(key)) {
            return this.villagerTypes.get(key);
        }
        if (this.serverVillagerTypes.containsKey(key)) {
            return this.serverVillagerTypes.get(key);
        }
        if (Mill.isDistantClient()) {
            VillagerType vtype = new VillagerType(this, key);
            this.serverVillagerTypes.put(key, vtype);
            return vtype;
        }
        return null;
    }

    public VillageType getVillageType(String key) {
        if (this.villageTypes.containsKey(key)) {
            return this.villageTypes.get(key);
        }
        if (this.serverVillageTypes.containsKey(key)) {
            return this.serverVillageTypes.get(key);
        }
        if (Mill.isDistantClient()) {
            VillageType vtype = new VillageType(this, key, false);
            this.serverVillageTypes.put(key, vtype);
            return vtype;
        }
        return null;
    }

    public boolean hasSentences(String key) {
        return this.getSentences(key) != null;
    }

    public boolean initialise(Vector<File> culturesDirs) {
        Vector<File> thisCultureDirs = new Vector<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, this.key);
            if (!dir.exists()) continue;
            thisCultureDirs.add(dir);
        }
        try {
            this.readConfig(thisCultureDirs);
            this.loadNameLists(thisCultureDirs);
            this.loadGoods(thisCultureDirs);
            this.loadShops(thisCultureDirs);
            this.loadVillagerTypes(thisCultureDirs);
            this.planSet = BuildingPlan.loadPlans(thisCultureDirs, this);
            if (this.planSet == null) {
                return false;
            }
            this.vectorPlanSets.addAll(this.planSet.values());
            if (MLN.LogBuildingPlan >= 1) {
                for (BuildingPlanSet set : this.vectorPlanSets) {
                    MLN.major(set, "Loaded plan set: " + set.key);
                }
            }
            this.vectorVillageTypes = VillageType.loadVillages(thisCultureDirs, this);
            if (this.vectorVillageTypes == null) {
                return false;
            }
            for (VillageType v : this.vectorVillageTypes) {
                this.villageTypes.put(v.key, v);
            }
            this.vectorLoneBuildingTypes = VillageType.loadLoneBuildings(thisCultureDirs, this);
            for (VillageType v : this.vectorLoneBuildingTypes) {
                this.loneBuildingTypes.put(v.key, v);
            }
            if (MLN.LogCulture >= 1) {
                MLN.major(this, "Finished loading culture.");
            }
            return true;
        }
        catch (Exception e) {
            MLN.printException("Error when loading culture: ", e);
            return false;
        }
    }

    private void loadGoods(Vector<File> culturesDirs) {
        Vector<File> files = new Vector<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "traded_goods.txt");
            if (!dir.exists()) continue;
            files.add(dir);
        }
        File dir = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), this.key), "traded_goods.txt");
        if (dir.exists()) {
            files.add(dir);
        }
        for (File file : files) {
            try {
                String line;
                if (!file.exists()) {
                    file.createNewFile();
                }
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                    try {
                        String[] values = line.split(",");
                        String name = values[0].toLowerCase();
                        if (Goods.goodsName.containsKey(name)) {
                            MillVillager.InvItem item = Goods.goodsName.get(name);
                            int sellingPrice = values.length > 1 && !values[1].isEmpty() ? MillCommonUtilities.readInteger(values[1]) : 0;
                            int buyingPrice = values.length > 2 && !values[2].isEmpty() ? MillCommonUtilities.readInteger(values[2]) : 0;
                            int reservedQuantity = values.length > 3 && !values[3].isEmpty() ? MillCommonUtilities.readInteger(values[3]) : 0;
                            int targetQuantity = values.length > 4 && !values[4].isEmpty() ? MillCommonUtilities.readInteger(values[4]) : 0;
                            int foreignMerchantPrice = values.length > 5 && !values[5].isEmpty() ? MillCommonUtilities.readInteger(values[5]) : 0;
                            boolean autoGenerate = values.length > 6 && !values[6].isEmpty() ? Boolean.parseBoolean(values[6]) : false;
                            String tag = values.length > 7 && !values[7].isEmpty() ? values[7] : null;
                            int minReputation = values.length > 8 && !values[8].isEmpty() ? MillCommonUtilities.readInteger(values[8]) : Integer.MIN_VALUE;
                            String desc = values.length > 9 && !values[9].isEmpty() ? values[9] : null;
                            Goods good = new Goods(name, item, sellingPrice, buyingPrice, reservedQuantity, targetQuantity, foreignMerchantPrice, autoGenerate, tag, minReputation, desc);
                            if (this.goods.containsKey(name) || this.goodsByItem.containsKey(good.item)) {
                                MLN.error(this, "Good " + name + " is present twice in the goods list.");
                            }
                            this.goods.put(name, good);
                            this.goodsByItem.put(good.item, good);
                            this.goodsVector.remove(good);
                            this.goodsVector.add(good);
                            if (MLN.LogCulture < 2) continue;
                            MLN.minor(this, "Loaded traded good: " + name + " prices: " + sellingPrice + "/" + buyingPrice);
                            continue;
                        }
                        MLN.error(this, "Unknown good on line: " + line);
                    }
                    catch (Exception e) {
                        MLN.printException("Exception when trying to read trade good on line: " + line, e);
                    }
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private CultureLanguage loadLanguage(Vector<File> languageDirs, String key) {
        if (this.loadedLanguages.containsKey(key)) {
            return this.loadedLanguages.get(key);
        }
        CultureLanguage lang = new CultureLanguage(this, key, false);
        Vector<File> languageDirsWithCusto = new Vector<File>(languageDirs);
        File dircusto = new File(new File(new File(Mill.proxy.getCustomDir(), "custom cultures"), key), "languages");
        if (dircusto.exists()) {
            languageDirsWithCusto.add(dircusto);
        }
        lang.loadFromDisk(languageDirsWithCusto);
        return lang;
    }

    public void loadLanguages(Vector<File> languageDirs, String effective_language, String fallback_language) {
        this.mainLanguage = this.loadLanguage(languageDirs, effective_language);
        this.fallbackLanguage = !effective_language.equals(fallback_language) ? this.loadLanguage(languageDirs, fallback_language) : this.mainLanguage;
        File mainDir = languageDirs.firstElement();
        for (File lang : mainDir.listFiles()) {
            String key;
            if (!lang.isDirectory() || lang.isHidden() || this.loadedLanguages.containsKey(key = lang.getName().toLowerCase())) continue;
            this.loadLanguage(languageDirs, key);
        }
    }

    private void loadNameLists(Vector<File> culturesDirs) {
        Vector<File> listDirs = new Vector<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "namelists");
            if (!dir.exists()) continue;
            listDirs.add(dir);
        }
        File dir = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), this.key), "custom namelists");
        if (dir.exists()) {
            listDirs.add(dir);
        }
        for (File lists : listDirs) {
            try {
                for (File file : lists.listFiles(new MillCommonUtilities.ExtFileFilter("txt"))) {
                    String line;
                    Vector<String> list = new Vector<String>();
                    BufferedReader reader = MillCommonUtilities.getReader(file);
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        list.add(line);
                    }
                    this.nameLists.put(file.getName().split("\\.")[0], list);
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadShop(File file) {
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                Vector<Goods> buys;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading shop " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].toLowerCase();
                String value = temp[1].toLowerCase();
                if (key.equals("buys")) {
                    buys = new Vector<Goods>();
                    for (String name : value.split(",")) {
                        if (this.goods.containsKey(name)) {
                            buys.add(this.goods.get(name));
                            if (MLN.LogSelling < 2) continue;
                            MLN.minor(this, "Loaded buying good " + name + " for shop " + file.getName());
                            continue;
                        }
                        MLN.error(this, "Unknown good when loading shop " + file.getName() + ": " + name);
                    }
                    this.shopBuys.put(file.getName().split("\\.")[0], buys);
                    continue;
                }
                if (key.equals("buysoptional")) {
                    buys = new Vector();
                    for (String name : value.split(",")) {
                        if (this.goods.containsKey(name)) {
                            buys.add(this.goods.get(name));
                            if (MLN.LogSelling < 2) continue;
                            MLN.minor(this, "Loaded optional buying good " + name + " for shop " + file.getName());
                            continue;
                        }
                        MLN.error(this, "Unknown good when loading shop " + file.getName() + ": " + name);
                    }
                    this.shopBuysOptional.put(file.getName().split("\\.")[0], buys);
                    continue;
                }
                if (key.equals("sells")) {
                    Vector<Goods> sells = new Vector<Goods>();
                    for (String name : value.split(",")) {
                        if (this.goods.containsKey(name)) {
                            sells.add(this.goods.get(name));
                            continue;
                        }
                        MLN.error(this, "Unknown good when loading shop " + file.getName() + ": " + name);
                    }
                    this.shopSells.put(file.getName().split("\\.")[0], sells);
                    continue;
                }
                if (key.equals("deliverto")) {
                    Vector<MillVillager.InvItem> needs = new Vector<MillVillager.InvItem>();
                    for (String name : value.split(",")) {
                        if (Goods.goodsName.containsKey(name)) {
                            needs.add(Goods.goodsName.get(name));
                            continue;
                        }
                        MLN.error(this, "Unknown good when loading shop " + file.getName() + ": " + name);
                    }
                    this.shopNeeds.put(file.getName().split("\\.")[0], needs);
                    continue;
                }
                MLN.error(this, "Unknown parameter when loading shop " + file.getName() + ": " + line);
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
        }
    }

    private void loadShops(Vector<File> culturesDirs) {
        Vector<File> dirs = new Vector<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "shops");
            if (!dir.exists()) continue;
            dirs.add(dir);
        }
        File dircusto = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), this.key), "shops");
        if (dircusto.exists()) {
            dirs.add(dircusto);
        }
        for (File dir : dirs) {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try {
                for (File file : dir.listFiles(new MillCommonUtilities.ExtFileFilter("txt"))) {
                    this.loadShop(file);
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadVillagerTypes(Vector<File> culturesDirs) {
        Vector<File> dirs = new Vector<File>();
        for (File culturesDir : culturesDirs) {
            File dir = new File(culturesDir, "villagers");
            if (!dir.exists()) continue;
            dirs.add(dir);
        }
        File dircusto = new File(new File(new File(Mill.proxy.getCustomDir(), "cultures"), this.key), "custom villagers");
        if (dircusto.exists()) {
            dirs.add(dircusto);
        }
        for (File dir : dirs) {
            try {
                for (File file : dir.listFiles(new MillCommonUtilities.ExtFileFilter("txt"))) {
                    VillagerType vtype = VillagerType.loadVillagerType(file, this);
                    if (vtype == null) continue;
                    this.villagerTypes.put(vtype.key, vtype);
                    this.vectorVillagerTypes.add(vtype);
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void readConfig(Vector<File> culturesDirs) {
        try {
            for (File cultureDir : culturesDirs) {
                String line;
                File file = new File(cultureDir, "culture.txt");
                if (!file.exists()) continue;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    String[] temp;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.split("=")).length != 2) continue;
                    String key = temp[0];
                    String value = temp[1];
                    if (key.equalsIgnoreCase("qualifierSeparator")) {
                        this.qualifierSeparator = value;
                        continue;
                    }
                    if (!key.equalsIgnoreCase("knownCrop")) continue;
                    this.knownCrops.add(value.trim().toLowerCase());
                }
                reader.close();
            }
        }
        catch (Exception e) {
            MLN.printException(e);
        }
    }

    public String toString() {
        return "Culture: " + this.key;
    }

    public void writeCultureAvailableContentPacket(ByteBufOutputStream data) throws IOException {
        MillCommonUtilities.WeightedChoice vtype;
        data.writeUTF(this.key);
        data.writeShort(this.mainLanguage.strings.size());
        data.writeShort(this.mainLanguage.buildingNames.size());
        data.writeShort(this.mainLanguage.sentences.size());
        data.writeShort(this.fallbackLanguage.strings.size());
        data.writeShort(this.fallbackLanguage.buildingNames.size());
        data.writeShort(this.fallbackLanguage.sentences.size());
        data.writeShort(this.vectorPlanSets.size());
        for (BuildingPlanSet set : this.vectorPlanSets) {
            data.writeUTF(set.key);
        }
        data.writeShort(this.villagerTypes.size());
        for (String key : this.villagerTypes.keySet()) {
            vtype = this.villagerTypes.get(key);
            data.writeUTF(vtype.key);
        }
        data.writeShort(this.villageTypes.size());
        for (String key : this.villageTypes.keySet()) {
            vtype = this.villageTypes.get(key);
            data.writeUTF(((VillageType)vtype).key);
        }
        data.writeShort(this.loneBuildingTypes.size());
        for (String key : this.loneBuildingTypes.keySet()) {
            vtype = this.loneBuildingTypes.get(key);
            data.writeUTF(((VillageType)vtype).key);
        }
    }

    public void writeCultureMissingContentPackPacket(DataOutput data, String mainLanguage, String fallbackLanguage, int nbStrings, int nbBuildingNames, int nbSentences, int nbFallbackStrings, int nbFallbackBuildingNames, int nbFallbackSentences, Vector<String> planSetAvailable, Vector<String> villagerAvailable, Vector<String> villagesAvailable, Vector<String> loneBuildingsAvailable) throws IOException {
        MillCommonUtilities.WeightedChoice vtype;
        data.writeUTF(this.key);
        CultureLanguage clientMain = null;
        CultureLanguage clientFallback = null;
        if (this.loadedLanguages.containsKey(mainLanguage)) {
            clientMain = this.loadedLanguages.get(mainLanguage);
        } else if (this.loadedLanguages.containsKey(mainLanguage.split("_")[0])) {
            clientMain = this.loadedLanguages.get(mainLanguage.split("_")[0]);
        }
        if (this.loadedLanguages.containsKey(fallbackLanguage)) {
            clientFallback = this.loadedLanguages.get(fallbackLanguage);
        } else if (this.loadedLanguages.containsKey(fallbackLanguage.split("_")[0])) {
            clientFallback = this.loadedLanguages.get(fallbackLanguage.split("_")[0]);
        }
        if (clientMain != null && clientMain.strings.size() > nbStrings) {
            StreamReadWrite.writeStringStringMap(clientMain.strings, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        if (clientMain != null && clientMain.buildingNames.size() > nbBuildingNames) {
            StreamReadWrite.writeStringStringMap(clientMain.buildingNames, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        if (clientMain != null && clientMain.sentences.size() > nbSentences) {
            StreamReadWrite.writeStringStringVectorMap(clientMain.sentences, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        if (clientFallback != null && clientFallback.strings.size() > nbFallbackStrings) {
            StreamReadWrite.writeStringStringMap(clientFallback.strings, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        if (clientFallback != null && clientFallback.buildingNames.size() > nbFallbackBuildingNames) {
            StreamReadWrite.writeStringStringMap(clientFallback.buildingNames, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        if (clientFallback != null && clientFallback.sentences.size() > nbFallbackSentences) {
            StreamReadWrite.writeStringStringVectorMap(clientFallback.sentences, data);
        } else {
            StreamReadWrite.writeStringStringMap(null, data);
        }
        int nbToWrite = 0;
        for (BuildingPlanSet set : this.vectorPlanSets) {
            if (planSetAvailable != null && planSetAvailable.contains(set.key)) continue;
            ++nbToWrite;
        }
        data.writeShort(nbToWrite);
        for (BuildingPlanSet set : this.vectorPlanSets) {
            if (planSetAvailable != null && planSetAvailable.contains(set.key)) continue;
            set.writeBuildingPlanSetInfo(data);
        }
        nbToWrite = 0;
        for (String key : this.villagerTypes.keySet()) {
            if (villagerAvailable != null && villagerAvailable.contains(key)) continue;
            ++nbToWrite;
        }
        data.writeShort(nbToWrite);
        for (String key : this.villagerTypes.keySet()) {
            if (villagerAvailable != null && villagerAvailable.contains(key)) continue;
            vtype = this.villagerTypes.get(key);
            ((VillagerType)vtype).writeVillagerTypeInfo(data);
        }
        nbToWrite = 0;
        for (String key : this.villageTypes.keySet()) {
            if (villagesAvailable != null && villagesAvailable.contains(key)) continue;
            ++nbToWrite;
        }
        data.writeShort(nbToWrite);
        for (String key : this.villageTypes.keySet()) {
            if (villagesAvailable != null && villagesAvailable.contains(key)) continue;
            vtype = this.villageTypes.get(key);
            ((VillageType)vtype).writeVillageTypeInfo(data);
        }
        nbToWrite = 0;
        for (String key : this.loneBuildingTypes.keySet()) {
            if (loneBuildingsAvailable != null && loneBuildingsAvailable.contains(key)) continue;
            ++nbToWrite;
        }
        data.writeShort(nbToWrite);
        for (String key : this.loneBuildingTypes.keySet()) {
            if (loneBuildingsAvailable != null && loneBuildingsAvailable.contains(key)) continue;
            vtype = this.loneBuildingTypes.get(key);
            ((VillageType)vtype).writeVillageTypeInfo(data);
        }
    }

    static {
        oldShopConversion.put("indianarmyforge", "armyforge");
        oldShopConversion.put("indianforge", "forge");
        oldShopConversion.put("indiantownhall", "townhall");
    }

    public static class CultureLanguage {
        public Culture culture;
        public String language;
        public boolean serverContent;
        public HashMap<String, Vector<String>> sentences = new HashMap();
        public HashMap<String, String> buildingNames = new HashMap();
        public HashMap<String, String> strings = new HashMap();
        public HashMap<String, Dialogue> dialogues = new HashMap();
        public Vector<ReputationLevel> reputationLevels = new Vector();

        public CultureLanguage(Culture c, String l, boolean serverContent) {
            this.culture = c;
            this.language = l;
            this.serverContent = serverContent;
        }

        public int[] compareWithLanguage(CultureLanguage ref, BufferedWriter writer) throws Exception {
            int translationsDone = 0;
            int translationsMissing = 0;
            Vector<String> errors = new Vector<String>();
            Vector<String> keys = new Vector<String>(ref.strings.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                if (!this.strings.containsKey(key)) {
                    errors.add("String missing for culture " + this.culture.key + ": " + key);
                    ++translationsMissing;
                    continue;
                }
                ++translationsDone;
            }
            if (errors.size() > 0) {
                writer.write("List of gaps found in culture strings for " + this.culture.key + ": " + MLN.EOL + MLN.EOL);
                for (String s : errors) {
                    writer.write(s + MLN.EOL);
                }
                writer.write(MLN.EOL);
            }
            for (Goods g : this.culture.goodsVector) {
                if (g.desc == null || this.strings.containsKey(g.desc) || ref.strings.containsKey(g.desc)) continue;
                errors.add("Trading good desc missing in both languages for item: " + g.name + ", desc key: " + g.desc);
            }
            errors.clear();
            keys = new Vector<String>(ref.sentences.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                if (key.startsWith("villager.chat_")) continue;
                if (!this.sentences.containsKey(key)) {
                    errors.add("Sentences missing for culture " + this.culture.key + ": " + key);
                    ++translationsMissing;
                    continue;
                }
                if (this.sentences.get(key).size() != ref.sentences.get(key).size()) {
                    errors.add("Different number of sentences for culture " + this.culture.key + ": " + key);
                    ++translationsMissing;
                    continue;
                }
                ++translationsDone;
            }
            if (errors.size() > 0) {
                writer.write("List of gaps found in culture sentences for " + this.culture.key + ": " + MLN.EOL + MLN.EOL);
                for (String s : errors) {
                    writer.write(s + MLN.EOL);
                }
                writer.write(MLN.EOL);
            }
            keys = new Vector<String>(ref.dialogues.keySet());
            Collections.sort(keys);
            errors.clear();
            for (String key : keys) {
                if (!this.dialogues.containsKey(key)) {
                    errors.add("Dialogue missing for culture " + this.culture.key + ": " + key);
                    ++translationsMissing;
                    continue;
                }
                boolean matches = this.dialogues.get(key).compareWith(ref.dialogues.get(key), errors);
                if (matches) {
                    ++translationsDone;
                    continue;
                }
                ++translationsMissing;
            }
            if (errors.size() > 0) {
                writer.write("List of gaps found in culture dialogues for " + this.culture.key + ": " + MLN.EOL + MLN.EOL);
                for (String s : errors) {
                    writer.write(s + MLN.EOL);
                }
                writer.write(MLN.EOL);
            }
            errors.clear();
            keys = new Vector<String>(ref.buildingNames.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                if (!this.buildingNames.containsKey(key)) {
                    errors.add("Building name missing for culture " + this.culture.key + ": " + key);
                    ++translationsMissing;
                    continue;
                }
                ++translationsDone;
            }
            for (BuildingPlanSet set : this.culture.planSet.values()) {
                for (BuildingPlan[] plans : set.plans) {
                    String planNameLC = plans[0].planName.toLowerCase();
                    if (!this.buildingNames.containsKey(planNameLC) && !ref.buildingNames.containsKey(planNameLC)) {
                        errors.add("Building name missing for culture " + this.culture.key + " in both languages: " + planNameLC);
                    }
                    if (plans[0].shop == null || this.strings.containsKey("shop." + plans[0].shop) || ref.strings.containsKey("shop." + plans[0].shop)) continue;
                    errors.add("Shop name missing for culture " + this.culture.key + " in both languages: " + "shop." + plans[0].shop);
                }
            }
            for (VillagerType vt : this.culture.vectorVillagerTypes) {
                if (this.strings.containsKey("villager." + vt.key) || ref.strings.containsKey("villager." + vt.key)) continue;
                errors.add("Villager name missing for culture " + this.culture.key + " in both languages: " + "villager." + vt.key);
            }
            if (errors.size() > 0) {
                writer.write("List of gaps found in culture building names for " + this.culture.key + ": " + MLN.EOL + MLN.EOL);
                for (String s : errors) {
                    writer.write(s + MLN.EOL);
                }
                writer.write(MLN.EOL);
            }
            if (this.reputationLevels.size() != ref.reputationLevels.size()) {
                translationsMissing += ref.reputationLevels.size() - this.reputationLevels.size();
                writer.write("Different number of reputation levels for culture " + this.culture.key + ": " + this.reputationLevels.size() + " in " + this.language + ", " + ref.reputationLevels.size() + " in " + ref.language + "." + MLN.EOL + MLN.EOL);
            } else {
                translationsDone += ref.reputationLevels.size();
            }
            return new int[]{translationsDone, translationsMissing};
        }

        public ReputationLevel getReputationLevel(int reputation) {
            int i;
            if (this.reputationLevels.size() == 0) {
                return null;
            }
            for (i = this.reputationLevels.size() - 1; i > 0 && this.reputationLevels.get((int)i).level > reputation; --i) {
            }
            return this.reputationLevels.get(i);
        }

        private void loadBuildingNames(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File file = new File(new File(languageDir, this.language), this.culture.key + "_buildings.txt");
                if (!file.exists()) {
                    file = new File(new File(languageDir, this.language.split("_")[0]), this.culture.key + "_buildings.txt");
                }
                if (!file.exists()) continue;
                this.readBuildingNameFile(file);
            }
            for (BuildingPlanSet set : this.culture.vectorPlanSets) {
                for (BuildingPlan[] plans : set.plans) {
                    for (BuildingPlan plan : plans) {
                        this.loadBuildingPlanName(plan);
                    }
                }
            }
        }

        private void loadBuildingPlanName(BuildingPlan plan) {
            String planNameLC = plan.planName.toLowerCase();
            for (String key : plan.names.keySet()) {
                if (key.equalsIgnoreCase("english")) {
                    if (!this.language.equals("en")) continue;
                    this.buildingNames.put(planNameLC, plan.names.get(key));
                    continue;
                }
                if (!key.startsWith("name_") || !key.endsWith("_" + this.language) && !key.endsWith("_" + this.language.split("_")[0])) continue;
                this.buildingNames.put(planNameLC, plan.names.get(key));
            }
        }

        private void loadCultureStrings(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File file = new File(new File(languageDir, this.language), this.culture.key + "_strings.txt");
                if (!file.exists()) {
                    file = new File(new File(languageDir, this.language.split("_")[0]), this.culture.key + "_strings.txt");
                }
                if (!file.exists()) continue;
                this.readCultureStringFile(file);
            }
        }

        public void loadFromDisk(Vector<File> languageDirs) {
            this.loadBuildingNames(languageDirs);
            this.loadCultureStrings(languageDirs);
            this.loadSentences(languageDirs);
            this.loadDialogues(languageDirs);
            this.loadReputations(languageDirs);
            if (!this.culture.loadedLanguages.containsKey(this.language)) {
                this.culture.loadedLanguages.put(this.language, this);
            }
        }

        private void loadReputationFile(File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    if (line.split(";").length <= 2) continue;
                    this.reputationLevels.add(new ReputationLevel(file, line));
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
            Collections.sort(this.reputationLevels);
        }

        private void loadReputations(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File file = new File(new File(languageDir, this.language), this.culture.key + "_reputation.txt");
                if (!file.exists()) {
                    file = new File(new File(languageDir, this.language.split("_")[0]), this.culture.key + "_reputation.txt");
                }
                if (!file.exists()) continue;
                this.loadReputationFile(file);
            }
        }

        private void loadSentences(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File file = new File(new File(languageDir, this.language), this.culture.key + "_sentences.txt");
                if (!file.exists()) {
                    file = new File(new File(languageDir, this.language.split("_")[0]), this.culture.key + "_sentences.txt");
                }
                if (!file.exists()) continue;
                this.readSentenceFile(file);
            }
        }

        private void loadDialogues(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File file = new File(new File(languageDir, this.language), this.culture.key + "_dialogues.txt");
                if (!file.exists()) {
                    file = new File(new File(languageDir, this.language.split("_")[0]), this.culture.key + "_dialogues.txt");
                }
                if (!file.exists()) continue;
                this.readDialoguesFile(file);
            }
        }

        private void readBuildingNameFile(File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    String key;
                    if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                    String[] temp = line.trim().split("=");
                    if (temp.length == 2) {
                        key = temp[0].toLowerCase();
                        String value = temp[1].trim();
                        this.buildingNames.put(key, value);
                        if (MLN.LogTranslation < 2) continue;
                        MLN.minor(this, "Loading name: " + value + " for " + key);
                        continue;
                    }
                    if (temp.length != 1) continue;
                    key = temp[0].toLowerCase();
                    this.buildingNames.put(key, "");
                    if (MLN.LogTranslation < 2) continue;
                    MLN.minor(this, "Loading empty name for " + key);
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }

        private void readCultureStringFile(File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    String key;
                    if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                    String[] temp = line.trim().split("=");
                    if (temp.length == 2) {
                        key = temp[0].toLowerCase();
                        String value = temp[1].trim();
                        this.strings.put(key, value);
                        if (MLN.LogTranslation < 2) continue;
                        MLN.minor(this, "Loading name: " + value + " for " + key);
                        continue;
                    }
                    if (temp.length != 1) continue;
                    key = temp[0].toLowerCase();
                    this.strings.put(key, "");
                    if (MLN.LogTranslation < 2) continue;
                    MLN.minor(this, "Loading empty name for " + key);
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }

        private boolean readSentenceFile(File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    String[] temp;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.split("=")).length != 2) continue;
                    String key = temp[0].toLowerCase();
                    String value = temp[1].trim();
                    if (this.sentences.containsKey(key)) {
                        this.sentences.get(key).add(value);
                        continue;
                    }
                    Vector<String> v = new Vector<String>();
                    v.add(value);
                    this.sentences.put(key, v);
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
                return false;
            }
            return true;
        }

        public Dialogue getDialogue(MillVillager v1, MillVillager v2) {
            Vector<Dialogue> possibleDialogues = new Vector<Dialogue>();
            for (Dialogue d : this.dialogues.values()) {
                if (d.isValidFor(v1, v2)) {
                    possibleDialogues.add(d);
                    continue;
                }
                if (!d.isValidFor(v2, v1)) continue;
                possibleDialogues.add(d);
            }
            if (possibleDialogues.isEmpty()) {
                return null;
            }
            MillCommonUtilities.WeightedChoice wc = MillCommonUtilities.getWeightedChoice(possibleDialogues, null);
            return (Dialogue)wc;
        }

        private boolean readDialoguesFile(File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                Dialogue dialogue = null;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                    if ((line = line.trim()).startsWith("newchat;") && line.split(";").length == 2) {
                        if (dialogue != null) {
                            if (dialogue.speechBy.size() > 0) {
                                if (this.dialogues.containsKey(dialogue.key)) {
                                    MLN.error(this.culture, this.language + ": Trying to register two dialogues with the same key: " + dialogue.key);
                                } else {
                                    dialogue.checkData(this.culture, this.language);
                                    this.dialogues.put(dialogue.key, dialogue);
                                }
                            } else {
                                MLN.error(this.culture, "In dialogue file " + file.getAbsolutePath() + " dialogue " + dialogue.key + " has no sentences.");
                            }
                        }
                        String s = line.split(";")[1].trim();
                        dialogue = new Dialogue(s);
                        if (dialogue.key != null) continue;
                        MLN.error(this.culture, this.language + ": Could not read dialogue line: " + line);
                        dialogue = null;
                        continue;
                    }
                    if (dialogue != null && line.split(";").length == 3) {
                        String[] temp = line.split(";");
                        dialogue.speechBy.add(temp[0].trim().equals("v2") ? 2 : 1);
                        dialogue.timeDelays.add(Integer.parseInt(temp[1].trim()));
                        Vector<String> sentence = new Vector<String>();
                        sentence.add(temp[2]);
                        this.sentences.put("villager.chat_" + dialogue.key + "_" + (dialogue.speechBy.size() - 1), sentence);
                        continue;
                    }
                    if (line.trim().length() <= 0) continue;
                    MLN.error(this.culture, this.language + ": In dialogue file " + file.getAbsolutePath() + " the following line is invalid: " + line);
                }
                if (dialogue.speechBy.size() > 0) {
                    if (this.dialogues.containsKey(dialogue.key)) {
                        MLN.error(this.culture, this.language + ": Trying to register two dialogues with the same key: " + dialogue.key);
                    } else {
                        dialogue.checkData(this.culture, this.language);
                        this.dialogues.put(dialogue.key, dialogue);
                    }
                } else {
                    MLN.error(this.culture, this.language + ": In dialogue file " + file.getAbsolutePath() + " dialogue " + dialogue.key + " has no sentences.");
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
                return false;
            }
            return true;
        }

        public static class Dialogue
        implements MillCommonUtilities.WeightedChoice {
            private static String adult = "adult";
            private static String child = "child";
            private static String male = "male";
            private static String female = "female";
            private static String hasspouse = "hasspouse";
            private static String nospouse = "nospouse";
            private static String vtype = "vtype";
            private static String notvtype = "notvtype";
            private static String rel_spouse = "spouse";
            private static String rel_parent = "parent";
            private static String rel_child = "child";
            private static String rel_sibling = "sibling";
            private static String tag_raining = "raining";
            private static String tag_notraining = "notraining";
            public String key = null;
            private int weight = 10;
            private final Vector<String> villager1 = new Vector();
            private final Vector<String> villager2 = new Vector();
            private final Vector<String> relations = new Vector();
            private final Vector<String> not_relations = new Vector();
            private final Vector<String> buildings = new Vector();
            private final Vector<String> not_buildings = new Vector();
            private final Vector<String> villagers = new Vector();
            private final Vector<String> not_villagers = new Vector();
            private final Vector<String> tags = new Vector();
            public final Vector<Integer> timeDelays = new Vector();
            public final Vector<Integer> speechBy = new Vector();

            Dialogue(String config) {
                for (String s : config.split(",")) {
                    if (s.split(":").length <= 1) continue;
                    String key = s.split(":")[0].trim();
                    String val = s.split(":")[1].trim();
                    if (s.split(":").length > 2) {
                        val = val + ":" + s.split(":")[2];
                    }
                    if (key.equals("key")) {
                        this.key = val;
                        continue;
                    }
                    if (key.equals("weigth")) {
                        this.weight = Integer.parseInt(val);
                        continue;
                    }
                    if (key.equals("v1")) {
                        this.villager1.add(val);
                        continue;
                    }
                    if (key.equals("v2")) {
                        this.villager2.add(val);
                        continue;
                    }
                    if (key.equals("rel")) {
                        this.relations.add(val);
                        continue;
                    }
                    if (key.equals("notrel")) {
                        this.not_relations.add(val);
                        continue;
                    }
                    if (key.equals("building")) {
                        this.buildings.add(val);
                        continue;
                    }
                    if (key.equals("notbuilding")) {
                        this.not_buildings.add(val);
                        continue;
                    }
                    if (key.equals("villager")) {
                        this.villagers.add(val);
                        continue;
                    }
                    if (key.equals("notvillager")) {
                        this.not_villagers.add(val);
                        continue;
                    }
                    if (key.equals("tag")) {
                        this.tags.add(val);
                        continue;
                    }
                    MLN.error(this, "Could not recognise key " + key + " in dialogue declaration " + config);
                }
            }

            public boolean compareWith(Dialogue d, Vector<String> errors) throws IOException {
                boolean differentSentences;
                boolean differentConfig = false;
                if (this.weight != d.weight) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.villager1, d.villager1)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.villager2, d.villager2)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.relations, d.relations)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.not_relations, d.not_relations)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.buildings, d.buildings)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.not_buildings, d.not_buildings)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.villagers, d.villagers)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.not_villagers, d.not_villagers)) {
                    differentConfig = true;
                }
                if (!this.sameVectors(this.tags, d.tags)) {
                    differentConfig = true;
                }
                if (differentConfig) {
                    errors.add("Dialogue has different configurations: " + this.key);
                }
                if (this.timeDelays.size() != d.timeDelays.size()) {
                    differentSentences = true;
                    errors.add("Dialogue has different sentence numbers: " + this.key);
                } else {
                    boolean bl = differentSentences = !this.sameVectors(this.timeDelays, d.timeDelays) || !this.sameVectors(this.speechBy, d.speechBy);
                    if (differentSentences) {
                        errors.add("Dialogue has different sentence settings: " + this.key);
                    }
                }
                return !differentSentences && !differentConfig;
            }

            private boolean sameVectors(Vector<?> v, Vector<?> v2) {
                if (v.size() != v2.size()) {
                    return false;
                }
                for (int i = 0; i < v.size(); ++i) {
                    if (v.get(i).equals(v2.get(i))) continue;
                    return false;
                }
                return true;
            }

            public boolean isValidFor(MillVillager v1, MillVillager v2) {
                return this.isCompatible(this.villager1, v1) && this.isCompatible(this.villager2, v2) && this.isRelCompatible(v1, v2) && this.isBuildingCompatible(v1.getTownHall()) && this.isVillagersCompatible(v1.getTownHall()) && this.isTagCompatible(v1.getTownHall());
            }

            private boolean isVillagersCompatible(Building townHall) {
                for (String s : this.villagers) {
                    boolean found = false;
                    for (VillagerRecord vr : townHall.vrecords) {
                        if (!vr.type.equals(s)) continue;
                        found = true;
                    }
                    if (found) continue;
                    return false;
                }
                for (String s : this.not_villagers) {
                    for (VillagerRecord vr : townHall.vrecords) {
                        if (!vr.type.equals(s)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean isBuildingCompatible(Building townHall) {
                for (String s : this.buildings) {
                    boolean found = false;
                    for (BuildingLocation bl : townHall.getLocations()) {
                        if (!bl.key.equals(s)) continue;
                        found = true;
                    }
                    if (found) continue;
                    return false;
                }
                for (String s : this.not_buildings) {
                    for (BuildingLocation bl : townHall.getLocations()) {
                        if (!bl.key.equals(s)) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean isTagCompatible(Building townHall) {
                for (String s : this.tags) {
                    if (!(s.equals(tag_raining) ? !townHall.worldObj.func_72896_J() : s.equals(tag_notraining) && townHall.worldObj.func_72896_J())) continue;
                    return false;
                }
                return true;
            }

            private boolean isRelCompatible(MillVillager v1, MillVillager v2) {
                String key;
                for (String s : this.relations) {
                    key = s.split(":")[0];
                    if (!(key.equals(rel_spouse) ? v1.getSpouse() != v2 : (key.equals(rel_parent) ? !v1.getRecord().fathersName.equals(v2.getName()) && !v1.getRecord().mothersName.equals(v2.getName()) : (key.equals(rel_child) ? !v2.getRecord().fathersName.equals(v1.getName()) && !v2.getRecord().mothersName.equals(v1.getName()) : key.equals(rel_sibling) && !v2.getRecord().mothersName.equals(v1.getRecord().mothersName))))) continue;
                    return false;
                }
                for (String s : this.not_relations) {
                    key = s.split(":")[0];
                    if (!(key.equals(rel_spouse) ? v1.getSpouse() == v2 : (key.equals(rel_parent) ? v1.getRecord().fathersName.equals(v2.getName()) || v1.getRecord().mothersName.equals(v2.getName()) : (key.equals(rel_child) ? v2.getRecord().fathersName.equals(v1.getName()) || v2.getRecord().mothersName.equals(v1.getName()) : key.equals(rel_sibling) && v2.getRecord().mothersName.equals(v1.getRecord().mothersName))))) continue;
                    return false;
                }
                return true;
            }

            public int validRoleFor(MillVillager v) {
                if (this.isCompatible(this.villager1, v)) {
                    return 1;
                }
                if (this.isCompatible(this.villager2, v)) {
                    return 2;
                }
                return 0;
            }

            private boolean isCompatible(Vector<String> req, MillVillager v) {
                if (v.getRecord() == null) {
                    return false;
                }
                for (String s : req) {
                    String key = s.split(":")[0];
                    String val = null;
                    if (s.split(":").length > 1) {
                        val = s.split(":")[1];
                    }
                    if (key.equals(adult)) {
                        if (!v.vtype.isChild) continue;
                        return false;
                    }
                    if (key.equals(child)) {
                        if (v.vtype.isChild) continue;
                        return false;
                    }
                    if (key.equals(male)) {
                        if (v.vtype.gender == 1) continue;
                        return false;
                    }
                    if (key.equals(female)) {
                        if (v.vtype.gender == 2) continue;
                        return false;
                    }
                    if (key.equals(vtype)) {
                        boolean found = false;
                        for (String type : val.split("-")) {
                            if (!type.equals(v.vtype.key)) continue;
                            found = true;
                        }
                        if (found) continue;
                        return false;
                    }
                    if (key.equals(notvtype)) {
                        for (String type : val.split("-")) {
                            if (!type.equals(v.vtype.key)) continue;
                            return false;
                        }
                        continue;
                    }
                    if (!(key.equals(hasspouse) ? v.getRecord().spousesName == null || v.getRecord().spousesName.equals("") : (v.getRecord().spousesName != null && key.equals(nospouse) ? !v.getRecord().spousesName.equals("") : key.equals(female) && v.vtype.gender != 2))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public int getChoiceWeight(EntityPlayer player) {
                return this.weight;
            }

            public void checkData(Culture culture, String language) {
                for (String s : this.villager1) {
                    if (!(s.equals(adult) || s.equals(child) || s.equals(male) || s.equals(female) || s.equals(hasspouse) || s.equals(nospouse) || s.startsWith(vtype + ":") || s.startsWith(notvtype + ":"))) {
                        MLN.error(culture, language + ": Unknown v1 setting in dialogue " + this.key + ": " + s);
                    }
                    if (!s.startsWith(vtype + ":") && !s.startsWith(notvtype + ":")) continue;
                    String s2 = s.split(":")[1].trim();
                    for (String vtype : s2.split("-")) {
                        if (culture.villagerTypes.containsKey(vtype = vtype.trim())) continue;
                        MLN.error(culture, language + ": Unknown villager type in dialogue " + this.key + ": " + s);
                    }
                }
                for (String s : this.villager2) {
                    if (s.equals(adult) || s.equals(child) || s.equals(male) || s.equals(female) || s.equals(hasspouse) || s.equals(nospouse) || s.startsWith(vtype + ":") || s.startsWith(notvtype + ":")) continue;
                    MLN.error(culture, language + ": Unknown v2 setting in dialogue " + this.key + ": " + s);
                }
                for (String s : this.relations) {
                    if (s.equals(rel_spouse) || s.equals(rel_parent) || s.equals(rel_child) || s.equals(rel_sibling)) continue;
                    MLN.error(culture, language + ": Unknown rel setting in dialogue " + this.key + ": " + s);
                }
                for (String s : this.not_relations) {
                    if (s.equals(rel_spouse) || s.equals(rel_parent) || s.equals(rel_child) || s.equals(rel_sibling)) continue;
                    MLN.error(culture, language + ": Unknown notrel setting in dialogue " + this.key + ": " + s);
                }
                for (String s : this.tags) {
                    if (s.equals(tag_raining) || s.equals(tag_notraining)) continue;
                    MLN.error(culture, language + ": Unknown tag in dialogue " + this.key + ": " + s);
                }
                for (String s : this.buildings) {
                    if (culture.planSet.containsKey(s)) continue;
                    MLN.error(culture, language + ": Unknown building in dialogue " + this.key + ": " + s);
                }
                for (String s : this.not_buildings) {
                    if (culture.planSet.containsKey(s)) continue;
                    MLN.error(culture, language + ": Unknown notbuilding in dialogue " + this.key + ": " + s);
                }
                for (String s : this.villagers) {
                    if (culture.villagerTypes.containsKey(s)) continue;
                    MLN.error(culture, language + ": Unknown villager in dialogue " + this.key + ": " + s);
                }
                for (String s : this.not_villagers) {
                    if (culture.villagerTypes.containsKey(s)) continue;
                    MLN.error(culture, language + ": Unknown notvillager in dialogue " + this.key + ": " + s);
                }
            }
        }

        public static class ReputationLevel
        implements Comparable<ReputationLevel> {
            private String label;
            private String desc;
            public int level;

            public ReputationLevel(File file, String line) {
                try {
                    this.level = MillCommonUtilities.readInteger(line.split(";")[0]);
                }
                catch (Exception e) {
                    this.level = 0;
                    MLN.error(null, "Error when reading reputation line in file " + file.getAbsolutePath() + ": " + line + " : " + e.getMessage());
                }
                this.label = line.split(";")[1];
                this.desc = line.split(";")[2];
            }

            @Override
            public int compareTo(ReputationLevel o) {
                return this.level - o.level;
            }
        }
    }
}

