/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MillConfig;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Quest;
import org.millenaire.common.VillageType;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingPlanSet;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;

public class MLN {
    public static boolean logPerformed = false;
    public static final char BLACK = '0';
    public static final char DARKBLUE = '1';
    public static final char DARKGREEN = '2';
    public static final char LIGHTBLUE = '3';
    public static final char DARKRED = '4';
    public static final char PURPLE = '5';
    public static final char ORANGE = '6';
    public static final char LIGHTGREY = '7';
    public static final char DARKGREY = '8';
    public static final char BLUE = '9';
    public static final char LIGHTGREEN = 'a';
    public static final char CYAN = 'b';
    public static final char LIGHTRED = 'c';
    public static final char PINK = 'd';
    public static final char YELLOW = 'e';
    public static final char WHITE = 'f';
    public static int KeepActiveRadius = 200;
    public static int BackgroundRadius = 2000;
    public static int BanditRaidRadius = 1500;
    public static int LogBuildingPlan = 0;
    public static int LogCattleFarmer = 0;
    public static int LogChildren = 0;
    public static int LogTranslation = 0;
    public static int LogConnections = 0;
    public static int LogCulture = 0;
    public static int LogDiplomacy = 0;
    public static int LogFarmerAI = 0;
    public static int LogGeneralAI = 0;
    public static int LogGetPath = 0;
    public static int LogHybernation = 0;
    public static int LogLumberman = 0;
    public static int LogMerchant = 0;
    public static int LogMiner = 0;
    public static int LogOther = 0;
    public static int LogPathing = 0;
    public static int LogPerformance = 0;
    public static int LogSelling = 0;
    public static int LogTileEntityBuilding = 0;
    public static int LogVillage = 0;
    public static int LogVillager = 0;
    public static int LogQuest = 0;
    public static int LogWifeAI = 0;
    public static int LogWorldGeneration = 0;
    public static int LogWorldInfo = 0;
    public static int LogPujas = 0;
    public static int LogVillagerSpawn = 0;
    public static int LogVillagePaths = 0;
    public static String questBiomeForest = "forest";
    public static String questBiomeDesert = "desert";
    public static String questBiomeMountain = "mountain";
    public static int LogNetwork = 0;
    public static final int MAJOR = 1;
    public static final int MINOR = 2;
    public static final int DEBUG = 3;
    private static boolean console = true;
    public static final String DATE_FORMAT_NOW = "dd-MM-yyyy HH:mm:ss";
    public static boolean DEV = false;
    public static boolean displayNames = true;
    public static boolean displayStart = true;
    public static final String EOL = System.getProperty("line.separator");
    public static Vector<Block> forbiddenBlocks = new Vector();
    public static boolean generateBuildingRes = false;
    public static boolean generateColourSheet = false;
    public static boolean generateVillages = true;
    public static boolean generateVillagesDefault = true;
    public static boolean generateLoneBuildings = true;
    public static boolean generateTranslationGap = false;
    public static boolean generateGoodsList = false;
    public static boolean infiniteAmulet = false;
    public static boolean languageLearning = true;
    public static boolean stopDefaultVillages = false;
    public static boolean seIndicators = false;
    public static boolean loadAllLanguages = true;
    public static boolean jpsPathing = true;
    public static String main_language = "";
    public static String effective_language = "";
    public static String fallback_language = "en";
    private static boolean logfile = true;
    public static int maxChildrenNumber = 10;
    public static int minDistanceBetweenBuildings = 5;
    public static int minDistanceBetweenVillages = 500;
    public static int minDistanceBetweenVillagesAndLoneBuildings = 250;
    public static int minDistanceBetweenLoneBuildings = 500;
    public static int forcePreload = 0;
    public static int spawnProtectionRadius = 250;
    public static int VillageRadius = 60;
    public static int VillagersNamesDistance = 6;
    public static boolean BuildVillagePaths = true;
    public static int VillagersSentenceInChatDistanceClient = 0;
    public static int VillagersSentenceInChatDistanceSP = 6;
    public static int RaidingRate = 20;
    public static int keyVillageList;
    public static int keyInfoPanelList;
    public static int keyAggressiveEscorts;
    private static FileWriter writer;
    private static String loadedLanguage;
    public static int textureSize;
    public static boolean dynamictextures;
    public static String customTexture;
    public static Language mainLanguage;
    public static Language fallbackLanguage;
    public static Language serverMainLanguage;
    public static Language serverFallbackLanguage;
    public static HashMap<String, Language> loadedLanguages;
    public static String bonusCode;
    public static boolean bonusEnabled;
    public static HashMap<String, MillConfig> configs;
    public static Vector<String> configPageTitles;
    public static Vector<String> configPageDesc;
    public static Vector<Vector<MillConfig>> configPages;
    public static final ResourceLocation textureLargeChest64;
    public static final ResourceLocation textureLargeChest;
    public static final ResourceLocation textureChest64;
    public static final ResourceLocation textureChest;

    private static void initConfigItems() {
        try {
            Vector<MillConfig> configPage = new Vector<MillConfig>();
            configPage.add(new MillConfig(MLN.class.getField("keyVillageList"), "village_list_key", 3).setMaxStringLength(1));
            configPage.add(new MillConfig(MLN.class.getField("keyInfoPanelList"), "quest_list_key", 3).setMaxStringLength(1));
            configPage.add(new MillConfig(MLN.class.getField("keyAggressiveEscorts"), "escort_key", 3).setMaxStringLength(1));
            configPage.add(new MillConfig(MLN.class.getField("fallback_language"), "fallback_language", "en", "fr"));
            configPage.add(new MillConfig(MLN.class.getField("dynamictextures"), "dynamic_textures", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("languageLearning"), "language_learning", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("loadAllLanguages"), "load_all_languages", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("displayStart"), "display_start", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("displayNames"), "display_names", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("VillagersNamesDistance"), "villagers_names_distance", 5, 10, 20, 30, 50));
            configPage.add(new MillConfig(MLN.class.getField("VillagersSentenceInChatDistanceSP"), "villagers_sentence_in_chat_distance_sp", 0, 1, 2, 3, 4, 6, 10));
            configPage.add(new MillConfig(MLN.class.getField("VillagersSentenceInChatDistanceClient"), "villagers_sentence_in_chat_distance_client", 0, 1, 2, 3, 4, 6, 10));
            configPages.add(configPage);
            configPageTitles.add("config.page.uisettings");
            configPageDesc.add(null);
            configPage = new Vector();
            configPage = new Vector();
            configPage.add(new MillConfig(MLN.class.getField("generateVillagesDefault"), "generate_villages", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("generateLoneBuildings"), "generate_lone_buildings", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("minDistanceBetweenVillages"), "min_village_distance", 300, 450, 600, 800, 1000));
            configPage.add(new MillConfig(MLN.class.getField("minDistanceBetweenVillagesAndLoneBuildings"), "min_village_lonebuilding_distance", 100, 200, 300, 500, 800));
            configPage.add(new MillConfig(MLN.class.getField("minDistanceBetweenLoneBuildings"), "min_lonebuilding_distance", 300, 450, 600, 800, 1000));
            configPage.add(new MillConfig(MLN.class.getField("spawnProtectionRadius"), "spawn_protection_radius", 0, 50, 100, 150, 250, 500));
            configPages.add(configPage);
            configPageTitles.add("config.page.worldgeneration");
            configPageDesc.add("config.page.worldgeneration.desc");
            configPage = new Vector();
            configPage.add(new MillConfig(MLN.class.getField("KeepActiveRadius"), "keep_active_radius", 0, 100, 150, 200, 250, 300, 400, 500));
            configPage.add(new MillConfig(MLN.class.getField("VillageRadius"), "village_radius", 40, 50, 60, 70, 80));
            configPage.add(new MillConfig(MLN.class.getField("minDistanceBetweenBuildings"), "min_distance_between_buildings", 0, 1, 2, 3, 4));
            configPage.add(new MillConfig(MLN.class.getField("BuildVillagePaths"), "village_paths", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("maxChildrenNumber"), "max_children_number", 2, 5, 10, 15, 20));
            configPage.add(new MillConfig(MLN.class.getField("BackgroundRadius"), "background_radius", 0, 200, 500, 1000, 1500, 2000, 2500, 3000));
            configPage.add(new MillConfig(MLN.class.getField("BanditRaidRadius"), "bandit_raid_radius", 0, 200, 500, 1000, 1500, 2000));
            configPage.add(new MillConfig(MLN.class.getField("RaidingRate"), "raiding_rate", 0, 10, 20, 50, 100));
            configPages.add(configPage);
            configPageTitles.add("config.page.villagebehaviour");
            configPageDesc.add("config.page.villagebehaviour.desc");
            configPage = new Vector();
            configPage.add(new MillConfig(MLN.class.getField("generateTranslationGap"), "generate_translation_gap", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("generateColourSheet"), "generate_colour_chart", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("generateBuildingRes"), "generate_building_res", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("generateGoodsList"), "generate_goods_list", new Object[0]));
            configPage.add(new MillConfig(MLN.class.getField("LogTileEntityBuilding"), "LogTileEntityBuilding", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogWorldGeneration"), "LogWorldGeneration", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogFarmerAI"), "LogFarmerAI", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogDiplomacy"), "LogDiplomacy", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogWifeAI"), "LogWifeAI", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogVillager"), "LogVillager", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogQuest"), "LogQuest", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogPathing"), "LogPathing", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogConnections"), "LogConnections", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogGetPath"), "LogGetPath", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogLumberman"), "LogLumberman", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogBuildingPlan"), "LogBuildingPlan", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogGeneralAI"), "LogGeneralAI", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogSelling"), "LogSelling", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogHybernation"), "LogHybernation", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogOther"), "LogOther", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogChildren"), "LogChildren", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogPerformance"), "LogPerformance", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogCattleFarmer"), "LogCattleFarmer", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogMiner"), "LogMiner", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogVillage"), "LogVillage", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogWorldInfo"), "LogWorldInfo", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogPujas"), "LogPujas", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogVillagerSpawn"), "LogVillagerSpawn", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogVillagePaths"), "LogVillagePaths", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogNetwork"), "LogNetwork", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogMerchant"), "LogMerchant", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogCulture"), "LogCulture", 5).setDisplayDev(true));
            configPage.add(new MillConfig(MLN.class.getField("LogTranslation"), "LogTranslation", 5).setDisplayDev(true));
            configPages.add(configPage);
            configPageTitles.add("config.page.devtools");
            configPageDesc.add(null);
            configPage = new Vector();
            configPage.add(new MillConfig(MLN.class.getField("bonusCode"), "bonus_code", 6).setMaxStringLength(4));
            configPages.add(configPage);
            configPageTitles.add("config.page.bonus");
            configPageDesc.add("config.page.bonus.desc");
            for (Vector<MillConfig> aConfigPage : configPages) {
                for (MillConfig config : aConfigPage) {
                    configs.put(config.key, config);
                }
            }
        }
        catch (Exception e) {
            MLN.error(null, "Exception when initialising config items: " + e);
        }
    }

    private static String md5(String input) {
        String result = input;
        if (input != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(input.getBytes());
                BigInteger hash = new BigInteger(1, md.digest());
                result = hash.toString(16);
                while (result.length() < 32) {
                    result = "0" + result;
                }
            }
            catch (NoSuchAlgorithmException e) {
                MLN.printException("Exception in md5():", e);
            }
        }
        return result;
    }

    public static String calculateLoginMD5(String login) {
        return MLN.md5(login + login.substring(1)).substring(0, 4);
    }

    public static void checkBonusCode(boolean manual) {
        if (Mill.proxy.getSinglePlayerName() == null) {
            bonusEnabled = false;
            return;
        }
        String login = Mill.proxy.getSinglePlayerName();
        if (bonusCode != null) {
            String calculatedCode = MLN.calculateLoginMD5(login);
            bonusEnabled = calculatedCode.equals(bonusCode);
        }
        if (!bonusEnabled && !manual) {
            new MillCommonUtilities.BonusThread(login).start();
        }
        if (manual && bonusCode != null && bonusCode.length() == 4) {
            if (bonusEnabled) {
                Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), '2', MLN.string("config.validbonuscode"));
            } else {
                Mill.proxy.sendLocalChat(Mill.proxy.getTheSinglePlayer(), '4', MLN.string("config.invalidbonuscode"));
            }
        }
    }

    private static void applyLanguage() {
        MLN.nameItems();
        LanguageRegistry.instance().addStringLocalization("entity.ml_GenericVillager.name", MLN.string("other.malevillager"));
        LanguageRegistry.instance().addStringLocalization("entity.ml_GenericAsimmFemale.name", MLN.string("other.femalevillager"));
        LanguageRegistry.instance().addStringLocalization("entity.ml_GenericSimmFemale.name", MLN.string("other.femalevillager"));
        if (!Mill.proxy.isTrueServer()) {
            MillVillager.InvItem iv = new MillVillager.InvItem(Mill.summoningWand, 1);
            MLN.major(null, "Language loaded: " + effective_language + ". Wand name: " + MLN.string("item.villagewand") + " Wand invitem name: " + iv.getName());
            if (generateBuildingRes) {
                MLN.major(null, "Generating building res file.");
                BuildingPlan.generateBuildingRes();
                try {
                    BuildingPlan.generateWikiTable();
                }
                catch (MillenaireException e) {
                    MLN.printException(e);
                }
                MLN.major(null, "Generated building res file.");
            }
        }
    }

    public static void debug(Object obj, String s) {
        MLN.writeText("DEBUG: " + obj + ": " + s);
    }

    public static void error(Object obj, String s) {
        if (DEV) {
            MLN.writeText("    !====================================!");
        }
        MLN.writeText("ERROR: " + obj + ": " + s);
        if (DEV) {
            MLN.writeText("     ==================================== ");
        }
    }

    private static String fillInName(String s) {
        if (s == null) {
            return "";
        }
        EntityPlayer player = Mill.proxy.getTheSinglePlayer();
        if (player != null) {
            return s.replaceAll("\\$name", player.getDisplayName());
        }
        return s;
    }

    public static Vector<Vector<String>> getHelp(int id) {
        if (MLN.mainLanguage.help.containsKey(id)) {
            return MLN.mainLanguage.help.get(id);
        }
        if (MLN.fallbackLanguage.help.containsKey(id)) {
            return MLN.fallbackLanguage.help.get(id);
        }
        return null;
    }

    public static Vector<String> getHoFData() {
        Vector<String> hofData = new Vector<String>();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(new File(Mill.proxy.getBaseDir(), "hof.txt"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                hofData.add(line);
            }
        }
        catch (Exception e) {
            MLN.printException("Error when loading HoF: ", e);
        }
        return hofData;
    }

    public static ResourceLocation getLargeLockedChestTexture() {
        if (dynamictextures && textureSize >= 64) {
            return textureLargeChest64;
        }
        return textureLargeChest;
    }

    public static ResourceLocation getLockedChestTexture() {
        if (dynamictextures && textureSize >= 64) {
            return textureChest64;
        }
        return textureChest;
    }

    public static Vector<Vector<String>> getParchment(int id) {
        if (MLN.mainLanguage.texts.containsKey(id)) {
            return MLN.mainLanguage.texts.get(id);
        }
        if (MLN.fallbackLanguage.texts.containsKey(id)) {
            return MLN.fallbackLanguage.texts.get(id);
        }
        return null;
    }

    public static String getRawString(String key, boolean mustFind) {
        return MLN.getRawString(key, mustFind, true, true);
    }

    public static String getRawString(String key, boolean mustFind, boolean main, boolean fallback) {
        if (main && mainLanguage != null && MLN.mainLanguage.strings.containsKey(key)) {
            return MLN.mainLanguage.strings.get(key);
        }
        if (main && serverMainLanguage != null && MLN.serverMainLanguage.strings.containsKey(key)) {
            return MLN.serverMainLanguage.strings.get(key);
        }
        if (fallback && fallbackLanguage != null && MLN.fallbackLanguage.strings.containsKey(key)) {
            return MLN.fallbackLanguage.strings.get(key);
        }
        if (fallback && serverFallbackLanguage != null && MLN.serverFallbackLanguage.strings.containsKey(key)) {
            return MLN.serverFallbackLanguage.strings.get(key);
        }
        if (mustFind && LogTranslation >= 1) {
            MLN.error(null, "String not found: " + key);
        }
        if (mustFind) {
            return key;
        }
        return null;
    }

    public static String getRawStringFallbackOnly(String key, boolean mustFind) {
        return MLN.getRawString(key, mustFind, false, true);
    }

    public static String getRawStringMainOnly(String key, boolean mustFind) {
        return MLN.getRawString(key, mustFind, true, false);
    }

    public static String getTextSuffix() {
        if (textureSize == -1) {
            Mill.proxy.testTextureSize();
        }
        if (customTexture != null) {
            return "";
        }
        if (dynamictextures && textureSize >= 64) {
            return "_64";
        }
        return "";
    }

    public static boolean isTranslationLoaded() {
        return mainLanguage != null;
    }

    public static void loadConfig() {
        Mill.proxy.loadKeyDefaultSettings();
        MLN.initConfigItems();
        boolean mainConfig = MLN.readConfigFile(Mill.proxy.getConfigFile(), true);
        if (!mainConfig) {
            System.err.println("ERREUR: Impossible de trouver le fichier de configuration " + Mill.proxy.getConfigFile().getAbsolutePath() + ". V\u00e9rifiez que le dossier millenaire est bien dans minecraft/mods/");
            System.err.println("ERROR: Could not find the config file at " + Mill.proxy.getConfigFile().getAbsolutePath() + ". Check that the millenaire directory is in minecraft/mods/");
            if (!Mill.proxy.isTrueServer()) {
                Mill.displayMillenaireLocationError = true;
            }
            Mill.startupError = true;
            return;
        }
        MLN.readConfigFile(Mill.proxy.getCustomConfigFile(), false);
        if (logfile) {
            try {
                writer = new FileWriter(Mill.proxy.getLogFile(), true);
            }
            catch (IOException e) {
                writer = null;
            }
        } else {
            writer = null;
        }
        Mill.loadingDirs.add(Mill.proxy.getBaseDir());
        File modDirs = new File(Mill.proxy.getCustomDir(), "mods");
        modDirs.mkdirs();
        String mods = "";
        for (File mod : modDirs.listFiles()) {
            if (!mod.isDirectory() || mod.isHidden()) continue;
            Mill.loadingDirs.add(mod);
            mods = mods + mod.getName() + " ";
        }
        if (mods.length() == 0) {
            MLN.writeText("Starting new session.");
        } else {
            MLN.writeText("Starting new session. Mods: " + mods);
        }
    }

    public static Vector<File> getLanguageDirs() {
        Vector<File> languageDirs = new Vector<File>();
        for (File dir : Mill.loadingDirs) {
            File languageDir = new File(dir, "languages");
            if (!languageDir.exists()) continue;
            languageDirs.add(languageDir);
        }
        return languageDirs;
    }

    public static void loadLanguages(String minecraftLanguage) {
        Language l;
        effective_language = !main_language.equals("") ? main_language : (minecraftLanguage != null ? minecraftLanguage : "fr");
        if (loadedLanguage != null && loadedLanguage.equals(effective_language)) {
            return;
        }
        MLN.major(null, "Loading language: " + effective_language);
        loadedLanguage = effective_language;
        Vector<File> languageDirs = MLN.getLanguageDirs();
        mainLanguage = new Language(effective_language, false);
        mainLanguage.loadFromDisk(languageDirs);
        if (main_language.equals(fallback_language)) {
            fallbackLanguage = mainLanguage;
        } else {
            fallbackLanguage = new Language(fallback_language, false);
            fallbackLanguage.loadFromDisk(languageDirs);
        }
        if (loadAllLanguages) {
            File mainDir = languageDirs.firstElement();
            for (File lang : mainDir.listFiles()) {
                String key;
                if (!lang.isDirectory() || lang.isHidden() || loadedLanguages.containsKey(key = lang.getName().toLowerCase())) continue;
                Language l2 = new Language(key, false);
                l2.loadFromDisk(languageDirs);
            }
        }
        if (!loadedLanguages.containsKey("fr")) {
            l = new Language("fr", false);
            l.loadFromDisk(languageDirs);
        }
        if (!loadedLanguages.containsKey("en")) {
            l = new Language("en", false);
            l.loadFromDisk(languageDirs);
        }
        for (Culture c : Culture.vectorCultures) {
            c.loadLanguages(languageDirs, effective_language, fallback_language);
        }
        VillageType.loadLevelNames();
        MLN.applyLanguage();
        if (generateTranslationGap) {
            File file;
            HashMap<String, Integer> percentageComplete = new HashMap<String, Integer>();
            ArrayList<Language> list = new ArrayList<Language>(loadedLanguages.values());
            for (Language l3 : list) {
                String refLanguage = l3.language.startsWith("fr") ? "en" : "fr";
                Language ref = null;
                if (loadedLanguages.containsKey(refLanguage)) {
                    ref = loadedLanguages.get(refLanguage);
                } else {
                    ref = new Language(refLanguage, false);
                    ref.loadFromDisk(languageDirs);
                }
                l3.compareWithLanguage(percentageComplete, ref);
            }
            File translationGapDir = new File(Mill.proxy.getBaseDir(), "Translation gaps");
            if (!translationGapDir.exists()) {
                translationGapDir.mkdirs();
            }
            if ((file = new File(translationGapDir, "Results.txt")).exists()) {
                file.delete();
            }
            try {
                BufferedWriter writer = MillCommonUtilities.getWriter(file);
                for (String key : percentageComplete.keySet()) {
                    writer.write(key + ": " + percentageComplete.get(key) + "%" + EOL);
                }
                writer.close();
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        if (DEV) {
            MLN.writeBaseConfigFile();
        }
    }

    public static void major(Object obj, String s) {
        MLN.writeText("MAJOR: " + obj + ": " + s);
    }

    public static void minor(Object obj, String s) {
        MLN.writeText("MINOR: " + obj + ": " + s);
    }

    private static void nameItems() {
        LanguageRegistry.addName((Object)Mill.lockedChest, (String)MLN.string("item.building"));
        LanguageRegistry.addName((Object)Mill.denier, (String)MLN.string("item.denier"));
        LanguageRegistry.addName((Object)Mill.denier_or, (String)MLN.string("item.denieror"));
        LanguageRegistry.addName((Object)Mill.denier_argent, (String)MLN.string("item.denierargent"));
        LanguageRegistry.addName((Object)Mill.calva, (String)MLN.string("item.calva"));
        LanguageRegistry.addName((Object)Mill.tripes, (String)MLN.string("item.tripes"));
        LanguageRegistry.addName((Object)Mill.boudin, (String)MLN.string("item.boudin"));
        LanguageRegistry.addName((Object)Mill.ciderapple, (String)MLN.string("item.ciderapple"));
        LanguageRegistry.addName((Object)Mill.cider, (String)MLN.string("item.cider"));
        LanguageRegistry.addName((Object)Mill.summoningWand, (String)MLN.string("item.villagewand"));
        LanguageRegistry.addName((Object)Mill.negationWand, (String)MLN.string("item.negationwand"));
        LanguageRegistry.addName((Object)Mill.normanPickaxe, (String)MLN.string("item.normanPickaxe"));
        LanguageRegistry.addName((Object)Mill.normanAxe, (String)MLN.string("item.normanAxe"));
        LanguageRegistry.addName((Object)Mill.normanShovel, (String)MLN.string("item.normanShovel"));
        LanguageRegistry.addName((Object)Mill.normanHoe, (String)MLN.string("item.normanHoe"));
        LanguageRegistry.addName((Object)Mill.normanBroadsword, (String)MLN.string("item.normanBroadsword"));
        LanguageRegistry.addName((Object)Mill.normanHelmet, (String)MLN.string("item.normanHelmet"));
        LanguageRegistry.addName((Object)Mill.normanPlate, (String)MLN.string("item.normanPlate"));
        LanguageRegistry.addName((Object)Mill.normanLegs, (String)MLN.string("item.normanLegs"));
        LanguageRegistry.addName((Object)Mill.normanBoots, (String)MLN.string("item.normanBoots"));
        LanguageRegistry.addName((Object)Mill.parchmentVillagers, (String)MLN.string("item.normanvillagers"));
        LanguageRegistry.addName((Object)Mill.parchmentBuildings, (String)MLN.string("item.normanbuildings"));
        LanguageRegistry.addName((Object)Mill.parchmentItems, (String)MLN.string("item.normanitems"));
        LanguageRegistry.addName((Object)Mill.parchmentComplete, (String)MLN.string("item.normanfull"));
        LanguageRegistry.addName((Object)Mill.tapestry, (String)MLN.string("item.tapestry"));
        LanguageRegistry.addName((Object)Mill.vishnu_amulet, (String)MLN.string("item.vishnu_amulet"));
        LanguageRegistry.addName((Object)Mill.alchemist_amulet, (String)MLN.string("item.alchemist_amulet"));
        LanguageRegistry.addName((Object)Mill.yddrasil_amulet, (String)MLN.string("item.yddrasil_amulet"));
        LanguageRegistry.addName((Object)Mill.skoll_hati_amulet, (String)MLN.string("item.skoll_hati_amulet"));
        LanguageRegistry.addName((Object)Mill.parchmentVillageScroll, (String)MLN.string("item.villagescroll"));
        LanguageRegistry.addName((Object)Mill.rice, (String)MLN.string("item.rice"));
        LanguageRegistry.addName((Object)Mill.turmeric, (String)MLN.string("item.turmeric"));
        LanguageRegistry.addName((Object)Mill.vegcurry, (String)MLN.string("item.vegcurry"));
        LanguageRegistry.addName((Object)Mill.chickencurry, (String)MLN.string("item.chickencurry"));
        LanguageRegistry.addName((Object)Mill.brickmould, (String)MLN.string("item.brickmould"));
        LanguageRegistry.addName((Object)Mill.rasgulla, (String)MLN.string("item.rasgulla"));
        LanguageRegistry.addName((Object)Mill.indianstatue, (String)MLN.string("item.indianstatue"));
        LanguageRegistry.addName((Object)Mill.parchmentIndianVillagers, (String)MLN.string("item.indianvillagers"));
        LanguageRegistry.addName((Object)Mill.parchmentIndianBuildings, (String)MLN.string("item.indianbuildings"));
        LanguageRegistry.addName((Object)Mill.parchmentIndianItems, (String)MLN.string("item.indianitems"));
        LanguageRegistry.addName((Object)Mill.parchmentIndianComplete, (String)MLN.string("item.indianfull"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.wood_decoration, 1, 0), (String)MLN.string("item.plaintimber"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.wood_decoration, 1, 1), (String)MLN.string("item.crosstimber"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.wood_decoration, 1, 2), (String)MLN.string("item.thatched"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.wood_decoration, 1, 3), (String)MLN.string("item.emptysilkwormblock"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.wood_decoration, 1, 4), (String)MLN.string("item.fullsilkwormblock"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.earth_decoration, 1, 0), (String)MLN.string("item.wetbrick"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.earth_decoration, 1, 1), (String)MLN.string("item.dirtwall"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.stone_decoration, 1, 0), (String)MLN.string("item.cookedbrick"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.stone_decoration, 1, 1), (String)MLN.string("item.mudbrick"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.stone_decoration, 1, 2), (String)MLN.string("item.mayangold"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.stone_decoration, 1, 3), (String)MLN.string("item.alchimistexplosive"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 0), (String)MLN.string("item.pathdirt"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 1), (String)MLN.string("item.pathgravel"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 2), (String)MLN.string("item.pathslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 3), (String)MLN.string("item.pathsandstone"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 4), (String)MLN.string("item.pathochretiles"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 5), (String)MLN.string("item.pathgravelslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 8), (String)MLN.string("item.pathdirt"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 9), (String)MLN.string("item.pathgravel"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 10), (String)MLN.string("item.pathslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 11), (String)MLN.string("item.pathsandstone"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 12), (String)MLN.string("item.pathochretiles"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.path, 1, 13), (String)MLN.string("item.pathgravelslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 0), (String)MLN.string("item.pathdirt"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 1), (String)MLN.string("item.pathgravel"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 2), (String)MLN.string("item.pathslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 3), (String)MLN.string("item.pathsandstone"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 4), (String)MLN.string("item.pathochretiles"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 5), (String)MLN.string("item.pathgravelslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 8), (String)MLN.string("item.pathdirt"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 9), (String)MLN.string("item.pathgravel"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 10), (String)MLN.string("item.pathslabs"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 11), (String)MLN.string("item.pathsandstone"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 12), (String)MLN.string("item.pathochretiles"));
        LanguageRegistry.addName((Object)new ItemStack((Block)Mill.pathSlab, 1, 13), (String)MLN.string("item.pathgravelslabs"));
        LanguageRegistry.addName((Object)Mill.mayanstatue, (String)MLN.string("item.mayanstatue"));
        LanguageRegistry.addName((Object)Mill.maize, (String)MLN.string("item.maize"));
        LanguageRegistry.addName((Object)Mill.wah, (String)MLN.string("item.wah"));
        LanguageRegistry.addName((Object)Mill.masa, (String)MLN.string("item.masa"));
        LanguageRegistry.addName((Object)Mill.unknownPowder, (String)MLN.string("item.unknownpowder"));
        LanguageRegistry.addName((Object)Mill.parchmentMayanVillagers, (String)MLN.string("item.mayanvillagers"));
        LanguageRegistry.addName((Object)Mill.parchmentMayanBuildings, (String)MLN.string("item.mayanbuildings"));
        LanguageRegistry.addName((Object)Mill.parchmentMayanItems, (String)MLN.string("item.mayanitems"));
        LanguageRegistry.addName((Object)Mill.parchmentMayanComplete, (String)MLN.string("item.mayanfull"));
        LanguageRegistry.addName((Object)Mill.parchmentSadhu, (String)MLN.string("item.parchmentsadhu"));
        LanguageRegistry.addName((Object)new ItemStack(Mill.paperWall, 1, 0), (String)MLN.string("item.paperwall"));
        LanguageRegistry.addName((Object)Mill.udon, (String)MLN.string("item.udon"));
        LanguageRegistry.addName((Object)Mill.tachiSword, (String)MLN.string("item.tachisword"));
        LanguageRegistry.addName((Object)Mill.obsidianFlake, (String)MLN.string("item.obsidianFlake"));
        LanguageRegistry.addName((Object)Mill.mayanPickaxe, (String)MLN.string("item.mayanPickaxe"));
        LanguageRegistry.addName((Object)Mill.mayanAxe, (String)MLN.string("item.mayanAxe"));
        LanguageRegistry.addName((Object)Mill.mayanShovel, (String)MLN.string("item.mayanShovel"));
        LanguageRegistry.addName((Object)Mill.mayanHoe, (String)MLN.string("item.mayanHoe"));
        LanguageRegistry.addName((Object)Mill.mayanMace, (String)MLN.string("item.mayanMace"));
        LanguageRegistry.addName((Object)Mill.yumiBow, (String)MLN.string("item.yumibow"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorBlueLegs, (String)MLN.string("item.japaneseWarriorBlueLegs"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorBlueHelmet, (String)MLN.string("item.japaneseWarriorBlueHelmet"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorBluePlate, (String)MLN.string("item.japaneseWarriorBluePlate"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorBlueBoots, (String)MLN.string("item.japaneseWarriorBlueBoots"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorRedLegs, (String)MLN.string("item.japaneseWarriorRedLegs"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorRedHelmet, (String)MLN.string("item.japaneseWarriorRedHelmet"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorRedPlate, (String)MLN.string("item.japaneseWarriorRedPlate"));
        LanguageRegistry.addName((Object)Mill.japaneseWarriorRedBoots, (String)MLN.string("item.japaneseWarriorRedBoots"));
        LanguageRegistry.addName((Object)Mill.japaneseGuardLegs, (String)MLN.string("item.japaneseGuardLegs"));
        LanguageRegistry.addName((Object)Mill.japaneseGuardHelmet, (String)MLN.string("item.japaneseGuardHelmet"));
        LanguageRegistry.addName((Object)Mill.japaneseGuardPlate, (String)MLN.string("item.japaneseGuardPlate"));
        LanguageRegistry.addName((Object)Mill.japaneseGuardBoots, (String)MLN.string("item.japaneseGuardBoots"));
        LanguageRegistry.addName((Object)Mill.parchmentJapaneseVillagers, (String)MLN.string("item.japanesevillagers"));
        LanguageRegistry.addName((Object)Mill.parchmentJapaneseBuildings, (String)MLN.string("item.japanesebuildings"));
        LanguageRegistry.addName((Object)Mill.parchmentJapaneseItems, (String)MLN.string("item.japaneseitems"));
        LanguageRegistry.addName((Object)Mill.parchmentJapaneseComplete, (String)MLN.string("item.japanesefull"));
        LanguageRegistry.addName((Object)Mill.grapes, (String)MLN.string("item.grapes"));
        LanguageRegistry.addName((Object)Mill.wineFancy, (String)MLN.string("item.wine"));
        LanguageRegistry.addName((Object)Mill.silk, (String)MLN.string("item.silk"));
        LanguageRegistry.addName((Object)Mill.byzantineiconsmall, (String)MLN.string("item.byzantineiconsmall"));
        LanguageRegistry.addName((Object)Mill.byzantineiconmedium, (String)MLN.string("item.byzantineiconmedium"));
        LanguageRegistry.addName((Object)Mill.byzantineiconlarge, (String)MLN.string("item.byzantineiconlarge"));
        LanguageRegistry.addName((Object)((Object)Mill.byzantine_tiles), (String)MLN.string("item.byzantinebrick"));
        LanguageRegistry.addName((Object)((Object)Mill.byzantine_tile_slab), (String)MLN.string("item.byzantineslab"));
        LanguageRegistry.addName((Object)((Object)Mill.byzantine_stone_tiles), (String)MLN.string("item.byzantinemixedbrick"));
        LanguageRegistry.addName((Object)Mill.byzantineLegs, (String)MLN.string("item.byzantineLegs"));
        LanguageRegistry.addName((Object)Mill.byzantineHelmet, (String)MLN.string("item.byzantineHelmet"));
        LanguageRegistry.addName((Object)Mill.byzantinePlate, (String)MLN.string("item.byzantinePlate"));
        LanguageRegistry.addName((Object)Mill.byzantineBoots, (String)MLN.string("item.byzantineBoots"));
        LanguageRegistry.addName((Object)Mill.byzantineMace, (String)MLN.string("item.byzantineMace"));
        LanguageRegistry.addName((Object)new ItemStack((Item)Mill.clothes, 1, 0), (String)MLN.string("item.clothes_byz_wool"));
        LanguageRegistry.addName((Object)new ItemStack((Item)Mill.clothes, 1, 1), (String)MLN.string("item.clothes_byz_silk"));
        LanguageRegistry.addName((Object)Mill.wineBasic, (String)MLN.string("item.wineBasic"));
        LanguageRegistry.addName((Object)Mill.lambRaw, (String)MLN.string("item.lambRaw"));
        LanguageRegistry.addName((Object)Mill.lambCooked, (String)MLN.string("item.lambCooked"));
        LanguageRegistry.addName((Object)Mill.feta, (String)MLN.string("item.feta"));
        LanguageRegistry.addName((Object)Mill.souvlaki, (String)MLN.string("item.souvlaki"));
        LanguageRegistry.addName((Object)((Object)Mill.purse), (String)MLN.string("item.purse"));
        LanguageRegistry.addName((Object)Mill.sake, (String)MLN.string("item.sake"));
        LanguageRegistry.addName((Object)Mill.cacauhaa, (String)MLN.string("item.cacauhaa"));
        LanguageRegistry.addName((Object)Mill.mayanQuestCrown, (String)MLN.string("item.mayanQuestCrown"));
        LanguageRegistry.addName((Object)Mill.ikayaki, (String)MLN.string("item.ikayaki"));
    }

    private static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static void printException(Exception e) {
        MLN.printException(null, e);
    }

    public static void printException(String s, Exception e) {
        if (DEV) {
            MLN.writeText("    !====================================!");
        }
        if (s == null) {
            MLN.writeText("Exception, printing stack:");
        } else {
            MLN.writeText(s);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        MLN.writeText(sw.toString());
        if (DEV) {
            MLN.writeText("     ==================================== ");
        }
    }

    public static String questString(String key, boolean required) {
        return MLN.questString(key, true, true, required);
    }

    public static String questString(String key, boolean main, boolean fallback, boolean required) {
        key = key.toLowerCase();
        if (main && mainLanguage != null && MLN.mainLanguage.questStrings.containsKey(key)) {
            return MLN.mainLanguage.questStrings.get(key);
        }
        if (main && serverMainLanguage != null && MLN.serverMainLanguage.questStrings.containsKey(key)) {
            return MLN.serverMainLanguage.questStrings.get(key);
        }
        if (fallback && fallbackLanguage != null && MLN.fallbackLanguage.questStrings.containsKey(key)) {
            return MLN.fallbackLanguage.questStrings.get(key);
        }
        if (fallback && serverFallbackLanguage != null && MLN.serverFallbackLanguage.questStrings.containsKey(key)) {
            return MLN.serverFallbackLanguage.questStrings.get(key);
        }
        if (required) {
            return key;
        }
        return null;
    }

    public static String questStringFallbackOnly(String key, boolean required) {
        return MLN.questString(key, false, true, required);
    }

    public static String questStringMainOnly(String key, boolean required) {
        return MLN.questString(key, true, false, required);
    }

    public static void writeBaseConfigFile() {
        File file = new File(Mill.proxy.getBaseDir(), "config-base.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(file);
            Language main = mainLanguage;
            Language fr = loadedLanguages.get("fr");
            Language en = loadedLanguages.get("en");
            for (int i = 0; i < configPages.size(); ++i) {
                mainLanguage = fr;
                String frTitle = MLN.string(configPageTitles.get(i));
                mainLanguage = en;
                String enTitle = MLN.string(configPageTitles.get(i));
                writer.write("//--------------------------------------------------------------------------------------------" + EOL);
                writer.write("//       " + frTitle + "    -    " + enTitle + EOL);
                writer.write("//--------------------------------------------------------------------------------------------" + EOL + EOL);
                for (int j = 0; j < configPages.get(i).size(); ++j) {
                    MillConfig config = configPages.get(i).get(j);
                    mainLanguage = fr;
                    writer.write("//" + config.getLabel() + "; " + config.getDesc() + EOL);
                    mainLanguage = en;
                    writer.write("//" + config.getLabel() + "; " + config.getDesc() + EOL);
                    writer.write(config.key + "=" + config.getDefaultValue() + EOL + EOL);
                }
            }
            mainLanguage = main;
            writer.close();
        }
        catch (Exception e) {
            MLN.printException("Exception in writeBaseConfigFile:", e);
        }
    }

    public static void writeConfigFile() {
        File file = Mill.proxy.getCustomConfigFile();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            Vector<String> toWrite = new Vector<String>();
            HashSet<MillConfig> configsWritten = new HashSet<MillConfig>();
            while ((line = reader.readLine()) != null) {
                boolean handled = false;
                if (line.trim().length() > 0 && !line.startsWith("//")) {
                    String[] temp = line.split("=");
                    String key = temp[0].trim().toLowerCase();
                    String value = "";
                    if (temp.length > 1) {
                        value = temp[1];
                    }
                    if (configs.containsKey(key)) {
                        if (configs.get(key).compareValuesFromString(value)) {
                            configsWritten.add(configs.get(key));
                        } else {
                            toWrite.add(key + "=" + configs.get(key).getSaveValue());
                            configsWritten.add(configs.get(key));
                            handled = true;
                        }
                    }
                }
                if (handled) continue;
                toWrite.add(line);
            }
            reader.close();
            BufferedWriter writer = MillCommonUtilities.getWriter(file);
            for (String s : toWrite) {
                writer.write(s + EOL);
            }
            for (MillConfig config : configs.values()) {
                if (configsWritten.contains(config) || config.hasDefaultValue()) continue;
                writer.write("//" + config.getLabel() + "; " + config.getDesc() + EOL);
                writer.write(config.key + "=" + config.getSaveValue() + EOL + EOL);
            }
            writer.close();
        }
        catch (Exception e) {
            MLN.printException("Exception in writeConfigFile:", e);
        }
    }

    private static boolean readConfigFile(File file, boolean defaultFile) {
        if (!file.exists()) {
            return false;
        }
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String[] temp;
                if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.split("=")).length != 2) continue;
                String key = temp[0].trim().toLowerCase();
                String value = temp[1];
                boolean configHandled = false;
                if (configs.containsKey(key)) {
                    configs.get(key).setValueFromString(value, defaultFile);
                    configHandled = true;
                }
                if (configHandled) continue;
                if (key.equalsIgnoreCase("devmode")) {
                    DEV = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("console")) {
                    console = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("logfile")) {
                    logfile = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("logfile")) {
                    logfile = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("infinite_amulet")) {
                    infiniteAmulet = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("stop_default_villages")) {
                    stopDefaultVillages = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("se_indicators")) {
                    seIndicators = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("language")) {
                    main_language = value.toLowerCase();
                    continue;
                }
                if (key.equalsIgnoreCase("forbidden_blocks")) {
                    for (String name : value.split(",")) {
                        if (Block.field_149771_c.func_148741_d(name)) {
                            forbiddenBlocks.add((Block)Block.field_149771_c.func_82594_a(name));
                            continue;
                        }
                        System.out.println("Could not read forbidden name: " + name);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("log.TileEntityBuilding")) {
                    LogTileEntityBuilding = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.WorldGeneration")) {
                    LogWorldGeneration = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.FarmerAI")) {
                    LogFarmerAI = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Diplomacy")) {
                    LogDiplomacy = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.WifeAI")) {
                    LogWifeAI = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Villager")) {
                    LogVillager = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Quest")) {
                    LogQuest = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Pathing")) {
                    LogPathing = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Connections")) {
                    LogConnections = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.getPath")) {
                    LogGetPath = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Lumberman")) {
                    LogLumberman = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.BuildingPlan")) {
                    LogBuildingPlan = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.GeneralAI")) {
                    LogGeneralAI = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Selling")) {
                    LogSelling = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Hybernation")) {
                    LogHybernation = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Other")) {
                    LogOther = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Children")) {
                    LogChildren = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Performance")) {
                    LogPerformance = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.CattleFarmer")) {
                    LogCattleFarmer = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Miner")) {
                    LogMiner = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Village")) {
                    LogVillage = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.WorldInfo")) {
                    LogWorldInfo = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Pujas")) {
                    LogPujas = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.villagerspawn")) {
                    LogVillagerSpawn = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.villagepaths")) {
                    LogVillagePaths = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Network")) {
                    LogNetwork = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Merchant")) {
                    LogMerchant = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Culture")) {
                    LogCulture = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("log.Translation")) {
                    LogTranslation = MLN.readLogLevel(value);
                    continue;
                }
                if (key.equalsIgnoreCase("force_preload_radius")) {
                    forcePreload = Integer.parseInt(value) / 16;
                    continue;
                }
                if (key.equalsIgnoreCase("sprites_path")) {
                    customTexture = value.trim();
                    continue;
                }
                if (key.equalsIgnoreCase("dynamic_textures")) {
                    dynamictextures = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equalsIgnoreCase("quest_biome_forest")) {
                    questBiomeForest = value.trim().toLowerCase();
                    continue;
                }
                if (key.equalsIgnoreCase("quest_biome_desert")) {
                    questBiomeDesert = value.trim().toLowerCase();
                    continue;
                }
                if (key.equalsIgnoreCase("quest_biome_mountain")) {
                    questBiomeMountain = value.trim().toLowerCase();
                    continue;
                }
                MLN.error(null, "Unknown config on line: " + line);
            }
            reader.close();
            System.out.println("Read config in " + file.getName() + ". Logging: " + console + "/" + logfile);
            return true;
        }
        catch (Exception e) {
            MLN.printException(e);
            return false;
        }
    }

    public static int readLogLevel(String s) {
        if (s.equalsIgnoreCase("major")) {
            return 1;
        }
        if (s.equalsIgnoreCase("minor")) {
            return 2;
        }
        if (s.equalsIgnoreCase("debug")) {
            return 3;
        }
        return 0;
    }

    public static String getLogLevel(int level) {
        if (level == 1) {
            return "major";
        }
        if (level == 2) {
            return "minor";
        }
        if (level == 3) {
            return "debug";
        }
        return "";
    }

    public static String removeAccent(String source) {
        return Normalizer.normalize(source, Normalizer.Form.NFD).replaceAll("[\u0300-\u036f]", "");
    }

    public static String string(String key) {
        if (!MLN.isTranslationLoaded()) {
            return "";
        }
        key = key.toLowerCase();
        return MLN.fillInName(MLN.getRawString(key, true));
    }

    public static String string(String key, String ... values) {
        String s = MLN.string(key);
        int pos = 0;
        for (String value : values) {
            s = value != null ? s.replaceAll("<" + pos + ">", value) : s.replaceAll("<" + pos + ">", "");
            ++pos;
        }
        return s;
    }

    public static String string(String[] values) {
        if (values.length == 0) {
            return "";
        }
        String s = MLN.unknownString(values[0]);
        int pos = -1;
        for (String value : values) {
            if (pos > -1) {
                s = value != null ? s.replaceAll("<" + pos + ">", MLN.unknownString(value)) : s.replaceAll("<" + pos + ">", "");
            }
            ++pos;
        }
        return MLN.fillInName(s);
    }

    public static void temp(Object obj, String s) {
        if (DEV) {
            MLN.writeText("TEMP: " + obj + ": " + s);
        }
    }

    public static String unknownString(String key) {
        int level;
        int variation;
        String buildingKey;
        BuildingPlanSet set;
        String cultureKey;
        Culture culture;
        if (key == null) {
            return "";
        }
        if (!MLN.isTranslationLoaded()) {
            return key;
        }
        if (key.startsWith("_item:")) {
            int id = Integer.parseInt(key.split(":")[1]);
            int meta = Integer.parseInt(key.split(":")[2]);
            MillVillager.InvItem item = new MillVillager.InvItem(MillCommonUtilities.getItemById(id), meta);
            return item.getName();
        }
        if (key.startsWith("_buildingGame:") && (culture = Culture.getCultureByName(cultureKey = key.split(":")[1])) != null && (set = culture.getBuildingPlanSet(buildingKey = key.split(":")[2])) != null && (variation = Integer.parseInt(key.split(":")[3])) < set.plans.size() && (level = Integer.parseInt(key.split(":")[4])) < set.plans.get(variation).length) {
            BuildingPlan plan = set.plans.get(variation)[level];
            return plan.getGameName();
        }
        String rawKey = MLN.getRawString(key, false);
        if (rawKey != null) {
            return MLN.fillInName(rawKey);
        }
        return key;
    }

    public static void warning(Object obj, String s) {
        if (DEV) {
            MLN.writeText("    !=============!");
        }
        MLN.writeText("WARNING: " + obj + ": " + s);
        if (DEV) {
            MLN.writeText("     =============");
        }
    }

    private static void writeText(String s) {
        if (console) {
            FMLLog.info((String)(Mill.proxy.logPrefix() + MLN.removeAccent(s)), (Object[])new Object[0]);
        }
        if (writer != null) {
            try {
                writer.write("5.2.0 " + MLN.now() + " " + s + EOL);
                writer.flush();
            }
            catch (IOException e) {
                System.out.println("Failed to write line to log file.");
            }
        }
    }

    static {
        loadedLanguage = null;
        textureSize = -1;
        dynamictextures = true;
        customTexture = null;
        mainLanguage = null;
        fallbackLanguage = null;
        serverMainLanguage = null;
        serverFallbackLanguage = null;
        loadedLanguages = new HashMap();
        bonusCode = null;
        bonusEnabled = false;
        configs = new HashMap();
        configPageTitles = new Vector();
        configPageDesc = new Vector();
        configPages = new Vector();
        textureLargeChest64 = new ResourceLocation("millenaire", "textures/entity/chest/ML_lockedlargechest_64.png");
        textureLargeChest = new ResourceLocation("millenaire", "textures/entity/chest/ML_lockedlargechest.png");
        textureChest64 = new ResourceLocation("millenaire", "textures/entity/chest/ML_lockedchest_64.png");
        textureChest = new ResourceLocation("millenaire", "textures/entity/chest/ML_lockedchest.png");
    }

    public static class MillenaireException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MillenaireException(String string) {
            super(string);
        }
    }

    public static class Language {
        private static final int PARCHMENT = 0;
        private static final int HELP = 1;
        public String language;
        public String topLevelLanguage = null;
        public boolean serverContent;
        public HashMap<String, String> strings = new HashMap();
        public HashMap<String, String> questStrings = new HashMap();
        public HashMap<Integer, Vector<Vector<String>>> texts = new HashMap();
        public HashMap<Integer, String> textsVersion = new HashMap();
        public HashMap<Integer, Vector<Vector<String>>> help = new HashMap();
        public HashMap<Integer, String> helpVersion = new HashMap();

        public Language(String key, boolean serverContent) {
            this.language = key;
            if (this.language.split("_").length > 1) {
                this.topLevelLanguage = this.language.split("_")[0];
            }
            this.serverContent = serverContent;
        }

        public void compareWithLanguage(HashMap<String, Integer> percentages, Language ref) {
            File file;
            MLN.major(null, "Generating translation gap file between " + this.language + " and " + ref.language);
            File translationGapDir = new File(Mill.proxy.getBaseDir(), "Translation gaps");
            if (!translationGapDir.exists()) {
                translationGapDir.mkdirs();
            }
            if ((file = new File(translationGapDir, this.language + "-" + ref.language + ".txt")).exists()) {
                file.delete();
            }
            try {
                int translationsMissing = 0;
                int translationsDone = 0;
                BufferedWriter writer = MillCommonUtilities.getWriter(file);
                writer.write("Translation comparison between " + this.language + " and " + ref.language + EOL + EOL);
                Vector<String> errors = new Vector<String>();
                Vector<String> keys = new Vector<String>(ref.strings.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    int nbValues2;
                    if (!this.strings.containsKey(key)) {
                        errors.add("Key missing in the strings.txt file: " + key);
                        ++translationsMissing;
                        continue;
                    }
                    int nbValues = ref.strings.get(key).split("<").length - 1;
                    if (nbValues != (nbValues2 = this.strings.get(key).split("<").length - 1)) {
                        errors.add("Mismatched number of parameters for " + key + ": " + nbValues + " in " + ref.language + " and " + nbValues2 + " in " + this.language);
                        ++translationsMissing;
                        continue;
                    }
                    ++translationsDone;
                }
                if (errors.size() > 0) {
                    writer.write("List of gaps found in strings.txt: " + EOL + EOL);
                    for (String s : errors) {
                        writer.write(s + EOL);
                    }
                    writer.write(EOL);
                }
                errors = new Vector();
                keys = new Vector<String>(ref.questStrings.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    if (!this.questStrings.containsKey(key)) {
                        errors.add("Key missing in the quests.txt file: " + key);
                        ++translationsMissing;
                        continue;
                    }
                    ++translationsDone;
                }
                if (errors.size() > 0) {
                    writer.write("List of gaps found in quest files: " + EOL + EOL);
                    for (String s : errors) {
                        writer.write(s + EOL);
                    }
                    writer.write(EOL);
                }
                errors = new Vector();
                for (Goal goal : Goal.goals.values()) {
                    if (this.strings.containsKey("goal." + goal.labelKey(null)) || ref.strings.containsKey("goal." + goal.labelKey(null))) continue;
                    errors.add("Could not find label for goal." + goal.labelKey(null) + " (class: " + goal.getClass().getSimpleName() + ") in either language.");
                }
                if (errors.size() > 0) {
                    writer.write("List of goals without labels: " + EOL + EOL);
                    for (String s : errors) {
                        writer.write(s + EOL);
                    }
                    writer.write(EOL);
                }
                errors = new Vector();
                Iterator<Object> i$ = ref.texts.keySet().iterator();
                while (i$.hasNext()) {
                    int id = (Integer)i$.next();
                    if (!this.texts.containsKey(id)) {
                        errors.add("Parchment " + id + " is missing.");
                        translationsMissing += 10;
                        continue;
                    }
                    if (!this.textsVersion.get(id).equals(ref.textsVersion.get(id))) {
                        errors.add("Parchment " + id + " has a different version: it is at version " + this.textsVersion.get(id) + " while " + ref.language + " parchment is at " + ref.textsVersion.get(id));
                        translationsMissing += 5;
                        continue;
                    }
                    translationsDone += 10;
                }
                i$ = ref.help.keySet().iterator();
                while (i$.hasNext()) {
                    int id = (Integer)i$.next();
                    if (!this.help.containsKey(id)) {
                        errors.add("Help " + id + " is missing.");
                        translationsMissing += 10;
                        continue;
                    }
                    if (!this.helpVersion.get(id).equals(ref.helpVersion.get(id))) {
                        errors.add("Help " + id + " has a different version: it is at version " + this.helpVersion.get(id) + " while " + ref.language + " parchment is at " + ref.helpVersion.get(id));
                        translationsMissing += 5;
                        continue;
                    }
                    translationsDone += 10;
                }
                if (errors.size() > 0) {
                    writer.write("List of gaps found between parchments: " + EOL + EOL);
                    for (String s : errors) {
                        writer.write(s + EOL);
                    }
                    writer.write(EOL);
                }
                for (Culture c : Culture.vectorCultures) {
                    int[] res = c.compareCultureLanguages(this.language, ref.language, writer);
                    translationsDone += res[0];
                    translationsMissing += res[1];
                }
                int percentDone = translationsDone + translationsMissing > 0 ? translationsDone * 100 / (translationsDone + translationsMissing) : 0;
                percentages.put(this.language, percentDone);
                writer.write("Traduction completness: " + percentDone + "%" + EOL);
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }

        public void loadFromDisk(Vector<File> languageDirs) {
            for (File languageDir : languageDirs) {
                File stringFile;
                File effectiveLanguageDir = new File(languageDir, this.language);
                if (!effectiveLanguageDir.exists()) {
                    effectiveLanguageDir = new File(languageDir, this.language.split("_")[0]);
                }
                if ((stringFile = new File(effectiveLanguageDir, "strings.txt")).exists()) {
                    this.loadStrings(this.strings, stringFile);
                }
                if (!effectiveLanguageDir.exists()) continue;
                for (File file : effectiveLanguageDir.listFiles(new MillCommonUtilities.PrefixExtFileFilter("quests", "txt"))) {
                    this.loadStrings(this.questStrings, file);
                }
            }
            for (Quest q : Quest.quests.values()) {
                for (Quest.QuestStep step : q.steps) {
                    if (step.labels.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "label", step.labels.get(this.language));
                    } else if (this.topLevelLanguage != null && step.labels.containsKey(this.topLevelLanguage)) {
                        this.questStrings.put(step.getStringKey() + "label", step.labels.get(this.topLevelLanguage));
                    }
                    if (step.descriptions.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "description", step.descriptions.get(this.language));
                    } else if (this.topLevelLanguage != null && step.descriptions.containsKey(this.topLevelLanguage)) {
                        this.questStrings.put(step.getStringKey() + "description", step.descriptions.get(this.topLevelLanguage));
                    }
                    if (step.descriptionsSuccess.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "description_success", step.descriptionsSuccess.get(this.language));
                    } else if (this.topLevelLanguage != null && step.descriptionsSuccess.containsKey(this.topLevelLanguage)) {
                        this.questStrings.put(step.getStringKey() + "description_success", step.descriptionsSuccess.get(this.topLevelLanguage));
                    }
                    if (step.descriptionsRefuse.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "description_refuse", step.descriptionsRefuse.get(this.language));
                    } else if (this.topLevelLanguage != null && step.descriptionsRefuse.containsKey(this.topLevelLanguage)) {
                        this.questStrings.put(step.getStringKey() + "description_refuse", step.descriptionsRefuse.get(this.topLevelLanguage));
                    }
                    if (step.descriptionsTimeUp.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "description_timeup", step.descriptionsTimeUp.get(this.language));
                    } else if (this.topLevelLanguage != null && step.descriptionsTimeUp.containsKey(this.topLevelLanguage)) {
                        this.questStrings.put(step.getStringKey() + "description_timeup", step.descriptionsTimeUp.get(this.topLevelLanguage));
                    }
                    if (step.listings.containsKey(this.language)) {
                        this.questStrings.put(step.getStringKey() + "listing", step.listings.get(this.language));
                        continue;
                    }
                    if (this.topLevelLanguage == null || !step.listings.containsKey(this.topLevelLanguage)) continue;
                    this.questStrings.put(step.getStringKey() + "listing", step.listings.get(this.topLevelLanguage));
                }
            }
            this.loadTextFiles(languageDirs, 0);
            this.loadTextFiles(languageDirs, 1);
            if (!loadedLanguages.containsKey(this.language)) {
                loadedLanguages.put(this.language, this);
            }
        }

        private void loadStrings(HashMap<String, String> strings, File file) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(file);
                while ((line = reader.readLine()) != null) {
                    String key;
                    if ((line = line.trim()).length() <= 0 || line.startsWith("//")) continue;
                    String[] temp = line.split("=");
                    if (temp.length == 2) {
                        key = temp[0].trim().toLowerCase();
                        String value = temp[1].trim();
                        if (strings.containsKey(key)) {
                            MLN.error(null, "Key " + key + " is present more than once in " + file.getAbsolutePath());
                            continue;
                        }
                        strings.put(key, value);
                        continue;
                    }
                    if (!line.endsWith("=")) continue;
                    key = temp[0].toLowerCase();
                    if (strings.containsKey(key)) {
                        MLN.error(null, "Key " + key + " is present more than once in " + file.getAbsolutePath());
                        continue;
                    }
                    strings.put(key, "");
                }
                reader.close();
            }
            catch (Exception e) {
                MLN.printException(e);
                return;
            }
        }

        public void loadTextFiles(Vector<File> languageDirs, int type) {
            String dirName = type == 0 ? "parchments" : "help";
            String filePrefix = type == 0 ? "parchment" : "help";
            for (File languageDir : languageDirs) {
                File parchmentsDir = new File(new File(languageDir, this.language), dirName);
                if (!parchmentsDir.exists()) {
                    parchmentsDir = new File(new File(languageDir, this.language.split("_")[0]), dirName);
                }
                if (!parchmentsDir.exists()) {
                    return;
                }
                ParchmentFileFilter filter = new ParchmentFileFilter(filePrefix);
                for (File file : parchmentsDir.listFiles(filter)) {
                    String sId = file.getName().substring(filePrefix.length() + 1, file.getName().length() - 4);
                    int id = 0;
                    if (sId.length() > 0) {
                        try {
                            id = Integer.parseInt(sId);
                        }
                        catch (Exception e) {
                            MLN.printException("Error when trying to read pachment id: ", e);
                        }
                    } else {
                        MLN.error(null, "Couldn't read the ID of " + file.getAbsolutePath() + ". sId: " + sId);
                    }
                    if (LogBuildingPlan >= 1) {
                        MLN.minor(file, "Loading " + dirName + ": " + file.getAbsolutePath());
                    }
                    Vector text = new Vector();
                    String version = "unknown";
                    try {
                        String line;
                        BufferedReader reader = MillCommonUtilities.getReader(file);
                        Vector<String> page = new Vector<String>();
                        while ((line = reader.readLine()) != null) {
                            if (line.equals("NEW_PAGE")) {
                                text.add(page);
                                page = new Vector();
                                continue;
                            }
                            if (line.startsWith("version:")) {
                                version = line.split(":")[1];
                                continue;
                            }
                            page.add(line);
                        }
                        text.add(page);
                        if (type == 0) {
                            this.texts.put(id, text);
                            this.textsVersion.put(id, version);
                            continue;
                        }
                        this.help.put(id, text);
                        this.helpVersion.put(id, version);
                    }
                    catch (Exception e) {
                        MLN.printException(e);
                    }
                }
            }
        }

        public String toString() {
            return this.language;
        }

        private static class ParchmentFileFilter
        implements FilenameFilter {
            private final String filePrefix;

            public ParchmentFileFilter(String filePrefix) {
                this.filePrefix = filePrefix;
            }

            @Override
            public boolean accept(File file, String name) {
                if (!name.startsWith(this.filePrefix)) {
                    return false;
                }
                if (!name.endsWith(".txt")) {
                    return false;
                }
                String id = name.substring(this.filePrefix.length() + 1, name.length() - 4);
                return id.length() != 0 && Integer.parseInt(id) >= 1;
            }
        }
    }

    public static class FileFiler
    implements FilenameFilter {
        String end;

        public FileFiler(String ending) {
            this.end = ending;
        }

        @Override
        public boolean accept(File file, String name) {
            if (!name.endsWith(this.end)) {
                return false;
            }
            return !name.startsWith(".");
        }
    }
}

