/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;

public class TileEntityMillChest
extends TileEntityChest
implements ISidedInventory {
    public Point buildingPos = null;
    public boolean loaded = false;
    public boolean serverDevMode = false;

    public static void readUpdatePacket(ByteBufInputStream ds, World world) {
        Point pos = null;
        try {
            pos = StreamReadWrite.readNullablePoint((DataInput)ds);
        }
        catch (IOException e) {
            MLN.printException(e);
            return;
        }
        TileEntityMillChest te = pos.getMillChest(world);
        if (te != null) {
            try {
                te.buildingPos = StreamReadWrite.readNullablePoint((DataInput)ds);
                te.serverDevMode = ds.readBoolean();
                int nb = ds.readByte();
                for (int i = 0; i < nb; ++i) {
                    te.func_70299_a(i, StreamReadWrite.readNullableItemStack((DataInput)ds));
                }
                te.loaded = true;
            }
            catch (IOException e) {
                MLN.printException((Object)((Object)te) + ": Error in readUpdatePacket", e);
            }
        }
    }

    public String getInvLargeName() {
        if (this.buildingPos == null) {
            return MLN.string("ui.largeunlockedchest");
        }
        Building building = null;
        if (Mill.clientWorld != null) {
            building = Mill.clientWorld.getBuilding(this.buildingPos);
        }
        if (building == null) {
            return MLN.string("ui.largeunlockedchest");
        }
        String s = building.getNativeBuildingName();
        if (building.chestLocked) {
            return s + ": " + MLN.string("ui.largelockedchest");
        }
        return s + ": " + MLN.string("ui.largeunlockedchest");
    }

    public String func_145825_b() {
        if (this.buildingPos == null) {
            return MLN.string("ui.unlockedchest");
        }
        Building building = null;
        if (Mill.clientWorld != null) {
            building = Mill.clientWorld.getBuilding(this.buildingPos);
        }
        if (building == null) {
            return MLN.string("ui.unlockedchest");
        }
        String s = building.getNativeBuildingName();
        if (building.chestLocked) {
            return s + ": " + MLN.string("ui.lockedchest");
        }
        return s + ": " + MLN.string("ui.unlockedchest");
    }

    public boolean isLockedFor(EntityPlayer player) {
        if (player == null) {
            MLN.printException("Null player", new Exception());
            return true;
        }
        if (!this.loaded && this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.buildingPos == null) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K && MLN.DEV) {
            return false;
        }
        if (this.serverDevMode) {
            return false;
        }
        MillWorld mw = Mill.getMillWorld(this.field_145850_b);
        if (mw == null) {
            MLN.printException("Null MillWorld", new Exception());
            return true;
        }
        Building building = mw.getBuilding(this.buildingPos);
        if (building == null) {
            return true;
        }
        return building.lockedForPlayer(player.getDisplayName());
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.buildingPos = Point.read(nbttagcompound, "buildingPos");
    }

    public void sendUpdatePacket(EntityPlayer player) {
        ServerSender.sendLockedChestUpdatePacket(this, player);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.buildingPos != null) {
            this.buildingPos.write(nbttagcompound, "buildingPos");
        }
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public static class InventoryMillLargeChest
    extends InventoryLargeChest
    implements ISidedInventory {
        public InventoryMillLargeChest(String par1Str, IInventory par2iInventory, IInventory par3iInventory) {
            super(par1Str, par2iInventory, par3iInventory);
        }

        public int[] func_94128_d(int var1) {
            return new int[0];
        }

        public boolean func_102007_a(int i, ItemStack itemstack, int j) {
            return false;
        }

        public boolean func_102008_b(int i, ItemStack itemstack, int j) {
            return false;
        }
    }
}

