/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.construction;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.VillageType;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.construction.BuildingProject;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.network.StreamReadWrite;

public class BuildingPlanSet {
    public File dir;
    public String key;
    public int max;
    public Vector<BuildingPlan[]> plans = new Vector();
    public Culture culture;

    public BuildingPlanSet(Culture c, String key, File dir) {
        this.culture = c;
        this.key = key;
        this.dir = dir;
    }

    public Vector<BuildingPlan.LocationBuildingPair> buildLocation(MillWorld mw, VillageType villageType, BuildingLocation location, boolean worldGeneration, boolean townHall, Point townHallPos, boolean wandimport, EntityPlayer owner) {
        return this.plans.get(location.getVariation())[location.level].build(mw, villageType, location, worldGeneration, townHall, townHallPos, wandimport, owner, false);
    }

    public BuildingProject getBuildingProject() {
        return new BuildingProject(this);
    }

    public BuildingPlan.PointType[][][] getConsolidatedPlan(int variation, int level) {
        int minLevel = this.getMinLevel(variation, level);
        int maxLevel = this.getMaxLevel(variation, level);
        int length = this.plans.get((int)variation)[0].plan[0].length;
        int width = this.plans.get((int)variation)[0].plan[0][0].length;
        BuildingPlan.PointType[][][] consolidatedPlan = new BuildingPlan.PointType[maxLevel - minLevel][length][width];
        for (int lid = 0; lid <= level; ++lid) {
            BuildingPlan plan = this.plans.get(variation)[lid];
            if (MLN.LogBuildingPlan >= 1) {
                MLN.major(this, "Consolidating plan: adding level " + lid);
            }
            int ioffset = plan.firstLevel - minLevel;
            for (int i = 0; i < plan.plan.length; ++i) {
                for (int j = 0; j < length; ++j) {
                    for (int k = 0; k < width; ++k) {
                        BuildingPlan.PointType pt = plan.plan[i][j][k];
                        if (pt.isType("empty") && lid != 0) continue;
                        consolidatedPlan[i + ioffset][j][k] = pt;
                    }
                }
            }
        }
        return consolidatedPlan;
    }

    public String getFullName(EntityPlayer player) {
        BuildingPlan plan = this.getRandomStartingPlan();
        return plan.getNativeDisplayName(player);
    }

    public String getGameName() {
        BuildingPlan plan = this.getRandomStartingPlan();
        return plan.getGameName();
    }

    public int getMaxLevel(int variation, int level) {
        int maxLevel = Integer.MIN_VALUE;
        for (int i = 0; i <= level; ++i) {
            BuildingPlan plan = this.plans.get(variation)[i];
            if (plan.plan.length + plan.firstLevel <= maxLevel) continue;
            maxLevel = plan.plan.length + plan.firstLevel;
        }
        return maxLevel;
    }

    public int getMinLevel(int variation, int level) {
        int minLevel = Integer.MAX_VALUE;
        for (int i = 0; i <= level; ++i) {
            BuildingPlan plan = this.plans.get(variation)[i];
            if (plan.firstLevel >= minLevel) continue;
            minLevel = plan.firstLevel;
        }
        return minLevel;
    }

    public String getNativeName() {
        if (this.plans.size() == 0) {
            return this.key;
        }
        BuildingPlan plan = this.getRandomStartingPlan();
        return plan.nativeName;
    }

    public BuildingPlan getRandomStartingPlan() {
        if (this.plans.size() == 0) {
            return null;
        }
        return this.plans.get(MillCommonUtilities.randomInt(this.plans.size()))[0];
    }

    public void loadPictPlans(boolean importPlan) throws Exception {
        Vector vplans = new Vector();
        BuildingPlan prevPlan = null;
        char varChar = 'A';
        int variation = 0;
        while (new File(this.dir, this.key + "_" + varChar + ".txt").exists()) {
            vplans.add(new Vector());
            int level = 0;
            prevPlan = null;
            BufferedReader bufferedReader = MillCommonUtilities.getReader(new File(this.dir, this.key + "_" + varChar + ".txt"));
            while (new File(this.dir, this.key + "_" + varChar + level + ".png").exists()) {
                String line = bufferedReader.readLine();
                prevPlan = new BuildingPlan(this.dir, this.key, level, variation, prevPlan, line, this.culture, importPlan);
                ((Vector)vplans.get(variation)).add(prevPlan);
                ++level;
            }
            if (((Vector)vplans.get(variation)).size() == 0) {
                throw new MLN.MillenaireException("No file found for building " + this.key + varChar);
            }
            varChar = (char)(varChar + '\u0001');
            ++variation;
        }
        this.max = ((BuildingPlan)((Vector)vplans.get((int)0)).get((int)0)).max;
        for (Vector vector : vplans) {
            int length = ((BuildingPlan)vector.get((int)0)).length;
            int width = ((BuildingPlan)vector.get((int)0)).width;
            for (BuildingPlan plan : vector) {
                if (plan.width != width) {
                    throw new MLN.MillenaireException("Width of upgrade " + plan.level + " of building " + plan.buildingKey + " is " + plan.width + " instead of " + width);
                }
                if (plan.length == length) continue;
                throw new MLN.MillenaireException("Length of upgrade " + plan.level + " of building " + plan.buildingKey + " is " + plan.length + " instead of " + length);
            }
            BuildingPlan[] varplansarray = new BuildingPlan[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                varplansarray[i] = (BuildingPlan)vector.get(i);
            }
            this.plans.add(varplansarray);
        }
    }

    public void loadPlans(Culture culture, boolean importPlan) throws Exception {
        Vector vplans = new Vector();
        BuildingPlan prevPlan = null;
        char varChar = 'A';
        int variation = 0;
        while (new File(this.dir, this.key + "_" + varChar + "0.txt").exists()) {
            vplans.add(new Vector());
            int level = 0;
            prevPlan = null;
            while (new File(this.dir, this.key + "_" + varChar + level + ".txt").exists()) {
                prevPlan = new BuildingPlan(this.dir, this.key, level, variation, prevPlan, culture, importPlan);
                ((Vector)vplans.get(variation)).add(prevPlan);
                ++level;
            }
            if (((Vector)vplans.get(variation)).size() == 0) {
                throw new MLN.MillenaireException("No file found for building " + this.key + varChar);
            }
            varChar = (char)(varChar + '\u0001');
            ++variation;
        }
        this.max = ((BuildingPlan)((Vector)vplans.get((int)0)).get((int)0)).max;
        for (Vector vector : vplans) {
            int length = ((BuildingPlan)vector.get((int)0)).length;
            int width = ((BuildingPlan)vector.get((int)0)).width;
            for (BuildingPlan plan : vector) {
                if (plan.width != width) {
                    throw new MLN.MillenaireException("Width of upgrade " + plan.level + " of building " + plan.buildingKey + " is " + plan.width + " instead of " + width);
                }
                if (plan.length == length) continue;
                throw new MLN.MillenaireException("Length of upgrade " + plan.level + " of building " + plan.buildingKey + " is " + plan.length + " instead of " + length);
            }
            BuildingPlan[] varplansarray = new BuildingPlan[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                varplansarray[i] = (BuildingPlan)vector.get(i);
            }
            this.plans.add(varplansarray);
        }
    }

    public void readBuildingPlanSetInfoPacket(ByteBufInputStream ds) throws IOException {
        int nb = ds.readInt();
        this.plans.clear();
        for (int i = 0; i < nb; ++i) {
            int nb2 = ds.readInt();
            BuildingPlan[] plans = new BuildingPlan[nb2];
            for (int j = 0; j < nb2; ++j) {
                plans[j] = StreamReadWrite.readBuildingPlanInfo((DataInput)ds, this.culture);
            }
            this.plans.add(plans);
        }
    }

    public String toString() {
        return this.key + " (" + this.plans.size() + " / " + this.max + "/" + this.plans.get((int)0)[0].nativeName + ")";
    }

    public void writeBuildingPlanSetInfo(DataOutput data) throws IOException {
        data.writeUTF(this.key);
        data.writeInt(this.plans.size());
        for (BuildingPlan[] plans : this.plans) {
            data.writeInt(plans.length);
            for (BuildingPlan plan : plans) {
                StreamReadWrite.writeBuildingPlanInfo(plan, data);
            }
        }
    }
}

