/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.core;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.Culture;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.UserProfile;
import org.millenaire.common.construction.BuildingPlan;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.item.Goods;
import org.millenaire.common.pathing.atomicstryker.AStarNode;
import org.millenaire.common.pathing.atomicstryker.AStarStatic;

public class MillCommonUtilities {
    public static Random random = new Random();
    private static final boolean PATH_RAISE = false;

    public static IIcon getIcon(IIconRegister register, String iconName) {
        return register.func_94245_a("millenaire:" + iconName + MLN.getTextSuffix());
    }

    public static boolean canStandInBlock(World world, Point p) {
        if (!AStarStatic.isPassableBlock(world, p.getiX(), p.getiY(), p.getiZ(), MillVillager.DEFAULT_JPS_CONFIG)) {
            return false;
        }
        if (!AStarStatic.isPassableBlock(world, (p = p.getAbove()).getiX(), p.getiY(), p.getiZ(), MillVillager.DEFAULT_JPS_CONFIG)) {
            return false;
        }
        return !AStarStatic.isPassableBlock(world, (p = p.getRelative(0.0, -2.0, 0.0)).getiX(), p.getiY(), p.getiZ(), MillVillager.DEFAULT_JPS_CONFIG);
    }

    public static boolean chanceOn(int i) {
        return MillCommonUtilities.getRandom().nextInt(i) == 0;
    }

    public static void changeMoney(IInventory chest, int toChange, EntityPlayer player) {
        boolean hasPurse = false;
        for (int i = 0; i < chest.func_70302_i_() && !hasPurse; ++i) {
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Mill.purse) continue;
            hasPurse = true;
        }
        if (hasPurse) {
            int current_denier = MillCommonUtilities.getItemsFromChest(chest, Mill.denier, 0, Integer.MAX_VALUE);
            int current_denier_argent = MillCommonUtilities.getItemsFromChest(chest, Mill.denier_argent, 0, Integer.MAX_VALUE);
            int current_denier_or = MillCommonUtilities.getItemsFromChest(chest, Mill.denier_or, 0, Integer.MAX_VALUE);
            int finalChange = current_denier_or * 64 * 64 + current_denier_argent * 64 + current_denier + toChange;
            for (int i = 0; i < chest.func_70302_i_() && finalChange != 0; ++i) {
                ItemStack stack = chest.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != Mill.purse) continue;
                int content = Mill.purse.totalDeniers(stack) + finalChange;
                if (content >= 0) {
                    Mill.purse.setDeniers(stack, player, content);
                    finalChange = 0;
                    continue;
                }
                Mill.purse.setDeniers(stack, player, 0);
                finalChange = content;
            }
        } else {
            int total = toChange + MillCommonUtilities.countMoney(chest);
            int denier = total % 64;
            int denier_argent = (total - denier) / 64 % 64;
            int denier_or = (total - denier - denier_argent * 64) / 4096;
            if (player != null && denier_or > 0) {
                player.func_71064_a((StatBase)MillAchievements.cresus, 1);
            }
            int current_denier = MillCommonUtilities.countChestItems(chest, Mill.denier, 0);
            int current_denier_argent = MillCommonUtilities.countChestItems(chest, Mill.denier_argent, 0);
            int current_denier_or = MillCommonUtilities.countChestItems(chest, Mill.denier_or, 0);
            if (MLN.LogWifeAI >= 1) {
                MLN.major(null, "Putting: " + denier + "/" + denier_argent + "/" + denier_or + " replacing " + current_denier + "/" + current_denier_argent + "/" + current_denier_or);
            }
            if (denier < current_denier) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier, 0, current_denier - denier);
            } else if (denier > current_denier) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier, 0, denier - current_denier);
            }
            if (denier_argent < current_denier_argent) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier_argent, 0, current_denier_argent - denier_argent);
            } else if (denier_argent > current_denier_argent) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier_argent, 0, denier_argent - current_denier_argent);
            }
            if (denier_or < current_denier_or) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier_or, 0, current_denier_or - denier_or);
            } else if (denier_or > current_denier_or) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier_or, 0, denier_or - current_denier_or);
            }
        }
    }

    public static void changeMoneyObsolete(IInventory chest, int toChange, EntityPlayer player) {
        int total = toChange + MillCommonUtilities.countMoney(chest);
        int denier = total % 64;
        int denier_argent = (total - denier) / 64 % 64;
        int denier_or = (total - denier - denier_argent * 64) / 4096;
        if (player != null && denier_or > 0) {
            player.func_71064_a((StatBase)MillAchievements.cresus, 1);
        }
        boolean placedInPurse = false;
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Mill.purse) continue;
            if (!placedInPurse) {
                Mill.purse.setDeniers(stack, player, denier, denier_argent, denier_or);
                placedInPurse = true;
                continue;
            }
            Mill.purse.setDeniers(stack, player, 0, 0, 0);
        }
        if (placedInPurse) {
            MillCommonUtilities.getItemsFromChest(chest, Mill.denier, 0, Integer.MAX_VALUE);
            MillCommonUtilities.getItemsFromChest(chest, Mill.denier_argent, 0, Integer.MAX_VALUE);
            MillCommonUtilities.getItemsFromChest(chest, Mill.denier_or, 0, Integer.MAX_VALUE);
        } else {
            int current_denier = MillCommonUtilities.countChestItems(chest, Mill.denier, 0);
            int current_denier_argent = MillCommonUtilities.countChestItems(chest, Mill.denier_argent, 0);
            int current_denier_or = MillCommonUtilities.countChestItems(chest, Mill.denier_or, 0);
            if (MLN.LogWifeAI >= 1) {
                MLN.major(null, "Putting: " + denier + "/" + denier_argent + "/" + denier_or + " replacing " + current_denier + "/" + current_denier_argent + "/" + current_denier_or);
            }
            if (denier < current_denier) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier, 0, current_denier - denier);
            } else if (denier > current_denier) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier, 0, denier - current_denier);
            }
            if (denier_argent < current_denier_argent) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier_argent, 0, current_denier_argent - denier_argent);
            } else if (denier_argent > current_denier_argent) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier_argent, 0, denier_argent - current_denier_argent);
            }
            if (denier_or < current_denier_or) {
                MillCommonUtilities.getItemsFromChest(chest, Mill.denier_or, 0, current_denier_or - denier_or);
            } else if (denier_or > current_denier_or) {
                MillCommonUtilities.putItemsInChest(chest, Mill.denier_or, 0, denier_or - current_denier_or);
            }
        }
    }

    public static int countBlocksAround(World world, int x, int y, int z, int rx, int ry, int rz) {
        int counter = 0;
        for (int i = x - rx; i <= x + rx; ++i) {
            for (int j = y - ry; j <= y + ry; ++j) {
                for (int k = z - rz; k <= z + rz; ++k) {
                    if (world.func_147439_a(i, j, k) == null || !world.func_147439_a(i, j, k).func_149688_o().func_76230_c()) continue;
                    ++counter;
                }
            }
        }
        return counter;
    }

    public static int countChestItems(IInventory chest, Block block, int meta) {
        return MillCommonUtilities.countChestItems(chest, Item.func_150898_a((Block)block), meta);
    }

    public static int countChestItems(IInventory chest, Item item, int meta) {
        if (chest == null) {
            return 0;
        }
        int maxSlot = chest.func_70302_i_();
        if (chest instanceof InventoryPlayer) {
            maxSlot -= 4;
        }
        int nb = 0;
        for (int i = 0; i < maxSlot; ++i) {
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || meta != -1 && stack.func_77960_j() >= 0 && stack.func_77960_j() != meta) continue;
            nb += stack.field_77994_a;
        }
        return nb;
    }

    public static int countFurnaceItems(IInventory furnace, Item item, int meta) {
        if (furnace == null) {
            return 0;
        }
        int nb = 0;
        ItemStack stack = furnace.func_70301_a(2);
        if (stack != null && stack.func_77973_b() == item && (meta == -1 || stack.func_77960_j() < 0 || stack.func_77960_j() == meta)) {
            nb += stack.field_77994_a;
        }
        return nb;
    }

    public static int countMoney(IInventory chest) {
        int deniers = 0;
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == Mill.purse) {
                deniers += Mill.purse.totalDeniers(stack);
                continue;
            }
            if (stack.func_77973_b() == Mill.denier) {
                deniers += stack.field_77994_a;
                continue;
            }
            if (stack.func_77973_b() == Mill.denier_argent) {
                deniers += stack.field_77994_a * 64;
                continue;
            }
            if (stack.func_77973_b() != Mill.denier_or) continue;
            deniers += stack.field_77994_a * 64 * 64;
        }
        return deniers;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = MillCommonUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static Point findRandomStandingPosAround(World world, Point dest) {
        if (dest == null) {
            return null;
        }
        for (int i = 0; i < 50; ++i) {
            if (!MillCommonUtilities.isBlockIdSolid(world.func_147439_a((dest = dest.getRelative(5 - MillCommonUtilities.randomInt(10), 5 - MillCommonUtilities.randomInt(20), 5 - MillCommonUtilities.randomInt(10))).getiX(), dest.getiY() - 1, dest.getiZ())) || MillCommonUtilities.isBlockIdSolid(world.func_147439_a(dest.getiX(), dest.getiY(), dest.getiZ())) || MillCommonUtilities.isBlockIdSolid(world.func_147439_a(dest.getiX(), dest.getiY() + 1, dest.getiZ()))) continue;
            return dest;
        }
        return null;
    }

    public static Point findTopNonPassableBlock(World world, int x, int z) {
        for (int y = 255; y > 0; --y) {
            if (AStarStatic.isPassableBlock(world, x, y, z, MillVillager.DEFAULT_JPS_CONFIG)) continue;
            return new Point(x, y, z);
        }
        return null;
    }

    public static int findTopSoilBlock(World world, int x, int z) {
        int y;
        for (y = world.func_72825_h(x, z); y > -1 && !MillCommonUtilities.isBlockIdGround(world.func_147439_a(x, y, z)); --y) {
        }
        if (y > 254) {
            y = 254;
        }
        return y + 1;
    }

    public static Point findVerticalStandingPos(World world, Point dest) {
        int y;
        if (dest == null) {
            return null;
        }
        for (y = MillCommonUtilities.findTopSoilBlock(world, dest.getiX(), dest.getiZ()); y < 250 && (MillCommonUtilities.isBlockIdSolid(world.func_147439_a(dest.getiX(), y, dest.getiZ())) || MillCommonUtilities.isBlockIdSolid(world.func_147439_a(dest.getiX(), y + 1, dest.getiZ()))); ++y) {
        }
        if (y == 250) {
            return null;
        }
        return new Point(dest.getiX(), y, dest.getiZ());
    }

    public static BufferedWriter getAppendWriter(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF8"));
    }

    public static Block getBlock(World world, Point p) {
        if (p.x < -3.2E7 || p.z < -3.2E7 || p.x >= 3.2E7 || p.z > 3.2E7) {
            return null;
        }
        if (p.y < 0.0) {
            return null;
        }
        if (p.y >= 256.0) {
            return null;
        }
        return world.func_147439_a(p.getiX(), p.getiY(), p.getiZ());
    }

    public static int getBlockMeta(World world, Point p) {
        if (p.x < -3.2E7 || p.z < -3.2E7 || p.x >= 3.2E7 || p.z > 3.2E7) {
            return -1;
        }
        if (p.y < 0.0) {
            return -1;
        }
        if (p.y >= 256.0) {
            return -1;
        }
        return world.func_72805_g(p.getiX(), p.getiY(), p.getiZ());
    }

    public static Vector<Point> getBlocksAround(World world, Block[] targetBlocks, Point pos, int rx, int ry, int rz) {
        Vector<Point> matches = new Vector<Point>();
        for (int i = pos.getiX() - rx; i <= pos.getiX() + rx; ++i) {
            for (int j = pos.getiY() - ry; j <= pos.getiY() + ry; ++j) {
                for (int k = pos.getiZ() - rz; k <= pos.getiZ() + rz; ++k) {
                    for (int l = 0; l < targetBlocks.length; ++l) {
                        if (world.func_147439_a(i, j, k) != targetBlocks[l]) continue;
                        matches.add(new Point(i, j, k));
                    }
                }
            }
        }
        return matches;
    }

    public static File getBuildingsDir(World worldObj) {
        File buildingsDir;
        File saveDir = MillCommonUtilities.getWorldSaveDir(worldObj);
        File millenaireDir = new File(saveDir, "millenaire");
        if (!millenaireDir.exists()) {
            millenaireDir.mkdir();
        }
        if (!(buildingsDir = new File(millenaireDir, "buildings")).exists()) {
            buildingsDir.mkdir();
        }
        return buildingsDir;
    }

    public static Point getClosestBlock(World world, int[] blockIds, double x, double y, double z, int rx, int ry, int rz) {
        return MillCommonUtilities.getClosestBlock(world, blockIds, MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z), rx, ry, rz);
    }

    public static Point getClosestBlock(World world, Block[] blocks, Point pos, int rx, int ry, int rz) {
        return MillCommonUtilities.getClosestBlockMeta(world, blocks, -1, pos, rx, ry, rz);
    }

    public static Point getClosestBlockMeta(World world, Block[] blocks, int meta, Point pos, int rx, int ry, int rz) {
        Point closest = null;
        double minDistance = 9.99999999E8;
        for (int i = pos.getiX() - rx; i <= pos.getiX() + rx; ++i) {
            for (int j = pos.getiY() - ry; j <= pos.getiY() + ry; ++j) {
                for (int k = pos.getiZ() - rz; k <= pos.getiZ() + rz; ++k) {
                    for (int l = 0; l < blocks.length; ++l) {
                        if (world.func_147439_a(i, j, k) != blocks[l] || meta != -1 && world.func_72805_g(i, j, k) != meta) continue;
                        Point temp = new Point(i, j, k);
                        if (closest != null && !(temp.distanceTo(pos) < minDistance)) continue;
                        closest = temp;
                        minDistance = closest.distanceTo(pos);
                    }
                }
            }
        }
        if (minDistance < 9.99999999E8) {
            return closest;
        }
        return null;
    }

    public static EntityItem getClosestItemVertical(World world, Point p, MillVillager.InvItem[] items, int radius, int vertical) {
        List<Entity> list = MillCommonUtilities.getEntitiesWithinAABB(world, Entity.class, p, radius, vertical);
        double bestdist = Double.MAX_VALUE;
        EntityItem citem = null;
        for (Entity ent : list) {
            if (ent.getClass() != EntityItem.class) continue;
            EntityItem item = (EntityItem)ent;
            if (item.field_70128_L) continue;
            for (MillVillager.InvItem key : items) {
                double dist;
                if (item.func_92059_d().func_77973_b() != key.getItem() || item.func_92059_d().func_77960_j() != key.meta || !((dist = item.func_70092_e(p.x, p.y, p.z)) < bestdist)) continue;
                bestdist = dist;
                citem = item;
            }
        }
        if (citem == null) {
            return null;
        }
        return citem;
    }

    public static List<Entity> getEntitiesWithinAABB(World world, Class type, Point p, int hradius, int vradius) {
        AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)p.x, (double)p.y, (double)p.z, (double)(p.x + 1.0), (double)(p.y + 1.0), (double)(p.z + 1.0)).func_72314_b((double)hradius, (double)vradius, (double)hradius);
        return world.func_72872_a(type, area);
    }

    public static List<Entity> getEntitiesWithinAABB(World world, Class type, Point pstart, Point pend) {
        AxisAlignedBB area = AxisAlignedBB.func_72330_a((double)pstart.x, (double)pstart.y, (double)pstart.z, (double)pend.x, (double)pend.y, (double)pend.z);
        return world.func_72872_a(type, area);
    }

    public static int getInvItemHashTotal(HashMap<MillVillager.InvItem, Integer> map) {
        int total = 0;
        for (MillVillager.InvItem key : map.keySet()) {
            total += map.get(key).intValue();
        }
        return total;
    }

    public static int getItemsFromChest(IInventory chest, Block block, int meta, int toTake) {
        return MillCommonUtilities.getItemsFromChest(chest, Item.func_150898_a((Block)block), meta, toTake);
    }

    public static int getItemsFromChest(IInventory chest, Item item, int meta, int toTake) {
        if (chest == null) {
            return 0;
        }
        int nb = 0;
        int maxSlot = chest.func_70302_i_() - 1;
        if (chest instanceof InventoryPlayer) {
            maxSlot -= 4;
        }
        for (int i = maxSlot; i >= 0 && nb < toTake; --i) {
            ItemStack stack = chest.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != meta && meta != -1) continue;
            if (stack.field_77994_a <= toTake - nb) {
                nb += stack.field_77994_a;
                chest.func_70299_a(i, null);
                continue;
            }
            chest.func_70298_a(i, toTake - nb);
            nb = toTake;
        }
        return nb;
    }

    public static int getItemsFromFurnace(IInventory furnace, Item item, int toTake) {
        if (furnace == null) {
            return 0;
        }
        int nb = 0;
        ItemStack stack = furnace.func_70301_a(2);
        if (stack != null && stack.func_77973_b() == item) {
            if (stack.field_77994_a <= toTake - nb) {
                nb += stack.field_77994_a;
                furnace.func_70299_a(2, null);
            } else {
                furnace.func_70298_a(2, toTake - nb);
                nb = toTake;
            }
        }
        return nb;
    }

    public static boolean isBlockOpaqueCube(World world, int i, int j, int k) {
        Block b = world.func_147439_a(i, j, k);
        if (b == null) {
            return false;
        }
        return MillCommonUtilities.isBlockOpaqueCube(b);
    }

    public static boolean isBlockOpaqueCube(Block b) {
        if (b == null) {
            return false;
        }
        return b.func_149688_o().func_76230_c();
    }

    public static int[] getJumpDestination(World world, int x, int y, int z) {
        if (!MillCommonUtilities.isBlockOpaqueCube(world, x, y, z) && !MillCommonUtilities.isBlockOpaqueCube(world, x, y + 1, z)) {
            return new int[]{x, y, z};
        }
        if (!MillCommonUtilities.isBlockOpaqueCube(world, x + 1, y, z) && !MillCommonUtilities.isBlockOpaqueCube(world, x + 1, y + 1, z)) {
            return new int[]{x + 1, y, z};
        }
        if (!MillCommonUtilities.isBlockOpaqueCube(world, x - 1, y, z) && !MillCommonUtilities.isBlockOpaqueCube(world, x - 1, y + 1, z)) {
            return new int[]{x - 1, y, z};
        }
        if (!MillCommonUtilities.isBlockOpaqueCube(world, x, y, z + 1) && !MillCommonUtilities.isBlockOpaqueCube(world, x, y + 1, z + 1)) {
            return new int[]{x, y, z + 1};
        }
        if (!MillCommonUtilities.isBlockOpaqueCube(world, x, y, z - 1) && !MillCommonUtilities.isBlockOpaqueCube(world, x, y + 1, z - 1)) {
            return new int[]{x, y, z - 1};
        }
        return null;
    }

    public static int getPointHash(String special) {
        return ("sp_" + special).hashCode();
    }

    public static int getPointHash(Block b, int meta) {
        return (Block.field_149771_c.func_148750_c((Object)b) + "_" + meta).hashCode();
    }

    public static int getPriceColour(int price) {
        if (price >= 4096) {
            return 16770304;
        }
        if (price >= 64) {
            return 0xF0F0F0;
        }
        return 10373418;
    }

    public static int getPriceColourMC(int price) {
        if (price >= 4096) {
            return 14;
        }
        if (price >= 64) {
            return 15;
        }
        return 6;
    }

    public static Object getPrivateValue(Class pclass, Object obj, int pos) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        return ReflectionHelper.getPrivateValue((Class)pclass, (Object)obj, (int)pos);
    }

    public static Object getPrivateValue(Class pclass, Object obj, String nameMCP, String name) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        if (EntityCreature.class.getSimpleName().equals("EntityCreature")) {
            return ReflectionHelper.getPrivateValue((Class)pclass, (Object)obj, (String[])new String[]{nameMCP});
        }
        return ReflectionHelper.getPrivateValue((Class)pclass, (Object)obj, (String[])new String[]{name});
    }

    public static Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    public static BufferedReader getReader(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
    }

    public static String getRelationName(int relation) {
        if (relation >= 90) {
            return "relation.excellent";
        }
        if (relation >= 70) {
            return "relation.verygood";
        }
        if (relation >= 50) {
            return "relation.good";
        }
        if (relation >= 30) {
            return "relation.decent";
        }
        if (relation >= 10) {
            return "relation.fair";
        }
        if (relation <= -90) {
            return "relation.openconflict";
        }
        if (relation <= -70) {
            return "relation.atrocious";
        }
        if (relation <= -50) {
            return "relation.verybad";
        }
        if (relation <= -30) {
            return "relation.bad";
        }
        if (relation <= -10) {
            return "relation.chilly";
        }
        return "relation.neutral";
    }

    public static EntityPlayer getServerPlayer(World world, String playerName) {
        for (Object o : world.field_73010_i) {
            EntityPlayer player;
            if (!(o instanceof EntityPlayer) || !(player = (EntityPlayer)o).getDisplayName().equals(playerName)) continue;
            return player;
        }
        return null;
    }

    public static Vector<EntityPlayer> getServerPlayers(World world) {
        Vector<EntityPlayer> players = new Vector<EntityPlayer>(world.field_73010_i);
        return players;
    }

    public static UserProfile getServerProfile(World world, String name) {
        MillWorld mw = Mill.getMillWorld(world);
        if (mw == null) {
            return null;
        }
        return mw.getProfile(name);
    }

    public static String getShortPrice(int price) {
        String res = "";
        if (price >= 4096) {
            res = (int)Math.floor(price / 4096) + "o ";
            price %= 4096;
        }
        if (price >= 64) {
            res = res + (int)Math.floor(price / 64) + "a ";
            price %= 64;
        }
        if (price > 0) {
            res = res + price + "d";
        }
        return res.trim();
    }

    public static WeightedChoice getWeightedChoice(List oChoices, EntityPlayer player) {
        List choices = oChoices;
        int weightTotal = 0;
        Vector<Integer> weights = new Vector<Integer>();
        for (WeightedChoice choice : choices) {
            weightTotal += choice.getChoiceWeight(player);
            weights.add(choice.getChoiceWeight(player));
        }
        if (weightTotal < 1) {
            return null;
        }
        int random = MillCommonUtilities.randomInt(weightTotal);
        int count = 0;
        for (int i = 0; i < choices.size(); ++i) {
            if (random >= (count += ((Integer)weights.get(i)).intValue())) continue;
            return (WeightedChoice)choices.get(i);
        }
        return null;
    }

    public static File getWorldSaveDir(World world) {
        ISaveHandler isavehandler = world.func_72860_G();
        if (isavehandler instanceof SaveHandler) {
            return ((SaveHandler)isavehandler).func_75765_b();
        }
        return null;
    }

    public static BufferedWriter getWriter(File file) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
    }

    public static int guessSignMetaData(World world, Point p) {
        boolean northOpen = true;
        boolean southOpen = true;
        boolean eastOpen = true;
        boolean westOpen = true;
        if (MillCommonUtilities.isBlockOpaqueCube(MillCommonUtilities.getBlock(world, p.getNorth()))) {
            northOpen = false;
        }
        if (MillCommonUtilities.isBlockOpaqueCube(MillCommonUtilities.getBlock(world, p.getEast()))) {
            eastOpen = false;
        }
        if (MillCommonUtilities.isBlockOpaqueCube(MillCommonUtilities.getBlock(world, p.getSouth()))) {
            southOpen = false;
        }
        if (MillCommonUtilities.isBlockOpaqueCube(MillCommonUtilities.getBlock(world, p.getWest()))) {
            westOpen = false;
        }
        if (!eastOpen) {
            return 3;
        }
        if (!westOpen) {
            return 2;
        }
        if (!southOpen) {
            return 4;
        }
        if (!northOpen) {
            return 5;
        }
        return 0;
    }

    public static boolean isBlockIdGround(Block b) {
        if (b == Blocks.field_150357_h) {
            return true;
        }
        if (b == Blocks.field_150435_aG) {
            return true;
        }
        if (b == Blocks.field_150346_d) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b == Blocks.field_150351_n) {
            return true;
        }
        if (b == Blocks.field_150343_Z) {
            return true;
        }
        if (b == Blocks.field_150354_m) {
            return true;
        }
        return b == Blocks.field_150458_ak;
    }

    public static boolean isBlockIdGroundOrCeiling(Block b) {
        if (b == Blocks.field_150348_b) {
            return true;
        }
        return b == Blocks.field_150322_A;
    }

    public static boolean isBlockIdLiquid(Block b) {
        if (b == null) {
            return false;
        }
        return b == Blocks.field_150355_j || b == Blocks.field_150358_i || b == Blocks.field_150353_l || b == Blocks.field_150356_k;
    }

    public static boolean isBlockIdSolid(Block b) {
        if (b == null) {
            return false;
        }
        if (b.func_149662_c()) {
            return true;
        }
        return b == Blocks.field_150359_w || b == Blocks.field_150410_aZ || b == Blocks.field_150333_U || b instanceof BlockSlab || b instanceof BlockStairs || b == Blocks.field_150422_aJ || b == Mill.paperWall;
    }

    public static Block getBlockIdValidGround(Block b, boolean surface) {
        if (b == Blocks.field_150357_h) {
            return Blocks.field_150346_d;
        }
        if (b == Blocks.field_150348_b && surface) {
            return Blocks.field_150346_d;
        }
        if (b == Blocks.field_150348_b && !surface) {
            return Blocks.field_150348_b;
        }
        if (b == Blocks.field_150346_d) {
            return Blocks.field_150346_d;
        }
        if (b == Blocks.field_150349_c) {
            return Blocks.field_150346_d;
        }
        if (b == Blocks.field_150351_n) {
            return Blocks.field_150351_n;
        }
        if (b == Blocks.field_150354_m) {
            return Blocks.field_150354_m;
        }
        if (b == Blocks.field_150322_A && surface) {
            return Blocks.field_150354_m;
        }
        if (b == Blocks.field_150322_A && !surface) {
            return Blocks.field_150322_A;
        }
        return null;
    }

    public static String[] limitSignText(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            String s = lines[i];
            if (s != null) {
                if (s.length() > 15) {
                    s = s.substring(0, 15);
                }
            } else {
                s = "";
            }
            lines[i] = s;
        }
        return lines;
    }

    public static void logInstance(World world) {
        String login;
        long uid = 0L;
        uid = !Mill.proxy.isTrueServer() ? ((login = Mill.proxy.getClientProfile().playerName).startsWith("Player") ? -1L : (long)login.hashCode()) : world.func_72912_H().func_76063_b();
        String os = System.getProperty("os.name");
        String mode = Mill.proxy.isTrueServer() ? "s" : (Mill.isDistantClient() ? "c" : "l");
        int totalexp = 0;
        if (Mill.proxy.isTrueServer()) {
            if (!Mill.serverWorlds.isEmpty()) {
                for (UserProfile p : Mill.serverWorlds.get((int)0).profiles.values()) {
                    for (Culture c : Culture.vectorCultures) {
                        totalexp += Math.abs(p.getCultureReputation(c.key));
                    }
                }
            }
        } else {
            UserProfile p = Mill.proxy.getClientProfile();
            if (p != null) {
                for (Culture c : Culture.vectorCultures) {
                    totalexp += Math.abs(p.getCultureReputation(c.key));
                }
            }
        }
        String lang = "";
        if (MLN.mainLanguage != null) {
            lang = MLN.mainLanguage.language;
        }
        int nbplayers = 1;
        if (Mill.proxy.isTrueServer() && !Mill.serverWorlds.isEmpty()) {
            nbplayers = Mill.serverWorlds.get((int)0).profiles.size();
        }
        String url = "http://millenaire.org/php/mlnuse.php?uid=" + uid + "&mlnversion=" + "5.2.0" + "&mode=" + mode + "&lang=" + lang + "&backuplang=" + MLN.fallback_language + "&nbplayers=" + nbplayers + "&os=" + os + "&totalexp=" + totalexp;
        url = url.replaceAll(" ", "%20");
        MLN.logPerformed = true;
        new LogThread(url).start();
    }

    public static void notifyBlock(World world, Point p) {
        world.func_147444_c(p.getiX() + 1, p.getiY(), p.getiZ(), null);
    }

    public static int[] packLong(long nb) {
        return new int[]{(int)(nb >> 32), (int)nb};
    }

    public static void playSound(World world, Point p, String sound, float volume, float pitch) {
        world.func_72908_a((double)((float)p.x + 0.5f), (double)((float)p.y + 0.5f), (double)((float)p.z + 0.5f), sound, (volume + 1.0f) / 2.0f, pitch * 0.8f);
    }

    public static void playSoundBlockBreaking(World world, Point p, Block b, float volume) {
        if (b != null && b.field_149762_H != null) {
            MillCommonUtilities.playSound(world, p, b.field_149762_H.func_150495_a(), b.field_149762_H.func_150497_c() * volume, b.field_149762_H.func_150494_d());
        }
    }

    public static void playSoundBlockPlaced(World world, Point p, Block b, float volume) {
        if (b != null && b.field_149762_H != null) {
            MillCommonUtilities.playSound(world, p, b.field_149762_H.field_150501_a, b.field_149762_H.func_150497_c() * volume, b.field_149762_H.func_150494_d());
        }
    }

    public static void playSoundByMillName(World world, Point p, String soundMill, float volume) {
        if (soundMill.equals("metal")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150339_S, volume);
        } else if (soundMill.equals("wood")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150364_r, volume);
        } else if (soundMill.equals("wool")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150325_L, volume);
        } else if (soundMill.equals("glass")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150359_w, volume);
        } else if (soundMill.equals("stone")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150348_b, volume);
        } else if (soundMill.equals("earth")) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, Blocks.field_150346_d, volume);
        } else {
            MLN.printException("Tried to play unknown sound: " + soundMill, new Exception());
        }
    }

    public static boolean probability(double probability) {
        return MillCommonUtilities.getRandom().nextDouble() < probability;
    }

    public static int putItemsInChest(IInventory chest, Item item, int toPut) {
        return MillCommonUtilities.putItemsInChest(chest, item, 0, toPut);
    }

    public static int putItemsInChest(IInventory chest, Block block, int toPut) {
        return MillCommonUtilities.putItemsInChest(chest, Item.func_150898_a((Block)block), 0, toPut);
    }

    public static int putItemsInChest(IInventory chest, Block block, int meta, int toPut) {
        return MillCommonUtilities.putItemsInChest(chest, Item.func_150898_a((Block)block), meta, toPut);
    }

    public static int putItemsInChest(IInventory chest, Item item, int meta, int toPut) {
        ItemStack stack;
        int i;
        if (chest == null) {
            return 0;
        }
        int nb = 0;
        int maxSlot = chest.func_70302_i_();
        if (chest instanceof InventoryPlayer) {
            maxSlot -= 4;
        }
        for (i = 0; i < maxSlot && nb < toPut; ++i) {
            stack = chest.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != meta) continue;
            if (stack.func_77976_d() - stack.field_77994_a >= toPut - nb) {
                stack.field_77994_a += toPut - nb;
                nb = toPut;
                continue;
            }
            nb += stack.func_77976_d() - stack.field_77994_a;
            stack.field_77994_a = stack.func_77976_d();
        }
        for (i = 0; i < maxSlot && nb < toPut; ++i) {
            stack = chest.func_70301_a(i);
            if (stack != null) continue;
            stack = new ItemStack(item, 1, meta);
            if (stack.func_77973_b() instanceof Goods.IItemInitialEnchantmens) {
                ((Goods.IItemInitialEnchantmens)stack.func_77973_b()).applyEnchantments(stack);
            }
            if (toPut - nb <= stack.func_77976_d()) {
                stack.field_77994_a = toPut - nb;
                nb = toPut;
            } else {
                stack.field_77994_a = stack.func_77976_d();
                nb += stack.field_77994_a;
            }
            chest.func_70299_a(i, stack);
        }
        return nb;
    }

    public static int randomInt(int i) {
        return MillCommonUtilities.getRandom().nextInt(i);
    }

    public static long randomLong() {
        return MillCommonUtilities.getRandom().nextLong();
    }

    public static int readInteger(String line) throws Exception {
        int res = 1;
        for (String s : line.trim().split("\\*")) {
            res *= Integer.parseInt(s);
        }
        return res;
    }

    public static boolean setBlock(World world, Point p, Block block) {
        return MillCommonUtilities.setBlock(world, p, block, true, false);
    }

    public static boolean setBlock(World world, Point p, Block block, boolean notify, boolean playSound) {
        Block oldBlock;
        if (p.x < -3.2E7 || p.z < -3.2E7 || p.x >= 3.2E7 || p.z > 3.2E7) {
            return false;
        }
        if (p.y < 0.0) {
            return false;
        }
        if (p.y >= 256.0) {
            return false;
        }
        if (playSound && block == Blocks.field_150350_a && (oldBlock = world.func_147439_a(p.getiX(), p.getiY(), p.getiZ())) != null && oldBlock.field_149762_H != null) {
            MillCommonUtilities.playSoundBlockBreaking(world, p, oldBlock, 2.0f);
        }
        if (notify) {
            world.func_147465_d(p.getiX(), p.getiY(), p.getiZ(), block, 0, 3);
        } else {
            world.func_147465_d(p.getiX(), p.getiY(), p.getiZ(), block, 0, 2);
        }
        if (playSound && block != Blocks.field_150350_a && block.field_149762_H != null) {
            MillCommonUtilities.playSoundBlockPlaced(world, p, block, 2.0f);
        }
        return true;
    }

    public static boolean setBlockAndMetadata(World world, Point p, Block block, int metadata) {
        return MillCommonUtilities.setBlockAndMetadata(world, p, block, metadata, true, false);
    }

    public static boolean setBlockAndMetadata(World world, int x, int y, int z, Block block, int metadata, boolean notify, boolean playSound) {
        Block oldBlock;
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= 256) {
            return false;
        }
        if (playSound && block != Blocks.field_150350_a && (oldBlock = world.func_147439_a(x, y, z)) != null && oldBlock.field_149762_H != null) {
            MillCommonUtilities.playSoundBlockBreaking(world, new Point(x, y, z), oldBlock, 2.0f);
        }
        if (block == null) {
            MLN.printException("Trying to set null block", new Exception());
        }
        if (notify) {
            world.func_147465_d(x, y, z, block, metadata, 3);
        } else {
            world.func_147465_d(x, y, z, block, metadata, 2);
        }
        if (playSound && block != Blocks.field_150350_a && block.field_149762_H != null) {
            MillCommonUtilities.playSoundBlockPlaced(world, new Point(x, y, z), block, 2.0f);
        }
        return true;
    }

    public static boolean setBlockAndMetadata(World world, Point p, Block block, int metadata, boolean notify, boolean playSound) {
        return MillCommonUtilities.setBlockAndMetadata(world, p.getiX(), p.getiY(), p.getiZ(), block, metadata, notify, playSound);
    }

    public static boolean setBlockMetadata(World world, Point p, int metadata) {
        return MillCommonUtilities.setBlockMetadata(world, p, metadata, true);
    }

    public static boolean setBlockMetadata(World world, int x, int y, int z, int metadata, boolean notify) {
        if (x < -32000000 || z < -32000000 || x >= 32000000 || z > 32000000) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y >= 256) {
            return false;
        }
        if (notify) {
            world.func_72921_c(x, y, z, metadata, 3);
        } else {
            world.func_72921_c(x, y, z, metadata, 2);
        }
        return true;
    }

    public static boolean setBlockMetadata(World world, Point p, int metadata, boolean notify) {
        return MillCommonUtilities.setBlockMetadata(world, p.getiX(), p.getiY(), p.getiZ(), metadata, notify);
    }

    public static void setPrivateValue(Class pclass, Object obj, String nameMCP, String name, Object value) throws IllegalArgumentException, SecurityException, NoSuchFieldException {
        if (EntityCreature.class.getSimpleName().equals("EntityCreature")) {
            ReflectionHelper.setPrivateValue((Class)pclass, (Object)obj, (Object)value, (String[])new String[]{nameMCP});
        } else {
            ReflectionHelper.setPrivateValue((Class)pclass, (Object)obj, (Object)value, (String[])new String[]{name});
        }
    }

    public static void spawnExp(World world, Point p, int nb) {
        int l;
        for (int j = nb; j > 0; j -= l) {
            l = EntityXPOrb.func_70527_a((int)j);
            world.func_72838_d((Entity)new EntityXPOrb(world, p.x + 0.5, p.y + 5.0, p.z + 0.5, l));
        }
    }

    public static EntityItem spawnItem(World world, Point p, ItemStack itemstack, float f) {
        EntityItem entityitem = new EntityItem(world, p.x, p.y + (double)f, p.z, itemstack);
        entityitem.field_145804_b = 10;
        world.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static void spawnMobsAround(World world, Point p, int radius, String mobType, int minNb, int extraNb) {
        int nb = minNb;
        if (extraNb > 0) {
            nb += MillCommonUtilities.randomInt(extraNb);
        }
        for (int i = 0; i < nb; ++i) {
            EntityLiving entityliving = (EntityLiving)EntityList.func_75620_a((String)mobType, (World)world);
            if (entityliving == null) continue;
            boolean spawned = false;
            for (int j = 0; j < 20 && !spawned; ++j) {
                double ex = p.x + (world.field_73012_v.nextDouble() * 2.0 - 1.0) * (double)radius;
                double ey = p.y + (double)world.field_73012_v.nextInt(3) - 1.0;
                double ez = p.z + (world.field_73012_v.nextDouble() * 2.0 - 1.0) * (double)radius;
                entityliving.func_70012_b(ex, ey, ez, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.func_70601_bi()) continue;
                world.func_72838_d((Entity)entityliving);
                MLN.major(null, "Entering world: " + entityliving.getClass().getName());
                spawned = true;
            }
            if (!spawned) {
                MLN.major(null, "No valid space found.");
            }
            entityliving.func_70656_aK();
        }
    }

    public static Entity spawnMobsSpawner(World world, Point p, String mobType) {
        int z;
        int ez;
        int ey;
        EntityLiving entityliving = (EntityLiving)EntityList.func_75620_a((String)mobType, (World)world);
        if (entityliving == null) {
            return null;
        }
        int x = MillCommonUtilities.randomInt(2) - 1;
        int ex = (int)(p.x + (double)x);
        if (world.func_147439_a(ex, ey = (int)p.y, ez = (int)(p.z + (double)(z = MillCommonUtilities.randomInt(2) - 1))) != Blocks.field_150350_a && world.func_147439_a(ex, ey + 1, ez) != Blocks.field_150350_a) {
            return null;
        }
        entityliving.func_70012_b((double)ex, (double)ey, (double)ez, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)entityliving);
        entityliving.func_70656_aK();
        return entityliving;
    }

    public static long unpackLong(int nb1, int nb2) {
        return (long)nb1 << 32 | (long)nb2 & 0xFFFFFFFFL;
    }

    public static void generateHearts(Entity ent) {
        for (int var3 = 0; var3 < 7; ++var3) {
            double var4 = random.nextGaussian() * 0.02;
            double var6 = random.nextGaussian() * 0.02;
            double var8 = random.nextGaussian() * 0.02;
            ent.field_70170_p.func_72869_a("heart", ent.field_70165_t + (double)(random.nextFloat() * ent.field_70130_N * 2.0f) - (double)ent.field_70130_N, ent.field_70163_u + 0.5 + (double)(random.nextFloat() * ent.field_70131_O), ent.field_70161_v + (double)(random.nextFloat() * ent.field_70130_N * 2.0f) - (double)ent.field_70130_N, var4, var6, var8);
        }
    }

    private static boolean attemptPathBuild(Building th, World world, Vector<BuildingPlan.BuildingBlock> pathPoints, Point p, Block pathBlock, int pathMeta) {
        Block block = p.getBlock(world);
        int meta = p.getMeta(world);
        if (th.isPointProtectedFromPathBuilding(p)) {
            return false;
        }
        if (p.getRelative(0.0, 2.0, 0.0).isBlockPassable(world) && p.getAbove().isBlockPassable(world) && MillCommonUtilities.canPathBeBuiltHere(block, meta)) {
            pathPoints.add(new BuildingPlan.BuildingBlock(p, pathBlock, pathMeta));
            return true;
        }
        return false;
    }

    public static boolean canPathBeBuiltHere(Block block, int meta) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150351_n || (block == Mill.path || block == Mill.pathSlab) && meta < 8 || block == Blocks.field_150327_N || block == Blocks.field_150328_O || block == Blocks.field_150338_P || block == Blocks.field_150337_Q || block == Blocks.field_150329_H || block == Blocks.field_150330_I;
    }

    public static boolean canPathBeBuiltOnTopOfThis(Block block, int meta) {
        return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150351_n || (block == Mill.path || block == Mill.pathSlab) && meta < 8 || block == Blocks.field_150348_b || block == Blocks.field_150322_A;
    }

    public static boolean isPointOnStablePath(Point p, World world) {
        Block block = p.getBlock(world);
        int meta = p.getMeta(world);
        if ((block == Mill.path || block == Mill.pathSlab) && meta > 7) {
            return true;
        }
        block = p.getBelow().getBlock(world);
        meta = p.getBelow().getMeta(world);
        return (block == Mill.path || block == Mill.pathSlab) && meta > 7;
    }

    private static void clearPathBackward(ArrayList<AStarNode> path, boolean[] pathShouldBuild, Building th, BuildingLocation l, int index) {
        BuildingLocation l2;
        Point np;
        int i;
        boolean exit = false;
        boolean leadsToBorder = false;
        for (i = index - 1; i >= 0 && !exit; --i) {
            np = new Point(path.get(i));
            l2 = th.getLocationAtCoord(np);
            if (l2 != l) {
                leadsToBorder = true;
                exit = true;
                continue;
            }
            if (!MillCommonUtilities.isPointOnStablePath(np, th.worldObj)) continue;
            exit = true;
        }
        if (!leadsToBorder) {
            exit = false;
            for (i = index - 1; i >= 0 && !exit; --i) {
                np = new Point(path.get(i));
                l2 = th.getLocationAtCoord(np);
                if (l2 != l) {
                    exit = true;
                    continue;
                }
                if (MillCommonUtilities.isPointOnStablePath(np, th.worldObj)) {
                    exit = true;
                    continue;
                }
                pathShouldBuild[i] = false;
            }
        }
    }

    private static void clearPathForward(ArrayList<AStarNode> path, boolean[] pathShouldBuild, Building th, BuildingLocation l, int index) {
        BuildingLocation l2;
        Point np;
        int i;
        boolean exit = false;
        boolean leadsToBorder = false;
        for (i = index + 1; i < path.size() && !exit; ++i) {
            np = new Point(path.get(i));
            l2 = th.getLocationAtCoord(np);
            if (l2 != l) {
                leadsToBorder = true;
                exit = true;
                continue;
            }
            if (!MillCommonUtilities.isPointOnStablePath(np, th.worldObj)) continue;
            exit = true;
        }
        if (!leadsToBorder) {
            exit = false;
            for (i = index + 1; i < path.size() && !exit; ++i) {
                np = new Point(path.get(i));
                l2 = th.getLocationAtCoord(np);
                if (l2 != l) {
                    exit = true;
                    continue;
                }
                if (MillCommonUtilities.isPointOnStablePath(np, th.worldObj)) {
                    exit = true;
                    continue;
                }
                pathShouldBuild[i] = false;
            }
        }
    }

    public static Vector<BuildingPlan.BuildingBlock> buildPath(Building th, ArrayList<AStarNode> path, Block pathBlock, int pathMeta, int pathWidth) {
        AStarNode node;
        int ip;
        Vector<BuildingPlan.BuildingBlock> pathPoints = new Vector<BuildingPlan.BuildingBlock>();
        boolean lastNodeHalfSlab = false;
        boolean[] pathShouldBuild = new boolean[path.size()];
        for (ip = 0; ip < path.size(); ++ip) {
            pathShouldBuild[ip] = true;
        }
        for (ip = 0; ip < path.size(); ++ip) {
            node = path.get(ip);
            Point p = new Point(node);
            BuildingLocation l = th.getLocationAtCoord(p);
            if (l == null) continue;
            if (ip == 0) {
                pathShouldBuild[ip] = true;
                MillCommonUtilities.clearPathForward(path, pathShouldBuild, th, l, ip);
                continue;
            }
            if (ip == path.size() - 1) {
                pathShouldBuild[ip] = true;
                MillCommonUtilities.clearPathBackward(path, pathShouldBuild, th, l, ip);
                continue;
            }
            boolean stablePath = MillCommonUtilities.isPointOnStablePath(p, th.worldObj);
            if (!stablePath) continue;
            pathShouldBuild[ip] = true;
            MillCommonUtilities.clearPathBackward(path, pathShouldBuild, th, l, ip);
            MillCommonUtilities.clearPathForward(path, pathShouldBuild, th, l, ip);
        }
        for (ip = 0; ip < path.size(); ++ip) {
            if (pathShouldBuild[ip]) {
                Point p;
                node = path.get(ip);
                AStarNode lastNode = null;
                AStarNode nextNode = null;
                if (ip > 0) {
                    lastNode = path.get(ip - 1);
                }
                if (ip + 1 < path.size()) {
                    nextNode = path.get(ip + 1);
                }
                boolean halfSlab = false;
                if (lastNode != null && nextNode != null) {
                    p = new Point(node);
                    Point nextp = new Point(nextNode);
                    Point lastp = new Point(lastNode);
                    if (!MillCommonUtilities.isStairsOrSlabOrChest(th.worldObj, nextp.getBelow()) && !MillCommonUtilities.isStairsOrSlabOrChest(th.worldObj, lastp.getBelow())) {
                        if (p.x == lastp.x && p.x == nextp.x || p.z != lastp.z || p.z != nextp.z) {
                            // empty if block
                        }
                        if (lastNode.y == nextNode.y && node.y < lastNode.y && p.getRelative(0.0, lastNode.y - node.y, 0.0).isBlockPassable(th.worldObj) && p.getRelative(0.0, lastNode.y - node.y + 1, 0.0).isBlockPassable(th.worldObj)) {
                            halfSlab = true;
                        } else if (!lastNodeHalfSlab && node.y == lastNode.y && node.y > nextNode.y) {
                            halfSlab = true;
                        } else if (!lastNodeHalfSlab && node.y == nextNode.y && node.y > lastNode.y) {
                            halfSlab = true;
                        }
                    } else {
                        Block block = p.getBelow().getBlock(th.worldObj);
                        if (block == Mill.pathSlab) {
                            halfSlab = true;
                        }
                    }
                }
                p = new Point(node).getBelow();
                Object nodePathBlock = pathBlock;
                if (nodePathBlock == Mill.path && halfSlab) {
                    nodePathBlock = Mill.pathSlab;
                }
                MillCommonUtilities.attemptPathBuild(th, th.worldObj, pathPoints, p, nodePathBlock, pathMeta);
                if (lastNode != null) {
                    int dx = p.getiX() - lastNode.x;
                    int dz = p.getiZ() - lastNode.z;
                    int nbPass = 1;
                    if (dx != 0 && dz != 0) {
                        nbPass = 2;
                    }
                    for (int i = 0; i < nbPass; ++i) {
                        boolean success;
                        int direction = i == 0 ? 1 : -1;
                        Point secondPoint = null;
                        Point secondPointAlternate = null;
                        Point thirdPoint = null;
                        if (pathWidth > 1) {
                            if (dx == 0 && direction == 1) {
                                secondPoint = p.getRelative(direction, 0.0, 0.0);
                                secondPointAlternate = p.getRelative(-direction, 0.0, 0.0);
                            } else if (dz == 0 && direction == 1) {
                                secondPoint = p.getRelative(0.0, 0.0, direction);
                                secondPointAlternate = p.getRelative(0.0, 0.0, -direction);
                            } else {
                                secondPoint = p.getRelative(dx * direction, 0.0, 0.0);
                                thirdPoint = p.getRelative(0.0, 0.0, dz * direction);
                            }
                        } else if (dx != 0 && dz != 0) {
                            secondPoint = p.getRelative(dx * direction, 0.0, 0.0);
                            secondPointAlternate = p.getRelative(0.0, 0.0, dz * direction);
                        }
                        if (secondPoint != null && !(success = MillCommonUtilities.attemptPathBuild(th, th.worldObj, pathPoints, secondPoint, nodePathBlock, pathMeta)) && secondPointAlternate != null) {
                            MillCommonUtilities.attemptPathBuild(th, th.worldObj, pathPoints, secondPointAlternate, nodePathBlock, pathMeta);
                        }
                        if (thirdPoint == null) continue;
                        MillCommonUtilities.attemptPathBuild(th, th.worldObj, pathPoints, thirdPoint, nodePathBlock, pathMeta);
                    }
                }
                lastNodeHalfSlab = halfSlab;
                continue;
            }
            lastNodeHalfSlab = false;
        }
        return pathPoints;
    }

    private static boolean isStairsOrSlabOrChest(World world, Point p) {
        Block block = p.getBlock(world);
        if (block == Blocks.field_150486_ae || block == Mill.lockedChest || block == Blocks.field_150462_ai || block == Blocks.field_150460_al || block == Blocks.field_150470_am) {
            return true;
        }
        if (block instanceof BlockStairs) {
            return true;
        }
        return block instanceof BlockSlab && !block.func_149662_c();
    }

    public static String getVillagerSentence(MillVillager v, String playerName, boolean nativeSpeech) {
        if (v.speech_key == null) {
            return null;
        }
        if (!nativeSpeech && !v.getCulture().canReadDialogues(playerName)) {
            return null;
        }
        Vector<String> variants = v.getCulture().getSentences(v.speech_key);
        if (variants != null && variants.size() > v.speech_variant) {
            String s = variants.get(v.speech_variant).replaceAll("\\$name", playerName);
            if (v.getGoalDestEntity() != null && v.getGoalDestEntity() instanceof MillVillager) {
                s = s.replaceAll("\\$targetfirstname", v.dialogueTargetFirstName);
                s = s.replaceAll("\\$targetlastname", v.dialogueTargetLastName);
            } else {
                s = s.replaceAll("\\$targetfirstname", "");
                s = s.replaceAll("\\$targetlastname", "");
            }
            if (!nativeSpeech) {
                if (s.split("/").length > 1) {
                    if ((s = s.split("/")[1].trim()).length() == 0) {
                        s = null;
                    }
                    return s;
                }
                return null;
            }
            if (s.split("/").length > 1) {
                s = s.split("/")[0].trim();
            }
            if (s.length() == 0) {
                s = null;
            }
            return s;
        }
        return v.speech_key;
    }

    public static double getItemWeaponDamage(Item item) {
        Multimap multimap = item.func_111205_h();
        if (multimap.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) && multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray().length > 0 && multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray()[0] instanceof AttributeModifier) {
            AttributeModifier weaponModifier = (AttributeModifier)multimap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).toArray()[0];
            return weaponModifier.func_111164_d();
        }
        return 0.0;
    }

    public static int getBlockId(Block b) {
        return Block.field_149771_c.func_148757_b((Object)b);
    }

    public static int getItemId(Item it) {
        return Item.field_150901_e.func_148757_b((Object)it);
    }

    public static Item getItemById(int id) {
        return (Item)Item.field_150901_e.func_148754_a(id);
    }

    public static Method getDrawSlotInventoryMethod(GuiContainer gui) {
        return ReflectionHelper.findMethod(GuiContainer.class, (Object)gui, (String[])new String[]{"func_146977_a", "func_146977_a"}, (Class[])new Class[]{Slot.class});
    }

    public static interface WeightedChoice {
        public int getChoiceWeight(EntityPlayer var1);
    }

    public static class VillageList {
        public Vector<Point> pos = new Vector();
        public Vector<String> names = new Vector();
        public Vector<String> types = new Vector();
        public Vector<String> cultures = new Vector();
        public Vector<String> generatedFor = new Vector();

        public void addVillage(Point p, String name, String type, String culture, String generatedFor) {
            this.pos.add(p);
            this.names.add(name);
            this.types.add(type);
            this.cultures.add(culture);
            this.generatedFor.add(generatedFor);
        }

        public void removeVillage(Point p) {
            int id = -1;
            for (int i = 0; i < this.pos.size() && id == -1; ++i) {
                if (!p.sameBlock(this.pos.get(i))) continue;
                id = i;
            }
            if (id != -1) {
                this.pos.remove(id);
                this.names.remove(id);
                this.types.remove(id);
                this.cultures.remove(id);
                this.generatedFor.remove(id);
            }
        }

        public void reset() {
            this.pos.clear();
            this.names.clear();
            this.types.clear();
            this.cultures.clear();
            this.generatedFor.clear();
        }
    }

    public static class VillageInfo
    implements Comparable<VillageInfo> {
        public String textKey;
        public String[] values;
        public int distance;

        @Override
        public int compareTo(VillageInfo arg0) {
            return arg0.distance - this.distance;
        }
    }

    public static class PrefixExtFileFilter
    implements FilenameFilter {
        String ext = null;
        String prefix = null;

        public PrefixExtFileFilter(String pref, String ext) {
            this.ext = ext;
            this.prefix = pref;
        }

        @Override
        public boolean accept(File file, String name) {
            if (!name.toLowerCase().endsWith("." + this.ext)) {
                return false;
            }
            if (!name.toLowerCase().startsWith(this.prefix)) {
                return false;
            }
            return !name.startsWith(".");
        }
    }

    public static class BonusThread
    extends Thread {
        String login;

        public BonusThread(String login) {
            this.login = login;
        }

        @Override
        public void run() {
            try {
                InputStream stream = new URL("http://millenaire.org/php/bonuscheck.php?login=" + this.login).openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                String result = reader.readLine();
                if (result.trim().equals("thik hai")) {
                    MLN.bonusEnabled = true;
                    MLN.bonusCode = MLN.calculateLoginMD5(this.login);
                    MLN.writeConfigFile();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class LogThread
    extends Thread {
        String url;

        public LogThread(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                InputStream stream = new URL(this.url).openStream();
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ExtFileFilter
    implements FilenameFilter {
        String ext = null;

        public ExtFileFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File file, String name) {
            if (!name.toLowerCase().endsWith("." + this.ext)) {
                return false;
            }
            return !name.startsWith(".");
        }
    }
}

