/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.BufferedReader;
import java.io.File;
import java.util.Vector;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import org.millenaire.common.Building;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.item.Goods;

public class GoalGenericCooking
extends GoalGeneric {
    public MillVillager.InvItem itemToCook = null;
    public int minimumToCook = 16;

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Vector<Building> buildings = this.getBuildings(villager);
        for (Building dest : buildings) {
            if (!this.isDestPossible(villager, dest)) continue;
            for (Point p : dest.furnaces) {
                TileEntityFurnace furnace = p.getFurnace(villager.field_70170_p);
                if (furnace == null) continue;
                if ((furnace.func_70301_a(1) == null || furnace.func_70301_a((int)1).field_77994_a < 32) && dest.countGoods(Blocks.field_150364_r, -1) > 4) {
                    return this.packDest(p, dest);
                }
                if (dest.countGoods(this.itemToCook) >= this.minimumToCook && (furnace.func_70301_a(0) == null || furnace.func_70301_a(0).func_77973_b() == this.itemToCook.getItem() && furnace.func_70301_a(0).func_77960_j() == this.itemToCook.meta && furnace.func_70301_a((int)0).field_77994_a < 32)) {
                    return this.packDest(p, dest);
                }
                if (furnace.func_70301_a(2) == null || furnace.func_70301_a((int)2).field_77994_a < this.minimumToCook) continue;
                return this.packDest(p, dest);
            }
        }
        return null;
    }

    @Override
    public boolean isPossibleGenericGoal(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        TileEntityFurnace furnace = villager.getGoalDestPoint().getFurnace(villager.field_70170_p);
        Building dest = villager.getGoalBuildingDest();
        if (furnace != null && dest != null) {
            if (furnace.func_70301_a(0) == null && dest.countGoods(this.itemToCook) >= this.minimumToCook || furnace.func_70301_a(0) != null && furnace.func_70301_a(0).func_77973_b() == this.itemToCook.getItem() && furnace.func_70301_a(0).func_77960_j() == this.itemToCook.meta && furnace.func_70301_a((int)0).field_77994_a < 64 && dest.countGoods(this.itemToCook) > 0) {
                int nb;
                if (furnace.func_70301_a(0) == null) {
                    nb = Math.min(64, dest.countGoods(this.itemToCook));
                    furnace.func_70299_a(0, new ItemStack(this.itemToCook.getItem(), nb, this.itemToCook.meta));
                    dest.takeGoods(this.itemToCook, nb);
                } else {
                    nb = Math.min(64 - furnace.func_70301_a((int)0).field_77994_a, villager.getHouse().countGoods(this.itemToCook));
                    furnace.func_70301_a((int)0).field_77994_a += nb;
                    dest.takeGoods(this.itemToCook, nb);
                }
            }
            if (furnace.func_70301_a(2) != null) {
                Item item = furnace.func_70301_a(2).func_77973_b();
                int meta = furnace.func_70301_a(2).func_77960_j();
                dest.storeGoods(item, meta, furnace.func_70301_a((int)2).field_77994_a);
                furnace.func_70299_a(2, null);
            }
        }
        if (dest.countGoods(Blocks.field_150364_r, -1) > 0) {
            if (furnace.func_70301_a(1) == null) {
                int nbplanks = Math.min(64, dest.countGoods(Blocks.field_150364_r, -1) * 4);
                furnace.func_70299_a(1, new ItemStack(Blocks.field_150344_f, nbplanks));
                dest.takeGoods(Blocks.field_150364_r, -1, nbplanks / 4);
            } else if (furnace.func_70301_a((int)1).field_77994_a < 64) {
                int nbplanks = Math.min(64 - furnace.func_70301_a((int)1).field_77994_a, dest.countGoods(Blocks.field_150364_r, -1) * 4);
                furnace.func_70299_a(1, new ItemStack(Blocks.field_150344_f, furnace.func_70301_a((int)1).field_77994_a + nbplanks));
                dest.takeGoods(Blocks.field_150364_r, -1, nbplanks / 4);
            }
        }
        return true;
    }

    public static GoalGenericCooking loadGenericCookingGoal(File file) {
        GoalGenericCooking g = new GoalGenericCooking();
        g.key = file.getName().split("\\.")[0].toLowerCase();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String value;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading generic cooking goal " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].trim().toLowerCase();
                if (GoalGeneric.readGenericGoalConfigLine(g, key, value = temp[1].trim(), file, line)) continue;
                if (key.equals("itemtocook")) {
                    if (Goods.goodsName.containsKey(value)) {
                        g.itemToCook = Goods.goodsName.get(value);
                        continue;
                    }
                    MLN.error(null, "Unknown itemToCook item in generic cooking goal " + file.getName() + ": " + line);
                    continue;
                }
                if (key.equals("minimumtocook")) {
                    g.minimumToCook = Integer.parseInt(value);
                    continue;
                }
                MLN.error(null, "Unknown line in generic cooking goal " + file.getName() + ": " + line);
            }
            if (g.itemToCook == null) {
                MLN.error(null, "The itemtocook id is mandatory in custom cooking goals " + file.getName());
                return null;
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
        return g;
    }

    @Override
    public boolean isDestPossibleSpecific(MillVillager villager, Building b) {
        return true;
    }
}

