/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.leasure;

import java.util.List;
import net.minecraft.entity.Entity;
import org.millenaire.common.Culture;
import org.millenaire.common.MillVillager;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalGoChat
extends Goal {
    private final char[] chatColours = new char[]{'f', '3', 'a', '7', 'c'};

    public GoalGoChat() {
        this.leasure = true;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        for (MillVillager v : villager.getTownHall().villagers) {
            if (v == villager || !Goal.gosocialise.key.equals(v.goalKey) || !(v.getPos().distanceToSquared((Entity)villager) < 25.0)) continue;
            return this.packDest(null, null, (Entity)v);
        }
        return null;
    }

    @Override
    public int actionDuration(MillVillager villager) {
        return 1000;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        return villager.dialogueKey == null;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 10;
    }

    @Override
    public void onAccept(MillVillager villager) throws Exception {
        Goal.GoalInformation info = this.getDestination(villager);
        if (info != null) {
            MillVillager target = (MillVillager)info.getTargetEnt();
            target.clearGoal();
            target.goalKey = this.key;
            target.setGoalDestEntity((Entity)villager);
            Culture.CultureLanguage.Dialogue dialog = villager.getCulture().getDialog(villager, target);
            if (dialog != null) {
                int role = dialog.validRoleFor(villager);
                villager.setGoalInformation(null);
                villager.setGoalDestEntity((Entity)target);
                int col = this.chatColours[MillCommonUtilities.randomInt(this.chatColours.length)];
                col = 102;
                if (dialog != null) {
                    List<Entity> entities = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, MillVillager.class, villager.getPos(), 5, 5);
                    boolean dialogueChat = true;
                    for (Entity ent : entities) {
                        if (ent == villager || ent == target) continue;
                        MillVillager v = (MillVillager)ent;
                        if (!this.key.equals(v.goalKey) || !v.dialogueChat) continue;
                        dialogueChat = false;
                    }
                    villager.dialogueKey = dialog.key;
                    villager.dialogueRole = role;
                    villager.dialogueStart = villager.field_70170_p.func_72820_D();
                    villager.dialogueColour = (char)col;
                    villager.dialogueChat = dialogueChat;
                    target.dialogueKey = dialog.key;
                    target.dialogueRole = 3 - role;
                    target.dialogueStart = villager.field_70170_p.func_72820_D();
                    target.dialogueColour = (char)col;
                    target.dialogueChat = dialogueChat;
                }
            }
        }
        super.onAccept(villager);
    }

    @Override
    protected boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public int range(MillVillager villager) {
        return 2;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }
}

