/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.millenaire.common.MLN;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.item.Goods;

public class ItemPurse
extends Goods.ItemText {
    private static final String ML_PURSE_DENIER = "ml_Purse_denier";
    private static final String ML_PURSE_DENIERARGENT = "ml_Purse_denierargent";
    private static final String ML_PURSE_DENIEROR = "ml_Purse_denieror";
    private static final String ML_PURSE_RAND = "ml_Purse_rand";

    public ItemPurse(String iconName) {
        super(iconName);
    }

    public void setDeniers(ItemStack purse, EntityPlayer player, int amount) {
        int denier = amount % 64;
        int denier_argent = (amount - denier) / 64 % 64;
        int denier_or = (amount - denier - denier_argent * 64) / 4096;
        this.setDeniers(purse, player, denier, denier_argent, denier_or);
    }

    public void setDeniers(ItemStack purse, EntityPlayer player, int denier, int denierargent, int denieror) {
        if (purse.field_77990_d == null) {
            purse.func_77982_d(new NBTTagCompound());
        }
        purse.field_77990_d.func_74768_a(ML_PURSE_DENIER, denier);
        purse.field_77990_d.func_74768_a(ML_PURSE_DENIERARGENT, denierargent);
        purse.field_77990_d.func_74768_a(ML_PURSE_DENIEROR, denieror);
        purse.field_77990_d.func_74768_a(ML_PURSE_RAND, player.field_70170_p.field_72995_K ? 0 : 1);
        this.setItemName(purse);
    }

    private void setItemName(ItemStack purse) {
        if (purse.field_77990_d == null) {
            purse.func_151001_c(MLN.string("item.purse"));
        } else {
            int deniers = purse.field_77990_d.func_74762_e(ML_PURSE_DENIER);
            int denierargent = purse.field_77990_d.func_74762_e(ML_PURSE_DENIERARGENT);
            int denieror = purse.field_77990_d.func_74762_e(ML_PURSE_DENIEROR);
            String label = "";
            if (denieror != 0) {
                label = "\u00a7e" + denieror + "o ";
            }
            if (denierargent != 0) {
                label = label + "\u00a7f" + denierargent + "a ";
            }
            if (deniers != 0 || label.length() == 0) {
                label = label + "\u00a76" + deniers + "d";
            }
            label.trim();
            purse.func_151001_c("\u00a7f" + MLN.string("item.purse") + ": " + label);
        }
    }

    public int totalDeniers(ItemStack purse) {
        if (purse.field_77990_d == null) {
            return 0;
        }
        int deniers = purse.field_77990_d.func_74762_e(ML_PURSE_DENIER);
        int denierargent = purse.field_77990_d.func_74762_e(ML_PURSE_DENIERARGENT);
        int denieror = purse.field_77990_d.func_74762_e(ML_PURSE_DENIEROR);
        return deniers + denierargent * 64 + denieror * 64 * 64;
    }

    public ItemStack func_77659_a(ItemStack purse, World world, EntityPlayer player) {
        if (this.totalDeniers(purse) > 0) {
            this.removeDeniersFromPurse(purse, player);
        } else {
            this.storeDeniersInPurse(purse, player);
        }
        return super.func_77659_a(purse, world, player);
    }

    private void removeDeniersFromPurse(ItemStack purse, EntityPlayer player) {
        if (purse.field_77990_d != null) {
            int deniers = purse.field_77990_d.func_74762_e(ML_PURSE_DENIER);
            int denierargent = purse.field_77990_d.func_74762_e(ML_PURSE_DENIERARGENT);
            int denieror = purse.field_77990_d.func_74762_e(ML_PURSE_DENIEROR);
            int result = MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, Mill.denier, deniers);
            purse.field_77990_d.func_74768_a(ML_PURSE_DENIER, deniers - result);
            result = MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, Mill.denier_argent, denierargent);
            purse.field_77990_d.func_74768_a(ML_PURSE_DENIERARGENT, denierargent - result);
            result = MillCommonUtilities.putItemsInChest((IInventory)player.field_71071_by, Mill.denier_or, denieror);
            purse.field_77990_d.func_74768_a(ML_PURSE_DENIEROR, denieror - result);
            purse.field_77990_d.func_74768_a(ML_PURSE_RAND, player.field_70170_p.field_72995_K ? 0 : 1);
            this.setItemName(purse);
        }
    }

    private void storeDeniersInPurse(ItemStack purse, EntityPlayer player) {
        int deniers = MillCommonUtilities.getItemsFromChest((IInventory)player.field_71071_by, Mill.denier, 0, Integer.MAX_VALUE);
        int denierargent = MillCommonUtilities.getItemsFromChest((IInventory)player.field_71071_by, Mill.denier_argent, 0, Integer.MAX_VALUE);
        int denieror = MillCommonUtilities.getItemsFromChest((IInventory)player.field_71071_by, Mill.denier_or, 0, Integer.MAX_VALUE);
        int total = this.totalDeniers(purse) + deniers + denierargent * 64 + denieror * 64 * 64;
        int new_denier = total % 64;
        int new_denier_argent = (total - new_denier) / 64 % 64;
        int new_denier_or = (total - new_denier - new_denier_argent * 64) / 4096;
        this.setDeniers(purse, player, new_denier, new_denier_argent, new_denier_or);
    }
}

