/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.pathing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;

public class AStarPathing {
    public MillWorldInfo winfo;
    public boolean[][] top;
    public boolean[][] bottom;
    public boolean[][] left;
    public boolean[][] right;
    public short[][] topGround;
    public byte[][] regions;
    public byte thRegion;
    public Vector<Node> nodes;
    public HashMap<PathKey, CachedPath> cache = new HashMap();
    public Vector<PathKey> firstDemand;
    public Vector<String> firstDemandOutcome;

    private static Vector<Point2D> buildPointsNode(Node end) {
        Node n = end;
        if (n.from != null) {
            Vector<Point2D> path = AStarPathing.buildPointsNode(n.from);
            path.add(n.pos);
            return path;
        }
        Vector<Point2D> path = new Vector<Point2D>();
        path.add(n.pos);
        return path;
    }

    private int boolDisplay(boolean a, boolean b, boolean c, boolean d) {
        int i = a ? 1 : 0;
        i += b ? 2 : 0;
        i += c ? 4 : 0;
        return i += d ? 8 : 0;
    }

    private Vector<PathPoint> buildFinalPath(MillVillager villager, CachedPath path) throws Exception {
        Vector<PathPoint> ppoints = new Vector<PathPoint>();
        for (int i = 0; i < path.points.length; ++i) {
            Point2D p = path.points[i];
            short newGround = this.winfo.topGround[p.x][p.z];
            short oldGround = this.topGround[p.x][p.z];
            if (newGround < oldGround + 3 && newGround > oldGround - 3) {
                oldGround = newGround;
            }
            PathPoint np = new PathPoint(p.x + this.winfo.mapStartX, (int)oldGround, p.z + this.winfo.mapStartZ);
            ppoints.add(np);
        }
        if (villager.extraLog && MLN.LogPathing >= 1 && path.points.length > 1 && ppoints.size() < 2) {
            MLN.major(this, "buildFinalPath returned a path of size " + ppoints.size() + " from " + path.points.length);
        }
        return ppoints;
    }

    private void buildNodes() {
        for (int i = 0; i < this.winfo.length; ++i) {
            for (int j = 0; j < this.winfo.width; ++j) {
                boolean isNode = false;
                int cornerSide = 0;
                if (i > 0 && j > 0 && this.top[i][j] && this.left[i][j] && (!this.left[i - 1][j] || !this.top[i][j - 1])) {
                    isNode = true;
                    cornerSide |= 1;
                }
                if (i < this.winfo.length - 1 && j > 0 && this.bottom[i][j] && this.left[i][j] && (!this.left[i + 1][j] || !this.bottom[i][j - 1])) {
                    isNode = true;
                    cornerSide += 2;
                    cornerSide |= 2;
                }
                if (i > 0 && j < this.winfo.width - 1 && this.top[i][j] && this.right[i][j] && (!this.right[i - 1][j] || !this.top[i][j + 1])) {
                    isNode = true;
                    cornerSide |= 4;
                }
                if (i < this.winfo.length - 1 && j < this.winfo.width - 1 && this.bottom[i][j] && this.right[i][j] && (!this.right[i + 1][j] || !this.bottom[i][j + 1])) {
                    isNode = true;
                    cornerSide |= 8;
                }
                if (!isNode) continue;
                this.nodes.add(new Node(new Point2D(i, j), this.nodes.size(), cornerSide, false));
            }
        }
        for (Node n : this.nodes) {
            int tz;
            int tx;
            if (n.cornerSide == 1 && n.pos.x < this.winfo.length - 1 && n.pos.z < this.winfo.width - 1 && this.bottom[n.pos.x][n.pos.z] && this.right[n.pos.x][n.pos.z] && this.bottom[n.pos.x][n.pos.z + 1] && this.right[n.pos.x + 1][n.pos.z]) {
                tx = n.pos.x + 1;
                tz = n.pos.z + 1;
                if (tx < this.winfo.length - 1 && tz < this.winfo.width - 1 && this.bottom[tx][tz] && this.right[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 2 && n.pos.x > 0 && n.pos.z < this.winfo.width - 1 && this.top[n.pos.x][n.pos.z] && this.right[n.pos.x][n.pos.z] && this.top[n.pos.x][n.pos.z + 1] && this.right[n.pos.x - 1][n.pos.z]) {
                tx = n.pos.x - 1;
                tz = n.pos.z + 1;
                if (tx > 0 && tz < this.winfo.width - 1 && this.top[tx][tz] && this.right[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 4 && n.pos.x < this.winfo.length - 1 && n.pos.z > 0 && this.bottom[n.pos.x][n.pos.z] && this.left[n.pos.x][n.pos.z] && this.bottom[n.pos.x][n.pos.z - 1] && this.left[n.pos.x + 1][n.pos.z]) {
                tx = n.pos.x + 1;
                tz = n.pos.z - 1;
                if (tx < this.winfo.length - 1 && tz > 0 && this.bottom[tx][tz] && this.left[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 8 && n.pos.x > 0 && n.pos.z > 0 && this.top[n.pos.x][n.pos.z] && this.left[n.pos.x][n.pos.z] && this.top[n.pos.x][n.pos.z - 1] && this.left[n.pos.x - 1][n.pos.z]) {
                tx = n.pos.x - 1;
                tz = n.pos.z - 1;
                if (tx > 0 && tz > 0 && this.top[tx][tz] && this.left[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 3 && n.pos.z < this.winfo.width - 1 && this.right[n.pos.x][n.pos.z]) {
                tx = n.pos.x;
                tz = n.pos.z + 1;
                if (tz < this.winfo.width - 1 && this.bottom[tx][tz] && this.right[tx][tz] && this.top[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 5 && n.pos.x < this.winfo.length - 1 && this.bottom[n.pos.x][n.pos.z]) {
                tx = n.pos.x + 1;
                tz = n.pos.z;
                if (tx < this.winfo.length - 1 && this.bottom[tx][tz] && this.right[tx][tz] && this.left[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide == 10 && n.pos.x > 0 && this.top[n.pos.x][n.pos.z]) {
                tx = n.pos.x - 1;
                tz = n.pos.z;
                if (tx > 0 && this.top[tx][tz] && this.right[tx][tz] && this.left[tx][tz]) {
                    n.pos.x = tx;
                    n.pos.z = tz;
                }
            }
            if (n.cornerSide != 12 || n.pos.z <= 0 || !this.left[n.pos.x][n.pos.z]) continue;
            tx = n.pos.x;
            tz = n.pos.z - 1;
            if (tx <= 0 || !this.top[tx][tz] || !this.bottom[tx][tz] || !this.left[tx][tz]) continue;
            n.pos.x = tx;
            n.pos.z = tz;
        }
        block3: for (int i = this.nodes.size() - 1; i > -1; --i) {
            for (int j = i - 1; j > -1; --j) {
                if (!this.nodes.get(i).equals(this.nodes.get(j))) continue;
                this.nodes.remove(i);
                continue block3;
            }
        }
    }

    public boolean canSee(Point2D p1, Point2D p2) {
        int xdist = p2.x - p1.x;
        int zdist = p2.z - p1.z;
        if (xdist == 0 && zdist == 0) {
            return true;
        }
        int xsign = 1;
        int zsign = 1;
        if (xdist < 0) {
            xsign = -1;
        }
        if (zdist < 0) {
            zsign = -1;
        }
        int x = p1.x;
        int z = p1.z;
        int xdone = 0;
        int zdone = 0;
        while (x != p2.x || z != p2.z) {
            int nx;
            int nz;
            if (xdist == 0 || zdist != 0 && xdone * 1000 / xdist > zdone * 1000 / zdist) {
                nz = z + zsign;
                nx = x;
                zdone += zsign;
                if (zsign == 1 && !this.right[x][z]) {
                    return false;
                }
                if (zsign == -1 && !this.left[x][z]) {
                    return false;
                }
            } else {
                nx = x + xsign;
                nz = z;
                xdone += xsign;
                if (xsign == 1 && !this.bottom[x][z]) {
                    return false;
                }
                if (xsign == -1 && !this.top[x][z]) {
                    return false;
                }
            }
            x = nx;
            z = nz;
        }
        return true;
    }

    public boolean createConnectionsTable(MillWorldInfo winfo, Point thStanding) throws MLN.MillenaireException {
        long startTime;
        long totalStartTime = startTime = System.nanoTime();
        this.winfo = winfo;
        this.top = new boolean[winfo.length][winfo.width];
        this.bottom = new boolean[winfo.length][winfo.width];
        this.left = new boolean[winfo.length][winfo.width];
        this.right = new boolean[winfo.length][winfo.width];
        this.regions = new byte[winfo.length][winfo.width];
        this.topGround = MillWorldInfo.shortArrayDeepClone(winfo.topGround);
        this.nodes = new Vector();
        this.firstDemand = new Vector();
        this.firstDemandOutcome = new Vector();
        for (int i = 0; i < winfo.length; ++i) {
            for (int j = 0; j < winfo.width; ++j) {
                boolean connected;
                short nspace;
                short ny;
                short y = winfo.topGround[i][j];
                short space = winfo.spaceAbove[i][j];
                if (space <= 1) continue;
                if (i > 0) {
                    ny = winfo.topGround[i - 1][j];
                    nspace = winfo.spaceAbove[i - 1][j];
                    connected = false;
                    if (ny == y && nspace > 1) {
                        connected = true;
                    } else if (ny == y - 1 && nspace > 2) {
                        connected = true;
                    } else if (ny == y + 1 && nspace > 1 && space > 2) {
                        connected = true;
                    }
                    if (connected) {
                        this.top[i][j] = true;
                        this.bottom[i - 1][j] = true;
                    }
                }
                if (j <= 0) continue;
                ny = winfo.topGround[i][j - 1];
                nspace = winfo.spaceAbove[i][j - 1];
                connected = false;
                if (ny == y && nspace > 1) {
                    connected = true;
                } else if (ny == y - 1 && nspace > 2) {
                    connected = true;
                } else if (ny == y + 1 && nspace > 1 && space > 2) {
                    connected = true;
                }
                if (!connected) continue;
                this.left[i][j] = true;
                this.right[i][j - 1] = true;
            }
        }
        if (MLN.LogConnections >= 2) {
            MLN.minor(this, "Time taken for connection building: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        startTime = System.nanoTime();
        this.buildNodes();
        if (MLN.LogConnections >= 2) {
            MLN.minor(this, "Time taken for nodes finding: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        startTime = System.nanoTime();
        for (Node n : this.nodes) {
            for (Node n2 : this.nodes) {
                if (n.id >= n2.id || !this.canSee(n.pos, n2.pos)) continue;
                Integer distance = n.pos.distanceTo(n2.pos);
                n.costs.put(n2, distance);
                n.neighbours.add(n2);
                n2.costs.put(n, distance);
                n2.neighbours.add(n);
            }
        }
        if (MLN.LogConnections >= 2) {
            MLN.minor(this, "Time taken for nodes linking: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        startTime = System.nanoTime();
        this.findRegions(thStanding);
        if (MLN.LogConnections >= 2) {
            MLN.minor(this, "Time taken for group finding: " + (double)(System.nanoTime() - startTime) / 1000000.0);
        }
        if (MLN.LogConnections >= 1) {
            MLN.major(this, "Node graph complete. Size: " + this.nodes.size() + " Time taken: " + (double)(System.nanoTime() - totalStartTime) / 1000000.0);
        }
        if (MLN.LogConnections >= 3 && MLN.DEV) {
            MLN.major(this, "Calling displayConnectionsLog");
            this.displayConnectionsLog();
        }
        return true;
    }

    public PathingWorker createWorkerForPath(MillVillager villager, int pStartX, int pStartZ, int pDestX, int pDestZ) {
        PathingWorker worker = new PathingWorker(villager, pStartX, pStartZ, pDestX, pDestZ);
        worker.start();
        return worker;
    }

    private void displayConnectionsLog() {
        int j;
        int i;
        int j2;
        long startTime = System.nanoTime();
        MLN.minor(this, "Connections:");
        String s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + MathHelper.func_76128_c((double)(j2 / 10)) % 10;
        }
        MLN.minor(this, s);
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + j2 % 10;
        }
        MLN.minor(this, s);
        for (i = 0; i < this.winfo.length; ++i) {
            s = i < 10 ? i + "   " : (i < 100 ? i + "  " : i + " ");
            for (j = 0; j < this.winfo.width; ++j) {
                s = s + Integer.toHexString(this.boolDisplay(this.top[i][j], this.left[i][j], this.bottom[i][j], this.right[i][j]));
            }
            s = i < 10 ? s + "   " + i : (i < 100 ? s + "  " + i : s + " " + i);
            MLN.minor(this, s);
        }
        MLN.minor(this, "spaceAbove:");
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + MathHelper.func_76128_c((double)(j2 / 10)) % 10;
        }
        MLN.minor(this, s);
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + j2 % 10;
        }
        MLN.minor(this, s);
        for (i = 0; i < this.winfo.length; ++i) {
            s = i < 10 ? i + "   " : (i < 100 ? i + "  " : i + " ");
            for (j = 0; j < this.winfo.width; ++j) {
                s = s + this.winfo.spaceAbove[i][j];
            }
            s = i < 10 ? s + "   " + i : (i < 100 ? s + "  " + i : s + " " + i);
            MLN.minor(this, s);
        }
        MLN.minor(this, "Y pos:");
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + MathHelper.func_76128_c((double)(j2 / 10)) % 10;
        }
        MLN.minor(this, s);
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + j2 % 10;
        }
        MLN.minor(this, s);
        for (i = 0; i < this.winfo.length; ++i) {
            s = i < 10 ? i + "   " : (i < 100 ? i + "  " : i + " ");
            for (j = 0; j < this.winfo.width; ++j) {
                s = s + this.winfo.topGround[i][j] % 10;
            }
            s = i < 10 ? s + "   " + i : (i < 100 ? s + "  " + i : s + " " + i);
            MLN.minor(this, s);
        }
        MLN.minor(this, "Nodes:");
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + MathHelper.func_76128_c((double)(j2 / 10)) % 10;
        }
        MLN.minor(this, s);
        s = "    ";
        for (j2 = 0; j2 < this.winfo.width; ++j2) {
            s = s + j2 % 10;
        }
        MLN.minor(this, s);
        for (i = 0; i < this.winfo.length; ++i) {
            s = i < 10 ? i + "   " : (i < 100 ? i + "  " : i + " ");
            for (j = 0; j < this.winfo.width; ++j) {
                boolean found = false;
                for (Node n : this.nodes) {
                    if (n.pos.x != i || n.pos.z != j) continue;
                    s = s + Integer.toHexString(n.id % 10);
                    found = true;
                }
                if (found) continue;
                s = !this.top[i][j] && !this.bottom[i][j] && !this.left[i][j] && !this.right[i][j] ? s + "#" : (!this.top[i][j] || !this.bottom[i][j] || !this.left[i][j] || !this.right[i][j] ? s + "." : s + " ");
            }
            s = i < 10 ? s + "   " + i : (i < 100 ? s + "  " + i : s + " " + i);
            MLN.minor(this, s);
        }
        MLN.minor(this, "Displaying connections finished. Time taken: " + (double)(System.nanoTime() - startTime) / 1000000.0);
    }

    private void findRegions(Point thStanding) throws MLN.MillenaireException {
        int nodesMarked = 0;
        int nodeGroup = 0;
        while (nodesMarked < this.nodes.size()) {
            ++nodeGroup;
            Vector<Node> toVisit = new Vector<Node>();
            Node fn = null;
            int i = 0;
            while (fn == null) {
                if (this.nodes.get((int)i).region == 0) {
                    fn = this.nodes.get(i);
                }
                ++i;
            }
            fn.region = nodeGroup;
            ++nodesMarked;
            toVisit.add(fn);
            while (toVisit.size() > 0) {
                for (Node n : ((Node)toVisit.get((int)0)).neighbours) {
                    if (n.region == 0) {
                        n.region = nodeGroup;
                        toVisit.add(n);
                        ++nodesMarked;
                        continue;
                    }
                    if (n.region == nodeGroup) continue;
                    throw new MLN.MillenaireException("Node belongs to group " + n.region + " but reached from " + nodeGroup);
                }
                toVisit.remove(0);
            }
        }
        for (int i = 0; i < this.winfo.length; ++i) {
            for (int j = 0; j < this.winfo.width; ++j) {
                this.regions[i][j] = -1;
            }
        }
        for (Node n : this.nodes) {
            this.regions[n.pos.x][n.pos.z] = (byte)n.region;
        }
        boolean spreaddone = true;
        while (spreaddone) {
            spreaddone = false;
            for (int i = 0; i < this.winfo.length; ++i) {
                for (int j = 0; j < this.winfo.width; ++j) {
                    if (this.regions[i][j] <= 0) continue;
                    byte regionid = this.regions[i][j];
                    int x = i;
                    while (x > 1 && this.top[x][j] && this.regions[x - 1][j] == -1) {
                        this.regions[--x][j] = regionid;
                        spreaddone = true;
                    }
                    x = i;
                    while (x < this.winfo.length - 1 && this.bottom[x][j] && this.regions[x + 1][j] == -1) {
                        this.regions[++x][j] = regionid;
                        spreaddone = true;
                    }
                    x = j;
                    while (x > 1 && this.left[i][x] && this.regions[i][x - 1] == -1) {
                        this.regions[i][--x] = regionid;
                        spreaddone = true;
                    }
                    x = j;
                    while (x < this.winfo.width - 1 && this.right[i][x] && this.regions[i][x + 1] == -1) {
                        this.regions[i][++x] = regionid;
                        spreaddone = true;
                    }
                }
            }
        }
        this.thRegion = this.regions[thStanding.getiX() - this.winfo.mapStartX][thStanding.getiZ() - this.winfo.mapStartZ];
        if (MLN.LogConnections >= 2) {
            MLN.minor(this, nodeGroup + " node groups found.");
        }
    }

    public boolean isInArea(Point p) {
        return !(p.x < (double)this.winfo.mapStartX || p.x >= (double)(this.winfo.mapStartX + this.winfo.length) || p.z < (double)this.winfo.mapStartZ || p.z >= (double)(this.winfo.mapStartZ + this.winfo.width));
    }

    public boolean isValidPoint(Point p) {
        if (!this.isInArea(p)) {
            return false;
        }
        return this.winfo.spaceAbove[p.getiX() - this.winfo.mapStartX][p.getiZ() - this.winfo.mapStartZ] > 1;
    }

    private void storeInCache(CachedPath path, Point2D dest) throws Exception {
        for (Point2D p : path.points) {
            if (p != null) continue;
            throw new Exception("Null node in path to cache: " + path);
        }
        this.cache.put(path.getKey(), path);
        if (!dest.equals(path.getEnd())) {
            this.cache.put(new PathKey(path.getStart(), dest), path);
        }
        for (int i = 1; i < path.points.length - 2; ++i) {
            CachedPath cp = new CachedPath(path, i);
            for (Point2D p : cp.points) {
                if (p != null) continue;
                throw new Exception("Null node in path to cache: " + path);
            }
            this.cache.put(cp.getKey(), cp);
            if (dest.equals(cp.getEnd())) continue;
            this.cache.put(new PathKey(cp.getStart(), dest), cp);
        }
    }

    public static class Point2D {
        int x;
        int z;

        public Point2D(int px, int pz) {
            this.x = px;
            this.z = pz;
        }

        public int distanceTo(Point2D p) {
            int d = p.x - this.x;
            int d1 = p.z - this.z;
            return (int)Math.sqrt(d * d + d1 * d1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Point2D)) {
                return false;
            }
            Point2D p = (Point2D)obj;
            return this.x == p.x && this.z == p.z;
        }

        public int hashCode() {
            return this.x << 16 & this.z;
        }

        public String toString() {
            return this.x + "/" + this.z;
        }
    }

    public static class PathKey {
        static final boolean log = false;
        Point2D start;
        Point2D end;

        PathKey(Point2D start, Point2D end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PathKey)) {
                return false;
            }
            PathKey p = (PathKey)obj;
            return this.start.equals(p.start) && this.end.equals(p.end);
        }

        public int hashCode() {
            return this.start.x + (this.start.z << 8) + (this.end.x << 16) + (this.end.z << 24);
        }

        public String toString() {
            return this.start + ", " + this.end;
        }
    }

    public class PathingWorker
    extends Thread {
        private static final int NODE_WARNING_LEVEL = 100;
        private static final int MAX_NODE_VISIT = 1500;
        MillVillager villager;
        int pStartX;
        int pStartZ;
        int pDestX;
        int pDestZ;
        int updateCounterStart;
        Point villagerPosStart;

        private PathingWorker(MillVillager villager, int pStartX, int pStartZ, int pDestX, int pDestZ) {
            this.villager = villager;
            this.pStartX = pStartX;
            this.pStartZ = pStartZ;
            this.pDestX = pDestX;
            this.pDestZ = pDestZ;
            this.updateCounterStart = villager.updateCounter;
            this.villagerPosStart = villager.getPos();
        }

        public Vector<PathPoint> getPathViaNodes(MillVillager villager, int pStartX, int pStartZ, int pDestX, int pDestZ) throws Exception {
            long startTime = System.nanoTime();
            long currentAge = System.currentTimeMillis();
            int startX = pStartX - AStarPathing.this.winfo.mapStartX;
            int startZ = pStartZ - AStarPathing.this.winfo.mapStartZ;
            int destX = pDestX - AStarPathing.this.winfo.mapStartX;
            int destZ = pDestZ - AStarPathing.this.winfo.mapStartZ;
            Node start = new Node(new Point2D(startX, startZ), 0, true);
            Node end = new Node(new Point2D(destX, destZ), 0, true);
            Point2D originalDest = new Point2D(destX, destZ);
            PathKey key = new PathKey(start.pos, end.pos);
            if (AStarPathing.this.cache.containsKey(key) && currentAge - AStarPathing.this.cache.get((Object)key).age < 30000L) {
                if (MLN.DEV && villager != null) {
                    ++villager.getTownHall().monitor.nbPathing;
                    ++villager.getTownHall().monitor.nbCached;
                }
                if (AStarPathing.this.cache.get((Object)key).points != null) {
                    return AStarPathing.this.buildFinalPath(villager, AStarPathing.this.cache.get(key));
                }
                return null;
            }
            if (AStarPathing.this.canSee(start.pos, end.pos)) {
                end.from = start;
                CachedPath path = new CachedPath(AStarPathing.buildPointsNode(end));
                AStarPathing.this.cache.put(new PathKey(start.pos, end.pos), path);
                if (MLN.DEV && villager != null) {
                    ++villager.getTownHall().monitor.nbPathing;
                    double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                    villager.getTownHall().monitor.pathingTime += timeInMl;
                    villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                    ++villager.nbPathsCalculated;
                    AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
                    AStarPathing.this.firstDemandOutcome.add("Trivial path");
                }
                return AStarPathing.this.buildFinalPath(villager, path);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            for (int i = AStarPathing.this.nodes.size() - 1; i >= 0; --i) {
                if (!AStarPathing.this.nodes.get((int)i).temp) continue;
                AStarPathing.this.nodes.remove(i);
            }
            for (Node n : AStarPathing.this.nodes) {
                int dist;
                if (AStarPathing.this.canSee(n.pos, start.pos)) {
                    start.neighbours.add(n);
                    start.region = n.region;
                    n.neighbours.add(start);
                    dist = start.pos.distanceTo(n.pos);
                    n.costs.put(start, dist);
                    start.costs.put(n, dist);
                }
                if (AStarPathing.this.canSee(n.pos, end.pos)) {
                    end.neighbours.add(n);
                    end.region = n.region;
                    n.neighbours.add(end);
                    dist = end.pos.distanceTo(n.pos);
                    n.costs.put(end, dist);
                    end.costs.put(n, dist);
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            if (start.region != end.region) {
                if (MLN.LogGetPath >= 1 && villager.extraLog) {
                    MLN.major(villager, "Start and end nodes in different groups: " + start + "/" + end);
                }
                end.neighbours.removeAllElements();
            }
            if (start.neighbours.size() == 0) {
                boolean foundStartNode = false;
                for (int i = -1; i < 2 && !foundStartNode; ++i) {
                    for (int j = -1; j < 2 && !foundStartNode; ++j) {
                        if ((i == 0 || j == 0) && startX + i >= 0 && startZ + j >= 0 && startX + i < AStarPathing.this.winfo.length && startZ + j < AStarPathing.this.winfo.width && AStarPathing.this.winfo.topGround[startX][startZ] - AStarPathing.this.winfo.topGround[startX + i][startZ + j] < 3 && AStarPathing.this.winfo.topGround[startX][startZ] - AStarPathing.this.winfo.topGround[startX + i][startZ + j] > -3) {
                            start = new Node(new Point2D(startX + i, startZ + j), 0, true);
                            for (Node n : AStarPathing.this.nodes) {
                                if (!AStarPathing.this.canSee(n.pos, start.pos)) continue;
                                start.neighbours.add(n);
                                start.region = n.region;
                                n.neighbours.add(start);
                                int dist = start.pos.distanceTo(n.pos);
                                n.costs.put(start, dist);
                                start.costs.put(n, dist);
                            }
                            if (start.neighbours.size() > 0) {
                                foundStartNode = true;
                                if (MLN.LogGetPath >= 2 && villager.extraLog) {
                                    MLN.minor(this, "Found alternative start: " + start);
                                }
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                if (!foundStartNode) {
                    if (MLN.LogGetPath >= 2 && villager.extraLog) {
                        MLN.minor(villager, "Start node " + start + " unreachable.");
                    }
                    AStarPathing.this.cache.put(new PathKey(start.pos, end.pos), new CachedPath());
                    if (MLN.DEV && villager != null) {
                        ++villager.getTownHall().monitor.nbPathing;
                        double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                        villager.getTownHall().monitor.pathingTime += timeInMl;
                        villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                        ++villager.nbPathsCalculated;
                        ++villager.nbPathNoStart;
                        AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
                        AStarPathing.this.firstDemandOutcome.add("No start node");
                    }
                    throw new PathingException("Start node " + start + " unreachable.", PathingException.UNREACHABLE_START);
                }
            }
            if (end.neighbours.size() == 0) {
                if (MLN.LogGetPath >= 2 && villager.extraLog) {
                    MLN.minor(this, "End node " + end + " unreachable.");
                }
                boolean foundEndNode = false;
                boolean foundEndNodeInOtherGroup = false;
                Vector<Node> testedNodes = new Vector<Node>();
                for (int i = 0; i < 4 && !foundEndNode; ++i) {
                    for (int j = 0; j <= i && !foundEndNode; ++j) {
                        if (i == 0 || j == 0) {
                            for (int cpt = 0; cpt < 8; ++cpt) {
                                if (cpt == 0) {
                                    end = new Node(new Point2D(destX + i, destZ + j), 0, true);
                                } else if (cpt == 1) {
                                    end = new Node(new Point2D(destX - i, destZ + j), 0, true);
                                } else if (cpt == 2) {
                                    end = new Node(new Point2D(destX + i, destZ - j), 0, true);
                                } else if (cpt == 3) {
                                    end = new Node(new Point2D(destX - i, destZ - j), 0, true);
                                } else if (cpt == 4) {
                                    end = new Node(new Point2D(destX + j, destZ + i), 0, true);
                                } else if (cpt == 5) {
                                    end = new Node(new Point2D(destX - j, destZ + i), 0, true);
                                } else if (cpt == 6) {
                                    end = new Node(new Point2D(destX + j, destZ - i), 0, true);
                                } else if (cpt == 7) {
                                    end = new Node(new Point2D(destX + j, destZ - i), 0, true);
                                }
                                if (testedNodes.contains(end)) continue;
                                for (Node n : AStarPathing.this.nodes) {
                                    if (!AStarPathing.this.canSee(n.pos, end.pos)) continue;
                                    end.neighbours.add(n);
                                    end.region = n.region;
                                    n.neighbours.add(end);
                                    int dist = end.pos.distanceTo(n.pos);
                                    n.costs.put(end, dist);
                                    end.costs.put(n, dist);
                                }
                                if (end.neighbours.size() > 0 && end.neighbours.get((int)0).region == start.region) {
                                    foundEndNode = true;
                                    if (MLN.LogGetPath >= 2 && villager.extraLog) {
                                        MLN.minor(villager, "Found alternative end: " + end);
                                    }
                                } else if (end.neighbours.size() > 0) {
                                    foundEndNodeInOtherGroup = true;
                                }
                                testedNodes.add(end);
                            }
                        }
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                if (!foundEndNode) {
                    AStarPathing.this.cache.put(new PathKey(start.pos, end.pos), new CachedPath());
                    if (MLN.DEV && villager != null) {
                        ++villager.getTownHall().monitor.nbPathing;
                        double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                        villager.getTownHall().monitor.pathingTime += timeInMl;
                        villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                        ++villager.nbPathsCalculated;
                        ++villager.nbPathNoEnd;
                        AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
                        AStarPathing.this.firstDemandOutcome.add("No end node");
                    }
                    if (foundEndNodeInOtherGroup) {
                        return null;
                    }
                    throw new PathingException("End pos not connected to any node", PathingException.INVALID_GOAL);
                }
            }
            AStarPathing.this.nodes.add(start);
            AStarPathing.this.nodes.add(end);
            for (Node n : AStarPathing.this.nodes) {
                n.from = null;
                n.fromDist = -1;
                n.toDist = -1;
            }
            Vector<Node> open = new Vector<Node>();
            HashMap<Node, Node> closed = new HashMap<Node, Node>();
            open.add(start);
            start.fromDist = 0;
            start.toDist = start.pos.distanceTo(end.pos);
            int nbNodesVisited = 0;
            Node closest = start;
            while (open.size() > 0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (++nbNodesVisited > 1500) {
                    if (MLN.LogGetPath >= 2 && villager.extraLog) {
                        MLN.minor(villager, "Aborting after :" + nbNodesVisited + ", " + startX + "/" + startZ + " - " + destX + "/" + destZ + ". Stopping at: " + closest);
                    }
                    if (MLN.LogGetPath >= 3 && villager.extraLog) {
                        MLN.debug(villager, "closest.equals(end): " + closest.equals(end));
                        MLN.debug(villager, "start.toDist: " + start.toDist);
                    }
                    CachedPath cpath = new CachedPath(AStarPathing.buildPointsNode(closest));
                    AStarPathing.this.storeInCache(cpath, originalDest);
                    if (MLN.DEV && villager != null) {
                        ++villager.getTownHall().monitor.nbPathing;
                        double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                        villager.getTownHall().monitor.pathingTime += timeInMl;
                        villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                        ++villager.nbPathsCalculated;
                        ++villager.nbPathAborted;
                        villager.abortedKeys.add(new PathKey(start.pos, end.pos));
                        if (MLN.LogGetPath >= 1) {
                            MLN.major(villager, "Caching aborted path: " + cpath.getKey() + " and " + new PathKey(cpath.getStart(), originalDest) + ", failing took " + timeInMl + " ms. " + "Regions: " + AStarPathing.this.regions[start.pos.x][start.pos.z] + " - " + AStarPathing.this.regions[end.pos.x][end.pos.z]);
                        }
                        AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
                        AStarPathing.this.firstDemandOutcome.add("Aborted");
                    }
                    return AStarPathing.this.buildFinalPath(villager, cpath);
                }
                Node cn = null;
                int bestdistance = -1;
                for (Node n : open) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (n.toDist == -1) {
                        n.toDist = n.pos.distanceTo(end.pos);
                    }
                    int distance = n.fromDist + n.toDist;
                    if (MLN.LogGetPath >= 3 && villager.extraLog) {
                        MLN.debug(this, "Testing " + n + ")");
                    }
                    if (n.equals(end)) {
                        CachedPath cpath = new CachedPath(AStarPathing.buildPointsNode(n));
                        AStarPathing.this.storeInCache(cpath, originalDest);
                        AStarPathing.this.cache.put(new PathKey(start.pos, end.pos), cpath);
                        AStarPathing.this.cache.put(new PathKey(new Point2D(startX, startZ), new Point2D(destX, destZ)), cpath);
                        if (MLN.DEV && villager != null) {
                            ++villager.getTownHall().monitor.nbPathing;
                            double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                            if (nbNodesVisited > 100 && MLN.LogGetPath >= 1) {
                                MLN.major(villager, "Success after: " + nbNodesVisited + " time: " + timeInMl + " ms between " + start.pos + " and " + end.pos + " goal: " + villager.goalKey);
                            } else if (MLN.LogGetPath >= 3 && villager.extraLog) {
                                MLN.debug(villager, "Success after: " + nbNodesVisited + " time: " + timeInMl + " ms between " + start.pos + " and " + end.pos + " goal: " + villager.goalKey);
                            }
                            villager.getTownHall().monitor.pathingTime += timeInMl;
                            villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                            ++villager.nbPathsCalculated;
                            AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
                            AStarPathing.this.firstDemandOutcome.add("Success");
                        }
                        if (MLN.LogGetPath >= 2) {
                            MLN.minor(villager, "Path calculation took " + (villager.updateCounter - this.updateCounterStart) + " update cycles. Start pos: " + this.villagerPosStart + " and pos: " + villager.getPos());
                        }
                        return AStarPathing.this.buildFinalPath(villager, cpath);
                    }
                    if (bestdistance == -1 || distance < bestdistance) {
                        cn = n;
                        bestdistance = distance;
                    }
                    if (n.toDist >= closest.toDist) continue;
                    closest = n;
                }
                if (closest.toDist == 0 && MLN.LogGetPath >= 1 && villager.extraLog) {
                    MLN.major(this, "Picked: " + cn + " " + "cn.equals(end): " + cn.equals(end));
                    MLN.major(this, "Should have reached: " + closest + " " + "closest.equals(end): " + closest.equals(end));
                }
                if (MLN.LogGetPath >= 3 && villager.extraLog) {
                    MLN.debug(this, "Selected: " + cn);
                }
                open.remove(cn);
                closed.put(cn, cn);
                for (Node n : cn.neighbours) {
                    Integer cost = cn.costs.get(n);
                    if (closed.containsKey(n)) continue;
                    if (!open.contains(n)) {
                        n.fromDist = cn.fromDist + cost;
                        n.toDist = n.pos.distanceTo(end.pos);
                        n.from = cn;
                        open.add(n);
                        continue;
                    }
                    if (cn.fromDist + cost >= n.fromDist) continue;
                    n.fromDist = cn.fromDist + cost;
                    n.from = cn;
                }
            }
            if (MLN.LogGetPath >= 1 && villager.extraLog) {
                MLN.major(villager, "Failure after :" + nbNodesVisited + ", " + startX + "/" + startZ + " - " + destX + "/" + destZ);
            }
            AStarPathing.this.cache.put(new PathKey(start.pos, end.pos), new CachedPath());
            AStarPathing.this.cache.put(new PathKey(new Point2D(startX, startZ), new Point2D(destX, destZ)), new CachedPath());
            if (MLN.DEV && villager != null) {
                ++villager.getTownHall().monitor.nbPathing;
                double timeInMl = (double)(System.nanoTime() - startTime) / 1000000.0;
                villager.getTownHall().monitor.pathingTime += timeInMl;
                villager.pathingTime = (long)((double)villager.pathingTime + timeInMl);
                ++villager.nbPathsCalculated;
                ++villager.nbPathFailure;
                villager.getTownHall().monitor.noPathFoundTime += timeInMl;
                AStarPathing.this.firstDemandOutcome.add("Failure");
                AStarPathing.this.firstDemand.add(new PathKey(start.pos, end.pos));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AStarPathing aStarPathing = AStarPathing.this;
            synchronized (aStarPathing) {
                try {
                    Vector<PathPoint> result = this.getPathViaNodes(this.villager, this.pStartX, this.pStartZ, this.pDestX, this.pDestZ);
                    this.villager.registerNewPath(result);
                }
                catch (InterruptedException e) {
                    this.villager.registerNewPathInterrupt(this);
                }
                catch (Exception e) {
                    this.villager.registerNewPathException(e);
                }
            }
        }
    }

    public static class PathingException
    extends Exception {
        private static final long serialVersionUID = 6212915693102946545L;
        public static int UNREACHABLE_START = 0;
        public static int INVALID_GOAL = 1;
        public int errorCode;

        public PathingException(String message, int code) {
            super(message);
            this.errorCode = code;
        }
    }

    protected static class Node {
        Point2D pos;
        Vector<Node> neighbours;
        HashMap<Node, Integer> costs;
        Node from;
        int id;
        int fromDist;
        int toDist;
        int cornerSide;
        int region = 0;
        boolean temp = false;

        public Node(Point2D p, int pid, boolean ptemp) {
            this.pos = p;
            this.id = pid;
            this.cornerSide = 0;
            this.temp = ptemp;
            this.neighbours = new Vector();
            this.costs = new HashMap();
        }

        public Node(Point2D p, int pid, int cornerSide, boolean ptemp) {
            this.pos = p;
            this.id = pid;
            this.temp = ptemp;
            this.cornerSide = cornerSide;
            this.neighbours = new Vector();
            this.costs = new HashMap();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Node n = (Node)obj;
            return n.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return this.pos.x + (this.pos.z << 16);
        }

        public String toString() {
            return "Node " + this.id + ": " + this.pos + " group: " + this.region + " neighbours: " + this.neighbours.size() + "(fromDist: " + this.fromDist + ", toDist: " + this.toDist + ")";
        }
    }

    public static class CachedPath {
        Point2D[] points = null;
        long age = 0L;

        CachedPath() {
            this.age = System.currentTimeMillis();
        }

        CachedPath(CachedPath cp, int from) {
            this.points = new Point2D[cp.points.length - from];
            int i = 0;
            for (Point2D p : cp.points) {
                if (i >= from) {
                    this.points[i - from] = p;
                }
                ++i;
            }
            this.age = System.currentTimeMillis();
        }

        CachedPath(Vector<Point2D> v) {
            int i;
            Vector<Point2D> v2 = new Vector<Point2D>();
            for (i = 0; i < v.size(); ++i) {
                Point2D p = v.get(i);
                if (i > 0) {
                    Point2D prevp = (Point2D)v2.get(v2.size() - 1);
                    try {
                        Vector<Point2D> v3 = this.fillPoints(prevp, p);
                        for (Point2D fp : v3) {
                            v2.add(fp);
                        }
                    }
                    catch (Exception e) {
                        MLN.printException(e);
                    }
                }
                v2.add(p);
            }
            this.points = new Point2D[v2.size()];
            i = 0;
            Iterator i$ = v2.iterator();
            while (i$.hasNext()) {
                Point2D p;
                this.points[i] = p = (Point2D)i$.next();
                ++i;
            }
            this.age = System.currentTimeMillis();
        }

        CachedPath(Vector<Point2D> v, CachedPath cp) {
            this.points = new Point2D[v.size() + cp.points.length - 1];
            int i = 0;
            Iterator<Point2D> i$ = v.iterator();
            while (i$.hasNext()) {
                Point2D p;
                this.points[i] = p = i$.next();
                ++i;
            }
            boolean first = true;
            for (Point2D p : cp.points) {
                if (first) {
                    first = false;
                    continue;
                }
                this.points[i] = p;
                ++i;
            }
            this.age = System.currentTimeMillis();
        }

        private Vector<Point2D> fillPoints(Point2D p1, Point2D p2) throws Exception {
            Vector<Point2D> v = new Vector<Point2D>();
            int xdist = p2.x - p1.x;
            int zdist = p2.z - p1.z;
            if (xdist == 0 && zdist == 0) {
                return v;
            }
            int xsign = 1;
            int zsign = 1;
            if (xdist < 0) {
                xsign = -1;
            }
            if (zdist < 0) {
                zsign = -1;
            }
            int x = p1.x;
            int z = p1.z;
            int xdone = 0;
            int zdone = 0;
            while (x != p2.x || z != p2.z) {
                int nx;
                int nz;
                if (zdone != zdist && (xdist == 0 || (float)zdone * 1.0f / (float)zdist < (float)xdone * 1.0f / (float)xdist)) {
                    nz = z + zsign;
                    nx = x;
                    zdone += zsign;
                } else if (xdone != xdist) {
                    nx = x + xsign;
                    nz = z;
                    xdone += xsign;
                } else {
                    throw new MLN.MillenaireException("Error in fillPoints: from " + p1 + " to " + p2 + " did " + xdone + "/" + zdone + " and could find nothing else to do.");
                }
                x = nx;
                z = nz;
                if (x == p2.x && z == p2.z) continue;
                v.add(new Point2D(nx, nz));
            }
            return v;
        }

        public String fullString() {
            String s = "";
            for (Point2D p : this.points) {
                s = s + p + " ";
            }
            return s;
        }

        public Point2D getEnd() {
            return this.points[this.points.length - 1];
        }

        public PathKey getKey() {
            return new PathKey(this.points[0], this.points[this.points.length - 1]);
        }

        public Point2D getStart() {
            return this.points[0];
        }

        public String toString() {
            return this.points.length + " - " + this.getStart() + " - " + this.getEnd();
        }
    }
}

