/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.client.gui;

import java.util.Vector;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.millenaire.client.gui.DisplayActions;
import org.millenaire.client.gui.GuiText;
import org.millenaire.client.network.ClientSender;
import org.millenaire.common.Building;
import org.millenaire.common.BuildingLocation;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.MillWorld;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.forge.Mill;

public class GuiPanelParchment
extends GuiText {
    public static final int VILLAGE_MAP = 1;
    public static final int CHUNK_MAP = 2;
    private boolean isParchment = false;
    private int mapType = 0;
    private Building townHall = null;
    private final EntityPlayer player;
    private final Vector<Vector<String>> fullText;
    private final Vector<Vector<GuiText.Line>> fullTextLines;
    ResourceLocation backgroundParchment = new ResourceLocation("millenaire", "textures/gui/ML_parchment.png");
    ResourceLocation backgroundPanel = new ResourceLocation("millenaire", "textures/gui/ML_panel.png");
    public static final int chunkMapSizeInBlocks = 1280;

    public GuiPanelParchment(EntityPlayer player, Vector<Vector<String>> fullText, Building townHall, int mapType, boolean isParchment) {
        this.mapType = mapType;
        this.townHall = townHall;
        this.isParchment = isParchment;
        this.player = player;
        this.fullText = fullText;
        this.fullTextLines = null;
    }

    public GuiPanelParchment(EntityPlayer player, Building townHall, Vector<Vector<GuiText.Line>> fullTextLines, int mapType, boolean isParchment) {
        this.mapType = mapType;
        this.townHall = townHall;
        this.isParchment = isParchment;
        this.player = player;
        this.fullTextLines = fullTextLines;
        this.fullText = null;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton instanceof GuiText.MillGuiButton) {
            GuiText.MillGuiButton gb = (GuiText.MillGuiButton)guibutton;
            if (gb.field_146127_k == 2000) {
                DisplayActions.displayHelpGUI();
            } else if (gb.field_146127_k == 3000) {
                DisplayActions.displayChunkGUI(this.player, this.player.field_70170_p);
            } else if (gb.field_146127_k == 4000) {
                DisplayActions.displayConfigGUI();
            }
        }
        super.func_146284_a(guibutton);
    }

    @Override
    protected void customDrawBackground(int i, int j, float f) {
    }

    @Override
    public void customDrawScreen(int i, int j, float f) {
        if (this.mapType == 1 && this.pageNum == 0 && this.townHall != null && this.townHall.mapInfo != null) {
            this.drawVillageMap(i, j);
        } else if (this.mapType == 2 && this.pageNum == 0) {
            this.drawChunkMap(i, j);
        }
    }

    private void drawPixel(int x, int y, int colour) {
        this.func_73733_a(x, y, x + 1, y + 1, colour, colour);
    }

    @Override
    public int getLineSizeInPx() {
        return 195;
    }

    @Override
    public int getPageSize() {
        return 19;
    }

    @Override
    public ResourceLocation getPNGPath() {
        if (this.isParchment) {
            return this.backgroundParchment;
        }
        return this.backgroundPanel;
    }

    @Override
    public int getXSize() {
        return 204;
    }

    @Override
    public int getYSize() {
        return 220;
    }

    @Override
    public void initData() {
        if (this.fullText != null) {
            this.descText = this.convertAdjustText(this.fullText);
        }
        if (this.fullTextLines != null) {
            this.descText = this.adjustText(this.fullTextLines);
        }
        if (this.mapType == 1 && this.townHall != null) {
            ClientSender.requestMapInfo(this.townHall);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
    }

    private void drawVillageMap(int i, int j) {
        int xStart = (this.field_146294_l - this.getXSize()) / 2;
        int yStart = (this.field_146295_m - this.getYSize()) / 2;
        MillWorldInfo.MillMapInfo minfo = this.townHall.mapInfo;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int startX = (this.getXSize() - minfo.length) / 2;
        int startY = (this.getYSize() - minfo.width) / 2;
        this.func_73733_a(startX - 2, startY - 2, startX + minfo.length + 2, startY + minfo.width + 2, 0x20000000, 0x20000000);
        BuildingLocation locHover = null;
        MillVillager villagerHover = null;
        byte thRegionId = -1;
        if (this.townHall.pathing != null) {
            thRegionId = this.townHall.pathing.thRegion;
        }
        for (int x = 0; x < minfo.length; ++x) {
            for (int y = 0; y < minfo.width; ++y) {
                Building b;
                int colour = 0;
                BuildingLocation bl = this.townHall.getLocationAtCoord(new Point(x + minfo.mapStartX, 0.0, y + minfo.mapStartZ));
                byte groundType = minfo.data[x][y];
                colour = bl != null ? (bl == this.townHall.buildingLocationIP ? 0x40FF00FF : (bl.level < 0 ? 0x40000060 : ((b = bl.getBuilding(this.townHall.worldObj)) == null || thRegionId == -1 || b.isReachableFromRegion(thRegionId) ? 0x400000FF : 0x40FF0000))) : (groundType == 1 ? -1439682305 : (groundType == 2 ? 0x40FF0000 : (groundType == 3 ? 0x40FFFF00 : (groundType == 4 ? 1090486336 : (groundType == 5 ? 0x1000FF00 : (groundType == 10 ? 0x2000FF00 : (groundType == 6 ? 1090474064 : (groundType == 7 ? Integer.MIN_VALUE : (groundType == 8 ? 1083834265 : 0x4000FF00)))))))));
                this.drawPixel(startX + x, startY + y, colour);
                if (xStart + startX + x != i || yStart + startY + y != j || bl == null) continue;
                locHover = bl;
            }
        }
        for (MillVillager villager : this.townHall.villagers) {
            int mapPosX = (int)(villager.field_70165_t - (double)minfo.mapStartX);
            int mapPosZ = (int)(villager.field_70161_v - (double)minfo.mapStartZ);
            if (mapPosX <= 0 || mapPosZ <= 0 || mapPosX >= minfo.length || mapPosZ >= minfo.width) continue;
            if (villager.func_70631_g_()) {
                this.func_73733_a(startX + mapPosX - 1, startY + mapPosZ - 1, startX + mapPosX + 1, startY + mapPosZ + 1, -1593835776, -1593835776);
            } else if (villager.getRecord() != null && villager.getRecord().raidingVillage) {
                this.func_73733_a(startX + mapPosX - 1, startY + mapPosZ - 1, startX + mapPosX + 1, startY + mapPosZ + 1, -1610612736, -1610612736);
            } else if (villager.gender == 1) {
                this.func_73733_a(startX + mapPosX - 1, startY + mapPosZ - 1, startX + mapPosX + 1, startY + mapPosZ + 1, -1610547201, -1610547201);
            } else {
                this.func_73733_a(startX + mapPosX - 1, startY + mapPosZ - 1, startX + mapPosX + 1, startY + mapPosZ + 1, -1593901056, -1593901056);
            }
            int screenPosX = xStart + startX + mapPosX;
            int screenPosY = yStart + startY + mapPosZ;
            if (screenPosX <= i - 2 || screenPosX >= i + 2 || screenPosY <= j - 2 || screenPosY >= j + 2) continue;
            villagerHover = villager;
        }
        if (villagerHover != null) {
            boolean gameString;
            int stringlength = this.field_146289_q.func_78256_a(villagerHover.getName());
            stringlength = Math.max(stringlength, this.field_146289_q.func_78256_a(villagerHover.getNativeOccupationName()));
            boolean bl = gameString = villagerHover.getGameOccupationName(this.player.getDisplayName()) != null && villagerHover.getGameOccupationName(this.player.getDisplayName()).length() > 0;
            if (gameString) {
                stringlength = Math.max(stringlength, this.field_146289_q.func_78256_a(villagerHover.getGameOccupationName(this.player.getDisplayName())));
                this.func_73733_a(i + 10 - 3 - xStart, j + 10 - 3 - yStart, i + 10 + stringlength + 3 - xStart, j + 10 + 33 - yStart, -1073741824, -1073741824);
                this.field_146289_q.func_78276_b(villagerHover.getName(), i + 10 - xStart, j + 10 - yStart, 0x909090);
                this.field_146289_q.func_78276_b(villagerHover.getNativeOccupationName(), i + 10 - xStart, j + 10 - yStart + 11, 0x909090);
                this.field_146289_q.func_78276_b(villagerHover.getGameOccupationName(this.player.getDisplayName()), i + 10 - xStart, j + 10 - yStart + 22, 0x909090);
            } else {
                this.func_73733_a(i + 10 - 3 - xStart, j + 10 - 3 - yStart, i + 10 + stringlength + 3 - xStart, j + 10 + 22 - yStart, -1073741824, -1073741824);
                this.field_146289_q.func_78276_b(villagerHover.getName(), i + 10 - xStart, j + 10 - yStart, 0x909090);
                this.field_146289_q.func_78276_b(villagerHover.getNativeOccupationName(), i + 10 - xStart, j + 10 - yStart + 11, 0x909090);
            }
        } else if (locHover != null) {
            boolean gameString;
            String nativeString;
            int stringlength;
            boolean unreachable;
            Building b = locHover.getBuilding(this.townHall.worldObj);
            boolean bl = unreachable = b != null && this.townHall.pathing != null && !b.isReachableFromRegion(this.townHall.pathing.thRegion);
            if (unreachable) {
                stringlength = this.field_146289_q.func_78256_a(locHover.getPlan().nativeName + " - " + MLN.string("panels.unreachablebuilding"));
                nativeString = locHover.getPlan().nativeName + " - " + MLN.string("panels.unreachablebuilding");
            } else {
                stringlength = this.field_146289_q.func_78256_a(locHover.getPlan().nativeName);
                nativeString = locHover.getPlan().nativeName;
            }
            int nblines = 1;
            boolean bl2 = gameString = locHover.getPlan().getGameName() != null && locHover.getPlan().getGameName().length() > 0;
            if (gameString) {
                stringlength = Math.max(stringlength, this.field_146289_q.func_78256_a(locHover.getPlan().getGameName()));
                ++nblines;
            }
            Vector<String> effects = locHover.getBuildingEffects(this.townHall.worldObj);
            nblines += effects.size();
            for (String s : effects) {
                stringlength = Math.max(stringlength, this.field_146289_q.func_78256_a(s));
            }
            this.func_73733_a(i - 3 - xStart, j - 3 - yStart, i + stringlength + 3 - xStart, j + 11 * nblines - yStart, -1073741824, -1073741824);
            this.field_146289_q.func_78276_b(nativeString, i - xStart, j - yStart, 0x909090);
            int pos = 1;
            if (gameString) {
                this.field_146289_q.func_78276_b(locHover.getPlan().getGameName(), i - xStart, j - yStart + 11, 0x909090);
                ++pos;
            }
            for (String s : effects) {
                this.field_146289_q.func_78276_b(s, i - xStart, j - yStart + 11 * pos, 0x909090);
                ++pos;
            }
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    private void drawChunkMap(int i, int j) {
        if (Mill.serverWorlds.isEmpty()) {
            return;
        }
        int windowXstart = (this.field_146294_l - this.getXSize()) / 2;
        int windowYstart = (this.field_146295_m - this.getYSize()) / 2;
        World world = Mill.serverWorlds.firstElement().world;
        MillWorld mw = Mill.serverWorlds.firstElement();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int startX = (this.getXSize() - 160) / 2;
        int startY = (this.getYSize() - 160) / 2;
        int posXstart = this.player.field_70176_ah * 16 - 640;
        int posZstart = this.player.field_70164_aj * 16 - 640;
        int mouseX = (i - startX - windowXstart) / 2 * 16 + posXstart;
        int mouseZ = (j - startY - windowYstart) / 2 * 16 + posZstart;
        this.func_73733_a(startX - 2, startY - 2, startX + 160 + 2, startY + 160 + 2, 0x20000000, 0x20000000);
        Vector<String> labels = new Vector<String>();
        for (int x = posXstart; x < posXstart + 1280; x += 16) {
            for (int z = posZstart; z < posZstart + 1280; z += 16) {
                int colour = 0;
                if (!world.func_72863_F().func_73149_a(x / 16, z / 16)) {
                    colour = 0x40111111;
                    continue;
                }
                Chunk chunk = world.func_72863_F().func_73154_d(x / 16, z / 16);
                colour = chunk.field_76636_d ? -1073676544 : -1057030144;
                this.drawPixel(startX + (x - posXstart) / 8, startY + (z - posZstart) / 8, colour);
                if (mouseX != x || mouseZ != z) continue;
                labels.add(MLN.string("chunk.chunkcoords", "" + x / 16 + "/" + z / 16));
            }
        }
        Vector<Building> buildings = new Vector<Building>(mw.allBuildings());
        for (Building b : buildings) {
            if (!b.isTownhall || b.winfo == null || b.villageType == null) continue;
            for (int x = b.winfo.mapStartX; x < b.winfo.mapStartX + b.winfo.length; x += 16) {
                for (int z = b.winfo.mapStartZ; z < b.winfo.mapStartZ + b.winfo.width; z += 16) {
                    if (x < posXstart || x > posXstart + 1280 || z < posZstart || z > posZstart + 1280) continue;
                    int colour = b.villageType.lonebuilding ? -258408295 : -268435201;
                    this.drawPixel(startX + (x - posXstart) / 8 + 1, startY + (z - posZstart) / 8 + 1, colour);
                    if (mouseX != x || mouseZ != z) continue;
                    labels.add(MLN.string("chunk.village", b.getVillageQualifiedName()));
                }
            }
        }
        boolean labelForced = false;
        for (ChunkCoordIntPair cc : ForgeChunkManager.getPersistentChunksFor((World)world).keys()) {
            if (cc.field_77276_a * 16 < posXstart || cc.field_77276_a * 16 > posXstart + 1280 || cc.field_77275_b * 16 < posZstart || cc.field_77275_b * 16 > posZstart + 1280) continue;
            this.drawPixel(startX + (cc.field_77276_a * 16 - posXstart) / 8, startY + (cc.field_77275_b * 16 - posZstart) / 8 + 1, -251658241);
            if (mouseX != cc.field_77276_a * 16 || mouseZ != cc.field_77275_b * 16 || labelForced) continue;
            labels.add(MLN.string("chunk.chunkforced"));
            labelForced = true;
        }
        if (!labels.isEmpty()) {
            int stringlength = 0;
            for (String s : labels) {
                int w = this.field_146289_q.func_78256_a(s);
                if (w <= stringlength) continue;
                stringlength = w;
            }
            this.func_73733_a(i - 3 - windowXstart + 10, j - 3 - windowYstart, i + stringlength + 3 - windowXstart + 10, j + 11 * labels.size() - windowYstart, -1073741824, -1073741824);
            for (int si = 0; si < labels.size(); ++si) {
                this.field_146289_q.func_78276_b((String)labels.get(si), i - windowXstart + 10, j - windowYstart + 11 * si, 0x909090);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }
}

