/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.Vector;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.millenaire.common.Building;
import org.millenaire.common.MillVillager;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalFish
extends Goal {
    private static ItemStack[] fishingRod = new ItemStack[]{new ItemStack((Item)Items.field_151112_aM, 1)};

    public GoalFish() {
        this.buildingLimit.put(new MillVillager.InvItem(Items.field_151115_aP, 0), 512);
        this.buildingLimit.put(new MillVillager.InvItem(Items.field_151101_aQ, 0), 512);
    }

    @Override
    public int actionDuration(MillVillager villager) {
        return 25000;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Vector<Building> vb = villager.getTownHall().getBuildingsWithTag("fishingspot");
        Building closest = null;
        for (Building b : vb) {
            if (closest != null && !(villager.getPos().horizontalDistanceToSquared(b.getSleepingPos()) < villager.getPos().horizontalDistanceToSquared(closest.getSleepingPos()))) continue;
            closest = b;
        }
        if (closest == null || closest.fishingspots.size() == 0) {
            return null;
        }
        return this.packDest(closest.fishingspots.get(MillCommonUtilities.randomInt(closest.fishingspots.size())), closest);
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        return fishingRod;
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        for (Building b : villager.getTownHall().getBuildings()) {
            if (b.fishingspots.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        villager.addToInv(Items.field_151115_aP, 1);
        villager.func_71038_i();
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        if (villager.getGoalBuildingDest() == null) {
            return 20;
        }
        return 100 - villager.getGoalBuildingDest().countGoods(Items.field_151115_aP);
    }

    @Override
    public boolean stuckAction(MillVillager villager) throws Exception {
        return this.performAction(villager);
    }
}

