/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.lang.reflect.Method;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smart.moving.ClimbGap;
import net.smart.moving.FeetClimbing;
import net.smart.moving.HandsClimbing;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

public class Orientation
extends SmartMovingContext {
    public static final Orientation ZZ = new Orientation(0, 0);
    public static final Orientation PZ = new Orientation(1, 0);
    public static final Orientation ZP = new Orientation(0, 1);
    public static final Orientation NZ = new Orientation(-1, 0);
    public static final Orientation ZN = new Orientation(0, -1);
    public static final Orientation PP = new Orientation(1, 1);
    public static final Orientation NN = new Orientation(-1, -1);
    public static final Orientation PN = new Orientation(1, -1);
    public static final Orientation NP = new Orientation(-1, 1);
    public static final int DefaultMeta = -1;
    public static final int VineFrontMeta = 0;
    public static final int VineSideMeta = 1;
    private static final int top = 2;
    private static final int middle = 1;
    private static final int base = 0;
    private static final int sub = -1;
    private static final int subSub = -2;
    private static final int NoGrab = 0;
    private static final int HalfGrab = 1;
    private static final int AroundGrab = 2;
    public static final HashSet<Orientation> Orthogonals = new HashSet();
    protected int _i;
    protected int _k;
    private boolean _isDiagonal;
    private float _directionAngle;
    private float _mimimumClimbingAngle;
    private float _maximumClimbingAngle;
    private static HashSet<Orientation> _getClimbingOrientationsHashSet;
    private static final float _handClimbingHoldGap;
    private static ClimbGap _climbGapTemp;
    private static ClimbGap _climbGapOuterTemp;
    private static World world;
    private static double base_jhd;
    private static double jh_offset;
    private static int all_j;
    private static int all_offset;
    private static int base_i;
    private static int base_k;
    private static double base_id;
    private static double base_kd;
    private static int remote_i;
    private static int remote_k;
    private static boolean crawl;
    private static int local_halfOffset;
    private static int local_half;
    private static int local_offset;
    private static boolean grabRemote;
    private static int grabType;
    private static Block grabBlock;
    private static int grabMeta;
    private static final Method _canConnectFenceTo;
    private static final Block[] _knownFanceGateBlocks;
    private static final Block[] _knownFenceBlocks;
    private static final Block[] _knownWallBlocks;
    private static final Block[] _knownHalfBlocks;
    private static final Block[] _knownCompactStairBlocks;
    private static final Block[] _knownTrapDoorBlocks;
    private static final Block[] _knownThinWallBlocks;
    private static final Class<?>[] _ladderKitLadderTypes;
    private static final Class<?> _blockCarpentersLadder;
    private static final Method _carpentersBlockPropertiesGetData;

    private Orientation(int i, int k) {
        this._i = i;
        this._k = k;
        this._isDiagonal = this._i != 0 && this._k != 0;
        this.setClimbingAngles();
    }

    public Orientation rotate(int angle) {
        if (this == ZZ) {
            throw new RuntimeException("unrotatable orientation");
        }
        switch (angle) {
            case 0: {
                return this;
            }
            case 45: {
                if (this == PZ) {
                    return PP;
                }
                if (this == PP) {
                    return ZP;
                }
                if (this == ZP) {
                    return NP;
                }
                if (this == NP) {
                    return NZ;
                }
                if (this == NZ) {
                    return NN;
                }
                if (this == NN) {
                    return ZN;
                }
                if (this == ZN) {
                    return PN;
                }
                if (this == PN) {
                    return PZ;
                }
                throw new RuntimeException("unknown orientation \"" + (Object)((Object)this) + "\"");
            }
            case -45: {
                if (this == PZ) {
                    return PN;
                }
                if (this == PN) {
                    return ZN;
                }
                if (this == ZN) {
                    return NN;
                }
                if (this == NN) {
                    return NZ;
                }
                if (this == NZ) {
                    return NP;
                }
                if (this == NP) {
                    return ZP;
                }
                if (this == ZP) {
                    return PP;
                }
                if (this == PP) {
                    return PZ;
                }
                throw new RuntimeException("unknown orientation \"" + (Object)((Object)this) + "\"");
            }
            case 90: {
                return this.rotate(45).rotate(45);
            }
            case -90: {
                return this.rotate(-45).rotate(-45);
            }
            case 135: {
                return this.rotate(180).rotate(-45);
            }
            case -135: {
                return this.rotate(-180).rotate(45);
            }
            case -180: 
            case 180: {
                if (this == PZ) {
                    return NZ;
                }
                if (this == PN) {
                    return NP;
                }
                if (this == ZN) {
                    return ZP;
                }
                if (this == NN) {
                    return PP;
                }
                if (this == NZ) {
                    return PZ;
                }
                if (this == NP) {
                    return PN;
                }
                if (this == ZP) {
                    return ZN;
                }
                if (this == PP) {
                    return NN;
                }
                throw new RuntimeException("unknown orientation");
            }
        }
        throw new RuntimeException("angle \"" + angle + "\" not supported");
    }

    public static Orientation getOrientation(EntityPlayer p, float tolerance, boolean orthogonals, boolean diagonals) {
        float maximumRotation;
        float minimumRotation;
        float rotation = p.rotationYaw % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if ((minimumRotation = rotation - tolerance) < 0.0f) {
            minimumRotation += 360.0f;
        }
        if ((maximumRotation = rotation + tolerance) >= 360.0f) {
            maximumRotation -= 360.0f;
        }
        if (orthogonals) {
            if (NZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return NZ;
            }
            if (PZ.isWithinAngle(minimumRotation, maximumRotation)) {
                return PZ;
            }
            if (ZN.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZN;
            }
            if (ZP.isWithinAngle(minimumRotation, maximumRotation)) {
                return ZP;
            }
        }
        if (diagonals) {
            if (NP.isWithinAngle(minimumRotation, maximumRotation)) {
                return NP;
            }
            if (PN.isWithinAngle(minimumRotation, maximumRotation)) {
                return PN;
            }
            if (NN.isWithinAngle(minimumRotation, maximumRotation)) {
                return NN;
            }
            if (PP.isWithinAngle(minimumRotation, maximumRotation)) {
                return PP;
            }
        }
        return null;
    }

    public double getHorizontalBorderGap(Entity entity) {
        return this.getHorizontalBorderGap(entity.posX, entity.posZ);
    }

    private double getHorizontalBorderGap() {
        return this.getHorizontalBorderGap(base_id, base_kd);
    }

    private double getHorizontalBorderGap(double i, double k) {
        if (this == NZ) {
            return i % 1.0;
        }
        if (this == PZ) {
            return 1.0 - i % 1.0;
        }
        if (this == ZN) {
            return k % 1.0;
        }
        if (this == ZP) {
            return 1.0 - k % 1.0;
        }
        return 0.0;
    }

    public boolean isTunnelAhead(World world, int i, int j, int k) {
        Material aboveMaterial;
        Block remoteId = world.getBlock(i + this._i, j + 1, k + this._k);
        return Orientation.isFullEmpty(remoteId) && (aboveMaterial = world.getBlock(i + this._i, j + 2, k + this._k).getMaterial()) != null && Orientation.isSolid(aboveMaterial);
    }

    public static HashSet<Orientation> getClimbingOrientations(EntityPlayer p, boolean orthogonals, boolean diagonals) {
        float rotation = p.rotationYaw % 360.0f;
        if (rotation < 0.0f) {
            rotation += 360.0f;
        }
        if (_getClimbingOrientationsHashSet == null) {
            _getClimbingOrientationsHashSet = new HashSet();
        } else {
            _getClimbingOrientationsHashSet.clear();
        }
        if (orthogonals) {
            NZ.addTo(rotation);
            PZ.addTo(rotation);
            ZN.addTo(rotation);
            ZP.addTo(rotation);
        }
        if (diagonals) {
            NP.addTo(rotation);
            PN.addTo(rotation);
            NN.addTo(rotation);
            PP.addTo(rotation);
        }
        return _getClimbingOrientationsHashSet;
    }

    private void addTo(float rotation) {
        if (this.isRotationForClimbing(rotation)) {
            _getClimbingOrientationsHashSet.add(this);
        }
    }

    public boolean isFeetLadderSubstitute(World world, int bi, int j, int bk) {
        int i = bi + this._i;
        int k = bk + this._k;
        return this.isLadderSubstitute(world, i, j, k, 1) > 0 || this.isLadderSubstitute(world, i, j, k, 0) > 0;
    }

    public boolean isHandsLadderSubstitute(World world, int bi, int j, int bk) {
        int i = bi + this._i;
        int k = bk + this._k;
        return this.isLadderSubstitute(world, i, j, k, 1) > 0 || this.isLadderSubstitute(world, i, j, k, 0) > 0 || this.isLadderSubstitute(world, i, j, k, -1) > 0;
    }

    private int isLadderSubstitute(World worldObj, int i, int j, int k, int halfOffset) {
        world = worldObj;
        remote_i = i;
        all_j = j;
        remote_k = k;
        all_offset = 0;
        return this.isLadderSubstitute(halfOffset, null);
    }

    public void seekClimbGap(float rotation, World world, int i, double id, double jhd, int k, double kd, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, HandsClimbing[] inout_handsClimbing, FeetClimbing[] inout_feetClimbing, ClimbGap out_handsClimbGap, ClimbGap out_feetClimbGap) {
        if (this.isRotationForClimbing(rotation)) {
            this.initialize(world, i, id, jhd, k, kd);
            inout_handsClimbing[0] = inout_handsClimbing[0].max(this.handsClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_handsClimbGap, _climbGapOuterTemp);
            inout_feetClimbing[0] = inout_feetClimbing[0].max(this.feetClimbing(isClimbCrawling, isCrawlClimbing, isCrawling, _climbGapOuterTemp), out_feetClimbGap, _climbGapOuterTemp);
        }
    }

    private HandsClimbing handsClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(3.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        HandsClimbing result = HandsClimbing.None;
        int gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0) {
            result = jh_offset > 1.0 - (double)_handClimbingHoldGap ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.None, out_climbGap, _climbGapTemp);
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = jh_offset < (double)_handClimbingHoldGap ? result.max(HandsClimbing.BottomHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(-1, _climbGapTemp);
        if (!(gap <= 0 || isCrawling && gap > 1)) {
            result = !isClimbCrawling && gap > 2 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (isClimbCrawling && gap > 1 ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : (jh_offset < (double)_handClimbingHoldGap ? (grabType == 2 ? result.max(HandsClimbing.Up, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp)) : (grabType == 2 ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp))));
        }
        if ((gap = this.isLadderSubstitute(-2, _climbGapTemp)) > 0 && !isCrawling && (gap > 2 && !isCrawlClimbing || grabType == 2 || gap > 1 && isClimbCrawling)) {
            result = jh_offset < (double)_handClimbingHoldGap && !isClimbCrawling ? result.max(HandsClimbing.TopHold, out_climbGap, _climbGapTemp) : (isClimbCrawling ? result.max(HandsClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(HandsClimbing.Sink, out_climbGap, _climbGapTemp));
        }
        return result;
    }

    private FeetClimbing feetClimbing(boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling, ClimbGap out_climbGap) {
        out_climbGap.reset();
        _climbGapTemp.reset();
        Orientation.initializeOffset(0.0, isClimbCrawling, isCrawlClimbing, isCrawling);
        FeetClimbing result = FeetClimbing.None;
        int gap = this.isLadderSubstitute(2, _climbGapTemp);
        if (gap > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        Orientation._climbGapTemp.SkipGaps = isClimbCrawling || isCrawlClimbing;
        gap = this.isLadderSubstitute(1, _climbGapTemp);
        if (gap > 0 && !isCrawling) {
            result = gap > 3 && !isClimbCrawling ? (!isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : ((isClimbCrawling || isCrawlClimbing) && gap > 1 ? (isCrawlClimbing ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp)) : (gap > 2 ? (!isClimbCrawling ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.TopWithHands, out_climbGap, _climbGapTemp)));
        }
        if ((gap = this.isLadderSubstitute(0, _climbGapTemp)) > 0) {
            result = gap > 3 && !isCrawling && !isCrawlClimbing ? result.max(FeetClimbing.FastUp, out_climbGap, _climbGapTemp) : (gap > 2 && !isCrawling ? (!isClimbCrawling ? (jh_offset < (double)_handClimbingHoldGap ? result.max(FeetClimbing.SlowUpWithHoldWithoutHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.SlowUpWithSinkWithoutHands, out_climbGap, _climbGapTemp)) : result.max(FeetClimbing.None, out_climbGap, _climbGapTemp)) : (jh_offset < 1.0 - (double)_handClimbingHoldGap ? result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp) : result.max(FeetClimbing.BaseHold, out_climbGap, _climbGapTemp)));
        }
        if (this.isLadderSubstitute(-1, _climbGapTemp) > 0) {
            result = result.max(FeetClimbing.None, out_climbGap, _climbGapTemp);
        }
        if (isCrawlClimbing || isCrawling) {
            result = result.max(FeetClimbing.BaseWithHands, out_climbGap, _climbGapTemp);
        }
        return result;
    }

    private int isLadderSubstitute(int local_Offset, ClimbGap out_climbGap) {
        int gap;
        Orientation.initializeLocal(local_Offset);
        if (local_half == 1) {
            if (this.hasHalfHold()) {
                if (!grabRemote) {
                    boolean overOverFullAccessible;
                    boolean overLadder = this.isOnLadderOrVine(0) || this.isOnOpenTrapDoor(0) || this.isRope(0) || this.isOnWallRope(0);
                    boolean overOverLadder = this.isOnLadderOrVine(1) || this.isOnOpenTrapDoor(1) || this.isRope(1) || this.isOnWallRope(1);
                    boolean overAccessible = this.isBaseAccessible(1, false, true);
                    boolean overOverAccessible = this.isBaseAccessible(2, false, true);
                    boolean overFullAccessible = overAccessible && this.isFullAccessible(1, grabRemote);
                    boolean bl = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(2, grabRemote);
                    gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverFullAccessible ? 5 : (crawl ? 3 : 5)) : (overOverLadder ? 5 : 1)) : 1);
                } else {
                    gap = this.isBaseAccessible(0) ? (this.isUpperHalfFrontEmpty(remote_i, 0, remote_k) ? (this.isFullAccessible(1, grabRemote) ? (this.isFullExtentAccessible(2, grabRemote) ? 5 : (this.isJustLowerHalfExtentAccessible(2) ? 4 : 3)) : 1) : 1) : 0;
                }
            } else {
                gap = 0;
            }
        } else if (this.hasBottomHold()) {
            if (!grabRemote) {
                boolean overOverFullAccessible;
                boolean overLadder = this.isOnLadderOrVine(0) || this.isOnOpenTrapDoor(0) || this.isRope(0) || this.isOnWallRope(0);
                boolean overOverLadder = this.isOnLadderOrVine(1) || this.isOnOpenTrapDoor(1) || this.isRope(1) || this.isOnWallRope(0);
                boolean overAccessible = this.isBaseAccessible(0, false, true);
                boolean overOverAccessible = this.isBaseAccessible(1, false, true);
                boolean overFullAccessible = overAccessible && this.isFullAccessible(0, grabRemote);
                boolean bl = overOverFullAccessible = overAccessible && this.isFullExtentAccessible(1, grabRemote);
                gap = overLadder ? (overOverLadder ? 1 : (overOverAccessible ? 1 : 1)) : (overAccessible ? (overFullAccessible ? (overOverAccessible ? (overOverFullAccessible ? 4 : (crawl ? 2 : 4)) : 2) : (overOverLadder ? 2 : 1)) : 1);
            } else {
                gap = this.isBaseAccessible(0) ? (this.isFullAccessible(0, grabRemote) ? (this.isFullExtentAccessible(1, grabRemote) ? 4 : 2) : 1) : 0;
            }
        } else {
            gap = 0;
        }
        if (out_climbGap != null && gap > 0) {
            out_climbGap.Block = grabBlock;
            out_climbGap.Meta = grabMeta;
            out_climbGap.CanStand = gap > 3;
            out_climbGap.MustCrawl = gap > 1 && gap < 4;
            out_climbGap.Direction = this;
        }
        return gap;
    }

    private boolean hasHalfHold() {
        int remoteMetadata;
        if (Config.isFreeBaseClimb()) {
            if (this.isOnLadder(0) && this.isOnLadderFront(0)) {
                return this.setHalfGrabType(2, Orientation.getBaseBlockId(0), false);
            }
            if (this.remoteLadderClimbing(0)) {
                return this.setHalfGrabType(2, Orientation.getRemoteBlockId(0), true);
            }
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            Block id = this.getRopeId(0);
            if (id != null && this.isHeadedToRope()) {
                return this.setHalfGrabType(2, id, false);
            }
            id = this.getAnchorId(0);
            if (id != null && this.isOnAnchorFront(0)) {
                return this.setHalfGrabType(1, id, false);
            }
        }
        Block remoteId = Orientation.getRemoteBlockId(0);
        if (this.isEmpty(base_i, 0, base_k) && remoteId == Block.getBlockFromName((String)"iron_bars") && this.headedToFrontWall(remote_i, 0, remote_k, remoteId)) {
            return this.setHalfGrabType(1, remoteId);
        }
        Block wallId = Orientation.getWallBlockId(base_i, 0, base_k);
        if (wallId == Block.getBlockFromName((String)"iron_bars") && this.headedToBaseWall(0, wallId)) {
            return this.setHalfGrabType(1, wallId, false);
        }
        if (wallId != null && this.isOnMiddleLadderFront(0)) {
            return this.setHalfGrabType(2, remoteId, false);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            Block remoteBelowId;
            if (Orientation.isFence(remoteId, remote_i, 0, remote_k) && this.headedToFrontWall(remote_i, 0, remote_k, remoteId)) {
                if (!Orientation.isFence(Orientation.getBaseBlockId(0), base_i, 0, base_k)) {
                    return this.setHalfGrabType(1, remoteId);
                }
                if (this.headedToFrontSideWall(remote_i, 0, remote_k, remoteId)) {
                    return this.setHalfGrabType(1, remoteId);
                }
            }
            if (Orientation.isFence(remoteBelowId = Orientation.getRemoteBlockId(-1), remote_i, -1, remote_k) && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowId)) {
                if (!Orientation.isFence(Orientation.getBaseBlockId(-1), remote_i, -1, remote_k)) {
                    return this.setHalfGrabType(1, remoteId);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, remoteBelowId)) {
                    return this.setHalfGrabType(1, remoteId);
                }
            }
            if (Orientation.isFence(wallId, base_i, 0, base_k) && this.headedToBaseWall(0, wallId)) {
                return this.setHalfGrabType(1, wallId, false);
            }
            Block belowWallId = Orientation.getWallBlockId(base_i, -1, base_k);
            if (Orientation.isFence(belowWallId, base_i, -1, base_k) && this.headedToBaseWall(-1, belowWallId)) {
                return this.setHalfGrabType(1, belowWallId, false);
            }
            if (remoteId == Block.getBlockFromName((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteId, 0)) {
                return this.setHalfGrabType(1, remoteId);
            }
            if (remoteBelowId == Block.getBlockFromName((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteBelowId, -1)) {
                return this.setHalfGrabType(1, remoteBelowId);
            }
        }
        if (Orientation.isBottomHalfBlock(remoteId, remoteMetadata = Orientation.getRemoteBlockMetadata(0)) || Orientation.isStairCompact(remoteId) && this.isBottomStairCompactNotBack(remoteMetadata) && (!Orientation.isStairCompact(Orientation.getBaseBlockId(-1)) || !this.isBottomStairCompactFront(Orientation.getBaseBlockMetadata(-1)))) {
            return this.setHalfGrabType(1, remoteId);
        }
        if (Orientation.isTrapDoor(remoteId) && Orientation.isClosedTrapDoor(Orientation.getRemoteBlockMetadata(0))) {
            return this.setHalfGrabType(1, remoteId);
        }
        Block baseId = Orientation.getBaseBlockId(0);
        if (Orientation.isTrapDoor(baseId) && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(0))) {
            return this.setHalfGrabType(1, baseId, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setHalfGrabType(1, baseId, false);
            }
            if (Orientation.isASRope(remoteId) && this.rotate(180).isASGrapplingHookFront(remoteMetadata)) {
                return this.setHalfGrabType(1, remoteId, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta > -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
        }
        return this.setHalfGrabType(0, null);
    }

    private boolean hasBottomHold() {
        int remoteMetadata;
        Block belowWallBlockId;
        if (Config.isFreeBaseClimb()) {
            if (this.isOnLadder(-1) && this.isOnLadderFront(-1)) {
                return this.setBottomGrabType(2, Orientation.getBaseBlockId(-1), false);
            }
            if (this.isOnLadder(0) && this.isOnLadderFront(0)) {
                return this.setBottomGrabType(2, Orientation.getBaseBlockId(0), false);
            }
            if (this.remoteLadderClimbing(-1)) {
                return this.setBottomGrabType(2, Orientation.getRemoteBlockId(-1), true);
            }
            if (this.remoteLadderClimbing(0)) {
                return this.setBottomGrabType(2, Orientation.getRemoteBlockId(0), true);
            }
        }
        if (SmartMovingOptions.hasBetterThanWolves || SmartMovingOptions.hasRopesPlus) {
            Block id = this.getRopeId(-1);
            if (id != null && this.isHeadedToRope() || (id = this.getRopeId(0)) != null && this.isHeadedToRope()) {
                return this.setBottomGrabType(2, id, false);
            }
            id = this.getAnchorId(-1);
            if (id != null && this.isOnAnchorFront(-1) || (id = this.getAnchorId(0)) != null && this.isOnAnchorFront(0)) {
                return this.setBottomGrabType(1, id, false);
            }
        }
        Block remoteId = Orientation.getRemoteBlockId(0);
        Block remoteBelowId = Orientation.getRemoteBlockId(-1);
        boolean remoteLowerHalfEmpty = this.isLowerHalfFrontFullEmpty(remote_i, 0, remote_k);
        if (SmartMovingOptions.hasRedPowerWire) {
            int coverSides;
            int coverSides2;
            if (Orientation.isRedPowerWire(remoteBelowId) && (this.isRedPowerWireFullFront(coverSides2 = Orientation.getRpCoverSides(remote_i, -1, remote_k)) || Orientation.isRedPowerWireTop(coverSides2)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            if (Orientation.isRedPowerWire(remoteId) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, 0, remote_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            Block baseId = Orientation.getBaseBlockId(-1);
            if (Orientation.isRedPowerWire(baseId) && this.isRedPowerWireFullBack(coverSides = Orientation.getRpCoverSides(base_i, -1, base_k)) && remoteLowerHalfEmpty) {
                return this.setBottomGrabType(1, remoteBelowId);
            }
            if (Orientation.isRedPowerWire(remoteBelowId)) {
                return false;
            }
        }
        if (this.isEmpty(base_i, -1, base_k) && remoteBelowId == Block.getBlockFromName((String)"iron_bars") && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowId)) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue()) {
            Block baseBelowBlockId = Orientation.getBaseBlockId(-1);
            if (Orientation.isFence(remoteBelowId, remote_i, -1, remote_k) && this.headedToFrontWall(remote_i, -1, remote_k, remoteBelowId)) {
                if (!Orientation.isFence(baseBelowBlockId, base_i, -1, base_k)) {
                    return this.setBottomGrabType(1, remoteBelowId);
                }
                if (this.headedToFrontSideWall(remote_i, -1, remote_k, remoteBelowId)) {
                    return this.setBottomGrabType(1, remoteBelowId);
                }
            }
            if (remoteBelowId == Block.getBlockFromName((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteBelowId, -1)) {
                return this.setHalfGrabType(1, remoteBelowId);
            }
            if (remoteId == Block.getBlockFromName((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(remoteId, 0)) {
                return this.setHalfGrabType(1, remoteId);
            }
        }
        if ((belowWallBlockId = Orientation.getWallBlockId(base_i, -1, base_k)) != null) {
            if (this.isEmpty(base_i - this._i, 0, base_k - this._k) && this.isEmpty(base_i - this._i, -1, base_k - this._k)) {
                if (belowWallBlockId == Block.getBlockFromName((String)"iron_bars") && this.headedToBaseWall(-1, belowWallBlockId)) {
                    return this.setBottomGrabType(1, belowWallBlockId, false);
                }
                if (belowWallBlockId != null && this.isOnMiddleLadderFront(-1)) {
                    return this.setHalfGrabType(2, remoteId, false);
                }
                if (this.headedToBaseGrabWall(-1, belowWallBlockId)) {
                    return this.setBottomGrabType(1, belowWallBlockId, false);
                }
            }
            if (((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && Orientation.isFence(belowWallBlockId, base_i, -1, base_k) && this.headedToBaseWall(-1, belowWallBlockId)) {
                return this.setBottomGrabType(1, belowWallBlockId, false);
            }
            return false;
        }
        int remoteBelowMetadata = Orientation.getRemoteBlockMetadata(-1);
        if (!(!remoteLowerHalfEmpty || !this.isBaseAccessible(-1, true, false) || !this.isUpperHalfFrontAnySolid(remote_i, -1, remote_k) || Orientation.isBottomHalfBlock(remoteBelowId, remoteBelowMetadata) || Orientation.isStairCompact(remoteBelowId) && this.isBottomStairCompactFront(remoteBelowMetadata) || Orientation.isDoor(remoteBelowId) && !Orientation.isDoorTop(remoteBelowMetadata) || Orientation.isDoor(Orientation.getBaseBlockId(0)) && this.isDoorFrontBlocked(base_i, 0, base_k) || !((Boolean)Orientation.Config._freeFenceClimbing.value).booleanValue() && this.isFence(remote_i, -1, remote_k))) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        if (Orientation.isStairCompact(remoteId) && Orientation.isTopStairCompact(remoteMetadata = Orientation.getRemoteBlockMetadata(0)) && !this.isTopStairCompactBack(remoteMetadata) && this.isUpperHalfFrontFullSolid(remote_i, -1, remote_k)) {
            return this.setBottomGrabType(1, remoteBelowId);
        }
        Block baseBelowId = Orientation.getBaseBlockId(-1);
        int baseBelowMetadata = Orientation.getBaseBlockMetadata(-1);
        if (Orientation.isTrapDoor(baseBelowId) && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(-1))) {
            return this.setBottomGrabType(1, baseBelowId, false);
        }
        if (Orientation.isDoor(baseBelowId) && Orientation.isDoorTop(baseBelowMetadata) && this.isDoorFrontBlocked(base_i, -1, base_k) && this.isBaseAccessible(0)) {
            return this.setBottomGrabType(1, baseBelowId, false);
        }
        if (SmartMovingOptions.hasASGrapplingHook && ((Boolean)Orientation.Config._replaceRopeClimbing.value).booleanValue() || SmartMovingOptions.hasRopesPlus) {
            if (Orientation.isASRope(baseBelowId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setBottomGrabType(1, baseBelowId, false);
            }
            Block baseId = Orientation.getBaseBlockId(0);
            if (Orientation.isASRope(baseId) && this.isASGrapplingHookFront(Orientation.getBaseBlockMetadata(0))) {
                return this.setBottomGrabType(1, baseId, false);
            }
            if (Orientation.isASRope(remoteBelowId) && this.rotate(180).isASGrapplingHookFront(remoteBelowMetadata)) {
                return this.setHalfGrabType(1, remoteBelowId, true);
            }
            if (Orientation.isASRope(remoteId) && this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(0))) {
                return this.setHalfGrabType(1, remoteId, true);
            }
        }
        if (Config.isFreeBaseClimb()) {
            int meta = this.baseVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
            meta = this.baseVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(-1);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
            meta = this.remoteVineClimbing(0);
            if (meta != -1) {
                return this.setHalfGrabType(1, Block.getBlockFromName((String)"vine"), false, meta);
            }
        }
        return this.setBottomGrabType(0, null);
    }

    private boolean setHalfGrabType(int type, Block block) {
        return this.setHalfGrabType(type, block, true);
    }

    private boolean setHalfGrabType(int type, Block block, boolean remote) {
        return this.setHalfGrabType(type, block, remote, -1);
    }

    private boolean setHalfGrabType(int type, Block block, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isUpperHalfFrontEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isUpperHalfFrontEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, block, remote, hasGrab, metaClimb);
    }

    private boolean setBottomGrabType(int type, Block block) {
        return this.setBottomGrabType(type, block, true);
    }

    private boolean setBottomGrabType(int type, Block block, boolean remote) {
        return this.setBottomGrabType(type, block, remote, -1);
    }

    private boolean setBottomGrabType(int type, Block block, boolean remote, int metaClimb) {
        boolean hasGrab;
        boolean bl = hasGrab = type != 0;
        if (hasGrab && remote && this._isDiagonal) {
            boolean edgeConnectCCW = this.rotate(90).isLowerHalfFrontFullEmpty(base_i, 0, remote_k);
            boolean edgeConnectCW = this.rotate(-90).isLowerHalfFrontFullEmpty(remote_i, 0, base_k);
            hasGrab &= edgeConnectCCW && edgeConnectCW;
        }
        return Orientation.setGrabType(type, block, remote, hasGrab, metaClimb);
    }

    private static boolean setGrabType(int type, Block block, boolean remote, boolean hasGrab, int metaClimb) {
        grabRemote = remote;
        grabType = hasGrab ? type : 0;
        grabBlock = block;
        grabMeta = metaClimb;
        return hasGrab;
    }

    private boolean setClimbingAngles() {
        switch (this._i) {
            case -1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(135.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(90.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(45.0f);
                    }
                }
                break;
            }
            case 0: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(180.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(0.0f, 360.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(0.0f);
                    }
                }
                break;
            }
            case 1: {
                switch (this._k) {
                    case -1: {
                        return this.setClimbingAngles(225.0f);
                    }
                    case 0: {
                        return this.setClimbingAngles(270.0f);
                    }
                    case 1: {
                        return this.setClimbingAngles(315.0f);
                    }
                }
            }
        }
        return false;
    }

    private boolean setClimbingAngles(float directionAngle) {
        this._directionAngle = directionAngle;
        float halfAreaAngle = (this._isDiagonal ? (Float)Orientation.Config._freeClimbingDiagonalDirectionAngle.value : (Float)Orientation.Config._freeClimbingOrthogonalDirectionAngle.value).floatValue() / 2.0f;
        return this.setClimbingAngles(directionAngle - halfAreaAngle, directionAngle + halfAreaAngle);
    }

    private boolean setClimbingAngles(float mimimumClimbingAngle, float maximumClimbingAngle) {
        if (mimimumClimbingAngle < 0.0f) {
            mimimumClimbingAngle += 360.0f;
        }
        if (maximumClimbingAngle > 360.0f) {
            maximumClimbingAngle -= 360.0f;
        }
        this._mimimumClimbingAngle = mimimumClimbingAngle;
        this._maximumClimbingAngle = maximumClimbingAngle;
        return mimimumClimbingAngle != maximumClimbingAngle;
    }

    private boolean isWithinAngle(float minimumRotation, float maximumRotation) {
        return this.isWithinAngle(this._directionAngle, minimumRotation, maximumRotation);
    }

    private boolean isRotationForClimbing(float rotation) {
        return this.isWithinAngle(rotation, this._mimimumClimbingAngle, this._maximumClimbingAngle);
    }

    private boolean isWithinAngle(float rotation, float minimumRotation, float maximumRotation) {
        if (minimumRotation > maximumRotation) {
            return rotation >= minimumRotation || rotation <= maximumRotation;
        }
        return rotation >= minimumRotation && rotation <= maximumRotation;
    }

    private int baseVineClimbing(int j_offset) {
        boolean result = this.isOnVine(j_offset);
        if (result) {
            result = this.isOnVineFront(j_offset);
            if (result) {
                return 0;
            }
            if (this.baseVineClimbing(j_offset, PZ) || this.baseVineClimbing(j_offset, NZ) || this.baseVineClimbing(j_offset, ZP) || this.baseVineClimbing(j_offset, ZN)) {
                return 1;
            }
        }
        return -1;
    }

    private boolean baseVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        return orientation.rotate(180).hasVineOrientation(world, base_i, local_offset + j_offset, base_k) && orientation.getHorizontalBorderGap() >= 0.65;
    }

    private boolean remoteLadderClimbing(int j_offset) {
        return this.isBehindLadder(j_offset) && this.isOnLadderBack(j_offset);
    }

    private int remoteVineClimbing(int j_offset) {
        if (this.isBehindVine(j_offset) && this.isOnVineBack(j_offset)) {
            return 0;
        }
        if (this.remoteVineClimbing(j_offset, PZ) || this.remoteVineClimbing(j_offset, NZ) || this.remoteVineClimbing(j_offset, ZP) || this.remoteVineClimbing(j_offset, ZN)) {
            return 1;
        }
        return -1;
    }

    private boolean remoteVineClimbing(int j_offset, Orientation orientation) {
        if (orientation == this) {
            return false;
        }
        int i = base_i - orientation._i;
        int k = base_k - orientation._k;
        return Orientation.isVine(Orientation.getBlock(i, j_offset, k)) && orientation.hasVineOrientation(world, i, local_offset + j_offset, k) && orientation.getHorizontalBorderGap() >= (double)0.65f;
    }

    private boolean isOnLadder(int j_offset) {
        Block block = Orientation.getBaseBlockId(j_offset);
        if (Orientation.isLadder(block)) {
            return true;
        }
        if (Orientation.isVine(block)) {
            return false;
        }
        return Orientation.isClimbable(world, base_i, local_offset + j_offset, base_k);
    }

    private boolean isBehindLadder(int j_offset) {
        Block block = Orientation.getRemoteBlockId(j_offset);
        if (Orientation.isLadder(block)) {
            return true;
        }
        if (Orientation.isVine(block)) {
            return false;
        }
        return Orientation.isClimbable(world, remote_i, local_offset + j_offset, remote_k);
    }

    private boolean isOnVine(int j_offset) {
        return Orientation.isVine(Orientation.getBaseBlockId(j_offset));
    }

    private boolean isBehindVine(int j_offset) {
        return Orientation.isVine(Orientation.getRemoteBlockId(j_offset));
    }

    private boolean isOnLadderOrVine(int j_offset) {
        return Orientation.isLadderOrVine(Orientation.getBaseBlockId(j_offset)) || Orientation.isVine(grabBlock);
    }

    public static boolean isLadder(Block block) {
        return block == Block.getBlockFromName((String)"ladder");
    }

    public static boolean isVine(Block block) {
        return block == Block.getBlockFromName((String)"vine");
    }

    public static boolean isLadderOrVine(Block block) {
        return Orientation.isLadder(block) || Orientation.isVine(block) || Orientation.isBlockIdOfType(block, _ladderKitLadderTypes);
    }

    public static boolean isKnownLadder(Block block) {
        return Orientation.isLadder(block) || Orientation.isBlockIdOfType(block, _ladderKitLadderTypes);
    }

    public static boolean isClimbable(World world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        return block != null && block.isLadder((IBlockAccess)world, i, j, k, (EntityLivingBase)Minecraft.getMinecraft().thePlayer);
    }

    private boolean isOnLadderFront(int j_offset) {
        return this.hasLadderOrientation(world, base_i, local_offset + j_offset, base_k);
    }

    private boolean isOnLadderBack(int j_offset) {
        return this.rotate(180).hasLadderOrientation(world, remote_i, local_offset + j_offset, remote_k);
    }

    private boolean isOnVineFront(int j_offset) {
        return this.hasVineOrientation(world, base_i, local_offset + j_offset, base_k);
    }

    private boolean isOnVineBack(int j_offset) {
        return this.rotate(180).hasVineOrientation(world, remote_i, local_offset + j_offset, remote_k);
    }

    private boolean isOnMiddleLadderFront(int j_offset) {
        switch (Orientation.getCarpentersBlockData(base_i, j_offset, base_k)) {
            case 0: {
                if (this == ZN) {
                    return Orientation.isTopHalf(base_kd);
                }
                if (this == ZP) {
                    return !Orientation.isTopHalf(base_kd);
                }
            }
            case 1: {
                if (this == NZ) {
                    return Orientation.isTopHalf(base_id);
                }
                if (this != PZ) break;
                return !Orientation.isTopHalf(base_id);
            }
        }
        return false;
    }

    private static int getCarpentersBlockData(int i, int j_offset, int k) {
        TileEntity entity;
        if (Orientation.isExternalBlockType(Orientation.getBlock(i, j_offset, k), _blockCarpentersLadder) && (entity = Orientation.getBlockTileEntity(i, j_offset, k)) != null) {
            return (Integer)Reflect.Invoke(_carpentersBlockPropertiesGetData, null, entity);
        }
        return -1;
    }

    public static Orientation getKnownLadderOrientation(World world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        int metadata = world.getBlockMetadata(i, j, k);
        if (Orientation.isBlockIdOfType(block, _ladderKitLadderTypes)) {
            switch (metadata & 3) {
                case 1: {
                    return NZ;
                }
                case 3: {
                    return PZ;
                }
                case 0: {
                    return ZP;
                }
                case 2: {
                    return ZN;
                }
            }
            return null;
        }
        switch (metadata & 7) {
            case 5: {
                return NZ;
            }
            case 4: {
                return PZ;
            }
            case 2: {
                return ZP;
            }
            case 3: {
                return ZN;
            }
        }
        return null;
    }

    public boolean hasVineOrientation(World world, int i, int j, int k) {
        int metaData = world.getBlockMetadata(i, j, k);
        if (this == NZ) {
            return (metaData & 2) != 0;
        }
        if (this == PZ) {
            return (metaData & 8) != 0;
        }
        if (this == ZP) {
            return (metaData & 1) != 0;
        }
        if (this == ZN) {
            return (metaData & 4) != 0;
        }
        return false;
    }

    private boolean hasLadderOrientation(World world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        int metadata = world.getBlockMetadata(i, j, k);
        if (Orientation.isBlockIdOfType(block, _ladderKitLadderTypes)) {
            metadata &= 3;
            if (this == NZ) {
                return metadata == 1;
            }
            if (this == PZ) {
                return metadata == 3;
            }
            if (this == ZP) {
                return metadata == 0;
            }
            if (this == ZN) {
                return metadata == 2;
            }
            return false;
        }
        metadata &= 7;
        if (this == NZ) {
            return metadata == 5;
        }
        if (this == PZ) {
            return metadata == 4;
        }
        if (this == ZP) {
            return metadata == 2;
        }
        if (this == ZN) {
            return metadata == 3;
        }
        return false;
    }

    public boolean isRemoteSolid(World world, int i, int j, int k) {
        return Orientation.isSolid(world.getBlock(i + this._i, j, k + this._k).getMaterial());
    }

    public static Orientation getOpenTrapDoorOrientation(World world, int i, int j, int k) {
        int metadata = world.getBlockMetadata(i, j, k);
        if (!Orientation.isClosedTrapDoor(metadata)) {
            switch (metadata & 3) {
                case 0: {
                    return ZP;
                }
                case 1: {
                    return ZN;
                }
                case 2: {
                    return PZ;
                }
                case 3: {
                    return NZ;
                }
            }
        }
        return null;
    }

    private boolean isHeadedToRope() {
        int iTriple = Orientation.getTriple(base_id, base_kd);
        int kTriple = Orientation.getTriple(base_kd, base_id);
        if (iTriple > 0) {
            if (kTriple > 0) {
                return this == NN;
            }
            if (kTriple < 0) {
                return this == NP;
            }
            return this == NZ;
        }
        if (iTriple < 0) {
            if (kTriple > 0) {
                return this == PN;
            }
            if (kTriple < 0) {
                return this == PP;
            }
            return this == PZ;
        }
        if (kTriple > 0) {
            return this == ZN;
        }
        if (kTriple < 0) {
            return this == ZP;
        }
        return this == ZZ;
    }

    private boolean isOnAnchorFront(int j_offset) {
        switch (Orientation.getBaseBlockMetadata(j_offset)) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return this._k == 1;
            }
            case 3: {
                return this._k == -1;
            }
            case 4: {
                return this._i == 1;
            }
            case 5: {
                return this._i == -1;
            }
        }
        return false;
    }

    private Block getRopeId(int j_offset) {
        Block block = Orientation.getBaseBlockId(j_offset);
        if (Orientation.isRopeId(block)) {
            return block;
        }
        return null;
    }

    private boolean isRope(int j_offset) {
        return this.getRopeId(j_offset) != null;
    }

    private static boolean isRopeId(Block block) {
        return SmartMovingOptions.hasBetterThanWolves && Orientation.hasBlockName(block, "tile.fcRopeBlock") || SmartMovingOptions.hasRopesPlus && Orientation.hasBlockName(block, "tile.blockRopeCentral");
    }

    private Block getAnchorId(int j_offset) {
        Block block = Orientation.getBaseBlockId(j_offset);
        if (Orientation.isAnchorId(block)) {
            return block;
        }
        return null;
    }

    private static boolean isAnchorId(Block block) {
        return Orientation.hasBlockName(block, "tile.fcAnchor");
    }

    private boolean isOnWallRope(int j_offset) {
        return (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(Orientation.getBaseBlockId(j_offset));
    }

    private static boolean isASRope(Block block) {
        return Orientation.hasBlockName(block, "tile.blockRope");
    }

    private static boolean isASGrapplingHook(Block block) {
        return Orientation.hasBlockName(block, "tile.blockGrHk");
    }

    private boolean isASGrapplingHookFront(int metaData) {
        boolean iPos;
        boolean kPos = metaData % 2 != 0;
        boolean iNeg = metaData / 2 % 2 != 0;
        boolean kNeg = metaData / 4 % 2 != 0;
        boolean bl = iPos = metaData / 8 % 2 != 0;
        if (this._i > 0 && iPos || this._i < 0 && iNeg) {
            if (this._k > 0) {
                return kPos;
            }
            if (this._k < 0) {
                return kNeg;
            }
            return true;
        }
        if (this._k > 0 && kPos || this._k < 0 && kNeg) {
            if (this._i > 0) {
                return iPos;
            }
            if (this._i < 0) {
                return iNeg;
            }
            return true;
        }
        return false;
    }

    private boolean isOnOpenTrapDoor(int j_offset) {
        return Orientation.isTrapDoor(Orientation.getBaseBlockId(j_offset)) && !Orientation.isClosedTrapDoor(Orientation.getBaseBlockMetadata(j_offset));
    }

    private boolean isTrapDoorFront(int trapDoorMetadata) {
        if (this == NZ) {
            return (trapDoorMetadata & 3) == 3;
        }
        if (this == PZ) {
            return (trapDoorMetadata & 3) == 2;
        }
        if (this == ZP) {
            return (trapDoorMetadata & 3) == 0;
        }
        if (this == ZN) {
            return (trapDoorMetadata & 3) == 1;
        }
        if (this == PN) {
            return (trapDoorMetadata & 3) == 2 || (trapDoorMetadata & 3) == 1;
        }
        if (this == PP) {
            return (trapDoorMetadata & 3) == 2 || (trapDoorMetadata & 3) == 0;
        }
        if (this == NN) {
            return (trapDoorMetadata & 3) == 3 || (trapDoorMetadata & 3) == 1;
        }
        if (this == NP) {
            return (trapDoorMetadata & 3) == 3 || (trapDoorMetadata & 3) == 0;
        }
        return false;
    }

    private boolean isBottomStairCompactNotBack(int stairMetadata) {
        return !Orientation.isTopStairCompact(stairMetadata) && !this.isStairCompactBack(stairMetadata);
    }

    private boolean isBottomStairCompactFront(int stairMetadata) {
        return !Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactFront(stairMetadata);
    }

    private boolean isTopStairCompactFront(int stairMetadata) {
        return Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactFront(stairMetadata);
    }

    private boolean isTopStairCompactBack(int stairMetadata) {
        return Orientation.isTopStairCompact(stairMetadata) && this.isStairCompactBack(stairMetadata);
    }

    private boolean isStairCompactFront(int stairMetadata) {
        stairMetadata &= 3;
        if (this == NZ) {
            return stairMetadata == 1;
        }
        if (this == PZ) {
            return stairMetadata == 0;
        }
        if (this == ZP) {
            return stairMetadata == 2;
        }
        if (this == ZN) {
            return stairMetadata == 3;
        }
        if (this == PN) {
            return stairMetadata == 0 || stairMetadata == 3;
        }
        if (this == PP) {
            return stairMetadata == 0 || stairMetadata == 2;
        }
        if (this == NN) {
            return stairMetadata == 1 || stairMetadata == 3;
        }
        if (this == NP) {
            return stairMetadata == 1 || stairMetadata == 2;
        }
        return false;
    }

    private boolean isStairCompactBack(int stairMetadata) {
        stairMetadata &= 3;
        if (this == NZ) {
            return stairMetadata == 0;
        }
        if (this == PZ) {
            return stairMetadata == 1;
        }
        if (this == ZP) {
            return stairMetadata == 3;
        }
        if (this == ZN) {
            return stairMetadata == 2;
        }
        if (this == PN) {
            return stairMetadata == 1 || stairMetadata == 2;
        }
        if (this == PP) {
            return stairMetadata == 1 || stairMetadata == 3;
        }
        if (this == NN) {
            return stairMetadata == 0 || stairMetadata == 2;
        }
        if (this == NP) {
            return stairMetadata == 0 || stairMetadata == 3;
        }
        return false;
    }

    private static boolean isTopStairCompact(int stairMetadata) {
        return (stairMetadata & 4) != 0;
    }

    private static boolean isRedPowerWireTop(int coverSides) {
        return (coverSides >> 1) % 2 == 1;
    }

    private static boolean isRedPowerWireBottom(int coverSides) {
        return (coverSides >> 0) % 2 == 1;
    }

    private boolean isRedPowerWireFullFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) && ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyFront(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZN.isRedPowerWireFullFront(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullFront(coverSides) || ZP.isRedPowerWireFullFront(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireFullBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) && ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isRedPowerWireAnyBack(int coverSides) {
        if (this == NZ) {
            return (coverSides >> 4) % 2 == 1;
        }
        if (this == PZ) {
            return (coverSides >> 5) % 2 == 1;
        }
        if (this == ZP) {
            return (coverSides >> 3) % 2 == 1;
        }
        if (this == ZN) {
            return (coverSides >> 2) % 2 == 1;
        }
        if (this == PN) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == PP) {
            return PZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        if (this == NN) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZN.isRedPowerWireFullBack(coverSides);
        }
        if (this == NP) {
            return NZ.isRedPowerWireFullBack(coverSides) || ZP.isRedPowerWireFullBack(coverSides);
        }
        return false;
    }

    private boolean isFenceGateFront(int metaData) {
        int direction = metaData % 4;
        if (this == NZ) {
            return direction == 0 || direction == 2;
        }
        if (this == PZ) {
            return direction == 0 || direction == 2;
        }
        if (this == ZP) {
            return direction == 1 || direction == 3;
        }
        if (this == ZN) {
            return direction == 1 || direction == 3;
        }
        return false;
    }

    private boolean headedToFrontWall(int i, int j_offset, int k, Block block) {
        boolean zn = this.getWallFlag(ZN, i, j_offset, k, block);
        boolean zp = this.getWallFlag(ZP, i, j_offset, k, block);
        boolean nz = this.getWallFlag(NZ, i, j_offset, k, block);
        boolean pz = this.getWallFlag(PZ, i, j_offset, k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        return this.headedToWall(NZ, pz) || this.headedToWall(PZ, nz) || this.headedToWall(ZN, zp) || this.headedToWall(ZP, zn);
    }

    private boolean headedToFrontSideWall(int i, int j_offset, int k, Block block) {
        boolean zn = this.getWallFlag(ZN, i, j_offset, k, block);
        boolean zp = this.getWallFlag(ZP, i, j_offset, k, block);
        boolean nz = this.getWallFlag(NZ, i, j_offset, k, block);
        boolean pz = this.getWallFlag(PZ, i, j_offset, k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToWall(NZ, zp) || this.headedToWall(PZ, zp) || this.headedToWall(ZN, pz) || this.headedToWall(ZP, pz);
            }
            return this.headedToWall(NZ, zn) || this.headedToWall(PZ, zn) || this.headedToWall(ZN, pz) || this.headedToWall(ZP, pz);
        }
        if (kTop) {
            return this.headedToWall(NZ, zp) || this.headedToWall(PZ, zp) || this.headedToWall(ZN, nz) || this.headedToWall(ZP, nz);
        }
        return this.headedToWall(NZ, zn) || this.headedToWall(PZ, zn) || this.headedToWall(ZN, nz) || this.headedToWall(ZP, nz);
    }

    private boolean headedToWall(Orientation base, boolean result) {
        if (this == base || this == base.rotate(45) || this == base.rotate(-45)) {
            return result;
        }
        return false;
    }

    private boolean headedToBaseWall(int j_offset, Block block) {
        boolean zn = this.getWallFlag(ZN, base_i, j_offset, base_k, block);
        boolean zp = this.getWallFlag(ZP, base_i, j_offset, base_k, block);
        boolean nz = this.getWallFlag(NZ, base_i, j_offset, base_k, block);
        boolean pz = this.getWallFlag(PZ, base_i, j_offset, base_k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        boolean leaf = zn || zp || nz || pz;
        boolean coreOnly = !allOnNone && !leaf;
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToBaseWall(NN, NZ, ZN, zp, nz, pz, zn, coreOnly, leaf);
            }
            return this.headedToBaseWall(NP, NZ, ZP, zn, nz, pz, zp, coreOnly, leaf);
        }
        if (kTop) {
            return this.headedToBaseWall(PN, PZ, ZN, zp, pz, nz, zn, coreOnly, leaf);
        }
        return this.headedToBaseWall(PP, PZ, ZP, zn, pz, nz, zp, coreOnly, leaf);
    }

    private boolean headedToBaseWall(Orientation diagonal, Orientation left, Orientation right, boolean leftFront, boolean rightFrontOpposite, boolean rightFront, boolean leftFrontOpposite, boolean co, boolean leaf) {
        if (this == diagonal) {
            return leaf || co;
        }
        if (this == left) {
            return this.headedToBaseWall(leftFront, rightFrontOpposite, rightFront, leftFrontOpposite, co);
        }
        if (this == right) {
            return this.headedToBaseWall(rightFront, leftFrontOpposite, leftFront, rightFrontOpposite, co);
        }
        return false;
    }

    private boolean headedToBaseWall(boolean front, boolean sideOpposite, boolean side, boolean frontOpposite, boolean coreOnly) {
        return front || sideOpposite && !side || frontOpposite && !front && !side || coreOnly;
    }

    private boolean headedToBaseGrabWall(int j_offset, Block block) {
        boolean azn;
        boolean azp;
        boolean anz;
        boolean apz;
        Block aboveBlock;
        boolean zn = this.getWallFlag(ZN, base_i, j_offset, base_k, block);
        boolean zp = this.getWallFlag(ZP, base_i, j_offset, base_k, block);
        boolean nz = this.getWallFlag(NZ, base_i, j_offset, base_k, block);
        boolean pz = this.getWallFlag(PZ, base_i, j_offset, base_k, block);
        boolean allOnNone = this.getAllWallsOnNoWall(block);
        if (!(!allOnNone || zn || zp || nz || pz)) {
            pz = true;
            nz = true;
            zp = true;
            zn = true;
        }
        if (Orientation.isFullEmpty(aboveBlock = Orientation.getBlock(base_i, j_offset + 1, base_k))) {
            apz = false;
            anz = false;
            azp = false;
            azn = false;
        } else if (Orientation.isWallBlock(aboveBlock, base_i, j_offset + 1, base_k)) {
            azn = this.getWallFlag(ZN, base_i, j_offset + 1, base_k, aboveBlock);
            azp = this.getWallFlag(ZP, base_i, j_offset + 1, base_k, aboveBlock);
            anz = this.getWallFlag(NZ, base_i, j_offset + 1, base_k, aboveBlock);
            apz = this.getWallFlag(PZ, base_i, j_offset + 1, base_k, aboveBlock);
            boolean aboveAllOnNone = this.getAllWallsOnNoWall(aboveBlock);
            if (!(!aboveAllOnNone || azn || azp || anz || apz)) {
                apz = true;
                anz = true;
                azp = true;
                azn = true;
            }
        } else {
            apz = true;
            anz = true;
            azp = true;
            azn = true;
        }
        boolean iTop = Orientation.isTopHalf(base_id);
        boolean kTop = Orientation.isTopHalf(base_kd);
        if (iTop) {
            if (kTop) {
                return this.headedToBaseGrabWall(-this._i, -this._k, zp, pz, nz, zn, azp, apz, anz, azn);
            }
            return this.headedToBaseGrabWall(-this._i, this._k, pz, zn, zp, nz, apz, azn, azp, anz);
        }
        if (kTop) {
            return this.headedToBaseGrabWall(this._i, -this._k, nz, zp, zn, pz, anz, azp, azn, apz);
        }
        return this.headedToBaseGrabWall(this._i, this._k, zn, nz, pz, zp, azn, anz, apz, azp);
    }

    private boolean headedToBaseGrabWall(int i, int k, boolean front, boolean side, boolean frontOpposite, boolean sideOpposite, boolean aboveFront, boolean aboveSide, boolean aboveFrontOpposite, boolean aboveSideOpposite) {
        if (sideOpposite && !aboveSideOpposite && !front && !aboveFront && i == 1) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !side && !aboveSide && k == 1) {
            return true;
        }
        if (side && !aboveSide && k >= 0) {
            return true;
        }
        if (front && !aboveFront && k >= 0) {
            return true;
        }
        if (frontOpposite && !aboveFrontOpposite && !aboveFront && i == 1 && k >= 0) {
            return true;
        }
        return sideOpposite && !aboveSideOpposite && !aboveSide && k == 1 && i >= 0;
    }

    private boolean headedToRemoteFlatWall(Block block, int j_offset) {
        return !this.getWallFlag(this, remote_i, j_offset, remote_k, block) && this.getWallFlag(this.rotate(90), remote_i, j_offset, remote_k, block) && !this.getWallFlag(this.rotate(180), remote_i, j_offset, remote_k, block) && this.getWallFlag(this.rotate(-90), remote_i, j_offset, remote_k, block);
    }

    private boolean getWallFlag(Orientation direction, int i, int j_offset, int k, Block block) {
        if (block instanceof BlockPane) {
            return ((BlockPane)block).canPaneConnectToBlock(Orientation.getBlock(i + direction._i, j_offset, k + direction._k));
        }
        if (Orientation.isFenceBase(block)) {
            if (block instanceof BlockFence) {
                return ((BlockFence)block).canConnectFenceTo((IBlockAccess)world, i + direction._i, local_offset + j_offset, k + direction._k);
            }
            if (block instanceof BlockWall) {
                return ((BlockWall)block).canConnectWallTo((IBlockAccess)world, i + direction._i, local_offset + j_offset, k + direction._k);
            }
            if (SmartMovingOptions.hasBetterMisc && _canConnectFenceTo != null) {
                return (Boolean)Reflect.Invoke(_canConnectFenceTo, block, world, i + direction._i, local_offset + j_offset, k + direction._k);
            }
        } else {
            if (Orientation.isFenceGate(block)) {
                int metaData = Orientation.getBlockMetadata(i, j_offset, k);
                return Orientation.isClosedFenceGate(metaData) && this.isFenceGateFront(metaData);
            }
            switch (Orientation.getCarpentersBlockData(i, j_offset, k)) {
                case -1: {
                    break;
                }
                case 0: {
                    if (direction._k == 0 && direction._i != 0) {
                        return true;
                    }
                }
                case 1: {
                    if (direction._i == 0 && direction._k != 0) {
                        return true;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean getAllWallsOnNoWall(Block block) {
        return block instanceof BlockPane;
    }

    private static boolean isTopHalf(double d) {
        return (int)Math.abs(Math.floor(d * 2.0)) % 2 == 1;
    }

    private static int getTriple(double primary, double secondary) {
        primary = primary - Math.floor(primary) - 0.5;
        secondary = secondary - Math.floor(secondary) - 0.5;
        if (Math.abs(primary) * 2.0 < Math.abs(secondary)) {
            return 0;
        }
        if (primary > 0.0) {
            return 1;
        }
        if (primary < 0.0) {
            return -1;
        }
        return 0;
    }

    private static boolean isBottomHalfBlock(Block block, int metadata) {
        if (Orientation.isHalfBlock(block) && Orientation.isHalfBlockBottomMetaData(metadata)) {
            return true;
        }
        if (block == Block.getBlockFromName((String)"bed")) {
            return true;
        }
        return SmartMovingOptions.hasBetterThanWolves && Orientation.isAnchorId(block) && metadata == 1;
    }

    private static boolean isTopHalfBlock(Block block, int metadata) {
        return Orientation.isHalfBlock(block) && Orientation.isHalfBlockTopMetaData(metadata);
    }

    private static boolean isHalfBlockBottomMetaData(int metadata) {
        return (metadata & 8) == 0;
    }

    private static boolean isHalfBlockTopMetaData(int metadata) {
        return (metadata & 8) != 0;
    }

    private static boolean isHalfBlock(Block block) {
        return Orientation.isBlock(block, BlockSlab.class, _knownHalfBlocks) && !((BlockSlab)block).isOpaqueCube();
    }

    private static boolean isStairCompact(Block block) {
        return Orientation.isBlock(block, BlockStairs.class, _knownCompactStairBlocks);
    }

    private boolean isLowerHalfFrontFullEmpty(int i, int j_offset, int k) {
        int coverSides;
        Block block = Orientation.getBlock(i, j_offset, k);
        boolean empty = Orientation.isFullEmpty(block);
        if (!empty && SmartMovingOptions.hasRedPowerWire && Orientation.isRedPowerWire(block) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i, j_offset, k))) {
            empty = true;
        }
        if (!empty && SmartMovingOptions.hasBetterThanWolves && Orientation.isAnchorId(block)) {
            boolean bl = empty = Orientation.getBlockMetadata(i, j_offset, k) == 0;
        }
        if (!empty && Orientation.isStairCompact(block) && this.isTopStairCompactFront(Orientation.getBlockMetadata(i, j_offset, k))) {
            empty = true;
        }
        if (!empty && Orientation.isHalfBlock(block) && Orientation.isHalfBlockTopMetaData(Orientation.getBlockMetadata(i, j_offset, k))) {
            empty = true;
        }
        if (!empty && Orientation.isWallBlock(block, i, j_offset, k) && !this.headedToFrontWall(i, j_offset, k, block)) {
            empty = true;
        }
        if (!empty && Orientation.isDoor(block) && !this.rotate(180).isDoorFrontBlocked(i, j_offset, k)) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(block) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(j_offset))) {
            empty = true;
        }
        if (empty && Orientation.isBlockIdOfType(block, _ladderKitLadderTypes) && this.rotate(180).hasLadderOrientation(world, i, local_offset + j_offset, k)) {
            empty = false;
        }
        return empty;
    }

    private boolean isUpperHalfFrontAnySolid(int i, int j_offset, int k) {
        Block block = Orientation.getBlock(i, j_offset, k);
        boolean solid = this.isUpperHalfFrontFullSolid(i, j_offset, k);
        if (solid && Orientation.isWallBlock(block, i, j_offset, k) && !this.headedToFrontWall(i, j_offset, k, block)) {
            solid = false;
        }
        return solid;
    }

    private boolean isUpperHalfFrontFullSolid(int i, int j_offset, int k) {
        Block block = Orientation.getBlock(i, j_offset, k);
        if (block == null) {
            return false;
        }
        boolean solid = Orientation.isSolid(block.getMaterial());
        if (solid && block == Block.getBlockFromName((String)"standing_sign")) {
            solid = false;
        }
        if (solid && block == Block.getBlockFromName((String)"wall_sign")) {
            solid = false;
        }
        if (solid && block instanceof BlockPressurePlate) {
            solid = false;
        }
        if (solid && Orientation.isTrapDoor(block)) {
            solid = false;
        }
        if (solid && SmartMovingOptions.hasASGrapplingHook && Orientation.isASGrapplingHook(block)) {
            solid = false;
        }
        if (solid && this.isOpenFenceGate(block, Orientation.getBlockMetadata(i, j_offset, k))) {
            solid = false;
        }
        return solid;
    }

    private static boolean isFullEmpty(Block block) {
        boolean empty;
        if (block == null) {
            return true;
        }
        boolean bl = empty = !Orientation.isSolid(block.getMaterial());
        if (!empty && block == Block.getBlockFromName((String)"standing_sign")) {
            empty = true;
        }
        if (!empty && block == Block.getBlockFromName((String)"wall_sign")) {
            empty = true;
        }
        if (!empty && block instanceof BlockPressurePlate) {
            empty = true;
        }
        if (!empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASGrapplingHook(block)) {
            empty = true;
        }
        if (empty && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(block)) {
            empty = false;
        }
        return empty;
    }

    private static boolean isFenceBase(Block block) {
        return Orientation.isBlock(block, BlockFence.class, _knownFenceBlocks) || Orientation.isBlock(block, BlockWall.class, _knownWallBlocks);
    }

    private static boolean isFence(Block block, int i, int j_offset, int k) {
        return Orientation.isFenceBase(block) || Orientation.isClosedFenceGate(block, Orientation.getBlockMetadata(i, j_offset, k));
    }

    private boolean isFence(int i, int j_offset, int k) {
        return this.getFenceId(i, j_offset, k) != null;
    }

    private Block getFenceId(int i, int j_offset, int k) {
        Block block = Orientation.getBlock(i, j_offset, k);
        if (Orientation.isFenceBase(block) || Orientation.isClosedFenceGate(block, Orientation.getBlockMetadata(i, j_offset, k))) {
            return block;
        }
        return null;
    }

    private static boolean isClosedFenceGate(Block block, int metdata) {
        return Orientation.isFenceGate(block) && Orientation.isClosedFenceGate(metdata);
    }

    private static boolean isFenceGate(Block block) {
        return Orientation.isBlock(block, BlockFenceGate.class, _knownFanceGateBlocks);
    }

    private boolean isOpenFenceGate(Block block, int metdata) {
        return Orientation.isFenceGate(block) && !Orientation.isClosedFenceGate(metdata);
    }

    private static boolean isClosedFenceGate(int metdata) {
        return (metdata & 4) == 0;
    }

    private boolean isOpenTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(i, j_offset, k) && !Orientation.isClosedTrapDoor(Orientation.getBlockMetadata(i, j_offset, k));
    }

    private static boolean isClosedTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(i, j_offset, k) && Orientation.isClosedTrapDoor(Orientation.getBlockMetadata(i, j_offset, k));
    }

    private static boolean isTrapDoor(int i, int j_offset, int k) {
        return Orientation.isTrapDoor(Orientation.getBlock(i, j_offset, k));
    }

    public static boolean isTrapDoor(Block block) {
        return Orientation.isBlock(block, BlockTrapDoor.class, _knownTrapDoorBlocks);
    }

    private static boolean isBlock(Block block, Class<?> type, Block[] baseBlocks) {
        if (block == null) {
            return false;
        }
        if (type != null && baseBlocks.length > 1 && Orientation.isBlockType(block, type)) {
            return true;
        }
        for (int i = 0; i < baseBlocks.length; ++i) {
            if (baseBlocks[i] == null || block != baseBlocks[i]) continue;
            return true;
        }
        if (type != null && Orientation.isBlockType(block, type)) {
            return true;
        }
        Class<?> blockType = block.getClass();
        for (int i = 0; i < baseBlocks.length; ++i) {
            if (baseBlocks[i] == null || !baseBlocks[i].getClass().isAssignableFrom(blockType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExternalBlockType(Block block, Class<?> externalType) {
        return externalType != null && Orientation.isBlockType(block, externalType);
    }

    private static boolean isBlockType(Block block, Class<?> type) {
        return block != null && type.isAssignableFrom(block.getClass());
    }

    public static boolean isClosedTrapDoor(int metaData) {
        return (metaData & 4) == 0;
    }

    private static boolean isDoor(Block block) {
        return block == Block.getBlockFromName((String)"wooden_door") || block == Block.getBlockFromName((String)"iron_door");
    }

    private static boolean isDoorTop(int metaData) {
        return metaData == 8;
    }

    private boolean isDoorFrontBlocked(int i, int j_offset, int k) {
        int metaData = Orientation.getBlockMetadata(i, j_offset, k);
        switch (metaData) {
            case 8: {
                return this.isDoorFrontBlocked(i, j_offset - 1, k);
            }
            case 1: 
            case 4: {
                return this._k < 0;
            }
            case 2: 
            case 5: {
                return this._i > 0;
            }
            case 3: 
            case 6: {
                return this._k > 0;
            }
            case 0: 
            case 7: {
                return this._i < 0;
            }
        }
        return true;
    }

    private static Block getWallBlockId(int i, int j_offset, int k) {
        Block block = Orientation.getBlock(i, j_offset, k);
        if (Orientation.isWallBlock(block, i, j_offset, k)) {
            return block;
        }
        return null;
    }

    private static boolean isWallBlock(Block block, int i, int j_offset, int k) {
        return Orientation.isBlock(block, BlockPane.class, _knownThinWallBlocks) || Orientation.isFence(block, i, j_offset, k) || Orientation.isExternalBlockType(block, _blockCarpentersLadder);
    }

    private boolean isBaseAccessible(int j_offset) {
        return this.isBaseAccessible(j_offset, false, false);
    }

    private boolean isBaseAccessible(int j_offset, boolean bottom, boolean full) {
        Block id = Orientation.getBaseBlockId(j_offset);
        boolean accessible = this.isEmpty(base_i, j_offset, base_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(id)) {
            int coverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
            accessible = !Orientation.isRedPowerWireBottom(coverSides);
            Block lowerId = Orientation.getBaseBlockId(j_offset - 1);
            if (Orientation.isRedPowerWire(lowerId)) {
                int lowerCoverSides = Orientation.getRpCoverSides(base_i, j_offset - 1, base_k);
                accessible &= !Orientation.isRedPowerWireTop(lowerCoverSides);
            }
        }
        if (!accessible && Orientation.isFullEmpty(id)) {
            accessible = true;
        }
        if (!accessible && this.isOpenTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && bottom && Orientation.isClosedTrapDoor(base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && Orientation.isWallBlock(id, base_i, j_offset, base_k)) {
            accessible = true;
        }
        if (!accessible && !full && (SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id)) {
            accessible = true;
        }
        if (!accessible && Orientation.isDoor(id)) {
            accessible = true;
        }
        return accessible;
    }

    private boolean isRemoteAccessible(int j_offset) {
        Block id;
        boolean accessible = this.isEmpty(remote_i, j_offset, remote_k);
        if (SmartMovingOptions.hasRedPowerWire && !accessible && Orientation.isRedPowerWire(id = Orientation.getRemoteBlockId(j_offset))) {
            int coverSides = Orientation.getRpCoverSides(remote_i, j_offset, remote_k);
            accessible = !this.isRedPowerWireAnyFront(coverSides);
            Block baseId = Orientation.getBaseBlockId(j_offset);
            if (Orientation.isRedPowerWire(baseId)) {
                int baseCoverSides = Orientation.getRpCoverSides(base_i, j_offset, base_k);
                accessible &= !this.isRedPowerWireAnyBack(baseCoverSides);
            }
        }
        if (accessible) {
            id = Orientation.getBaseBlockId(j_offset);
            if (Orientation.isTrapDoor(id)) {
                boolean bl = accessible = !this.isTrapDoorFront(Orientation.getBlockMetadata(base_i, j_offset, base_k));
            }
            if (accessible && Orientation.isDoor(id)) {
                boolean bl = accessible = !this.isDoorFrontBlocked(base_i, j_offset, base_k);
            }
            if (this.remoteLadderClimbing(j_offset)) {
                accessible = false;
            }
        }
        if (!accessible && Orientation.isTrapDoor(remote_i, j_offset, remote_k)) {
            accessible = Orientation.isClosedTrapDoor(Orientation.getRemoteBlockMetadata(j_offset));
        }
        if (!accessible) {
            id = Orientation.getRemoteBlockId(j_offset);
            if (Orientation.isWallBlock(id, remote_i, j_offset, remote_k) && !this.headedToFrontWall(remote_i, j_offset, remote_k, id) && !this.isFence(remote_i, j_offset - 1, remote_k)) {
                accessible = true;
            }
            Block belowId = Orientation.getRemoteBlockId(j_offset - 1);
            if (!(accessible || !Orientation.isFence(belowId, remote_i, j_offset - 1, remote_k) || this.headedToFrontWall(remote_i, j_offset - 1, remote_k, belowId) && !Orientation.isWallBlock(Orientation.getBaseBlockId(j_offset - 1), base_i, j_offset - 1, base_k) || belowId == Block.getBlockFromName((String)"cobblestone_wall") && !this.headedToRemoteFlatWall(belowId, -1))) {
                accessible = true;
            }
            if (!accessible && Orientation.isDoor(id) && !this.rotate(180).isDoorFrontBlocked(remote_i, j_offset, remote_k)) {
                accessible = true;
            }
            if ((SmartMovingOptions.hasASGrapplingHook || SmartMovingOptions.hasRopesPlus) && Orientation.isASRope(id) && !this.rotate(180).isASGrapplingHookFront(Orientation.getRemoteBlockMetadata(j_offset))) {
                accessible = true;
            }
        }
        return accessible;
    }

    private boolean isAccessAccessible(int j_offset) {
        if (!this._isDiagonal) {
            return true;
        }
        return this.isEmpty(remote_i, j_offset, base_k) && this.isEmpty(base_i, j_offset, remote_k);
    }

    private boolean isFullExtentAccessible(int j_offset, boolean grabRemote) {
        boolean accessible = this.isFullAccessible(j_offset, grabRemote);
        if (SmartMovingOptions.hasRedPowerWire && accessible) {
            int coverSides;
            Block bottomId;
            int coverSides2;
            Block topId = Orientation.getRemoteBlockId(j_offset);
            if (Orientation.isRedPowerWire(topId) && Orientation.isRedPowerWireBottom(coverSides2 = Orientation.getRpCoverSides(remote_i, j_offset, remote_k))) {
                accessible = false;
            }
            if (Orientation.isRedPowerWire(bottomId = Orientation.getRemoteBlockId(j_offset - 1)) && Orientation.isRedPowerWireTop(coverSides = Orientation.getRpCoverSides(remote_i, j_offset - 1, remote_k))) {
                accessible = false;
            }
        }
        return accessible;
    }

    private boolean isJustLowerHalfExtentAccessible(int j_offset) {
        Block remoteId = Orientation.getRemoteBlockId(j_offset);
        int remoteMetaData = Orientation.getRemoteBlockMetadata(j_offset);
        boolean accessible = false;
        if (!accessible) {
            accessible = Orientation.isTopHalfBlock(remoteId, remoteMetaData);
        }
        if (!accessible) {
            accessible = Orientation.isStairCompact(remoteId) && this.isTopStairCompactFront(remoteMetaData);
        }
        return accessible;
    }

    private boolean isFullAccessible(int j_offset, boolean grabRemote) {
        if (grabRemote) {
            return this.isBaseAccessible(j_offset) && this.isRemoteAccessible(j_offset) && this.isAccessAccessible(j_offset);
        }
        return this.isEmpty(base_i, j_offset, base_k);
    }

    private boolean isEmpty(int i, int j_offset, int k) {
        return Orientation.isFullEmpty(Orientation.getBlock(i, j_offset, k)) && !this.isFence(i, j_offset - 1, k);
    }

    private boolean isUpperHalfFrontEmpty(int i, int j_offset, int k) {
        Block wallId;
        int coverSides;
        Block block = Orientation.getBlock(i, j_offset, k);
        boolean empty = Orientation.isFullEmpty(block);
        if (!empty) {
            int metadata = Orientation.getBlockMetadata(i, j_offset, k);
            if (Orientation.isBottomHalfBlock(block, metadata)) {
                empty = true;
            }
            if (!empty && Orientation.isStairCompact(block) && this.isBottomStairCompactFront(metadata)) {
                empty = true;
            }
        }
        if (SmartMovingOptions.hasRedPowerWire && !empty && Orientation.isRedPowerWire(block) && !this.isRedPowerWireAnyFront(coverSides = Orientation.getRpCoverSides(i, j_offset, k))) {
            empty = true;
        }
        if (!empty && Orientation.isTrapDoor(block)) {
            empty = true;
        }
        if (!(empty || (wallId = Orientation.getWallBlockId(i, j_offset, k)) == null || this.headedToFrontWall(i, j_offset, k, wallId) && !Orientation.isWallBlock(Orientation.getBlock(i - this._i, j_offset, k - this._k), i - this._i, j_offset, k - this._k))) {
            empty = true;
        }
        if (empty && Orientation.isBlockIdOfType(block, _ladderKitLadderTypes) && this.rotate(180).hasLadderOrientation(world, i, local_offset + j_offset, k)) {
            empty = false;
        }
        return empty;
    }

    private static int getRpCoverSides(int i, int j_offset, int k) {
        TileEntity tileEntity = Orientation.getBlockTileEntity(i, j_offset, k);
        Class<?> tileEntityClass = tileEntity.getClass();
        while (!tileEntityClass.getSimpleName().equals("TileCovered")) {
            tileEntityClass = tileEntityClass.getSuperclass();
        }
        return (Integer)Reflect.GetField(tileEntityClass, tileEntity, new Name("CoverSides"));
    }

    private static boolean isRedPowerWire(Block block) {
        return Orientation.hasBlockName(block, "tile.rpwire");
    }

    public static int getFiniteLiquidWater(Block block) {
        String blockName = Orientation.getBlockName(block);
        if (blockName == null) {
            return 0;
        }
        if (blockName.equals("tile.nocean")) {
            return 2;
        }
        if (blockName.equals("tile.nwater_still")) {
            return 1;
        }
        return 0;
    }

    private static boolean isSolid(Material material) {
        return material.isSolid() && material.blocksMovement();
    }

    private static Block getBlock(int i, int j_offset, int k) {
        return world.getBlock(i, local_offset + j_offset, k);
    }

    private static int getBlockMetadata(int i, int j_offset, int k) {
        return world.getBlockMetadata(i, local_offset + j_offset, k);
    }

    private static TileEntity getBlockTileEntity(int i, int j_offset, int k) {
        return world.getTileEntity(i, local_offset + j_offset, k);
    }

    private static Block getBaseBlockId(int j_offset) {
        return world.getBlock(base_i, local_offset + j_offset, base_k);
    }

    private static int getBaseBlockMetadata(int j_offset) {
        return world.getBlockMetadata(base_i, local_offset + j_offset, base_k);
    }

    private static TileEntity getBaseBlockTileEntity(int j_offset) {
        return world.getTileEntity(base_i, local_offset + j_offset, base_k);
    }

    private static boolean isBaseBlockOfType(int j_offset, Class<?> ... types) {
        return Orientation.isBlockIdOfType(Orientation.getBaseBlockId(j_offset), types);
    }

    private static boolean isRemoteBlockOfType(int j_offset, Class<?> ... types) {
        return Orientation.isBlockIdOfType(Orientation.getRemoteBlockId(j_offset), types);
    }

    private static boolean isBlockIdOfType(Block block, Class<?> ... types) {
        if (types == null || block == null) {
            return false;
        }
        Class<?> blockType = block.getClass();
        for (Class<?> type : types) {
            if (!type.isAssignableFrom(blockType)) continue;
            return true;
        }
        return false;
    }

    private static Block getRemoteBlockId(int j_offset) {
        return world.getBlock(remote_i, local_offset + j_offset, remote_k);
    }

    private static int getRemoteBlockMetadata(int j_offset) {
        return world.getBlockMetadata(remote_i, local_offset + j_offset, remote_k);
    }

    private static boolean hasBlockName(Block block, String name) {
        String blockName = Orientation.getBlockName(block);
        return blockName != null && blockName.equals(name);
    }

    private static String getBlockName(Block block) {
        if (block == null) {
            return null;
        }
        return block.getUnlocalizedName();
    }

    private void initialize(World w, int i, double id, double jhd, int k, double kd) {
        world = w;
        base_i = i;
        base_id = id;
        base_jhd = jhd;
        base_k = k;
        base_kd = kd;
        remote_i = i + this._i;
        remote_k = k + this._k;
    }

    private static void initializeOffset(double offset_halfs, boolean isClimbCrawling, boolean isCrawlClimbing, boolean isCrawling) {
        crawl = isClimbCrawling || isCrawlClimbing || isCrawling;
        double offset_jhd = base_jhd + offset_halfs;
        int offset_jh = MathHelper.floor_double((double)offset_jhd);
        jh_offset = offset_jhd - (double)offset_jh;
        all_j = offset_jh / 2;
        all_offset = offset_jh % 2;
    }

    private static void initializeLocal(int localOffset) {
        local_halfOffset = localOffset + all_offset;
        local_half = Math.abs(local_halfOffset) % 2;
        local_offset = all_j + (local_halfOffset - local_half) / 2;
    }

    public String toString() {
        if (this == ZZ) {
            return "ZZ";
        }
        if (this == NZ) {
            return "NZ";
        }
        if (this == PZ) {
            return "PZ";
        }
        if (this == ZP) {
            return "ZP";
        }
        if (this == ZN) {
            return "ZN";
        }
        if (this == PN) {
            return "PN";
        }
        if (this == PP) {
            return "PP";
        }
        if (this == NN) {
            return "NN";
        }
        if (this == NP) {
            return "NP";
        }
        return "UNKNOWN(" + this._i + "," + this._k + ")";
    }

    static {
        Orthogonals.add(PZ);
        Orthogonals.add(ZP);
        Orthogonals.add(NZ);
        Orthogonals.add(ZN);
        _getClimbingOrientationsHashSet = null;
        _handClimbingHoldGap = Math.min(0.25f, 0.06f * Math.max(((Float)Orientation.Config._freeClimbingUpSpeedFactor.value).floatValue(), ((Float)Orientation.Config._freeClimbingDownSpeedFactor.value).floatValue()));
        _climbGapTemp = new ClimbGap();
        _climbGapOuterTemp = new ClimbGap();
        Class<?> modFenceBlock = Reflect.LoadClass(Block.class, SmartMovingInstall.ModBlockFence, false);
        _canConnectFenceTo = modFenceBlock != null ? Reflect.GetMethod(modFenceBlock, new Name("canConnectFenceTo"), false, IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE) : null;
        _blockCarpentersLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersBlockLadder, false);
        if (_blockCarpentersLadder != null) {
            Class<?> carpentersBlockProperties = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersBlockProperties, false);
            Class<?> carpentersTECarpentersBlock = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersTECarpentersBlock, false);
            Class<?> carpentersTEBaseBlock = Reflect.LoadClass(Block.class, SmartMovingInstall.CarpentersTEBaseBlock, false);
            _carpentersBlockPropertiesGetData = carpentersTECarpentersBlock != null ? Reflect.GetMethod(carpentersBlockProperties, SmartMovingInstall.CarpentersBlockProperties_getData, carpentersTECarpentersBlock) : (carpentersTEBaseBlock != null ? Reflect.GetMethod(carpentersBlockProperties, SmartMovingInstall.CarpentersBlockProperties_getData, carpentersTEBaseBlock) : null);
        } else {
            _carpentersBlockPropertiesGetData = null;
        }
        _knownFanceGateBlocks = new Block[]{Block.getBlockFromName((String)"fence_gate")};
        _knownFenceBlocks = new Block[]{Block.getBlockFromName((String)"fence"), Block.getBlockFromName((String)"nether_brick_fence")};
        _knownWallBlocks = new Block[]{Block.getBlockFromName((String)"cobblestone_wall")};
        _knownHalfBlocks = new Block[]{Block.getBlockFromName((String)"stone_slab"), Block.getBlockFromName((String)"double_stone_slab"), Block.getBlockFromName((String)"wooden_slab"), Block.getBlockFromName((String)"double_wooden_slab")};
        _knownCompactStairBlocks = new Block[]{Block.getBlockFromName((String)"stone_stairs"), Block.getBlockFromName((String)"oak_stairs"), Block.getBlockFromName((String)"dark_oak_stairs"), Block.getBlockFromName((String)"brick_stairs"), Block.getBlockFromName((String)"nether_brick_stairs"), Block.getBlockFromName((String)"sandstone_stairs"), Block.getBlockFromName((String)"stone_brick_stairs"), Block.getBlockFromName((String)"birch_stairs"), Block.getBlockFromName((String)"jungle_stairs"), Block.getBlockFromName((String)"spruce_stairs"), Block.getBlockFromName((String)"quartz_stairs"), Block.getBlockFromName((String)"acacia_stairs")};
        _knownTrapDoorBlocks = new Block[]{Block.getBlockFromName((String)"trapdoor")};
        _knownThinWallBlocks = new Block[]{Block.getBlockFromName((String)"iron_bars"), Block.getBlockFromName((String)"glass_pane")};
        Class<?> blockRopeLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.BlockRopeLadder, false);
        Class<?> blockSturdyLadder = Reflect.LoadClass(Block.class, SmartMovingInstall.BlockSturdyLadder, false);
        _ladderKitLadderTypes = blockRopeLadder != null ? (blockSturdyLadder != null ? new Class[]{blockRopeLadder, blockSturdyLadder} : new Class[]{blockRopeLadder}) : (blockSturdyLadder != null ? new Class[]{blockSturdyLadder} : null);
    }
}

