/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import cpw.mods.fml.common.FMLLog;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.MinecraftServer;
import net.smart.moving.SmartMovingClient;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingServer;
import net.smart.moving.config.SmartMovingClientConfig;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.moving.config.SmartMovingServerConfig;
import net.smart.moving.render.RenderPlayer;
import net.smart.render.SmartRenderContext;
import net.smart.render.statistics.SmartStatisticsContext;

public abstract class SmartMovingContext
extends SmartRenderContext {
    public static final float ClimbPullMotion = 0.3f;
    public static final double FastUpMotion = 0.2;
    public static final double MediumUpMotion = 0.14;
    public static final double SlowUpMotion = 0.1;
    public static final double HoldMotion = 0.08;
    public static final double SinkDownMotion = 0.05;
    public static final double ClimbDownMotion = 0.01;
    public static final double CatchCrawlGapMotion = 0.17;
    public static final float SwimCrawlWaterMaxBorder = 1.0f;
    public static final float SwimCrawlWaterTopBorder = 0.65f;
    public static final float SwimCrawlWaterMediumBorder = 0.6f;
    public static final float SwimCrawlWaterBottomBorder = 0.55f;
    public static final float HorizontalGroundDamping = 0.546f;
    public static final float HorizontalAirDamping = 0.91f;
    public static final float HorizontalAirodynamicDamping = 0.999f;
    public static final float SwimSoundDistance = 1.4285715f;
    public static final float SlideToHeadJumpingFallDistance = 0.05f;
    public static final SmartMovingClient Client = new SmartMovingClient();
    public static final SmartMovingOptions Options = new SmartMovingOptions();
    public static final SmartMovingServerConfig ServerConfig = new SmartMovingServerConfig();
    public static SmartMovingClientConfig Config = Options;
    private static boolean wasInitialized;
    private static Set<String> translateKeys;
    private static MinecraftServer lastMinecraftServer;

    public static void onTickInGame() {
        Minecraft minecraft = Minecraft.getMinecraft();
        if (minecraft.theWorld != null && minecraft.theWorld.isRemote) {
            SmartMovingFactory.handleMultiPlayerTick(minecraft);
        }
        Options.initializeForGameIfNeccessary();
        SmartMovingContext.initializeServerIfNecessary();
    }

    public static void initialize(GameSettings gameSettings) {
        if (!wasInitialized) {
            SmartStatisticsContext.setCalculateHorizontalStats((boolean)true);
        }
        KeyBinding[] previous = gameSettings.keyBindings;
        gameSettings.keyBindings = new KeyBinding[previous.length + 5];
        KeyBinding[] current = gameSettings.keyBindings;
        int i = 0;
        int n = 0;
        while (i < previous.length) {
            KeyBinding binding = previous[i];
            if (binding == gameSettings.keyBindSneak) {
                current[n++] = gameSettings.keyBindSneak;
                current[n++] = SmartMovingContext.Options.keyBindGrab;
                current[n++] = SmartMovingContext.Options.keyBindSprint;
                current[n++] = SmartMovingContext.Options.keyBindConfigToggle;
                current[n++] = SmartMovingContext.Options.keyBindSpeedIncrease;
                current[n] = SmartMovingContext.Options.keyBindSpeedDecrease;
            } else {
                current[n] = binding;
            }
            ++i;
            ++n;
        }
        if (wasInitialized) {
            return;
        }
        wasInitialized = true;
        System.out.println("Smart Moving uses communication protocol 2.3");
        FMLLog.getLogger().info("Smart Moving uses communication protocol 2.3");
    }

    public static void initializeServerIfNecessary() {
        MinecraftServer currentMinecraftServer = MinecraftServer.getServer();
        if (currentMinecraftServer != null && currentMinecraftServer != lastMinecraftServer) {
            SmartMovingServer.initialize(SmartMovingOptions.optionsPath, FMLLog.getLogger(), currentMinecraftServer.getGameType().getID(), Options);
        }
        lastMinecraftServer = currentMinecraftServer;
    }

    public static void registerRenderers() {
        SmartMovingContext.registerRenderers(RenderPlayer.class);
    }

    static {
        lastMinecraftServer = null;
    }
}

