/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.Hashtable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.SmartMoving;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.SmartMovingOther;

public class SmartMovingFactory
extends SmartMovingContext {
    private static SmartMovingFactory factory;
    private Hashtable<Integer, SmartMovingOther> otherSmartMovings;

    public SmartMovingFactory() {
        if (factory != null) {
            throw new RuntimeException("FATAL: Can only create one instance of type 'SmartMovingFactory'");
        }
        factory = this;
    }

    protected static boolean isInitialized() {
        return factory != null;
    }

    public static void initialize() {
        if (!SmartMovingFactory.isInitialized()) {
            new SmartMovingFactory();
        }
    }

    public static void handleMultiPlayerTick(Minecraft minecraft) {
        factory.doHandleMultiPlayerTick(minecraft);
    }

    public static SmartMoving getInstance(EntityPlayer entityPlayer) {
        return factory.doGetInstance(entityPlayer);
    }

    public static SmartMoving getOtherSmartMoving(int entityId) {
        return factory.doGetOtherSmartMoving(entityId);
    }

    public static SmartMovingOther getOtherSmartMoving(EntityOtherPlayerMP entity) {
        return factory.doGetOtherSmartMoving(entity);
    }

    protected void doHandleMultiPlayerTick(Minecraft minecraft) {
        SmartMovingOther moving;
        for (Entity player : minecraft.theWorld.playerEntities) {
            if (!(player instanceof EntityOtherPlayerMP)) continue;
            EntityOtherPlayerMP otherPlayer = (EntityOtherPlayerMP)player;
            moving = this.doGetOtherSmartMoving(otherPlayer);
            moving.spawnParticles(minecraft, otherPlayer.posX - otherPlayer.prevPosX, otherPlayer.posZ - otherPlayer.prevPosZ);
            moving.foundAlive = true;
        }
        if (this.otherSmartMovings == null || this.otherSmartMovings.isEmpty()) {
            return;
        }
        Iterator<Integer> entityIds = this.otherSmartMovings.keySet().iterator();
        while (entityIds.hasNext()) {
            Integer entityId = entityIds.next();
            moving = this.otherSmartMovings.get(entityId);
            if (moving.foundAlive) {
                moving.foundAlive = false;
                continue;
            }
            entityIds.remove();
        }
    }

    protected SmartMoving doGetInstance(EntityPlayer entityPlayer) {
        if (entityPlayer instanceof EntityOtherPlayerMP) {
            return this.doGetOtherSmartMoving(entityPlayer.getEntityId());
        }
        if (entityPlayer instanceof IEntityPlayerSP) {
            return ((IEntityPlayerSP)entityPlayer).getMoving();
        }
        return null;
    }

    protected SmartMoving doGetOtherSmartMoving(int entityId) {
        Entity entity;
        SmartMovingOther moving = this.tryGetOtherSmartMoving(entityId);
        if (moving == null && (entity = Minecraft.getMinecraft().theWorld.getEntityByID(entityId)) != null && entity instanceof EntityOtherPlayerMP) {
            moving = this.addOtherSmartMoving((EntityOtherPlayerMP)entity);
        }
        return moving;
    }

    protected SmartMovingOther doGetOtherSmartMoving(EntityOtherPlayerMP entity) {
        SmartMovingOther moving = this.tryGetOtherSmartMoving(entity.getEntityId());
        if (moving == null) {
            moving = this.addOtherSmartMoving(entity);
        }
        return moving;
    }

    protected final SmartMovingOther tryGetOtherSmartMoving(int entityId) {
        if (this.otherSmartMovings == null) {
            this.otherSmartMovings = new Hashtable();
        }
        return this.otherSmartMovings.get(entityId);
    }

    protected final SmartMovingOther addOtherSmartMoving(EntityOtherPlayerMP entity) {
        SmartMovingOther moving = new SmartMovingOther(entity);
        this.otherSmartMovings.put(entity.getEntityId(), moving);
        return moving;
    }
}

