/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.playerapi;

import api.player.server.IServerPlayerAPI;
import api.player.server.ServerPlayerAPI;
import api.player.server.ServerPlayerBase;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.SmartMovingInstall;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.SmartMovingServer;
import net.smart.utilities.Reflect;

public class SmartMovingServerPlayerBase
extends ServerPlayerBase
implements IEntityPlayerMP {
    public final SmartMovingServer moving = new SmartMovingServer(this, false);

    public static void registerPlayerBase() {
        ServerPlayerAPI.register((String)"Smart Moving", SmartMovingServerPlayerBase.class);
    }

    public static SmartMovingServerPlayerBase getPlayerBase(Object player) {
        return (SmartMovingServerPlayerBase)((IServerPlayerAPI)player).getServerPlayerBase("Smart Moving");
    }

    public SmartMovingServerPlayerBase(ServerPlayerAPI playerApi) {
        super(playerApi);
    }

    @Override
    public float getHeight() {
        return this.player.height;
    }

    @Override
    public double getMinY() {
        return this.player.boundingBox.minY;
    }

    @Override
    public void setMaxY(double maxY) {
        this.player.boundingBox.maxY = maxY;
    }

    public void afterSetPosition(double d, double d1, double d2) {
        this.moving.afterSetPosition(d, d1, d2);
    }

    public void beforeIsPlayerSleeping() {
        this.moving.beforeIsPlayerSleeping();
    }

    public void beforeOnUpdate() {
        this.moving.beforeOnUpdate();
    }

    public void afterOnUpdate() {
        this.moving.afterOnUpdate();
    }

    public void beforeOnLivingUpdate() {
        this.moving.beforeOnLivingUpdate();
    }

    public void afterOnLivingUpdate() {
        this.moving.afterOnLivingUpdate();
    }

    @Override
    public float doGetHealth() {
        return this.player.getHealth();
    }

    @Override
    public AxisAlignedBB getBox() {
        return this.player.boundingBox;
    }

    @Override
    public AxisAlignedBB expandBox(AxisAlignedBB box, double x, double y, double z) {
        return box.expand(x, y, z);
    }

    @Override
    public List getEntitiesExcludingPlayer(AxisAlignedBB box) {
        return this.player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.player, box);
    }

    @Override
    public boolean isDeadEntity(Entity entity) {
        return entity.isDead;
    }

    @Override
    public void onCollideWithPlayer(Entity entity) {
        entity.onCollideWithPlayer((EntityPlayer)this.player);
    }

    public float getEyeHeight() {
        return this.player.height - 0.18f;
    }

    public boolean isEntityInsideOpaqueBlock() {
        return this.moving.isEntityInsideOpaqueBlock();
    }

    @Override
    public boolean localIsEntityInsideOpaqueBlock() {
        return super.isEntityInsideOpaqueBlock();
    }

    public void addExhaustion(float exhaustion) {
        this.moving.addExhaustion(exhaustion);
    }

    @Override
    public void localAddExhaustion(float exhaustion) {
        super.addExhaustion(exhaustion);
    }

    public void addMovementStat(double x, double y, double z) {
        this.moving.addMovementStat(x, y, z);
    }

    @Override
    public void localAddMovementStat(double x, double y, double z) {
        super.addMovementStat(x, y, z);
    }

    @Override
    public void localPlaySound(String soundId, float volume, float pitch) {
        this.player.playSound(soundId, volume, pitch);
    }

    public void beforeUpdatePotionEffects() {
        this.moving.afterAddMovingHungerBatch();
    }

    public void afterUpdatePotionEffects() {
        this.moving.beforeAddMovingHungerBatch();
    }

    @Override
    public void setHeight(float height) {
        this.player.height = height;
    }

    @Override
    public void sendPacket(byte[] data) {
        this.sendPacket(new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])data), SmartMovingPacketStream.Id));
    }

    public void sendPacket(FMLProxyPacket packet) {
        this.player.playerNetServerHandler.sendPacket((Packet)packet);
    }

    @Override
    public String getUsername() {
        return this.player.getGameProfile().getName();
    }

    @Override
    public void resetFallDistance() {
        this.player.fallDistance = 0.0f;
        this.player.motionY = 0.08;
    }

    @Override
    public void resetTicksForFloatKick() {
        Reflect.SetField(NetHandlerPlayServer.class, this.player.playerNetServerHandler, SmartMovingInstall.NetServerHandler_ticksForFloatKick, 0);
    }

    @Override
    public void sendPacketToTrackedPlayers(FMLProxyPacket packet) {
        this.player.mcServer.worldServerForDimension(this.player.dimension).getEntityTracker().func_151247_a((Entity)this.player, (Packet)packet);
    }

    @Override
    public SmartMovingServer getMoving() {
        return this.moving;
    }

    @Override
    public IEntityPlayerMP[] getAllPlayers() {
        List playerEntityList = this.player.mcServer.getConfigurationManager().playerEntityList;
        IEntityPlayerMP[] result = new IEntityPlayerMP[playerEntityList.size()];
        for (int i = 0; i < playerEntityList.size(); ++i) {
            result[i] = (IEntityPlayerMP)((IServerPlayerAPI)playerEntityList.get(i)).getServerPlayerBase("Smart Moving");
        }
        return result;
    }
}

