/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render.statistics;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.smart.render.statistics.SmartStatisticsContext;
import net.smart.render.statistics.SmartStatisticsDatas;

public class SmartStatistics
extends SmartStatisticsContext {
    private final EntityPlayer sp;
    private float tickDistance;
    public int ticksRiding;
    public float prevHorizontalAngle = Float.NaN;
    private static final SmartStatisticsDatas dummy = new SmartStatisticsDatas();
    private final SmartStatisticsDatas[] datas = new SmartStatisticsDatas[10];
    private int currentDataIndex = -1;

    public SmartStatistics(EntityPlayer sp) {
        this.sp = sp;
    }

    public void calculateAllStats() {
        SmartStatisticsDatas data;
        double diffX = this.sp.posX - this.sp.prevPosX;
        double diffY = this.sp.posY - this.sp.prevPosY;
        double diffZ = this.sp.posZ - this.sp.prevPosZ;
        SmartStatisticsDatas previous = this.get();
        ++this.currentDataIndex;
        if (this.currentDataIndex >= this.datas.length) {
            this.currentDataIndex = 0;
        }
        if ((data = this.datas[this.currentDataIndex]) == null) {
            data = this.datas[this.currentDataIndex] = new SmartStatisticsDatas();
        }
        data.initialize(previous);
        data.horizontal.calcualte(MathHelper.sqrt_double((double)(diffX * diffX + diffZ * diffZ)));
        data.vertical.calcualte((float)Math.abs(diffY));
        this.tickDistance = data.all.calcualte(MathHelper.sqrt_double((double)(diffX * diffX + diffY * diffY + diffZ * diffZ)));
        if (calculateHorizontalStats) {
            data.horizontal.apply(this.sp);
        }
    }

    public void calculateRiddenStats() {
        ++this.ticksRiding;
    }

    public float getHorizontalPrevLegYaw() {
        return this.sp.prevLimbSwingAmount;
    }

    public float getHorizontalLegYaw() {
        return this.sp.limbSwingAmount;
    }

    public float getHorizontalTotal() {
        return this.sp.limbSwing;
    }

    public float getVerticalPrevLegYaw() {
        return this.datas[this.currentDataIndex].vertical.prevLegYaw;
    }

    public float getVerticalLegYaw() {
        return this.datas[this.currentDataIndex].vertical.legYaw;
    }

    public float getVerticalTotal() {
        return this.datas[this.currentDataIndex].vertical.total;
    }

    public float getAllPrevLegYaw() {
        return this.datas[this.currentDataIndex].all.prevLegYaw;
    }

    public float getAllLegYaw() {
        return this.datas[this.currentDataIndex].all.legYaw;
    }

    public float getAllTotal() {
        return this.datas[this.currentDataIndex].all.total;
    }

    public float getTickDistance() {
        return this.tickDistance;
    }

    public float getTotalHorizontalDistance(float renderPartialTicks) {
        return this.get(renderPartialTicks).getTotalHorizontalDistance();
    }

    public float getTotalVerticalDistance(float renderPartialTicks) {
        return this.get(renderPartialTicks).getTotalVerticalDistance();
    }

    public float getTotalDistance(float renderPartialTicks) {
        return this.get(renderPartialTicks).getTotalDistance();
    }

    public float getCurrentHorizontalSpeed(float renderPartialTicks) {
        return this.get(renderPartialTicks).getCurrentHorizontalSpeed();
    }

    public float getCurrentVerticalSpeed(float renderPartialTicks) {
        return this.get(renderPartialTicks).getCurrentVerticalSpeed();
    }

    public float getCurrentSpeed(float renderPartialTicks) {
        return this.get(renderPartialTicks).getCurrentSpeed();
    }

    private SmartStatisticsDatas get() {
        return this.currentDataIndex == -1 ? dummy : this.datas[this.currentDataIndex];
    }

    private SmartStatisticsDatas get(float renderPartialTicks) {
        SmartStatisticsDatas data = this.get();
        data.setReady(renderPartialTicks);
        return data;
    }

    public float getCurrentHorizontalSpeedFlattened(float renderPartialTicks, int strength) {
        if ((strength = Math.min(strength, this.datas.length)) < 0) {
            strength = this.datas.length;
        }
        this.get(renderPartialTicks);
        float sum = 0.0f;
        int count = 0;
        int i = 0;
        int dataIndex = this.currentDataIndex;
        while (i < strength) {
            SmartStatisticsDatas data;
            if (dataIndex < 0) {
                dataIndex = this.datas.length - 1;
            }
            if ((data = this.datas[dataIndex]) == null || !data.isReady()) break;
            sum += data.getCurrentHorizontalSpeed();
            ++count;
            ++i;
            --dataIndex;
        }
        return sum / (float)count;
    }

    public float getCurrentVerticalSpeedFlattened(float renderPartialTicks, int strength) {
        if ((strength = Math.min(strength, this.datas.length)) < 0) {
            strength = this.datas.length;
        }
        this.get(renderPartialTicks);
        float sum = 0.0f;
        int count = 0;
        int i = 0;
        int dataIndex = this.currentDataIndex;
        while (i < strength) {
            SmartStatisticsDatas data;
            if (dataIndex < 0) {
                dataIndex = this.datas.length - 1;
            }
            if ((data = this.datas[dataIndex]) == null || !data.isReady()) break;
            sum += data.getCurrentVerticalSpeed();
            ++count;
            ++i;
            --dataIndex;
        }
        return sum / (float)count;
    }

    public float getCurrentSpeedFlattened(float renderPartialTicks, int strength) {
        if ((strength = Math.min(strength, this.datas.length)) < 0) {
            strength = this.datas.length;
        }
        this.get(renderPartialTicks);
        float sum = 0.0f;
        int count = 0;
        int i = 0;
        int dataIndex = this.currentDataIndex;
        while (i < strength) {
            SmartStatisticsDatas data;
            if (dataIndex < 0) {
                dataIndex = this.datas.length - 1;
            }
            if ((data = this.datas[dataIndex]) == null || !data.isReady()) break;
            sum += data.getCurrentSpeed();
            ++count;
            ++i;
            --dataIndex;
        }
        return sum / (float)count;
    }
}

