/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.smart.moving.ISmartMovingClient;
import net.smart.moving.SmartMovingContext;

public class SmartMovingClient
extends SmartMovingContext
implements ISmartMovingClient {
    private final Map<String, Float> maximumExhaustionValues = new HashMap<String, Float>();
    private boolean nativeUserInterfaceDrawing = true;

    @Override
    public float getMaximumExhaustion() {
        float maxExhaustion = Config.getMaxExhaustion();
        if (this.maximumExhaustionValues.size() > 0) {
            Iterator<Float> iterator = this.maximumExhaustionValues.values().iterator();
            while (iterator.hasNext()) {
                maxExhaustion = Math.max(iterator.next().floatValue(), maxExhaustion);
            }
        }
        return maxExhaustion;
    }

    @Override
    public float getMaximumUpJumpCharge() {
        return ((Float)SmartMovingClient.Config._jumpChargeMaximum.value).floatValue();
    }

    @Override
    public float getMaximumHeadJumpCharge() {
        return ((Float)SmartMovingClient.Config._headJumpChargeMaximum.value).floatValue();
    }

    @Override
    public void setMaximumExhaustionValue(String key, float value) {
        this.maximumExhaustionValues.put(key, Float.valueOf(value));
    }

    @Override
    public float getMaximumExhaustionValue(String key) {
        return this.maximumExhaustionValues.get(key).floatValue();
    }

    @Override
    public boolean removeMaximumExhaustionValue(String key) {
        return this.maximumExhaustionValues.remove(key) != null;
    }

    @Override
    public void setNativeUserInterfaceDrawing(boolean value) {
        this.nativeUserInterfaceDrawing = value;
    }

    @Override
    public boolean getNativeUserInterfaceDrawing() {
        return this.nativeUserInterfaceDrawing;
    }
}

