package net.smart.core;

import java.io.*;

import org.objectweb.asm.*;

public final class NetServerHandlerClassVisitor extends ClassVisitor
{
	public static final String targetClassName = "net.minecraft.network.NetHandlerPlayServer";

	public static byte[] transform(byte[] bytes, boolean isObfuscated)
	{
		try
		{
			ByteArrayInputStream in = new ByteArrayInputStream(bytes);
			ClassReader cr = new ClassReader(in);
			ClassWriter cw = new ClassWriter(ClassWriter.COMPUTE_MAXS);
			NetServerHandlerClassVisitor p = new NetServerHandlerClassVisitor(cw, isObfuscated);

			cr.accept(p, 0);

			byte[] result = cw.toByteArray();
			in.close();
			return result;
		}
		catch(IOException ioe)
		{
			throw new RuntimeException(ioe);
		}
	}

	private final boolean isObfuscated;

	public NetServerHandlerClassVisitor(ClassVisitor classVisitor, boolean isObfuscated)
	{
		super(262144, classVisitor);
		this.isObfuscated = isObfuscated;
	}
 
	@Override
	public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions)
	{
		MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);

		if(name.equals(isObfuscated ? "a" : "processPlayer") && desc.equals(isObfuscated ? "(Lir;)V" : "(Lnet/minecraft/network/play/client/C03PacketPlayer;)V"))
			return new NetServerHandlerMethodVisitor(base, isObfuscated, "HandleFlying", isObfuscated ? "Lir;" : "Lnet/minecraft/network/play/client/C03PacketPlayer;");

		if(name.equals(isObfuscated ? "a" : "processPlayerBlockPlacement") && desc.equals(isObfuscated ? "(Ljc;)V" : "(Lnet/minecraft/network/play/client/C08PacketPlayerBlockPlacement;)V"))
			return new NetServerHandlerMethodVisitor(base, isObfuscated, "HandlePlace", isObfuscated ? "Ljc;" : "Lnet/minecraft/network/play/client/C08PacketPlayerBlockPlacement;");

		return base;
	}
}

