package net.smart.core;

import org.objectweb.asm.*;

public class NetServerHandlerMethodVisitor extends MethodVisitor
{
	private final boolean isObfuscated;
	private final String namePostfix;
	private final String eventDesc;

	public NetServerHandlerMethodVisitor(MethodVisitor paramMethodVisitor, boolean isObfuscated, String name, String paramDesc)
	{
		super(262144, paramMethodVisitor);
		this.isObfuscated = isObfuscated;
		this.namePostfix = "NetServerHandler" + name + "Hook";
		this.eventDesc = (isObfuscated ? "(Lmx;" : "(Lnet/minecraft/network/NetHandlerPlayServer;") + paramDesc + ")V";

		mv.visitVarInsn(Opcodes.ALOAD, 0);
		mv.visitIntInsn(Opcodes.ALOAD, 1);
		mv.visitMethodInsn(Opcodes.INVOKESTATIC, "net/smart/core/SmartCoreEventHandler", "before" + namePostfix, eventDesc);
	}

	public void visitInsn(int opcode)
	{
		if(opcode == Opcodes.RETURN)
		{
			mv.visitVarInsn(Opcodes.ALOAD, 0);
			mv.visitIntInsn(Opcodes.ALOAD, 1);
			mv.visitMethodInsn(Opcodes.INVOKESTATIC, "net/smart/core/SmartCoreEventHandler", "after" + namePostfix, eventDesc);
		}
		super.visitInsn(opcode);
	}
}