/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.client.particle.EntitySplashFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.SmartMovingBase;
import net.smart.render.SmartRenderRender;

public abstract class SmartMoving
extends SmartMovingBase {
    public boolean isSlow;
    public boolean isFast;
    public boolean isClimbing;
    public boolean isHandsVineClimbing;
    public boolean isFeetVineClimbing;
    public boolean isClimbJumping;
    public boolean isClimbBackJumping;
    public boolean isWallJumping;
    public boolean isClimbCrawling;
    public boolean isCrawlClimbing;
    public boolean isCeilingClimbing;
    public boolean isRopeSliding;
    public boolean isDipping;
    public boolean isSwimming;
    public boolean isDiving;
    public boolean isLevitating;
    public boolean isHeadJumping;
    public boolean isCrawling;
    public boolean isSliding;
    public boolean isFlying;
    public int actualHandsClimbType;
    public int actualFeetClimbType;
    public int angleJumpType;
    public float heightOffset;
    private float spawnSlindingParticle;
    private float spawnSwimmingParticle;

    public SmartMoving(EntityPlayer sp, IEntityPlayerSP isp) {
        super(sp, isp);
    }

    public boolean isAngleJumping() {
        return this.angleJumpType > 1 && this.angleJumpType < 7;
    }

    public abstract boolean isJumping();

    public abstract boolean doFlyingAnimation();

    public abstract boolean doFallingAnimation();

    protected void spawnParticles(Minecraft minecraft, double playerMotionX, double playerMotionZ) {
        int k;
        int j;
        int i;
        Block block;
        float horizontalSpeedSquare = 0.0f;
        if (this.isSliding || this.isSwimming) {
            horizontalSpeedSquare = (float)(playerMotionX * playerMotionX + playerMotionZ * playerMotionZ);
        }
        if (this.isSliding && (block = this.sp.worldObj.getBlock(i = MathHelper.floor_double((double)this.sp.posX), j = MathHelper.floor_double((double)(this.sp.boundingBox.minY - (double)0.1f)), k = MathHelper.floor_double((double)this.sp.posZ))) != null) {
            double posY = this.sp.boundingBox.minY + 0.1;
            double motionX = -playerMotionX * 4.0;
            double motionY = 1.5;
            double motionZ = -playerMotionZ * 4.0;
            this.spawnSlindingParticle += horizontalSpeedSquare;
            float maxSpawnSlindingParticle = ((Float)SmartMoving.Config._slideParticlePeriodFactor.value).floatValue() * 0.1f;
            while (this.spawnSlindingParticle > maxSpawnSlindingParticle) {
                double posX = this.sp.posX + (double)this.getSpawnOffset();
                double posZ = this.sp.posZ + (double)this.getSpawnOffset();
                int metaData = this.sp.worldObj.getBlockMetadata(i, j, k);
                this.sp.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + metaData, posX, posY, posZ, motionX, motionY, motionZ);
                this.spawnSlindingParticle -= maxSpawnSlindingParticle;
            }
        }
        if (this.isSwimming) {
            int k2;
            int j2;
            float posY = (float)MathHelper.floor_double((double)this.sp.boundingBox.minY) + 1.0f;
            int i2 = (int)Math.floor(this.sp.posX);
            Block block2 = this.sp.worldObj.getBlock(i2, j2 = (int)Math.floor((double)posY - 0.5), k2 = (int)Math.floor(this.sp.posZ));
            boolean isLava = block2 != null && this.isLava(block2);
            this.spawnSwimmingParticle += horizontalSpeedSquare;
            float maxSpawnSwimmingParticle = (isLava ? (Float)SmartMoving.Config._lavaSwimParticlePeriodFactor.value : (Float)SmartMoving.Config._swimParticlePeriodFactor.value).floatValue() * 0.01f;
            while (this.spawnSwimmingParticle > maxSpawnSwimmingParticle) {
                double posX = this.sp.posX + (double)this.getSpawnOffset();
                double posZ = this.sp.posZ + (double)this.getSpawnOffset();
                EntityLavaFX splash = isLava ? new EntityLavaFX(this.sp.worldObj, posX, (double)posY, posZ) : new EntitySplashFX(this.sp.worldObj, posX, (double)posY, posZ, 0.0, 0.0, 0.0);
                splash.motionX = 0.0;
                splash.motionY = 0.2;
                splash.motionZ = 0.0;
                minecraft.effectRenderer.addEffect((EntityFX)splash);
                this.spawnSwimmingParticle -= maxSpawnSwimmingParticle;
            }
        }
    }

    private float getSpawnOffset() {
        return (this.sp.getRNG().nextFloat() - 0.5f) * 2.0f * this.sp.width;
    }

    protected void onStartClimbBackJump() {
        SmartRenderRender.getPreviousRendererData((EntityPlayer)this.sp).rotateAngleY = SmartRenderRender.getPreviousRendererData((EntityPlayer)this.sp).rotateAngleY + (this.isHeadJumping ? (float)Math.PI : 1.5707964f);
        this.isClimbBackJumping = true;
    }

    protected void onStartWallJump(Float angle) {
        if (angle != null) {
            SmartRenderRender.getPreviousRendererData((EntityPlayer)this.sp).rotateAngleY = angle.floatValue() / 57.295776f;
        }
        this.isWallJumping = true;
        this.sp.fallDistance = 0.0f;
    }
}

