package net.smart.core;

import java.util.*;

import net.minecraft.network.*;
import net.minecraft.network.play.client.*;

public class SmartCoreEventHandler
{
	private final static Set<SmartCoreEventHandler> handlers = new HashSet<SmartCoreEventHandler>();

	public static void Add(SmartCoreEventHandler handler)
	{
		handlers.add(handler);
	}

	public static void Remove(SmartCoreEventHandler handler)
	{
		handlers.remove(handler);
	}

	public static void beforeNetServerHandlerHandleFlyingHook(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
		for(SmartCoreEventHandler eventHandler : handlers)
			eventHandler.beforeNetServerHandlerHandleFlying(netServerHandler, packet10Flying);
	}

	public static void afterNetServerHandlerHandleFlyingHook(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
		for(SmartCoreEventHandler eventHandler : handlers)
			eventHandler.afterNetServerHandlerHandleFlying(netServerHandler, packet10Flying);
	}

	public static void beforeNetServerHandlerHandlePlaceHook(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
		for(SmartCoreEventHandler eventHandler : handlers)
			eventHandler.beforeNetServerHandlerHandlePlace(netServerHandler, packet15place);
	}

	public static void afterNetServerHandlerHandlePlaceHook(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
		for(SmartCoreEventHandler eventHandler : handlers)
			eventHandler.afterNetServerHandlerHandlePlace(netServerHandler, packet15place);
	}

	public void beforeNetServerHandlerHandleFlying(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
	}

	public void afterNetServerHandlerHandleFlying(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
	}

	public void beforeNetServerHandlerHandlePlace(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
	}

	public void afterNetServerHandlerHandlePlace(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
	}
}