package net.smart.render;

import java.lang.reflect.*;

import cpw.mods.fml.common.*;
import cpw.mods.fml.common.Mod.*;
import cpw.mods.fml.common.event.*;
import cpw.mods.fml.common.eventhandler.*;
import cpw.mods.fml.common.gameevent.TickEvent.*;

import net.smart.render.statistics.*;
import net.smart.utilities.*;

@Mod(modid = SmartRenderInfo.ModId, name = SmartRenderInfo.ModName, version = SmartRenderInfo.ModVersion)
public class SmartRenderMod
{
	private final boolean isClient;

	private static boolean addRenderer = true;

	private boolean hasRenderer = false;

	public SmartRenderMod()
	{
		Assert.clientPlayerAPI(SmartRenderInfo.ModName);

		isClient = FMLCommonHandler.instance().getSide().isClient();
	}

	public static void doNotAddRenderer()
	{
		addRenderer = false;
	}

	@EventHandler
	public void init(FMLInitializationEvent event)
	{
		if(!isClient)
			return;

		hasRenderer = Assert.hasRenderPlayerAPI;

		net.smart.render.statistics.playerapi.SmartStatistics.register();

		if(hasRenderer)
		{
			Class<?> type = Reflect.LoadClass(SmartRenderMod.class, new Name("net.smart.render.playerapi.SmartRender"), true);
			Method method = Reflect.GetMethod(type, new Name("register"));
			Reflect.Invoke(method, null);
		}

		if(!hasRenderer && addRenderer)
			SmartRenderContext.registerRenderers(null);

		net.smart.render.statistics.playerapi.SmartStatisticsFactory.initialize();

		FMLCommonHandler.instance().bus().register(this);
	}

	@SubscribeEvent
	public void tickStart(ClientTickEvent event)
	{
		SmartStatisticsContext.onTickInGame();
	}
}