package net.smart.moving;

import java.util.*;

import cpw.mods.fml.common.*;

import net.minecraft.client.*;
import net.minecraft.client.settings.*;
import net.minecraft.server.*;

import net.smart.moving.config.*;
import net.smart.render.*;

public abstract class SmartMovingContext extends SmartRenderContext
{
	public static final float ClimbPullMotion = 0.3F;

	public static final double FastUpMotion = 0.2D;
	public static final double MediumUpMotion = 0.14D;
	public static final double SlowUpMotion = 0.1D;
	public static final double HoldMotion = 0.08D;
	public static final double SinkDownMotion = 0.05D;
	public static final double ClimbDownMotion = 0.01D;
	public static final double CatchCrawlGapMotion = 0.17D;

	public static final float SwimCrawlWaterMaxBorder = 1F;
	public static final float SwimCrawlWaterTopBorder = 0.65F;
	public static final float SwimCrawlWaterMediumBorder = 0.6F;
	public static final float SwimCrawlWaterBottomBorder = 0.55F;

	public static final float HorizontalGroundDamping = 0.546F;
	public static final float HorizontalAirDamping = 0.91F;
	public static final float HorizontalAirodynamicDamping = 0.999F;

	public static final float SwimSoundDistance = 1F / 0.7F;
	public static final float SlideToHeadJumpingFallDistance = 0.05F;


	public static final SmartMovingClient Client = new SmartMovingClient();
	public static final SmartMovingOptions Options = new SmartMovingOptions();
	public static final SmartMovingServerConfig ServerConfig = new SmartMovingServerConfig();
	public static SmartMovingClientConfig Config = Options;


	private static boolean wasInitialized;
	private static Set<String> translateKeys;

	public static void onTickInGame()
	{
		Minecraft minecraft = Minecraft.getMinecraft();

		if(minecraft.theWorld != null && minecraft.theWorld.isRemote)
			SmartMovingFactory.handleMultiPlayerTick(minecraft);

		Options.initializeForGameIfNeccessary();

		initializeServerIfNecessary();
	}

	public static void initialize(GameSettings gameSettings)
	{
		if(!wasInitialized)
			net.smart.render.statistics.SmartStatisticsContext.setCalculateHorizontalStats(true);

		KeyBinding[] previous = gameSettings.keyBindings;
		KeyBinding[] current = gameSettings.keyBindings = new KeyBinding[previous.length + 5];

		for(int i = 0, n = 0; i < previous.length; i++, n++)
		{
			KeyBinding binding = previous[i];
			if(binding == gameSettings.keyBindSneak)
			{
				current[n++] = gameSettings.keyBindSneak;
				current[n++] = Options.keyBindGrab;
				current[n++] = Options.keyBindSprint;
				current[n++] = Options.keyBindConfigToggle;
				current[n++] = Options.keyBindSpeedIncrease;
				current[n] = Options.keyBindSpeedDecrease;
			}
			else
				current[n] = binding;
		}

		if(wasInitialized)
			return;

		wasInitialized = true;

		System.out.println(SmartMovingInfo.ModComMessage);
		FMLLog.getLogger().info(SmartMovingInfo.ModComMessage);
	}

	public static void initializeServerIfNecessary()
	{
		MinecraftServer currentMinecraftServer = MinecraftServer.getServer();
		if(currentMinecraftServer != null && currentMinecraftServer != lastMinecraftServer)
			SmartMovingServer.initialize(SmartMovingOptions.optionsPath, FMLLog.getLogger(), currentMinecraftServer.getGameType().getID(), Options);
		lastMinecraftServer = currentMinecraftServer;
	}

	public static void registerRenderers()
	{
		registerRenderers(net.smart.moving.render.RenderPlayer.class);
	}

	private static MinecraftServer lastMinecraftServer = null;
}
