package net.smart.moving;

import net.minecraft.item.*;
import net.minecraft.network.*;
import net.minecraft.network.play.client.*;

import net.smart.core.*;
import net.smart.moving.playerapi.*;

public class SmartMovingCoreEventHandler extends SmartCoreEventHandler
{
	@Override
	public void beforeNetServerHandlerHandleFlying(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
		SmartMovingServerPlayerBase playerBase = SmartMovingServerPlayerBase.getPlayerBase(netServerHandler.playerEntity);
		playerBase.moving.beforeAddMovingHungerBatch();
	}

	@Override
	public void afterNetServerHandlerHandleFlying(NetHandlerPlayServer netServerHandler, C03PacketPlayer packet10Flying)
	{
		SmartMovingServerPlayerBase playerBase = SmartMovingServerPlayerBase.getPlayerBase(netServerHandler.playerEntity);
		playerBase.moving.afterAddMovingHungerBatch();
	}

	@Override
	public void beforeNetServerHandlerHandlePlace(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
		if (packet15place.func_149568_f() == 255)
		{
			ItemStack itemstack = netServerHandler.playerEntity.inventory.getCurrentItem();
			if (itemstack != null)
			{
				float offset = 1.62F - netServerHandler.playerEntity.getEyeHeight();
				netServerHandler.playerEntity.yOffset += offset;
			}
		}
	}

	@Override
	public void afterNetServerHandlerHandlePlace(NetHandlerPlayServer netServerHandler, C08PacketPlayerBlockPlacement packet15place)
	{
		if (packet15place.func_149568_f() == 255)
		{
			ItemStack itemstack = netServerHandler.playerEntity.inventory.getCurrentItem();
			if (itemstack != null)
			{
				float offset = 1.62F - netServerHandler.playerEntity.getEyeHeight();
				netServerHandler.playerEntity.yOffset -= offset;
			}
		}
	}
}