package net.smart.moving;

import java.io.*;
import java.lang.reflect.*;
import java.util.*;

import cpw.mods.fml.common.*;
import cpw.mods.fml.common.Mod.*;
import cpw.mods.fml.common.event.*;
import cpw.mods.fml.common.eventhandler.*;
import cpw.mods.fml.common.gameevent.TickEvent.*;
import cpw.mods.fml.common.network.*;
import cpw.mods.fml.common.network.FMLNetworkEvent.*;

import net.minecraft.client.*;
import net.minecraft.entity.player.*;
import net.minecraft.network.*;

import net.smart.core.*;
import net.smart.moving.config.*;
import net.smart.utilities.*;

@Mod(modid = SmartMovingInfo.ModId, name = SmartMovingInfo.ModName, version = SmartMovingInfo.ModVersion)
public class SmartMovingMod
{
	private final boolean isClient;

	private boolean hasRenderer = false;

	public SmartMovingMod()
	{
		Assert.clientPlayerAPI(SmartMovingInfo.ModName);
		Assert.serverPlayerAPI(SmartMovingInfo.ModName);

		isClient = FMLCommonHandler.instance().getSide().isClient();
	}

	@EventHandler
	public void init(FMLInitializationEvent event)
	{
		NetworkRegistry.INSTANCE.newEventDrivenChannel(SmartMovingPacketStream.Id).register(this);

		if(isClient)
		{
			hasRenderer = Assert.hasRenderPlayerAPI;

			net.smart.moving.playerapi.SmartMoving.register();

			if(hasRenderer)
			{
				Class<?> type = Reflect.LoadClass(SmartMovingMod.class, new Name("net.smart.moving.render.playerapi.SmartMoving"), true);
				Method method = Reflect.GetMethod(type, new Name("register"));
				Reflect.Invoke(method, null);
			}
			else
				net.smart.render.SmartRenderMod.doNotAddRenderer();

			SmartMovingServerComm.localUserNameProvider = new LocalUserNameProvider();
			if(!hasRenderer)
				SmartMovingContext.registerRenderers();

			registerGameTicks();

			net.smart.moving.playerapi.SmartMovingFactory.initialize();

			checkForPresentModsAndInitializeOptions();

			SmartMovingContext.initialize(Minecraft.getMinecraft().gameSettings);
		}
		else
			SmartMovingServer.initialize(new File("."), FMLLog.getLogger(), FMLCommonHandler.instance().getMinecraftServerInstance().getGameType().getID(), new SmartMovingConfig());

		SmartCoreEventHandler.Add(new SmartMovingCoreEventHandler());
	}

	@EventHandler
	public void postInit(FMLPostInitializationEvent event)
	{
		if(!isClient)
			net.smart.moving.playerapi.SmartMovingServerPlayerBase.registerPlayerBase();
	}

	@SubscribeEvent
	public void tickStart(ClientTickEvent event)
	{
		SmartMovingContext.onTickInGame();
	}

	@SubscribeEvent
	public void onPacketData(ServerCustomPacketEvent event)
	{
		SmartMovingPacketStream.receivePacket(event.packet, SmartMovingServerComm.instance, net.smart.moving.playerapi.SmartMovingServerPlayerBase.getPlayerBase(((NetHandlerPlayServer)event.handler).playerEntity));
	}

	@SubscribeEvent
	public void onPacketData(ClientCustomPacketEvent event)
	{
		SmartMovingPacketStream.receivePacket(event.packet, SmartMovingComm.instance, null);
	}

	public void registerGameTicks()
	{
		FMLCommonHandler.instance().bus().register(this);
	}

	public Object getInstance(EntityPlayer entityPlayer)
	{
		return SmartMovingFactory.getInstance(entityPlayer);
	}

	public Object getClient()
	{
		return SmartMovingContext.Client;
	}

	public void checkForPresentModsAndInitializeOptions()
	{
		List<ModContainer> modList = Loader.instance().getActiveModList();
		boolean hasRedPowerWiring = false;
		boolean hasBuildCraftTransport = false;
		boolean hasFiniteLiquid = false;
		boolean hasBetterThanWolves = false;
		boolean hasSinglePlayerCommands = false;
		boolean hasRopesPlus = false;
		boolean hasASGrapplingHook = false;
		boolean hasBetterMisc = false;

		for(int i = 0; i < modList.size(); i++)
		{
			ModContainer mod = modList.get(i);
			String name = mod.getName();

			if(name.contains("RedPowerWiring"))
				hasRedPowerWiring = true;
			else if(name.contains("BuildCraftTransport"))
				hasBuildCraftTransport = true;
			else if(name.contains("Liquid"))
				hasFiniteLiquid = true;
			else if(name.contains("FCBetterThanWolves"))
				hasBetterThanWolves = true;
			else if(name.contains("SinglePlayerCommands"))
				hasSinglePlayerCommands = true;
			else if(name.contains("ASGrapplingHook"))
				hasASGrapplingHook = true;
			else if(name.contains("BetterMisc"))
				hasBetterMisc = true;
		}

		hasRopesPlus = Reflect.CheckClasses(SmartMovingMod.class, SmartMovingInstall.RopesPlusCore);

		SmartMovingOptions.initialize(hasRedPowerWiring, hasBuildCraftTransport, hasFiniteLiquid, hasBetterThanWolves, hasSinglePlayerCommands, hasRopesPlus, hasASGrapplingHook, hasBetterMisc);
	}
}