package net.smart.moving.config;

import java.util.Iterator;

import net.smart.properties.*;

public class SmartMovingServerConfig extends SmartMovingClientConfig
{
	private Properties properties = new Properties();
	private Properties topProperties = new Properties();

	public void loadFromProperties(String[] propertyArray, boolean top)
	{
		for(int i = 0; i < propertyArray.length - 1; i += 2)
		{
			String key = propertyArray[i];
			String value = propertyArray[i + 1];
			properties.put(key, value);
			if(top)
				topProperties.put(key, value);
		}

		load(top);
	}

	public void load(boolean top)
	{
		if(!top && !topProperties.isEmpty())
		{
			Iterator iterator = topProperties.keySet().iterator();
			while(iterator.hasNext())
			{
				Object topKey = iterator.next();
				properties.put(topKey, topProperties.get(topKey));
			}
		}
		super.loadFromProperties(properties);
	}

	public void reset()
	{
		properties.clear();
		topProperties.clear();
	}
}