package net.smart.moving.playerapi;

import java.lang.reflect.*;

import api.player.client.*;

import net.minecraft.client.entity.*;
import net.minecraft.entity.player.*;

import net.smart.moving.config.*;
import net.smart.utilities.*;

public class SmartMovingSelf extends net.smart.moving.SmartMovingSelf
{
	public SmartMovingSelf(EntityPlayer sp, SmartMovingPlayerBase playerBase)
	{
		super(sp, playerBase);
	}

	public boolean doFlyingAnimation()
	{
		return SmartMovingOptions.hasSinglePlayerCommands && isSPCFlying(esp) || super.doFlyingAnimation();
	}

	public static boolean isSPCFlying(EntityPlayerSP entityPlayer)
	{
		if(!SmartMovingOptions.hasSinglePlayerCommands)
			return false;

		ClientPlayerBase spcPlayerBase = ((IClientPlayerAPI)entityPlayer).getClientPlayerBase(SmartMoving.SPC_ID);
		if(spcPlayerBase == null)
			return false;

		if(playerHelperField == null)
			playerHelperField = Reflect.GetField(spcPlayerBase.getClass(), new Name("ph"), false);
		if(playerHelperField == null)
			return false;

		Object playerHelper = Reflect.GetField(playerHelperField, spcPlayerBase);
		if(playerHelper == null)
			return false;

		if(flyingField == null)
			flyingField = Reflect.GetField(playerHelper.getClass(), new Name("flying"), false);
		if(flyingField == null)
			return false;

		Object isFlying =  Reflect.GetField(flyingField, playerHelper);
		if(isFlying == null)
			return false;

		return isFlying instanceof Boolean && (Boolean)isFlying;
	}

	private static Field playerHelperField = null;
	private static Field flyingField = null;
}
