package net.smart.moving.render.playerapi;

import api.player.model.*;
import api.player.render.*;

import net.smart.moving.*;
import net.smart.render.playerapi.*;

public abstract class SmartMoving
{
	public static final String ID = SmartMovingInfo.ModName;

	public static void register()
	{
		String[] inferiors = new String[] { SmartRender.ID };

		RenderPlayerBaseSorting renderSorting = new RenderPlayerBaseSorting();
		renderSorting.setAfterLocalConstructingInferiors(inferiors);
		renderSorting.setOverrideRenderPlayerInferiors(inferiors);
		renderSorting.setOverrideRotatePlayerInferiors(inferiors);
		renderSorting.setOverrideRenderPlayerSleepInferiors(inferiors);
		RenderPlayerAPI.register(ID, SmartMovingRenderPlayerBase.class, renderSorting);

		ModelPlayerBaseSorting modelSorting = new ModelPlayerBaseSorting();
		modelSorting.setAfterLocalConstructingInferiors(inferiors);
		ModelPlayerAPI.register(ID, SmartMovingModelPlayerBase.class, modelSorting);
	}

	public static SmartMovingRenderPlayerBase getPlayerBase(net.minecraft.client.renderer.entity.RenderPlayer renderPlayer)
	{
		return (SmartMovingRenderPlayerBase)((IRenderPlayerAPI)renderPlayer).getRenderPlayerBase(ID);
	}

	public static SmartMovingModelPlayerBase getPlayerBase(api.player.model.ModelPlayer modelPlayer)
	{
		return (SmartMovingModelPlayerBase)((IModelPlayerAPI)modelPlayer).getModelPlayerBase(ID);
	}
}