/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Properties;

public class ConnectedProperties {
    public String name = null;
    public String basePath = null;
    public int[] matchBlocks = null;
    public String[] matchTiles = null;
    public int method = 0;
    public String[] tiles = null;
    public int connect = 0;
    public int faces = 63;
    public int[] metadatas = null;
    public acp[] biomes = null;
    public int minHeight = 0;
    public int maxHeight = 1024;
    public int renderPass = 0;
    public boolean innerSeams = false;
    public int width = 0;
    public int height = 0;
    public int[] weights = null;
    public int symmetry = 1;
    public int[] sumWeights = null;
    public int sumAllWeights = 0;
    public mr[] matchTileIcons = null;
    public mr[] tileIcons = null;
    public static final int METHOD_NONE = 0;
    public static final int METHOD_CTM = 1;
    public static final int METHOD_HORIZONTAL = 2;
    public static final int METHOD_TOP = 3;
    public static final int METHOD_RANDOM = 4;
    public static final int METHOD_REPEAT = 5;
    public static final int METHOD_VERTICAL = 6;
    public static final int METHOD_FIXED = 7;
    public static final int CONNECT_NONE = 0;
    public static final int CONNECT_BLOCK = 1;
    public static final int CONNECT_TILE = 2;
    public static final int CONNECT_MATERIAL = 3;
    public static final int CONNECT_UNKNOWN = 128;
    public static final int FACE_BOTTOM = 1;
    public static final int FACE_TOP = 2;
    public static final int FACE_EAST = 4;
    public static final int FACE_WEST = 8;
    public static final int FACE_NORTH = 16;
    public static final int FACE_SOUTH = 32;
    public static final int FACE_SIDES = 60;
    public static final int FACE_ALL = 63;
    public static final int FACE_UNKNOWN = 128;
    public static final int SYMMETRY_NONE = 1;
    public static final int SYMMETRY_OPPOSITE = 2;
    public static final int SYMMETRY_ALL = 6;
    public static final int SYMMETRY_UNKNOWN = 128;

    public ConnectedProperties(Properties props, String path) {
        this.name = ConnectedProperties.parseName(path);
        this.basePath = ConnectedProperties.parseBasePath(path);
        this.matchBlocks = ConnectedProperties.parseInts(props.getProperty("matchBlocks"));
        this.matchTiles = this.parseMatchTiles(props.getProperty("matchTiles"));
        this.method = ConnectedProperties.parseMethod(props.getProperty("method"));
        this.tiles = this.parseTileNames(props.getProperty("tiles"));
        this.connect = ConnectedProperties.parseConnect(props.getProperty("connect"));
        this.faces = ConnectedProperties.parseFaces(props.getProperty("faces"));
        this.metadatas = ConnectedProperties.parseInts(props.getProperty("metadata"));
        this.biomes = ConnectedProperties.parseBiomes(props.getProperty("biomes"));
        this.minHeight = ConnectedProperties.parseInt(props.getProperty("minHeight"), -1);
        this.maxHeight = ConnectedProperties.parseInt(props.getProperty("maxHeight"), 1024);
        this.renderPass = ConnectedProperties.parseInt(props.getProperty("renderPass"));
        this.innerSeams = ConnectedProperties.parseBoolean(props.getProperty("innerSeams"));
        this.width = ConnectedProperties.parseInt(props.getProperty("width"));
        this.height = ConnectedProperties.parseInt(props.getProperty("height"));
        this.weights = ConnectedProperties.parseInts(props.getProperty("weights"));
        this.symmetry = ConnectedProperties.parseSymmetry(props.getProperty("symmetry"));
    }

    private String[] parseMatchTiles(String str) {
        if (str == null) {
            return null;
        }
        String[] names = Config.tokenize(str, " ");
        for (int i = 0; i < names.length; ++i) {
            String iconName = names[i];
            if (iconName.endsWith(".png")) {
                iconName = iconName.substring(0, iconName.length() - 4);
            }
            names[i] = iconName = TextureUtils.fixResourcePath(iconName, this.basePath);
        }
        return names;
    }

    private static String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    private static String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    private static acp[] parseBiomes(String str) {
        if (str == null) {
            return null;
        }
        String[] biomeNames = Config.tokenize(str, " ");
        ArrayList<acp> list = new ArrayList<acp>();
        for (int i = 0; i < biomeNames.length; ++i) {
            String biomeName = biomeNames[i];
            acp biome = ConnectedProperties.findBiome(biomeName);
            if (biome == null) {
                Config.warn("Biome not found: " + biomeName);
                continue;
            }
            list.add(biome);
        }
        acp[] biomeArr = list.toArray(new acp[list.size()]);
        return biomeArr;
    }

    private static acp findBiome(String biomeName) {
        biomeName = biomeName.toLowerCase();
        for (int i = 0; i < acp.a.length; ++i) {
            String name;
            acp biome = acp.a[i];
            if (biome == null || !(name = biome.y.replace(" ", "").toLowerCase()).equals(biomeName)) continue;
            return biome;
        }
        return null;
    }

    private String[] parseTileNames(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] iconStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < iconStrs.length; ++i) {
            String[] subStrs;
            String iconStr = iconStrs[i];
            if (iconStr.contains("-") && (subStrs = Config.tokenize(iconStr, "-")).length == 2) {
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min >= 0 && max >= 0) {
                    if (min > max) {
                        Config.warn("Invalid interval: " + iconStr + ", when parsing: " + str);
                        continue;
                    }
                    for (int n = min; n <= max; ++n) {
                        list.add(String.valueOf(n));
                    }
                    continue;
                }
            }
            list.add(iconStr);
        }
        String[] names = list.toArray(new String[list.size()]);
        for (int i = 0; i < names.length; ++i) {
            String pathBlocks;
            String iconName = names[i];
            if (!((iconName = TextureUtils.fixResourcePath(iconName, this.basePath)).startsWith(this.basePath) || iconName.startsWith("textures/") || iconName.startsWith("mcpatcher/"))) {
                iconName = this.basePath + "/" + iconName;
            }
            if (iconName.endsWith(".png")) {
                iconName = iconName.substring(0, iconName.length() - 4);
            }
            if (iconName.startsWith(pathBlocks = "textures/blocks/")) {
                iconName = iconName.substring(pathBlocks.length());
            }
            if (iconName.startsWith("/")) {
                iconName = iconName.substring(1);
            }
            names[i] = iconName;
        }
        return names;
    }

    private static int parseInt(String str) {
        if (str == null) {
            return -1;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            Config.warn("Invalid number: " + str);
        }
        return num;
    }

    private static int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int num = Config.parseInt(str, -1);
        if (num < 0) {
            Config.warn("Invalid number: " + str);
            return defVal;
        }
        return num;
    }

    private static boolean parseBoolean(String str) {
        if (str == null) {
            return false;
        }
        return str.toLowerCase().equals("true");
    }

    private static int parseSymmetry(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("opposite")) {
            return 2;
        }
        if (str.equals("all")) {
            return 6;
        }
        Config.warn("Unknown symmetry: " + str);
        return 1;
    }

    private static int parseFaces(String str) {
        if (str == null) {
            return 63;
        }
        String[] faceStrs = Config.tokenize(str, " ,");
        int facesMask = 0;
        for (int i = 0; i < faceStrs.length; ++i) {
            String faceStr = faceStrs[i];
            int faceMask = ConnectedProperties.parseFace(faceStr);
            facesMask |= faceMask;
        }
        return facesMask;
    }

    private static int parseFace(String str) {
        if ((str = str.toLowerCase()).equals("bottom")) {
            return 1;
        }
        if (str.equals("top")) {
            return 2;
        }
        if (str.equals("north")) {
            return 4;
        }
        if (str.equals("south")) {
            return 8;
        }
        if (str.equals("east")) {
            return 32;
        }
        if (str.equals("west")) {
            return 16;
        }
        if (str.equals("sides")) {
            return 60;
        }
        if (str.equals("all")) {
            return 63;
        }
        Config.warn("Unknown face: " + str);
        return 128;
    }

    private static int parseConnect(String str) {
        if (str == null) {
            return 0;
        }
        if (str.equals("block")) {
            return 1;
        }
        if (str.equals("tile")) {
            return 2;
        }
        if (str.equals("material")) {
            return 3;
        }
        Config.warn("Unknown connect: " + str);
        return 128;
    }

    private static int[] parseInts(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        String[] intStrs = Config.tokenize(str, " ,");
        for (int i = 0; i < intStrs.length; ++i) {
            String intStr = intStrs[i];
            if (intStr.contains("-")) {
                String[] subStrs = Config.tokenize(intStr, "-");
                if (subStrs.length != 2) {
                    Config.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                int min = Config.parseInt(subStrs[0], -1);
                int max = Config.parseInt(subStrs[1], -1);
                if (min < 0 || max < 0 || min > max) {
                    Config.warn("Invalid interval: " + intStr + ", when parsing: " + str);
                    continue;
                }
                for (int n = min; n <= max; ++n) {
                    list.add(n);
                }
                continue;
            }
            int val = Config.parseInt(intStr, -1);
            if (val < 0) {
                Config.warn("Invalid number: " + intStr + ", when parsing: " + str);
                continue;
            }
            list.add(val);
        }
        int[] ints = new int[list.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)list.get(i);
        }
        return ints;
    }

    private static int parseMethod(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("ctm") || str.equals("glass")) {
            return 1;
        }
        if (str.equals("horizontal") || str.equals("bookshelf")) {
            return 2;
        }
        if (str.equals("vertical")) {
            return 6;
        }
        if (str.equals("top")) {
            return 3;
        }
        if (str.equals("random")) {
            return 4;
        }
        if (str.equals("repeat")) {
            return 5;
        }
        if (str.equals("fixed")) {
            return 7;
        }
        Config.warn("Unknown method: " + str);
        return 0;
    }

    public boolean isValid(String path) {
        if (this.name == null || this.name.length() <= 0) {
            Config.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            Config.warn("No base path found: " + path);
            return false;
        }
        if (this.matchBlocks == null) {
            this.matchBlocks = this.detectMatchBlocks();
        }
        if (this.matchTiles == null && this.matchBlocks == null) {
            this.matchTiles = this.detectMatchTiles();
        }
        if (this.matchBlocks == null && this.matchTiles == null) {
            Config.warn("No matchBlocks or matchTiles specified: " + path);
            return false;
        }
        if (this.method == 0) {
            Config.warn("No method: " + path);
            return false;
        }
        if (this.tiles == null || this.tiles.length <= 0) {
            Config.warn("No tiles specified: " + path);
            return false;
        }
        if (this.connect == 0) {
            this.connect = this.detectConnect();
        }
        if (this.connect == 128) {
            Config.warn("Invalid connect in: " + path);
            return false;
        }
        if (this.renderPass > 0) {
            Config.warn("Render pass not supported: " + this.renderPass);
            return false;
        }
        if ((this.faces & 0x80) != 0) {
            Config.warn("Invalid faces in: " + path);
            return false;
        }
        if ((this.symmetry & 0x80) != 0) {
            Config.warn("Invalid symmetry in: " + path);
            return false;
        }
        switch (this.method) {
            case 1: {
                return this.isValidCtm(path);
            }
            case 2: {
                return this.isValidHorizontal(path);
            }
            case 6: {
                return this.isValidVertical(path);
            }
            case 3: {
                return this.isValidTop(path);
            }
            case 4: {
                return this.isValidRandom(path);
            }
            case 5: {
                return this.isValidRepeat(path);
            }
            case 7: {
                return this.isValidFixed(path);
            }
        }
        Config.warn("Unknown method: " + path);
        return false;
    }

    private int detectConnect() {
        if (this.matchBlocks != null) {
            return 1;
        }
        if (this.matchTiles != null) {
            return 2;
        }
        return 128;
    }

    private int[] detectMatchBlocks() {
        int startPos;
        char ch;
        int pos;
        if (!this.name.startsWith("block")) {
            return null;
        }
        for (pos = startPos = "block".length(); pos < this.name.length() && (ch = this.name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        if (pos == startPos) {
            return null;
        }
        String idStr = this.name.substring(startPos, pos);
        int id = Config.parseInt(idStr, -1);
        if (id < 0) {
            return null;
        }
        return new int[]{id};
    }

    private String[] detectMatchTiles() {
        mr icon = ConnectedProperties.getIcon(this.name);
        if (icon == null) {
            return null;
        }
        return new String[]{this.name};
    }

    private static mr getIcon(String iconName) {
        return bih.textureMapBlocks.getIconSafe(iconName);
    }

    private boolean isValidCtm(String path) {
        if (this.tiles == null) {
            this.tiles = this.parseTileNames("0-11 16-27 32-43 48-58");
        }
        if (this.tiles.length < 47) {
            Config.warn("Invalid tiles, must be at least 47: " + path);
            return false;
        }
        return true;
    }

    private boolean isValidHorizontal(String path) {
        if (this.tiles == null) {
            this.tiles = this.parseTileNames("12-15");
        }
        if (this.tiles.length != 4) {
            Config.warn("Invalid tiles, must be exactly 4: " + path);
            return false;
        }
        return true;
    }

    private boolean isValidVertical(String path) {
        if (this.tiles == null) {
            Config.warn("No tiles defined for vertical: " + path);
            return false;
        }
        if (this.tiles.length != 4) {
            Config.warn("Invalid tiles, must be exactly 4: " + path);
            return false;
        }
        return true;
    }

    private boolean isValidRandom(String path) {
        if (this.tiles == null || this.tiles.length <= 0) {
            Config.warn("Tiles not defined: " + path);
            return false;
        }
        if (this.weights != null && this.weights.length != this.tiles.length) {
            Config.warn("Number of weights must equal the number of tiles: " + path);
            this.weights = null;
        }
        if (this.weights != null) {
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i = 0; i < this.weights.length; ++i) {
                this.sumWeights[i] = sum += this.weights[i];
            }
            this.sumAllWeights = sum;
        }
        return true;
    }

    private boolean isValidRepeat(String path) {
        if (this.tiles == null) {
            Config.warn("Tiles not defined: " + path);
            return false;
        }
        if (this.width <= 0 || this.width > 16) {
            Config.warn("Invalid width: " + path);
            return false;
        }
        if (this.height <= 0 || this.height > 16) {
            Config.warn("Invalid height: " + path);
            return false;
        }
        if (this.tiles.length != this.width * this.height) {
            Config.warn("Number of tiles does not equal width x height: " + path);
            return false;
        }
        return true;
    }

    private boolean isValidFixed(String path) {
        if (this.tiles == null) {
            Config.warn("Tiles not defined: " + path);
            return false;
        }
        if (this.tiles.length != 1) {
            Config.warn("Number of tiles should be 1 for method: fixed.");
            return false;
        }
        return true;
    }

    private boolean isValidTop(String path) {
        if (this.tiles == null) {
            this.tiles = this.parseTileNames("66");
        }
        if (this.tiles.length != 1) {
            Config.warn("Invalid tiles, must be exactly 1: " + path);
            return false;
        }
        return true;
    }

    public void updateIcons(bih textureMap) {
        if (this.matchTiles != null) {
            this.matchTileIcons = ConnectedProperties.registerIcons(this.matchTiles, textureMap);
        }
        if (this.tiles != null) {
            this.tileIcons = ConnectedProperties.registerIcons(this.tiles, textureMap);
        }
    }

    private static mr[] registerIcons(String[] tileNames, bih textureMap) {
        if (tileNames == null) {
            return null;
        }
        ArrayList<mr> iconList = new ArrayList<mr>();
        for (int i = 0; i < tileNames.length; ++i) {
            String fileName;
            bjl loc;
            boolean exists;
            String iconName = tileNames[i];
            String fullName = iconName;
            if (!fullName.contains("/")) {
                fullName = "textures/blocks/" + fullName;
            }
            if (!(exists = Config.hasResource(loc = new bjl(fileName = fullName + ".png")))) {
                Config.warn("File not found: " + fileName);
            }
            mr icon = textureMap.a(iconName);
            iconList.add(icon);
        }
        mr[] icons = iconList.toArray(new mr[iconList.size()]);
        return icons;
    }

    public String toString() {
        return "CTM name: " + this.name + ", basePath: " + this.basePath + ", matchBlocks: " + Config.arrayToString(this.matchBlocks) + ", matchTiles: " + Config.arrayToString(this.matchTiles);
    }
}

