/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class WrUpdaterSmooth
implements IWrUpdater {
    private long lastUpdateStartTimeNs = 0L;
    private long updateStartTimeNs = 0L;
    private long updateTimeNs = 10000000L;
    private WorldRendererSmooth currentUpdateRenderer = null;
    private int renderersUpdated = 0;
    private int renderersFound = 0;

    @Override
    public void initialize() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public bfa makeWorldRenderer(abw worldObj, List tileEntities, int x2, int y, int z, int glRenderListBase) {
        return new WorldRendererSmooth(worldObj, tileEntities, x2, y, z, glRenderListBase);
    }

    @Override
    public boolean updateRenderers(bfl rg, of entityliving, boolean flag) {
        this.lastUpdateStartTimeNs = this.updateStartTimeNs;
        this.updateStartTimeNs = System.nanoTime();
        long finishTimeNs = this.updateStartTimeNs + this.updateTimeNs;
        int maxNum = Config.getUpdatesPerFrame();
        if (Config.isDynamicUpdates() && !rg.isMoving(entityliving)) {
            maxNum *= 3;
        }
        this.renderersUpdated = 0;
        do {
            this.renderersFound = 0;
            this.updateRenderersImpl(rg, entityliving, flag);
        } while (this.renderersFound > 0 && System.nanoTime() - finishTimeNs < 0L);
        if (this.renderersFound > 0) {
            maxNum = Math.min(maxNum, this.renderersFound);
            long diff = 400000L;
            if (this.renderersUpdated > maxNum) {
                this.updateTimeNs -= 2L * diff;
            }
            if (this.renderersUpdated < maxNum) {
                this.updateTimeNs += diff;
            }
        } else {
            this.updateTimeNs = 0L;
            this.updateTimeNs -= 200000L;
        }
        if (this.updateTimeNs < 0L) {
            this.updateTimeNs = 0L;
        }
        return this.renderersUpdated > 0;
    }

    private void updateRenderersImpl(bfl rg, of entityliving, boolean flag) {
        this.renderersFound = 0;
        boolean currentUpdateFinished = true;
        if (this.currentUpdateRenderer != null) {
            ++this.renderersFound;
            currentUpdateFinished = this.updateRenderer(this.currentUpdateRenderer);
            if (currentUpdateFinished) {
                ++this.renderersUpdated;
            }
        }
        if (rg.m.size() <= 0) {
            return;
        }
        int NOT_IN_FRUSTRUM_MUL = 4;
        WorldRendererSmooth wrBest = null;
        float distSqBest = Float.MAX_VALUE;
        int indexBest = -1;
        for (int i = 0; i < rg.m.size(); ++i) {
            WorldRendererSmooth wr = (WorldRendererSmooth)rg.m.get(i);
            if (wr == null) continue;
            ++this.renderersFound;
            if (!wr.q) {
                rg.m.set(i, null);
                continue;
            }
            float distSq = wr.a((nn)entityliving);
            if (distSq <= 256.0f && rg.isActingNow()) {
                wr.a();
                wr.q = false;
                rg.m.set(i, null);
                ++this.renderersUpdated;
                continue;
            }
            if (!wr.l) {
                distSq *= (float)NOT_IN_FRUSTRUM_MUL;
            }
            if (wrBest == null) {
                wrBest = wr;
                distSqBest = distSq;
                indexBest = i;
                continue;
            }
            if (!(distSq < distSqBest)) continue;
            wrBest = wr;
            distSqBest = distSq;
            indexBest = i;
        }
        if (this.currentUpdateRenderer != null && !currentUpdateFinished) {
            return;
        }
        if (wrBest != null) {
            rg.m.set(indexBest, null);
            if (!this.updateRenderer(wrBest)) {
                return;
            }
            ++this.renderersUpdated;
            if (System.nanoTime() > this.updateStartTimeNs + this.updateTimeNs) {
                return;
            }
            float maxDiffDistSq = distSqBest / 5.0f;
            for (int i = 0; i < rg.m.size(); ++i) {
                float diffDistSq;
                WorldRendererSmooth wr = (WorldRendererSmooth)rg.m.get(i);
                if (wr == null) continue;
                float distSq = wr.a((nn)entityliving);
                if (!wr.l) {
                    distSq *= (float)NOT_IN_FRUSTRUM_MUL;
                }
                if (!((diffDistSq = Math.abs(distSq - distSqBest)) < maxDiffDistSq)) continue;
                rg.m.set(i, null);
                if (!this.updateRenderer(wr)) {
                    return;
                }
                ++this.renderersUpdated;
                if (System.nanoTime() > this.updateStartTimeNs + this.updateTimeNs) break;
            }
        }
        if (this.renderersFound == 0) {
            rg.m.clear();
        }
        if (rg.m.size() > 100 && this.renderersFound < rg.m.size() * 4 / 5) {
            int dstIndex = 0;
            for (int srcIndex = 0; srcIndex < rg.m.size(); ++srcIndex) {
                Object wr = rg.m.get(srcIndex);
                if (wr == null) continue;
                if (srcIndex != dstIndex) {
                    rg.m.set(dstIndex, wr);
                }
                ++dstIndex;
            }
            for (int i = rg.m.size() - 1; i >= dstIndex; --i) {
                rg.m.remove(i);
            }
        }
    }

    private boolean updateRenderer(WorldRendererSmooth wr) {
        long finishTime = this.updateStartTimeNs + this.updateTimeNs;
        wr.q = false;
        boolean ready = wr.updateRenderer(finishTime);
        if (!ready) {
            this.currentUpdateRenderer = wr;
            return false;
        }
        wr.finishUpdate();
        this.currentUpdateRenderer = null;
        return true;
    }

    @Override
    public void finishCurrentUpdate() {
    }

    @Override
    public void resumeBackgroundUpdates() {
    }

    @Override
    public void pauseBackgroundUpdates() {
    }

    @Override
    public void preRender(bfl rg, of player) {
    }

    @Override
    public void postRender() {
    }
}

