/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import mc.ambientocclusion.xrayinstaller.XRayInstaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MCPatcher
extends SwingWorker<Void, Void> {
    private File newVersionDir;
    private File newVersionJson;
    private File newVersionJar;
    private File oldVersionDir;
    private File oldVersionJson;
    private File oldVersionJar;
    private Set<String> NewMC = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Set<String> Sources = new LinkedHashSet<String>();

    public MCPatcher(String oldVersion, String newVersion, List<String> mods) {
        this.newVersionDir = new File(XRayInstaller.mcVersions, newVersion);
        this.newVersionJson = new File(this.newVersionDir, String.valueOf(newVersion) + ".json");
        this.newVersionJar = new File(this.newVersionDir, String.valueOf(newVersion) + ".jar");
        this.oldVersionDir = new File(XRayInstaller.mcVersions, oldVersion);
        this.oldVersionJson = new File(this.oldVersionDir, String.valueOf(oldVersion) + ".json");
        this.oldVersionJar = new File(this.oldVersionDir, String.valueOf(oldVersion) + ".jar");
        this.Sources.addAll(mods);
        this.Sources.add(this.oldVersionJar.getAbsolutePath());
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.NewMC.addAll(Arrays.asList(XRayInstaller.g_thePatcher.additionalFiles()));
        for (String source : this.Sources) {
            ZipFile z = null;
            try {
                z = new ZipFile(source);
                this.InsertIntoClassPath(new File(source));
                Enumeration<? extends ZipEntry> zipEntries = z.entries();
                while (zipEntries.hasMoreElements()) {
                    ZipEntry entry = zipEntries.nextElement();
                    if (entry.getName().startsWith("META-INF/")) continue;
                    this.NewMC.add(entry.getName());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(z);
                throw throwable;
            }
            IOUtils.closeQuietly(z);
        }
        File lwjgllib = this.getLWJGL(this.oldVersionJson);
        this.InsertIntoClassPath(lwjgllib);
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream(FileUtils.openOutputStream(this.newVersionJar));
            for (String entry : this.NewMC) {
                System.out.println("Putting entry: " + entry);
                jarOut.putNextEntry(new JarEntry(entry));
                if (entry.toLowerCase().endsWith(".class")) {
                    String className = entry.replaceFirst("(?i)\\.class$", "");
                    IOUtils.write(XRayInstaller.g_thePatcher.patchAndGetBytes(className), (OutputStream)jarOut);
                    continue;
                }
                InputStream is = XRayInstaller.class.getResourceAsStream("/" + entry);
                if (is == null) {
                    throw new RuntimeException("Resource stream is null: " + entry);
                }
                IOUtils.copy(is, (OutputStream)jarOut);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jarOut);
            throw throwable;
        }
        IOUtils.closeQuietly(jarOut);
        this.CreateNewJson(this.oldVersionJson, this.newVersionJson, this.newVersionDir.getName());
        return null;
    }

    @Override
    protected void done() {
        try {
            try {
                XRayInstaller.progressDlg.setVisible(false);
                this.get();
                JOptionPane.showMessageDialog(XRayInstaller.GUI, "Minecraft has been patched successfully!");
            }
            catch (Exception e) {
                XRayInstaller.showException(e);
                XRayInstaller.GUI.dispose();
            }
        }
        finally {
            XRayInstaller.GUI.dispose();
        }
    }

    private File getLWJGL(File inJson) throws IOException {
        String jsonTxt;
        Pattern special_regex = Pattern.compile("(?i)\"name\": \"org.lwjgl.lwjgl:lwjgl:([^\"]+)\"");
        Matcher m = special_regex.matcher(jsonTxt = FileUtils.readFileToString(inJson));
        if (m.find()) {
            return new File(XRayInstaller.mcDirectory, "libraries/org/lwjgl/lwjgl/lwjgl/{0}/lwjgl-{0}.jar".replace("{0}", m.group(1)));
        }
        throw new RuntimeException("LWJGL not found!");
    }

    private void CreateNewJson(File inJson, File outJson, String newVersion) throws IOException {
        String jsonStr = FileUtils.readFileToString(inJson);
        FileUtils.writeStringToFile(outJson, jsonStr.replaceAll("\"id\":\\s*\".+\",", "\"id\": \"" + newVersion + "\","));
    }

    private void InsertIntoClassPath(File file) throws Exception {
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, file.toURI().toURL());
    }
}

