/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mc.ambientocclusion.xray.XRayPatcher;
import mc.ambientocclusion.xrayinstaller.ProgressDialog;
import mc.ambientocclusion.xrayinstaller.XRayInstallerGUI;

public class XRayInstaller {
    public static final XRayPatcher g_thePatcher = new XRayPatcher();
    public static final String g_copyright = "This program was written by AmbientOcclusion.";
    public static final String g_xrayVersion = "v4";
    public static final String g_mcVersion = g_thePatcher.getVersion();
    public static XRayInstallerGUI GUI;
    public static ProgressDialog progressDlg;
    public static File mcDirectory;
    public static File mcVersions;
    public static String oldVersion;
    public static String newVersion;

    static {
        oldVersion = "";
        newVersion = "";
    }

    public static void main(String[] args) {
        mcDirectory = XRayInstaller.getMCDirectory();
        mcVersions = new File(mcDirectory, "versions");
        XRayInstaller.setLookAndFeel("Nimbus");
        if (!mcDirectory.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Minecraft not found! Are you sure it is installed?", "Error", 0);
            System.exit(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUI = new XRayInstallerGUI();
                    GUI.setVisible(true);
                    progressDlg = new ProgressDialog(GUI);
                }
                catch (Exception e) {
                    XRayInstaller.showException(e);
                }
            }
        });
    }

    private static void setLookAndFeel(String laf) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if (laf.equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showException(Exception exception) {
        exception.printStackTrace();
        progressDlg.setVisible(false);
        Object[] options = new Object[]{"COPY ERROR DETAILS TO CLIPBOARD", "EXIT"};
        int opt = JOptionPane.showOptionDialog(null, "There has been an error :(", "Error", -1, 0, null, options, options[1]);
        if (opt == 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Using patcher for Minecraft version " + g_mcVersion + " - Patcher: " + g_xrayVersion);
            pw.println("Minecraft directory found at: " + mcDirectory);
            pw.println("Old version: " + oldVersion);
            pw.println("New version: " + newVersion);
            pw.println("System.getProperty('os.name') == " + System.getProperty("os.name"));
            pw.println("System.getProperty('os.version') == " + System.getProperty("os.version"));
            pw.println("System.getProperty('os.arch') == " + System.getProperty("os.arch"));
            pw.println("System.getProperty('java.version') == " + System.getProperty("java.version"));
            pw.println("System.getProperty('java.vendor') == " + System.getProperty("java.vendor"));
            pw.println("System.getProperty('sun.arch.data.model') == " + System.getProperty("sun.arch.data.model"));
            pw.println();
            exception.printStackTrace(pw);
            StringSelection stringSelection = new StringSelection(sw.toString());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    public static File getMCDirectory() {
        File workingDirectory;
        String osName = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home", ".");
        if (osName.contains("win")) {
            String applicationData = System.getenv("APPDATA");
            String folder = applicationData != null ? applicationData : userHome;
            workingDirectory = new File(folder, ".minecraft/");
        } else {
            workingDirectory = osName.contains("mac") ? new File(userHome, "Library/Application Support/minecraft") : (osName.contains("linux") || osName.contains("unix") ? new File(userHome, ".minecraft/") : new File(userHome, "minecraft/"));
        }
        return workingDirectory;
    }
}

