/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.AbstractList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import mc.ambientocclusion.xrayinstaller.AutoRepair;
import mc.ambientocclusion.xrayinstaller.MCFileFilter;
import mc.ambientocclusion.xrayinstaller.MCPatcher;
import mc.ambientocclusion.xrayinstaller.XRayInstaller;
import org.apache.commons.io.FileUtils;

public class XRayInstallerGUI
extends JFrame {
    private JPanel contentPane;
    private JPanel mainPanel;
    private JPanel bottomPanel;
    private JButton btnPatch;
    private JComboBox<String> patchVersion;
    private JTextField newVersion;
    private JList<String> additionalMods;
    private DefaultListModel<String> additionalModsModel;
    private File rememberDirectory = new File(System.getProperty("user.dir"));

    public XRayInstallerGUI() {
        this.setResizable(false);
        this.setTitle(String.format("[%s] XRayPatcher", "v4"));
        this.setSize(300, 350);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(10, 8, 8, 8));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JLabel lblWarning = new JLabel("<html><b><font color=\"red\">Warning: this is for Minecraft version <u>" + XRayInstaller.g_mcVersion + "</u><br>Patching a different version will not work!</font></b></html>");
        lblWarning.setHorizontalAlignment(0);
        this.contentPane.add((Component)lblWarning, "North");
        this.mainPanel = new JPanel();
        this.contentPane.add((Component)this.mainPanel, "Center");
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.columnWidths = new int[2];
        gbl_mainPanel.rowHeights = new int[7];
        gbl_mainPanel.columnWeights = new double[]{1.0};
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0};
        this.mainPanel.setLayout(gbl_mainPanel);
        JLabel lbl1 = new JLabel("Select Minecraft version to patch:");
        lbl1.setHorizontalAlignment(0);
        GridBagConstraints gbc_lbl1 = new GridBagConstraints();
        gbc_lbl1.gridwidth = 2;
        gbc_lbl1.insets = new Insets(10, 0, 0, 0);
        gbc_lbl1.gridx = 0;
        gbc_lbl1.gridy = 0;
        this.mainPanel.add((Component)lbl1, gbc_lbl1);
        this.patchVersion = new JComboBox();
        this.patchVersion.setToolTipText("<html>Note: this has be a version <i>without</i> XRay already installed.</html>");
        this.reloadVersions();
        GridBagConstraints gbc_patchVersion = new GridBagConstraints();
        gbc_patchVersion.gridwidth = 2;
        gbc_patchVersion.insets = new Insets(2, 0, 0, 0);
        gbc_patchVersion.fill = 2;
        gbc_patchVersion.anchor = 11;
        gbc_patchVersion.gridx = 0;
        gbc_patchVersion.gridy = 1;
        this.mainPanel.add(this.patchVersion, gbc_patchVersion);
        JLabel lbl2 = new JLabel("Enter a name for the patched version:");
        GridBagConstraints gbc_lbl2 = new GridBagConstraints();
        gbc_lbl2.gridwidth = 2;
        gbc_lbl2.insets = new Insets(8, 0, 0, 0);
        gbc_lbl2.gridx = 0;
        gbc_lbl2.gridy = 2;
        this.mainPanel.add((Component)lbl2, gbc_lbl2);
        this.newVersion = new JTextField(String.valueOf(XRayInstaller.g_mcVersion) + "-XRay");
        this.newVersion.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String s = XRayInstallerGUI.this.newVersion.getText().trim();
                if (s.isEmpty() || XRayInstallerGUI.this.patchVersion.getSelectedIndex() == -1 || s.equalsIgnoreCase((String)XRayInstallerGUI.this.patchVersion.getSelectedItem())) {
                    XRayInstallerGUI.this.btnPatch.setEnabled(false);
                } else {
                    XRayInstallerGUI.this.btnPatch.setEnabled(true);
                }
            }
        });
        GridBagConstraints gbc_newVersion = new GridBagConstraints();
        gbc_newVersion.gridwidth = 2;
        gbc_newVersion.insets = new Insets(2, 0, 0, 0);
        gbc_newVersion.fill = 2;
        gbc_newVersion.gridx = 0;
        gbc_newVersion.gridy = 3;
        this.mainPanel.add((Component)this.newVersion, gbc_newVersion);
        this.newVersion.setColumns(10);
        JLabel lbl = new JLabel("Select additional mods to install:");
        lbl.setHorizontalAlignment(0);
        GridBagConstraints gbc_lbl = new GridBagConstraints();
        gbc_lbl.gridwidth = 2;
        gbc_lbl.insets = new Insets(8, 0, 0, 0);
        gbc_lbl.gridx = 0;
        gbc_lbl.gridy = 4;
        this.mainPanel.add((Component)lbl, gbc_lbl);
        this.additionalModsModel = new DefaultListModel();
        this.additionalMods = new JList<String>(this.additionalModsModel);
        GridBagConstraints gbc_additionalMods = new GridBagConstraints();
        gbc_additionalMods.gridwidth = 2;
        gbc_additionalMods.insets = new Insets(2, 0, 1, 0);
        gbc_additionalMods.fill = 1;
        gbc_additionalMods.gridx = 0;
        gbc_additionalMods.gridy = 5;
        this.mainPanel.add((Component)new JScrollPane(this.additionalMods), gbc_additionalMods);
        JButton btnAdd = new JButton("ADD");
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XRayInstallerGUI.this.addMod();
            }
        });
        btnAdd.setFont(new Font("SansSerif", 0, 11));
        GridBagConstraints gbc_btnAdd = new GridBagConstraints();
        gbc_btnAdd.anchor = 13;
        gbc_btnAdd.insets = new Insets(0, 0, 0, 0);
        gbc_btnAdd.gridx = 0;
        gbc_btnAdd.gridy = 6;
        this.mainPanel.add((Component)btnAdd, gbc_btnAdd);
        JButton btnRemove = new JButton("REMOVE");
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XRayInstallerGUI.this.additionalModsModel.removeElement(XRayInstallerGUI.this.additionalMods.getSelectedValue());
            }
        });
        btnRemove.setFont(new Font("SansSerif", 0, 11));
        GridBagConstraints gbc_btnRemove = new GridBagConstraints();
        gbc_btnRemove.insets = new Insets(0, 0, 0, 0);
        gbc_btnRemove.gridx = 1;
        gbc_btnRemove.gridy = 6;
        this.mainPanel.add((Component)btnRemove, gbc_btnRemove);
        this.bottomPanel = new JPanel(new GridLayout());
        this.btnPatch = new JButton("Patch");
        this.btnPatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XRayInstallerGUI.this.newVersion.setText(XRayInstallerGUI.this.newVersion.getText().trim());
                XRayInstallerGUI.this.doPatch();
            }
        });
        JButton forceUpdate = new JButton("Auto Repair");
        forceUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XRayInstaller.progressDlg.setVisible(true);
                new AutoRepair().execute();
            }
        });
        this.bottomPanel.add(forceUpdate);
        this.bottomPanel.add(this.btnPatch);
        this.contentPane.add((Component)this.bottomPanel, "South");
    }

    public void reloadVersions() {
        if (XRayInstaller.mcVersions.exists()) {
            this.patchVersion.setModel(new DefaultComboBoxModel<String>(XRayInstaller.mcVersions.list(new MCFileFilter())));
            this.patchVersion.setSelectedItem(XRayInstaller.g_mcVersion);
        }
    }

    private void doPatch() {
        String oldVersion = (String)this.patchVersion.getSelectedItem();
        String newVersion = this.newVersion.getText();
        File newVersionDir = new File(XRayInstaller.mcVersions, newVersion);
        File newVersionJson = new File(newVersionDir, String.valueOf(newVersion) + ".json");
        File newVersionJar = new File(newVersionDir, String.valueOf(newVersion) + ".jar");
        if (newVersionJson.exists() || newVersionJar.exists()) {
            int opt = JOptionPane.showConfirmDialog(XRayInstaller.GUI, "<html><b>Warning: " + newVersion + " already exists!</b>" + "<br>If you continue this will be overwritten." + "<br>Are you sure you want to continue?</html>", "Overwrite?", 0);
            if (opt == 1) {
                return;
            }
            try {
                FileUtils.deleteDirectory(newVersionDir);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(XRayInstaller.GUI, "<html><b>Unable to delete: " + newVersion + "</b><br>" + "Make sure Minecraft is not running.</html>", "Error", 0);
                return;
            }
        }
        XRayInstaller.progressDlg.setVisible(true);
        XRayInstaller.oldVersion = oldVersion;
        XRayInstaller.newVersion = newVersion;
        new MCPatcher(oldVersion, newVersion, XRayInstallerGUI.asList(this.additionalModsModel)).execute();
    }

    public static <T> List<T> asList(final DefaultListModel<T> model) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return model.getElementAt(index);
            }

            @Override
            public int size() {
                return model.getSize();
            }
        };
    }

    private void addMod() {
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(this.rememberDirectory);
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(new FileFilter(){

            public String getExtension(File f) {
                String ext = null;
                String s = f.getName();
                int i = s.lastIndexOf(46);
                if (i > 0 && i < s.length() - 1) {
                    ext = s.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                return extension != null && (extension.equals("jar") || extension.equals("zip"));
            }

            @Override
            public String getDescription() {
                return "Minecraft Mods";
            }
        });
        if (fc.showOpenDialog(null) == 0) {
            this.rememberDirectory = fc.getCurrentDirectory();
            this.additionalModsModel.addElement(fc.getSelectedFile().getAbsolutePath());
        }
    }
}

