/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xray;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import mc.ambientocclusion.xray.UpdateChecker;

public abstract class XRay {
    public static final int majorVersion = 9;
    public static final int minorVersion = 0;
    public static final int internalVersion = 589824;
    public static final String strVersion = String.format("v%d.%d", 9, 0);
    private static final String[] xrayDefaults = new String[]{"minecraft:planks", "minecraft:flowing_water", "minecraft:water", "minecraft:flowing_lava", "minecraft:lava", "minecraft:gold_ore", "minecraft:iron_ore", "minecraft:coal_ore", "minecraft:lapis_ore", "minecraft:lapis_block", "minecraft:noteblock", "minecraft:bed", "minecraft:golden_rail", "minecraft:detector_rail", "minecraft:sticky_piston", "minecraft:web", "minecraft:piston", "minecraft:piston_head", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:gold_block", "minecraft:iron_block", "minecraft:double_stone_slab", "minecraft:stone_slab", "minecraft:tnt", "minecraft:mossy_cobblestone", "minecraft:torch", "minecraft:fire", "minecraft:mob_spawner", "minecraft:chest", "minecraft:redstone_wire", "minecraft:diamond_ore", "minecraft:diamond_block", "minecraft:wheat", "minecraft:ladder", "minecraft:rail", "minecraft:stone_pressure_plate", "minecraft:iron_door", "minecraft:wooden_pressure_plate", "minecraft:redstone_ore", "minecraft:lit_redstone_ore", "minecraft:unlit_redstone_torch", "minecraft:redstone_torch", "minecraft:fence", "minecraft:glowstone", "minecraft:unpowered_repeater", "minecraft:powered_repeater", "minecraft:stained_glass", "minecraft:trapdoor", "minecraft:monster_egg", "minecraft:stonebrick", "minecraft:brown_mushroom_block", "minecraft:red_mushroom_block", "minecraft:melon_block", "minecraft:stone_brick_stairs", "minecraft:waterlily", "minecraft:nether_wart", "minecraft:enchanting_table", "minecraft:brewing_stand", "minecraft:cauldron", "minecraft:end_portal", "minecraft:end_portal_frame", "minecraft:end_portal_frame", "minecraft:dragon_egg", "minecraft:emerald_ore", "minecraft:tripwire_hook", "minecraft:tripwire", "minecraft:emerald_block", "minecraft:cobblestone_wall", "minecraft:daylight_detector", "minecraft:redstone_block", "minecraft:redstone_block", "minecraft:quartz_ore", "minecraft:hopper", "minecraft:quartz_block", "minecraft:activator_rail", "minecraft:dropper"};
    private static final String[] redstoneDefaults = new String[]{"minecraft:dispenser", "minecraft:golden_rail", "minecraft:detector_rail", "minecraft:sticky_piston", "minecraft:piston", "minecraft:piston_head", "minecraft:tnt", "minecraft:redstone_wire", "minecraft:unlit_redstone_torch", "minecraft:redstone_torch", "minecraft:unpowered_repeater", "minecraft:powered_repeater", "minecraft:trapdoor", "minecraft:redstone_lamp", "minecraft:lit_redstone_lamp", "minecraft:unpowered_comparator", "minecraft:powered_comparator", "minecraft:daylight_detector", "minecraft:redstone_block"};
    public static int xray = 0;
    public static int coords = 1;
    public static boolean fullbright = false;
    public static boolean fly = false;
    public static boolean noFall = false;
    public static boolean wasFlying = false;
    private static HashSet<Integer> xrayBlocks = new HashSet();
    private static HashSet<Integer> redstoneBlocks = new HashSet();
    private static boolean checkedForUpdates = false;
    private static UpdateChecker updateChecker = new UpdateChecker(589824);
    private static XRay instance;

    protected static void initialize() {
        try {
            instance = (XRay)Class.forName("XRayImpl").newInstance();
            System.out.println(String.format("XRay version %s (%d) initialized successfully.", strVersion, 589824));
        }
        catch (Throwable e) {
            System.err.println("FATAL: no xray implementation found!");
            e.printStackTrace();
        }
    }

    protected abstract void tickImpl();

    protected abstract void addChatMessage(String var1);

    protected abstract File getMinecraftDirectory();

    protected abstract int blockNameToID(String var1);

    protected abstract Set getBlocks();

    public static boolean shouldBlockBeRendered(int blockID) {
        switch (xray) {
            case 1: {
                return xrayBlocks.contains(blockID);
            }
            case 2: {
                return redstoneBlocks.contains(blockID);
            }
            case 4: {
                return blockID == 1 || blockID == 87;
            }
        }
        return false;
    }

    public static void tick() {
        XRay.checkForUpdates();
        instance.tickImpl();
    }

    private static void checkForUpdates() {
        if (!checkedForUpdates) {
            checkedForUpdates = true;
            XRay.loadConfigurationFiles();
            XRay.blockDump();
            updateChecker.start();
        }
        if (XRay.updateChecker.updateAvailable) {
            XRay.updateChecker.updateAvailable = false;
            instance.addChatMessage("\u00a7c[*] \u00a7fThere is an update available for XRay");
        }
    }

    protected static void loadConfigurationFiles() {
        File configDirectory = new File(instance.getMinecraftDirectory(), "config/XRay");
        File xrayConfig = new File(configDirectory, "XRay.txt");
        File redstoneConfig = new File(configDirectory, "Redstone.txt");
        configDirectory.mkdirs();
        XRay.readConfigurationFile(xrayConfig, xrayBlocks, xrayDefaults);
        XRay.readConfigurationFile(redstoneConfig, redstoneBlocks, redstoneDefaults);
    }

    private static void readConfigurationFile(File file, HashSet<Integer> blocks, String[] defaults) {
        block24: {
            BufferedWriter writer = null;
            BufferedReader reader = null;
            try {
                try {
                    blocks.clear();
                    if (file.exists()) {
                        String line;
                        reader = new BufferedReader(new FileReader(file));
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                            blocks.add(instance.blockNameToID(line));
                        }
                    } else {
                        writer = new BufferedWriter(new FileWriter(file));
                        String[] stringArray = defaults;
                        int n = defaults.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String block = stringArray[n2];
                            blocks.add(instance.blockNameToID(block));
                            writer.write(String.format("%s%n", block));
                            ++n2;
                        }
                    }
                }
                catch (IOException e) {
                    instance.addChatMessage("[XRAY] \u00a7cThere was a problem reading the configuration files");
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (writer == null) break block24;
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private static void blockDump() {
        block13: {
            BufferedWriter writer = null;
            File configDirectory = new File(instance.getMinecraftDirectory(), "config/XRay");
            File blockFile = new File(configDirectory, "Blocks.txt");
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(blockFile));
                    writer.write(String.format("# This file contains a list of available blocks.%n#%n", new Object[0]));
                    for (String s : new TreeSet(instance.getBlocks())) {
                        writer.write(String.format("%s%n", s));
                    }
                }
                catch (IOException e) {
                    instance.addChatMessage("[XRAY] \u00a7cThere was a problem creating the block dump");
                    e.printStackTrace();
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

