/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mc.ambientocclusion.xrayinstaller.XRayInstallerGUI;

public class XRayInstaller
implements Runnable {
    public static final File mcDirectory = XRayInstaller.getMCDirectory();
    public static final File mcVersions = new File(mcDirectory, "versions");
    public static String XRayTargetVersion;

    public static void main(String[] args) {
        XRayTargetVersion = "1.7.9";
        SwingUtilities.invokeLater(new XRayInstaller());
    }

    private XRayInstaller() {
    }

    @Override
    public void run() {
        try {
            XRayInstaller.setLookAndFeel("Nimbus");
            if (!mcDirectory.isDirectory()) {
                JOptionPane.showMessageDialog(null, "Minecraft not found! Are you sure it is installed?", "Error", 0);
                return;
            }
            new XRayInstallerGUI().setVisible(true);
        }
        catch (Exception e) {
            XRayInstaller.showException(e);
        }
    }

    public static void showException(Exception exception) {
        XRayInstaller.showException(exception, "", "");
    }

    public static void showException(Exception exception, String oldVersion, String newVersion) {
        exception.printStackTrace();
        Object[] options = new Object[]{"COPY ERROR DETAILS TO CLIPBOARD", "EXIT"};
        int opt = JOptionPane.showOptionDialog(null, "There has been an error :(", "Error", -1, 0, null, options, options[1]);
        if (opt == 0) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.format("Using patcher for Minecraft version %s - %s%n", XRayTargetVersion, "1.7.9");
            pw.println("Minecraft directory found at: " + mcDirectory);
            pw.println("Old version: " + oldVersion);
            pw.println("New version: " + newVersion);
            pw.println("System.getProperty('os.name') == " + System.getProperty("os.name"));
            pw.println("System.getProperty('os.version') == " + System.getProperty("os.version"));
            pw.println("System.getProperty('os.arch') == " + System.getProperty("os.arch"));
            pw.println("System.getProperty('java.version') == " + System.getProperty("java.version"));
            pw.println("System.getProperty('java.vendor') == " + System.getProperty("java.vendor"));
            pw.println("System.getProperty('sun.arch.data.model') == " + System.getProperty("sun.arch.data.model"));
            pw.println();
            exception.printStackTrace(pw);
            StringSelection stringSelection = new StringSelection(sw.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    private static File getMCDirectory() {
        File workingDirectory;
        String osName = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home", ".");
        if (osName.contains("win")) {
            String applicationData = System.getenv("APPDATA");
            String folder = applicationData != null ? applicationData : userHome;
            workingDirectory = new File(folder, ".minecraft/");
        } else {
            workingDirectory = osName.contains("mac") ? new File(userHome, "Library/Application Support/minecraft") : (osName.contains("linux") || osName.contains("unix") ? new File(userHome, ".minecraft/") : new File(userHome, "minecraft/"));
        }
        return workingDirectory;
    }

    private static void setLookAndFeel(String laf) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if (laf.equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

