/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import mc.ambientocclusion.xray.XRay;
import mc.ambientocclusion.xrayinstaller.AutoRepair;
import mc.ambientocclusion.xrayinstaller.MCFileFilter;
import mc.ambientocclusion.xrayinstaller.XRayInstaller;
import mc.ambientocclusion.xrayinstaller.XRayPatcher;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.IOUtils;

public class XRayInstallerGUI
extends JFrame {
    private static final String str_XRayWarning = "<html><b><font color=\"red\">Warning: this is for Minecraft version <u>%s</u><br>Patching a different version will not work!</font></b></html>";
    private JPanel contentPane;
    private JComboBox oldVersion;
    private JTextField newVersion;
    private JButton btnPatch;
    private JCheckBox autoSetVersion;
    private JList additionalMods;
    private DefaultListModel additionalModsModel;
    private File rememberDirectory = null;

    public XRayInstallerGUI() {
        this.setTitle(String.format("[%s] XRay Installer", XRay.strVersion));
        this.setMinimumSize(new Dimension(306, 360));
        this.setPreferredSize(this.getMinimumSize());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        new SwingWorker<InputStream, Void>(){

            @Override
            protected InputStream doInBackground() throws Exception {
                ByteArrayInputStream byteArrayInputStream;
                InputStream faviconIs = null;
                try {
                    URL favicon = new URL("https://minecraft.net/favicon.png");
                    faviconIs = favicon.openStream();
                    byteArrayInputStream = new ByteArrayInputStream(IOUtils.toByteArray(faviconIs));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(faviconIs);
                    throw throwable;
                }
                IOUtils.closeQuietly(faviconIs);
                return byteArrayInputStream;
            }

            @Override
            public void done() {
                try {
                    XRayInstallerGUI.this.setIconImage(ImageIO.read((InputStream)this.get()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute();
        this.oldVersion = new JComboBox();
        this.oldVersion.setToolTipText("<html>Note: this has be a version <i>without</i> XRay already installed.<br>This can however, be an already modified profile.<br>The XRay code will be injected into the existing mods.</html>");
        this.newVersion = new JTextField(String.format("%s-XRay", XRayInstaller.XRayTargetVersion));
        this.newVersion.setToolTipText("If you are unsure, leave it at the default :)");
        this.additionalModsModel = new DefaultListModel();
        this.additionalMods = new JList(this.additionalModsModel);
        this.oldVersion.addActionListener(new PatchEnableListener());
        this.newVersion.getDocument().addDocumentListener(new PatchEnableListener());
        JButton btnAdd = new JButton("ADD");
        JButton btnRemove = new JButton("REMOVE");
        JButton btnRepair = new JButton("Auto Repair");
        this.btnPatch = new JButton("Patch");
        this.autoSetVersion = new JCheckBox("Auto set profile", true);
        this.autoSetVersion.setToolTipText("Automatically sets the launcher to use the correct version.");
        btnAdd.setFont(new Font(btnAdd.getFont().getName(), btnAdd.getFont().getStyle(), btnAdd.getFont().getSize() - 2));
        btnRemove.setFont(btnAdd.getFont());
        this.contentPane = new JPanel(new MigLayout("fillx, wrap, gapy 2", "[center]", "[]u[][]u[][]u[][grow][][]"));
        this.contentPane.add(new JLabel(String.format(str_XRayWarning, XRayInstaller.XRayTargetVersion)));
        this.contentPane.add(new JLabel("Select Minecraft version to patch:"));
        this.contentPane.add((Component)this.oldVersion, "grow");
        this.contentPane.add(new JLabel("Enter a name for the patched version:"));
        this.contentPane.add((Component)this.newVersion, "grow");
        this.contentPane.add(new JLabel("Select additional mods to install:"));
        this.contentPane.add((Component)new JScrollPane(this.additionalMods), "grow");
        this.contentPane.add((Component)this.autoSetVersion, "split 3, growx, align right");
        this.contentPane.add(btnAdd);
        this.contentPane.add(btnRemove);
        this.contentPane.add((Component)btnRepair, "split 2, w 50%");
        this.contentPane.add((Component)this.btnPatch, "w 50%");
        this.setContentPane(this.contentPane);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIManager.put("FileChooser.readOnly", Boolean.TRUE);
                JFileChooser fc = new JFileChooser(XRayInstallerGUI.this.rememberDirectory);
                fc.setAcceptAllFileFilterUsed(false);
                fc.addChoosableFileFilter(new FileNameExtensionFilter("Minecraft Mods", "jar", "zip"));
                if (fc.showOpenDialog(XRayInstallerGUI.this) == 0 && !XRayInstallerGUI.this.additionalModsModel.contains(fc.getSelectedFile())) {
                    XRayInstallerGUI.this.additionalModsModel.addElement(fc.getSelectedFile());
                }
                XRayInstallerGUI.this.rememberDirectory = fc.getCurrentDirectory();
            }
        });
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XRayInstallerGUI.this.additionalModsModel.removeElement(XRayInstallerGUI.this.additionalMods.getSelectedValue());
            }
        });
        btnRepair.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    XRayInstallerGUI.this.runWorker(new AutoRepair());
                    JOptionPane.showMessageDialog(XRayInstallerGUI.this, "Auto repair complete.");
                }
                catch (Exception e) {
                    XRayInstaller.showException(e, XRayInstaller.XRayTargetVersion, "");
                }
                XRayInstallerGUI.this.reloadVersions();
            }
        });
        this.btnPatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XRayInstallerGUI.this.newVersion.setText(XRayInstallerGUI.this.newVersion.getText().trim());
                String oldVersionStr = (String)XRayInstallerGUI.this.oldVersion.getSelectedItem();
                String newVersionStr = XRayInstallerGUI.this.newVersion.getText();
                final XRayPatcher patcher = new XRayPatcher(oldVersionStr, newVersionStr).setLauncherVersion(XRayInstallerGUI.this.autoSetVersion.isSelected()).addSources(Collections.list(XRayInstallerGUI.this.additionalModsModel.elements()));
                if (patcher.alreadyExists() && JOptionPane.showConfirmDialog(XRayInstallerGUI.this, "<html><b>Warning: " + newVersionStr + " already exists!</b>" + "<br>If you continue this will be overwritten." + "<br>Are you sure you want to continue?</html>", "Overwrite?", 0) != 0) {
                    return;
                }
                try {
                    if (JOptionPane.showConfirmDialog(XRayInstallerGUI.this, "Make sure neither Minecraft nor the Minecraft Launcher are currently running.", "XRay Installer", 2, 1) != 0) {
                        return;
                    }
                    XRayInstallerGUI.this.runWorker(new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            patcher.patch();
                            return null;
                        }
                    });
                    Object[] options = new Object[]{"Copy details to clipboard", "Close"};
                    if (JOptionPane.showOptionDialog(XRayInstallerGUI.this, "Minecraft has been patched successfully!", "XRay Installer", -1, 1, null, options, options[1]) == 0) {
                        StringSelection stringSelection = new StringSelection(patcher.getPatchDetails());
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
                    }
                    XRayInstallerGUI.this.dispose();
                }
                catch (Exception e) {
                    XRayInstaller.showException(e, oldVersionStr, newVersionStr);
                }
            }
        });
        this.reloadVersions();
    }

    private <T> T runWorker(SwingWorker<T, ?> thread) throws Exception {
        final JDialog workingDialog = new JDialog((Window)this, "Working", Dialog.ModalityType.DOCUMENT_MODAL);
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        workingDialog.setDefaultCloseOperation(0);
        workingDialog.setResizable(false);
        workingDialog.setLayout(new BorderLayout());
        workingDialog.add((Component)progress, "South");
        workingDialog.pack();
        workingDialog.setSize(260, workingDialog.getHeight() + 2);
        workingDialog.setLocationRelativeTo(this);
        thread.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName()) && SwingWorker.StateValue.DONE == evt.getNewValue()) {
                    workingDialog.dispose();
                }
            }
        });
        thread.execute();
        workingDialog.setVisible(true);
        return thread.get();
    }

    private void reloadVersions() {
        this.btnPatch.setEnabled(false);
        if (XRayInstaller.mcVersions.isDirectory()) {
            this.oldVersion.setModel(new DefaultComboBoxModel<String>(XRayInstaller.mcVersions.list(new MCFileFilter())));
            this.oldVersion.setSelectedItem(XRayInstaller.XRayTargetVersion);
        }
    }

    private class PatchEnableListener
    implements DocumentListener,
    ActionListener {
        private PatchEnableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String oldVersionStr = (String)XRayInstallerGUI.this.oldVersion.getSelectedItem();
            String newVersionStr = XRayInstallerGUI.this.newVersion.getText().trim();
            if (!(oldVersionStr == null || newVersionStr == null || oldVersionStr.isEmpty() || newVersionStr.isEmpty() || oldVersionStr.equalsIgnoreCase(newVersionStr))) {
                XRayInstallerGUI.this.btnPatch.setEnabled(true);
            } else {
                XRayInstallerGUI.this.btnPatch.setEnabled(false);
            }
        }
    }
}

