/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mc.ambientocclusion.xray.XRayClassTransformer;
import mc.ambientocclusion.xrayinstaller.XRayInstaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class XRayPatcher {
    private static final Logger LOG = Logger.getLogger("XRayPatcher");
    private final String oldVersion;
    private final String newVersion;
    private final File newVersionJson;
    private final File newVersionJar;
    private final File oldVersionJson;
    private final File oldVersionJar;
    private boolean setLauncherVersion = false;
    private final List<File> sources = new ArrayList<File>();

    public XRayPatcher(String oldVersion, String newVersion) {
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
        File newVersionDir = new File(XRayInstaller.mcVersions, newVersion);
        File oldVersionDir = new File(XRayInstaller.mcVersions, oldVersion);
        this.newVersionJson = new File(newVersionDir, String.valueOf(newVersion) + ".json");
        this.newVersionJar = new File(newVersionDir, String.valueOf(newVersion) + ".jar");
        this.oldVersionJson = new File(oldVersionDir, String.valueOf(oldVersion) + ".json");
        this.oldVersionJar = new File(oldVersionDir, String.valueOf(oldVersion) + ".jar");
        this.sources.add(this.oldVersionJar);
    }

    public XRayPatcher setLauncherVersion(boolean shouldSetLauncherVersion) {
        this.setLauncherVersion = shouldSetLauncherVersion;
        return this;
    }

    public XRayPatcher addSources(Collection<? extends File> c) {
        this.sources.addAll(c);
        return this;
    }

    public boolean alreadyExists() {
        return this.newVersionJar.exists() || this.newVersionJson.exists();
    }

    public String getPatchDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\"%s\" -> \"%s\"%n", this.oldVersion, this.newVersion));
        for (File source : this.sources) {
            sb.append(String.format("%s%n", source.getName()));
        }
        return sb.toString();
    }

    public void patch() throws Exception {
        LOG.info(String.format("Patching version \"%s\" into \"%s\"", this.oldVersion, this.newVersion));
        JSONObject json = new JSONObject(FileUtils.readFileToString(this.oldVersionJson));
        json.put("id", this.newVersion);
        String minecraftArguments = json.getString("minecraftArguments");
        if (minecraftArguments.contains("optifine.OptiFineTweaker")) {
            LOG.warning("User attempted to patch OptiFine profile, adding as source mod instead.");
            JSONArray libraries = json.getJSONArray("libraries");
            int i = 0;
            while (i < libraries.length()) {
                String string = libraries.getJSONObject(i).getString("name");
                String[] parts = string.split(":", 3);
                if (parts[1].equals("OptiFine")) {
                    File optifine = this.libToFile(string);
                    LOG.fine("OptiFine library path: " + optifine);
                    if (!optifine.exists()) {
                        throw new RuntimeException("OptiFine listed as library, but file is missing.");
                    }
                    this.sources.add(1, optifine);
                    libraries.remove(i);
                    break;
                }
                ++i;
            }
        }
        if (minecraftArguments.contains("cpw.mods.fml.common.launcher.FMLTweaker")) {
            LOG.warning("User attempted to patch Forge profile, adding to mods directory instead.");
            File forgeModsDir = new File(XRayInstaller.mcDirectory, "mods");
            File thisMod = this.getCurrentJar();
            FileUtils.copyFileToDirectory(thisMod, forgeModsDir);
            FileUtils.copyFile(this.oldVersionJar, this.newVersionJar);
        } else {
            JarOutputStream out = null;
            TreeMap<String, byte[]> outputMap = new TreeMap<String, byte[]>();
            outputMap.put("XRayImpl.class", IOUtils.toByteArray(XRayPatcher.class.getResourceAsStream("/XRayImpl.class")));
            outputMap.put("mc/ambientocclusion/xray/XRay.class", IOUtils.toByteArray(XRayPatcher.class.getResourceAsStream("/mc/ambientocclusion/xray/XRay.class")));
            outputMap.put("mc/ambientocclusion/xray/Config.class", IOUtils.toByteArray(XRayPatcher.class.getResourceAsStream("/mc/ambientocclusion/xray/Config.class")));
            outputMap.put("mc/ambientocclusion/xray/UpdateChecker.class", IOUtils.toByteArray(XRayPatcher.class.getResourceAsStream("/mc/ambientocclusion/xray/UpdateChecker.class")));
            Collections.reverse(this.sources);
            for (File file : this.sources) {
                LOG.info("Processing source: " + file.getName());
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(file);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (zipEntry.getName().startsWith("META-INF") || outputMap.containsKey(zipEntry.getName())) continue;
                        outputMap.put(zipEntry.getName(), IOUtils.toByteArray(zipFile.getInputStream(zipEntry)));
                    }
                }
                finally {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
            }
            try {
                out = new JarOutputStream(FileUtils.openOutputStream(this.newVersionJar));
                for (Map.Entry entry : outputMap.entrySet()) {
                    String name = (String)entry.getKey();
                    byte[] data = (byte[])entry.getValue();
                    out.putNextEntry(new JarEntry(name));
                    if (name.toLowerCase().endsWith(".class")) {
                        ClassReader cr = new ClassReader(data);
                        ClassWriter cw2 = new ClassWriter(cr, 2);
                        XRayClassTransformer cv = new XRayClassTransformer(cw2);
                        cr.accept(cv, 4);
                        data = cw2.toByteArray();
                    }
                    IOUtils.write(data, (OutputStream)out);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly(out);
        }
        FileUtils.writeStringToFile(this.newVersionJson, json.toString(4));
        if (this.setLauncherVersion) {
            this.setLauncherVersion(this.newVersion);
        }
    }

    private File libToFile(String libstr) {
        String[] parts = libstr.split(":", 3);
        String artifactDir = String.format("%s/%s/%s", parts[0].replaceAll("\\.", "/"), parts[1], parts[2]);
        String artifactFilename = String.format("%s-%s.jar", parts[1], parts[2]);
        return new File(XRayInstaller.mcDirectory, String.format("libraries/%s/%s", artifactDir, artifactFilename));
    }

    private void setLauncherVersion(String version) throws JSONException, IOException {
        File launcher_profile = new File(XRayInstaller.mcDirectory, "launcher_profiles.json");
        if (launcher_profile.isFile()) {
            JSONObject json = new JSONObject(FileUtils.readFileToString(launcher_profile));
            JSONObject profiles = json.getJSONObject("profiles");
            JSONObject profile = profiles.getJSONObject(json.getString("selectedProfile"));
            profile.put("lastVersionId", version);
            FileUtils.writeStringToFile(launcher_profile, json.toString(4));
        }
    }

    private File getCurrentJar() throws URISyntaxException {
        return new File(XRayPatcher.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }
}

