/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileBuilder;
import buildcraft.builders.gui.ContainerBuilder;
import buildcraft.core.DefaultProps;
import buildcraft.core.gui.GuiAdvancedInterface;
import buildcraft.core.utils.StringUtils;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBuilder
extends GuiAdvancedInterface {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/builder_blueprint.png");
    IInventory playerInventory;
    TileBuilder builder;
    int inventoryRows = 6;

    public GuiBuilder(IInventory playerInventory, TileBuilder builder) {
        super(new ContainerBuilder(playerInventory, builder), builder);
        this.playerInventory = playerInventory;
        this.builder = builder;
        this.field_74194_b = 176;
        this.field_74195_c = 225;
        this.slots = new GuiAdvancedInterface.AdvancedSlot[28];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots[i * 4 + j] = new GuiAdvancedInterface.ItemSlot(this, 179 + j * 18, 18 + i * 18);
            }
        }
    }

    @Override
    protected void func_74189_g(int par1, int par2) {
        super.func_74189_g(par1, par2);
        String title = StringUtils.localize("tile.builderBlock");
        this.field_73886_k.func_78276_b(title, this.getCenteredOffset(title), 12, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
        this.field_73886_k.func_78276_b(StringUtils.localize("gui.inventory"), 8, this.field_74195_c - 97, 0x404040);
        if (this.builder.isBuildingBlueprint()) {
            this.field_73886_k.func_78276_b(StringUtils.localize("gui.needed"), 185, 7, 0x404040);
        }
        this.drawForegroundSelection(par1, par2);
    }

    protected void func_74185_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = (this.field_73880_f - this.field_74194_b) / 2;
        int k = (this.field_73881_g - this.field_74195_c) / 2;
        int realXSize = 0;
        if (this.builder.isBuildingBlueprint()) {
            this.field_73882_e.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
            realXSize = 256;
        } else {
            this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
            realXSize = 176;
        }
        this.func_73729_b(j, k, 0, 0, realXSize, this.field_74195_c);
        for (int s = 0; s < this.slots.length; ++s) {
            ((GuiAdvancedInterface.ItemSlot)this.slots[s]).stack = null;
        }
        Collection needs = this.builder.getNeededItems();
        if (needs != null) {
            int s = 0;
            for (ItemStack stack : needs) {
                if (s >= this.slots.length) break;
                ((GuiAdvancedInterface.ItemSlot)this.slots[s]).stack = stack.func_77946_l();
                ++s;
            }
        }
        this.drawBackgroundSlots();
    }
}

