/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.Position;
import buildcraft.core.EntityLaser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityEnergyLaser
extends EntityLaser {
    public static final short POWER_AVERAGING = 100;
    public int displayStage = 0;
    private final float[] power = new float[100];
    private int powerIndex = 0;
    private float powerAverage = 0.0f;

    public EntityEnergyLaser(World world) {
        super(world);
    }

    public EntityEnergyLaser(World world, Position head, Position tail) {
        super(world, head, tail);
    }

    public void pushPower(float received) {
        this.powerAverage -= this.power[this.powerIndex];
        this.powerAverage += received;
        this.power[this.powerIndex] = received;
        ++this.powerIndex;
        if (this.powerIndex == this.power.length) {
            this.powerIndex = 0;
        }
    }

    public float getPowerAverage() {
        return this.powerAverage / 100.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        if ((double)this.getPowerAverage() <= 1.0) {
            return LASER_TEXTURES[0];
        }
        if ((double)this.getPowerAverage() <= 2.0) {
            return LASER_TEXTURES[1];
        }
        if ((double)this.getPowerAverage() <= 3.0) {
            return LASER_TEXTURES[2];
        }
        return LASER_TEXTURES[3];
    }

    @Override
    protected void updateDataClient() {
        super.updateDataClient();
        this.powerAverage = (float)this.decodeDouble(this.field_70180_af.func_75679_c(15));
    }

    @Override
    protected void updateDataServer() {
        super.updateDataServer();
        this.field_70180_af.func_75692_b(15, (Object)this.encodeDouble(this.powerAverage));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)0);
    }
}

