/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.core.blueprints.BptBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.TreeMap;

public class BptRootIndex {
    private TreeMap bluePrintsFile = new TreeMap();
    public TreeMap filesSet = new TreeMap();
    private TreeMap bluePrints = new TreeMap();
    private File baseDir = new File("./", "blueprints/");
    private File file;
    public int maxBpt = 0;

    public BptRootIndex(String filename) throws IOException {
        this.file = new File(this.baseDir, filename);
        this.baseDir.mkdir();
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
    }

    public void loadIndex() throws IOException {
        String line;
        FileInputStream input = new FileInputStream(this.file);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)input, "8859_1"));
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("\\n", "");
            File bptFile = new File(this.baseDir, line);
            ++this.maxBpt;
            this.filesSet.put(line, this.maxBpt);
            if (!bptFile.exists()) continue;
            this.bluePrintsFile.put(this.maxBpt, bptFile);
        }
        input.close();
        this.saveIndex();
    }

    public void importNewFiles() throws IOException {
        String[] files;
        for (String foundFile : files = this.baseDir.list()) {
            String[] parts = foundFile.split("[.]");
            if (parts.length < 2 || !parts[1].equals("bpt") || this.filesSet.containsKey(foundFile)) continue;
            ++this.maxBpt;
            this.filesSet.put(foundFile, this.maxBpt);
            File newFile = new File(this.baseDir, foundFile);
            this.bluePrintsFile.put(this.maxBpt, newFile);
        }
        this.saveIndex();
    }

    public void saveIndex() throws IOException {
        FileOutputStream output = new FileOutputStream(this.file);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, "8859_1"));
        for (int i = 1; i <= this.maxBpt; ++i) {
            File f = (File)this.bluePrintsFile.get(i);
            if (f != null) {
                writer.write(f.getName());
            }
            writer.newLine();
        }
        writer.flush();
        output.close();
    }

    public BptBase getBluePrint(int number) {
        if (!this.bluePrints.containsKey(number) && this.bluePrintsFile.containsKey(number)) {
            BptBase bpt = BptBase.loadBluePrint((File)this.bluePrintsFile.get(number), number);
            if (bpt != null) {
                this.bluePrints.put(number, bpt);
                bpt.file = (File)this.bluePrintsFile.get(number);
            } else {
                this.bluePrintsFile.remove(number);
                return null;
            }
        }
        return (BptBase)this.bluePrints.get(number);
    }

    public BptBase getBluePrint(String filename) {
        return this.getBluePrint((Integer)this.filesSet.get(filename));
    }

    public int storeBluePrint(BptBase bluePrint) {
        String name = bluePrint.name;
        if (name == null || name.equals("")) {
            name = "unnamed";
        }
        if (this.filesSet.containsKey(name + ".bpt")) {
            int n = 0;
            while (this.filesSet.containsKey(name + "_" + n + ".bpt")) {
                ++n;
            }
            name = name + "_" + n;
        }
        ++this.maxBpt;
        this.filesSet.put(name + ".bpt", this.maxBpt);
        name = name + ".bpt";
        File bptFile = new File(this.baseDir, name);
        this.bluePrintsFile.put(this.maxBpt, bptFile);
        this.bluePrints.put(this.maxBpt, bluePrint);
        bluePrint.file = bptFile;
        bluePrint.save();
        bluePrint.position = this.maxBpt;
        try {
            this.saveIndex();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.maxBpt;
    }
}

