/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class InvUtils {
    public static int countItems(IInventory inv, ForgeDirection side, ItemStack ... filter) {
        return InvUtils.countItems(inv, side, new ArrayStackFilter(filter));
    }

    public static int countItems(IInventory inv, ForgeDirection side, IStackFilter filter) {
        int count = 0;
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, ItemStack ... filter) {
        return InvUtils.containsItem(inv, side, new ArrayStackFilter(filter));
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, IStackFilter filter) {
        for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoomForStack(ItemStack stack, ForgeDirection side, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        ITransactor tran = Transactor.getTransactorFor(dest);
        return tran.add((ItemStack)stack, (ForgeDirection)side, (boolean)false).field_77994_a > 0;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, IStackFilter filter) {
        ITransactor imSource = Transactor.getTransactorFor(source);
        ItemStack stack = imSource.remove(filter, output, false);
        if (stack != null) {
            ITransactor imDest = Transactor.getTransactorFor(dest);
            int moved = imDest.add((ItemStack)stack, (ForgeDirection)intput, (boolean)true).field_77994_a;
            if (moved > 0) {
                imSource.remove(filter, output, true);
                return stack;
            }
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, ItemStack ... filter) {
        return InvUtils.moveOneItem(source, output, dest, intput, new ArrayStackFilter(filter));
    }

    public static void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_70293_c = 10;
        world.func_72838_d((Entity)entityitem);
    }

    public static void dropItems(World world, IInventory inv, int i, int j, int k) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack items = inv.func_70301_a(slot);
            if (items == null || items.field_77994_a <= 0) continue;
            InvUtils.dropItems(world, inv.func_70301_a(slot).func_77946_l(), i, j, k);
        }
    }

    public static void wipeInventory(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            inv.func_70299_a(slot, null);
        }
    }
}

