/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.IndexInPayload;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.utils.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketPayloadArrays
extends PacketPayload {
    public int[] intPayload = new int[0];
    public float[] floatPayload = new float[0];
    public String[] stringPayload = new String[0];

    public PacketPayloadArrays() {
    }

    public PacketPayloadArrays(int intSize, int floatSize, int stringSize) {
        this.intPayload = new int[intSize];
        this.floatPayload = new float[floatSize];
        this.stringPayload = new String[stringSize];
    }

    public void append(PacketPayloadArrays other) {
        if (other == null) {
            return;
        }
        if (other.intPayload.length > 0) {
            this.intPayload = Utils.concat(this.intPayload, other.intPayload);
        }
        if (other.floatPayload.length > 0) {
            this.floatPayload = Utils.concat(this.floatPayload, other.floatPayload);
        }
        if (other.stringPayload.length > 0) {
            this.stringPayload = (String[])Utils.concat(this.stringPayload, other.stringPayload);
        }
    }

    public void append(int[] other) {
        if (other == null || other.length < 0) {
            return;
        }
        this.intPayload = Utils.concat(this.intPayload, other);
    }

    public void splitTail(IndexInPayload index) {
        PacketPayloadArrays payload = new PacketPayloadArrays(this.intPayload.length - index.intIndex, this.floatPayload.length - index.floatIndex, this.stringPayload.length - index.stringIndex);
        if (this.intPayload.length > 0) {
            System.arraycopy(this.intPayload, index.intIndex, payload.intPayload, 0, payload.intPayload.length);
        }
        if (this.floatPayload.length > 0) {
            System.arraycopy(this.floatPayload, index.floatIndex, payload.floatPayload, 0, payload.floatPayload.length);
        }
        if (this.stringPayload.length > 0) {
            System.arraycopy(this.stringPayload, index.stringIndex, payload.stringPayload, 0, payload.stringPayload.length);
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.intPayload.length);
        data.writeInt(this.floatPayload.length);
        data.writeInt(this.stringPayload.length);
        for (int intData : this.intPayload) {
            data.writeInt(intData);
        }
        for (float floatData : this.floatPayload) {
            data.writeFloat(floatData);
        }
        for (String stringData : this.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int i;
        this.intPayload = new int[data.readInt()];
        this.floatPayload = new float[data.readInt()];
        this.stringPayload = new String[data.readInt()];
        for (i = 0; i < this.intPayload.length; ++i) {
            this.intPayload[i] = data.readInt();
        }
        for (i = 0; i < this.floatPayload.length; ++i) {
            this.floatPayload[i] = data.readFloat();
        }
        for (i = 0; i < this.stringPayload.length; ++i) {
            this.stringPayload[i] = data.readUTF();
        }
    }

    @Override
    public PacketPayload.Type getType() {
        return PacketPayload.Type.ARRAY;
    }
}

