/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.BuildCraftCore;
import buildcraft.api.gates.IOverrideDefaultTriggers;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipe;
import buildcraft.core.IMachine;
import buildcraft.core.triggers.BCTrigger;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class DefaultTriggerProvider
implements ITriggerProvider {
    @Override
    public LinkedList getNeighborTriggers(Block block, TileEntity tile) {
        FluidTankInfo[] tanks;
        if (tile instanceof IOverrideDefaultTriggers) {
            return ((IOverrideDefaultTriggers)tile).getTriggers();
        }
        LinkedList<BCTrigger> res = new LinkedList<BCTrigger>();
        if (tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0) {
            res.add(BuildCraftCore.triggerEmptyInventory);
            res.add(BuildCraftCore.triggerContainsInventory);
            res.add(BuildCraftCore.triggerSpaceInventory);
            res.add(BuildCraftCore.triggerFullInventory);
        }
        if (tile instanceof IFluidHandler && (tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN)) != null && tanks.length > 0) {
            res.add(BuildCraftCore.triggerEmptyFluid);
            res.add(BuildCraftCore.triggerContainsFluid);
            res.add(BuildCraftCore.triggerSpaceFluid);
            res.add(BuildCraftCore.triggerFullFluid);
        }
        if (tile instanceof IMachine) {
            res.add(BuildCraftCore.triggerMachineActive);
            res.add(BuildCraftCore.triggerMachineInactive);
        }
        if (block == null || block.func_71853_i()) {
            // empty if block
        }
        return res;
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }
}

