/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.IItemPipe;
import buildcraft.energy.TileEngine;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineStone;
import buildcraft.energy.TileEngineWood;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockEngine
extends BlockContainer {
    private static Icon woodTexture;
    private static Icon stoneTexture;
    private static Icon ironTexture;

    public BlockEngine(int i) {
        super(i, Material.field_76243_f);
        this.func_71848_c(0.5f);
        this.func_71849_a(CreativeTabBuildCraft.tabBuildCraft);
        this.func_71864_b("engineBlock");
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
        woodTexture = par1IconRegister.func_94245_a("buildcraft:engineWoodBottom");
        stoneTexture = par1IconRegister.func_94245_a("buildcraft:engineStoneBottom");
        ironTexture = par1IconRegister.func_94245_a("buildcraft:engineIronBottom");
    }

    public int func_71857_b() {
        return BuildCraftCore.blockByEntityModel;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 1) {
            return new TileEngineStone();
        }
        if (metadata == 2) {
            return new TileEngineIron();
        }
        return new TileEngineWood();
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).orientation.getOpposite() == side;
        }
        return false;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEngine engine = (TileEngine)world.func_72796_p(x, y, z);
        if (engine != null) {
            engine.delete();
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).switchOrientation();
        }
        return false;
    }

    public boolean func_71903_a(World world, int i, int j, int k, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileEngine tile = (TileEngine)world.func_72796_p(i, j, k);
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        if (tile instanceof TileEngine) {
            return tile.onBlockActivated(player, ForgeDirection.getOrientation((int)side));
        }
        return false;
    }

    public void func_85105_g(World world, int x, int y, int z, int par5) {
        TileEngine tile = (TileEngine)world.func_72796_p(x, y, z);
        tile.orientation = ForgeDirection.UP;
        tile.switchOrientation();
    }

    public int func_71899_b(int i) {
        return i;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        TileEngine tile = (TileEngine)world.func_72796_p(i, j, k);
        if (!tile.isBurning()) {
            return;
        }
        float f = (float)i + 0.5f;
        float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)k + 0.5f;
        float f3 = 0.52f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        world.func_72869_a("reddust", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
    }

    public void func_71879_a(int blockid, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
        itemList.add(new ItemStack((Block)this, 1, 2));
    }

    public void func_71863_a(World world, int i, int j, int k, int l) {
        TileEngine tile = (TileEngine)world.func_72796_p(i, j, k);
        if (tile != null) {
            tile.checkRedstonePower();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return woodTexture;
            }
            case 1: {
                return stoneTexture;
            }
            case 2: {
                return ironTexture;
            }
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }
}

