/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.fuels.IronEngineCoolant;
import buildcraft.api.fuels.IronEngineFuel;
import buildcraft.core.IItemPipe;
import buildcraft.core.fluids.FluidUtils;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.energy.TileEngine;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEngineIron
extends TileEngine
implements IFluidHandler {
    public static int MAX_LIQUID = 10000;
    public static float HEAT_PER_MJ = 0.0023f;
    public static float COOLDOWN_RATE = 0.01f;
    int burnTime = 0;
    private Tank tankFuel;
    private Tank tankCoolant;
    private TankManager tankManager = new TankManager();
    private IronEngineFuel.Fuel currentFuel = null;
    public int penaltyCooling = 0;
    boolean lastPowered = false;

    public TileEngineIron() {
        super(1);
        this.tankFuel = new Tank("tankFuel", MAX_LIQUID);
        this.tankCoolant = new Tank("tankCoolant", MAX_LIQUID);
        this.tankManager.add((Object)this.tankFuel);
        this.tankManager.add((Object)this.tankCoolant);
    }

    @Override
    public ResourceLocation getTextureFile() {
        return IRON_TEXTURE;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (player.func_71045_bC() != null) {
            if (player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
                return false;
            }
            ItemStack current = player.func_71045_bC();
            if (current != null && current.field_77993_c != Item.field_77788_aw.field_77779_bT && (CoreProxy.proxy.isSimulating(this.field_70331_k) ? FluidUtils.handleRightClick(this, side, player, true, false) : FluidContainerRegistry.isContainer((ItemStack)current))) {
                return true;
            }
        }
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            player.openGui((Object)BuildCraftEnergy.instance, 20, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public float explosionRange() {
        return 4.0f;
    }

    @Override
    public float getPistonSpeed() {
        if (CoreProxy.proxy.isSimulating(this.field_70331_k)) {
            return Math.max(0.07f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.04f;
            }
            case GREEN: {
                return 0.05f;
            }
            case YELLOW: {
                return 0.06f;
            }
            case RED: {
                return 0.07f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        FluidStack fuel = this.tankFuel.getFluid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.isRedstonePowered;
    }

    @Override
    public void burn() {
        FluidStack fuel = this.tankFuel.getFluid();
        if (this.currentFuel == null && fuel != null) {
            this.currentFuel = IronEngineFuel.getFuelForFluid(fuel.getFluid());
        }
        if (this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0 && this.isRedstonePowered) {
            this.lastPowered = true;
            if (this.burnTime > 0 || fuel.amount > 0) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                }
                if (this.burnTime <= 0) {
                    if (fuel != null) {
                        if (--fuel.amount <= 0) {
                            this.tankFuel.setFluid(null);
                        }
                        this.burnTime = this.currentFuel.totalBurningTime / 1000;
                    } else {
                        this.currentFuel = null;
                        return;
                    }
                }
                this.currentOutput = this.currentFuel.powerPerCycle;
                this.addEnergy(this.currentFuel.powerPerCycle);
                this.heat += this.currentFuel.powerPerCycle * HEAT_PER_MJ;
            }
        } else if (this.penaltyCooling <= 0 && this.lastPowered) {
            this.lastPowered = false;
            this.penaltyCooling = 600;
        }
    }

    @Override
    public void updateHeatLevel() {
    }

    @Override
    public void engineUpdate() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (liquid == null && this.heat > 100.0f) {
                liquid = IronEngineCoolant.getFluidCoolant(stack);
            }
            if (liquid != null && this.fill(ForgeDirection.UNKNOWN, liquid, false) == liquid.amount) {
                this.fill(ForgeDirection.UNKNOWN, liquid, true);
                this.func_70299_a(0, Utils.consumeItem(stack));
            }
        }
        if (this.heat > 100.0f) {
            float extraHeat = this.heat - 100.0f;
            FluidStack coolant = this.tankCoolant.getFluid();
            IronEngineCoolant.Coolant currentCoolant = IronEngineCoolant.getCoolant(coolant);
            if (currentCoolant != null) {
                float cooling = currentCoolant.getDegreesCoolingPerMB(this.heat);
                if ((float)coolant.amount * cooling > extraHeat) {
                    coolant.amount -= Math.round(extraHeat / cooling);
                    this.heat = 100.0f;
                } else {
                    this.heat -= (float)coolant.amount * cooling;
                    this.tankCoolant.setFluid(null);
                }
            }
        }
        if (this.heat > 20.0f && (this.penaltyCooling > 0 || !this.isRedstonePowered)) {
            this.heat -= COOLDOWN_RATE;
        }
        if (this.heat <= 20.0f) {
            this.heat = 20.0f;
        }
        if (this.heat <= 20.0f && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return this.tankFuel.getFluid() != null ? (int)((float)this.tankFuel.getFluid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.tankManager.readFromNBT(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.penaltyCooling = data.func_74762_e("penaltyCooling");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("penaltyCooling", this.penaltyCooling);
    }

    public int getScaledCoolant(int i) {
        return this.tankCoolant.getFluid() != null ? (int)((float)this.tankCoolant.getFluid().amount / (float)MAX_LIQUID * (float)i) : 0;
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                if (this.tankFuel.getFluid() == null) {
                    this.tankFuel.setFluid(new FluidStack(value, 0));
                    break;
                }
                this.tankFuel.getFluid().fluidID = value;
                break;
            }
            case 16: {
                if (this.tankCoolant.getFluid() == null) {
                    this.tankCoolant.setFluid(new FluidStack(value, 0));
                    break;
                }
                this.tankCoolant.getFluid().fluidID = value;
                break;
            }
            case 17: {
                if (this.tankFuel.getFluid() == null) {
                    this.tankFuel.setFluid(new FluidStack(0, value));
                    break;
                }
                this.tankFuel.getFluid().amount = value;
                break;
            }
            case 18: {
                if (this.tankCoolant.getFluid() == null) {
                    this.tankCoolant.setFluid(new FluidStack(0, value));
                    break;
                }
                this.tankCoolant.getFluid().amount = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a((Container)containerEngine, 15, this.tankFuel.getFluid() != null ? this.tankFuel.getFluid().fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 16, this.tankCoolant.getFluid() != null ? this.tankCoolant.getFluid().fluidID : 0);
        iCrafting.func_71112_a((Container)containerEngine, 17, this.tankFuel.getFluid() != null ? this.tankFuel.getFluid().amount : 0);
        iCrafting.func_71112_a((Container)containerEngine, 18, this.tankCoolant.getFluid() != null ? this.tankCoolant.getFluid().amount : 0);
    }

    @Override
    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (IronEngineCoolant.getCoolant(resource) != null) {
            return this.tankCoolant.fill(resource, doFill);
        }
        if (IronEngineFuel.getFuelForFluid(resource.getFluid()) != null) {
            return this.tankFuel.fill(resource, doFill);
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (IronEngineCoolant.isCoolant(fluid)) {
            return true;
        }
        return IronEngineFuel.getFuelForFluid(fluid) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (IronEngineCoolant.getCoolant(itemstack) != null) {
            return true;
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null;
    }

    public FluidStack getFuel() {
        return this.tankFuel.getFluid();
    }

    public FluidStack getCoolant() {
        return this.tankCoolant.getFluid();
    }

    @Override
    public float maxEnergyReceived() {
        return 2000.0f;
    }

    @Override
    public float maxEnergyExtracted() {
        return 500.0f;
    }

    @Override
    public float getMaxEnergy() {
        return 10000.0f;
    }

    @Override
    public float getCurrentOutput() {
        if (this.currentFuel == null) {
            return 0.0f;
        }
        return this.currentFuel.powerPerCycle;
    }

    @Override
    public LinkedList getTriggers() {
        LinkedList triggers = super.getTriggers();
        triggers.add(BuildCraftCore.triggerEmptyFluid);
        triggers.add(BuildCraftCore.triggerContainsFluid);
        triggers.add(BuildCraftCore.triggerSpaceFluid);
        triggers.add(BuildCraftCore.triggerFullFluid);
        return triggers;
    }
}

